/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import jd.controlling.downloadcontroller.BadFilePathException;
import jd.controlling.downloadcontroller.tests.FilePathCheckerTest;
import org.appwork.utils.DebugMode;
import org.appwork.utils.IO;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.UniqueAlltimeID;

public class FilePathChecker {
    public static void createFilePath(File file) throws IOException {
        FilePathChecker.createFilePath(file, CheckFlag.IS_FILE, CheckFlag.CHECK_FILE_WRITE, CheckFlag.CHECK_FILE_FOR_TOO_LONG_FILENAME);
    }

    public static void createFolderPath(File file) throws IOException {
        FilePathChecker.createFilePath(file, CheckFlag.CHECK_FOLDER_CREATE);
    }

    public static void createFilePath(File file, CheckFlag ... flags) throws IOException {
        boolean isFile = false;
        boolean checkFileWrite = false;
        boolean checkFolderCreate = false;
        boolean allowCheckForTooLongFilename = false;
        boolean errorOnFileAlreadyExist = false;
        if (flags != null) {
            for (CheckFlag flag : flags) {
                if (flag == CheckFlag.IS_FILE) {
                    isFile = true;
                    continue;
                }
                if (flag == CheckFlag.CHECK_FILE_WRITE) {
                    checkFileWrite = true;
                    continue;
                }
                if (flag == CheckFlag.CHECK_FOLDER_CREATE) {
                    checkFolderCreate = true;
                    continue;
                }
                if (flag == CheckFlag.CHECK_FILE_FOR_TOO_LONG_FILENAME) {
                    allowCheckForTooLongFilename = true;
                    continue;
                }
                if (flag != CheckFlag.ERROR_ON_ALREADY_EXIST) continue;
                errorOnFileAlreadyExist = true;
            }
        }
        if (file == null) {
            throw new IllegalArgumentException("fileOutput can't be null");
        }
        if (isFile && file.isDirectory()) {
            throw new BadFilePathException(file, BadFilePathException.PathFailureReason.FILE_ALREADY_EXISTS_AS_FOLDER);
        }
        if (file.exists()) {
            if (file.isFile() && errorOnFileAlreadyExist) {
                throw new BadFilePathException(file, BadFilePathException.PathFailureReason.FILE_ALREADY_EXISTS);
            }
            return;
        }
        if (file.getParentFile() == null) {
            throw new BadFilePathException(file, BadFilePathException.PathFailureReason.INVALID_DESTINATION);
        }
        File checking = null;
        switch (CrossSystem.getOSFamily()) {
            case LINUX: {
                String[] folders = CrossSystem.getPathComponents((File)file);
                if (folders.length < 3) break;
                String userName = System.getProperty("user.name");
                if (folders.length >= 4 && "run".equals(folders[1]) && "media".equals(folders[2]) && folders[3].equals(userName)) {
                    checking = new File("/run/media/" + userName + "/" + folders[4]);
                    break;
                }
                if ("media".equals(folders[1])) {
                    checking = new File("/media/" + folders[2]);
                    break;
                }
                if (!"mnt".equals(folders[1])) break;
                checking = new File("/mnt/" + folders[2]);
                break;
            }
            case MAC: {
                String[] folders = CrossSystem.getPathComponents((File)file);
                if (folders.length < 3) break;
                if ("media".equals(folders[1])) {
                    checking = new File("/media/" + folders[2]);
                    break;
                }
                if ("mnt".equals(folders[1])) {
                    checking = new File("/mnt/" + folders[2]);
                    break;
                }
                if (!"Volumes".equals(folders[1])) break;
                checking = new File("/Volumes/" + folders[2]);
                break;
            }
            case WINDOWS: {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    boolean pathLimitActive = true;
                    String pathToCheck = isFile ? file.getParentFile().getAbsolutePath() : file.getAbsolutePath();
                    if (pathToCheck.length() >= 259) {
                        throw new BadFilePathException(file, BadFilePathException.PathFailureReason.PATH_TOO_LONG);
                    }
                }
            }
            default: {
                if (CrossSystem.getOS().isMaximum(CrossSystem.OperatingSystem.WINDOWS_NT) && file.getAbsolutePath().length() > 259) {
                    throw new BadFilePathException(file, BadFilePathException.PathFailureReason.PATH_TOO_LONG);
                }
                String[] folders = CrossSystem.getPathComponents((File)file);
                if (folders.length <= 0) break;
                String root = folders[0];
                if (root.matches("^[a-zA-Z]{1}:\\\\$") || root.matches("^[a-zA-Z]{1}://$")) {
                    checking = new File(folders[0]);
                    break;
                }
                if (!root.equals("\\\\") || folders.length < 3) break;
                checking = new File(folders[0] + folders[1] + "\\" + folders[2]);
            }
        }
        if (!(checking == null || checking.exists() && checking.isDirectory())) {
            throw new BadFilePathException(file, BadFilePathException.PathFailureReason.INVALID_DESTINATION);
        }
        if (!checkFolderCreate && !checkFileWrite) {
            return;
        }
        ArrayList<File> pathlist = new ArrayList<File>();
        int loop = 0;
        File next = file;
        int folderCreateStartSegmentIndex = -1;
        while (true) {
            pathlist.add(0, next);
            if (folderCreateStartSegmentIndex != -1 || folderCreateStartSegmentIndex == -1 && !next.exists()) {
                folderCreateStartSegmentIndex = loop;
            }
            if ((next = next.getParentFile()) == null) break;
            ++loop;
        }
        if (folderCreateStartSegmentIndex != -1) {
            for (int index = folderCreateStartSegmentIndex = pathlist.size() - folderCreateStartSegmentIndex - 1; index < pathlist.size(); ++index) {
                boolean isLastItem;
                boolean bl = isLastItem = index == pathlist.size() - 1;
                if (isFile && isLastItem) break;
                File thisfolder = (File)pathlist.get(index);
                if (thisfolder.exists() || thisfolder.mkdir() || thisfolder.isDirectory()) continue;
                if (CrossSystem.isWindows() && FilePathChecker.looksLikeTooLongWindowsPathOrFilename(thisfolder)) {
                    if (isFile) {
                        throw new BadFilePathException(thisfolder, BadFilePathException.PathFailureReason.PATH_SEGMENT_TOO_LONG, index);
                    }
                    throw new BadFilePathException(thisfolder, BadFilePathException.PathFailureReason.PATH_TOO_LONG, index);
                }
                throw new BadFilePathException(thisfolder, BadFilePathException.PathFailureReason.PERMISSION_PROBLEM, index);
            }
        }
        if (isFile && checkFileWrite) {
            File writeTest1 = file;
            try {
                FilePathChecker.fileWriteCheck(writeTest1);
            }
            catch (IOException e1) {
                if (!allowCheckForTooLongFilename) {
                    throw new BadFilePathException(file, BadFilePathException.PathFailureReason.PERMISSION_PROBLEM, pathlist.size() - 1);
                }
                File writeTest2 = new File(writeTest1.getParent(), "jd_accessCheck_" + new UniqueAlltimeID().getID());
                if (writeTest2.exists()) {
                    throw e1;
                }
                try {
                    FilePathChecker.fileWriteCheck(writeTest2);
                }
                catch (IOException e2) {
                    throw new BadFilePathException(file, BadFilePathException.PathFailureReason.PERMISSION_PROBLEM, pathlist.size() - 1);
                }
                throw new BadFilePathException(file, BadFilePathException.PathFailureReason.PATH_SEGMENT_TOO_LONG, pathlist.size() - 1);
            }
        }
    }

    public static void fileWriteCheck(File file) throws IOException {
        RandomAccessFile raffile = IO.open((File)file, (String)"rw");
        raffile.close();
        if (!file.delete()) {
            throw new IOException("Failed to delete written file");
        }
    }

    public static boolean looksLikeTooLongWindowsPathOrFilename(File file) throws IOException {
        String[] folders;
        for (String folder : folders = CrossSystem.getPathComponents((File)file)) {
            if (!FilePathChecker.looksLikeTooLongWindowsPathSegment(folder)) continue;
            return true;
        }
        return false;
    }

    public static boolean looksLikeTooLongWindowsPathSegment(String str) throws IOException {
        return str.length() > 255;
    }

    public static void main(String[] args) throws IOException {
        FilePathCheckerTest.main(args);
    }

    public static enum CheckFlag {
        CHECK_FOLDER_CREATE,
        CHECK_FILE_WRITE,
        CHECK_FILE_FOR_TOO_LONG_FILENAME,
        IS_FILE,
        ERROR_ON_ALREADY_EXIST;

    }
}

