/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller.tests;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jd.controlling.downloadcontroller.BadFilePathException;
import jd.controlling.downloadcontroller.FilePathChecker;
import org.appwork.testframework.AWTest;
import org.appwork.utils.IO;
import org.appwork.utils.os.CrossSystem;

public class FilePathCheckerTest
extends AWTest {
    private final List<File> CLEANUP = new CopyOnWriteArrayList<File>();

    public static void main(String[] args) {
        FilePathCheckerTest.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest() throws Exception {
        boolean allowDeleteFolderRecursive = false;
        String windowsTestBasePath = "jdownloaderfilefoldertests";
        File testBasePath = new File("jdownloaderfilefoldertests");
        System.out.print(testBasePath.getAbsolutePath());
        try {
            if (testBasePath.exists()) {
                File[] filesfolders = testBasePath.listFiles();
                allowDeleteFolderRecursive = filesfolders == null || filesfolders.length == 0;
            } else {
                testBasePath.mkdirs();
                allowDeleteFolderRecursive = true;
            }
            File testfile = new File(testBasePath, "testfile.txt");
            RandomAccessFile raffile = IO.open((File)testfile, (String)"rw");
            raffile.close();
            this.CLEANUP.add(testfile);
            File testfolderWithFilename = new File(testBasePath, "test_folder_with_filename.txt");
            testfolderWithFilename.mkdirs();
            this.CLEANUP.add(testfolderWithFilename);
            if (CrossSystem.isWindows()) {
                File testBasePathNoWrite = new File("jdownloaderfilefoldertests", "nowrite");
                testBasePathNoWrite.setReadOnly();
                testBasePathNoWrite.mkdirs();
                File testInvalidFilePath = new File(testBasePath, "invalid:folder_because_of_invalid_char_colon");
                this.CLEANUP.add(testInvalidFilePath);
                FilePathCheckerTest.testFolderCreationFail(testInvalidFilePath, new BadFilePathException(testInvalidFilePath, BadFilePathException.PathFailureReason.PERMISSION_PROBLEM));
                boolean doPermissionTest = false;
                File longfilenameTest = new File(testBasePath, "too_long_filename_test_Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy.txt");
                this.CLEANUP.add(longfilenameTest);
                FilePathCheckerTest.testFileCreationFail(longfilenameTest, new BadFilePathException(longfilenameTest, BadFilePathException.PathFailureReason.PATH_SEGMENT_TOO_LONG));
            }
            FilePathCheckerTest.testFileCreationFail(testfile, new BadFilePathException(testfile, BadFilePathException.PathFailureReason.FILE_ALREADY_EXISTS), FilePathChecker.CheckFlag.ERROR_ON_ALREADY_EXIST);
            File testInvalidFilePath = new File(testfolderWithFilename.getAbsolutePath());
            FilePathCheckerTest.testFileCreationFail(testInvalidFilePath, new BadFilePathException(testInvalidFilePath, BadFilePathException.PathFailureReason.FILE_ALREADY_EXISTS_AS_FOLDER));
            File normalFolderAndSubfolderTest = new File(testBasePath, "subfolder");
            this.CLEANUP.add(normalFolderAndSubfolderTest);
            FilePathCheckerTest.testFolderCreationSuccess(normalFolderAndSubfolderTest);
            File normalFileTest = new File(testBasePath, "testfile_valid_filename_length.txt");
            this.CLEANUP.add(normalFileTest);
            FilePathCheckerTest.testFileCreationSuccess(normalFileTest);
            System.out.println("SUCCESS");
        }
        finally {
            this.cleanup();
            if (allowDeleteFolderRecursive) {
                FilePathCheckerTest.deleteRecursive(testBasePath);
            } else {
                System.out.println("!! TEST ENDED BUT SOME TEST FILES MAY BE LEFT !!");
            }
        }
    }

    private void cleanup() {
        for (File next : this.CLEANUP) {
            if (next.delete() || !next.exists()) {
                this.CLEANUP.remove(next);
                continue;
            }
            if (!next.isFile()) continue;
            this.CLEANUP.remove(next);
            next.deleteOnExit();
        }
    }

    private static void deleteRecursive(File folder) {
        File[] filesfolders;
        if (folder.isDirectory() && (filesfolders = folder.listFiles()) != null) {
            for (File file : filesfolders) {
                FilePathCheckerTest.deleteRecursive(file);
            }
        }
        folder.delete();
    }

    public static void testFolderCreationFail(File file, BadFilePathException expectedException) throws Exception {
        try {
            FilePathChecker.createFolderPath(file);
            throw new Exception("Expected Exception did not occur");
        }
        catch (BadFilePathException bf) {
            if (bf.getReason() != expectedException.getReason()) {
                bf.printStackTrace();
                throw new Exception("Expected FailureReason " + (Object)((Object)expectedException.getReason()) + " | Got: " + (Object)((Object)bf.getReason()));
            }
            return;
        }
    }

    public static void testFileCreationFail(File file, BadFilePathException expectedException) throws Exception {
        try {
            FilePathChecker.createFilePath(file);
            throw new Exception("Expected Exception did not occur");
        }
        catch (BadFilePathException bf) {
            if (bf.getReason() != expectedException.getReason()) {
                bf.printStackTrace();
                throw new Exception("Expected FailureReason " + (Object)((Object)expectedException.getReason()) + " | Got: " + (Object)((Object)bf.getReason()));
            }
            return;
        }
    }

    public static void testFileCreationFail(File file, BadFilePathException expectedException, FilePathChecker.CheckFlag ... flags) throws Exception {
        try {
            FilePathChecker.createFilePath(file, flags);
            throw new Exception("Expected Exception did not occur");
        }
        catch (BadFilePathException bf) {
            if (bf.getReason() != expectedException.getReason()) {
                bf.printStackTrace();
                throw new Exception("Expected FailureReason " + (Object)((Object)expectedException.getReason()) + " | Got: " + (Object)((Object)bf.getReason()));
            }
            return;
        }
    }

    public static void testFolderCreationSuccess(File file) throws Exception {
        try {
            FilePathChecker.createFolderPath(file);
        }
        catch (BadFilePathException bf) {
            bf.printStackTrace();
            throw new Exception("Folder creation failed");
        }
    }

    public static void testFileCreationSuccess(File file) throws Exception {
        try {
            FilePathChecker.createFilePath(file);
        }
        catch (BadFilePathException bf) {
            bf.printStackTrace();
            throw new Exception("File creation failed");
        }
    }

    public static void assertSuccessfulFileFolderCreation(File File2) throws Exception {
    }
}

