/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkchecker;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.linkchecker.LinkCheckerConfig;
import jd.controlling.linkchecker.LinkCheckerEvent;
import jd.controlling.linkchecker.LinkCheckerEventSender;
import jd.controlling.linkchecker.LinkCheckerHandler;
import jd.controlling.linkchecker.LinkCheckerThread;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.http.Browser;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.plugins.FinalLinkState;

public class LinkChecker<E extends CheckableLink> {
    private static final AtomicInteger CHECKER = new AtomicInteger(0);
    private static final AtomicLong LINKCHECKER_THREAD_NUM = new AtomicLong(0L);
    private static final int MAX_THREADS;
    private static final int KEEP_ALIVE;
    private static final HashMap<String, Thread> CHECK_THREADS;
    private static final HashMap<String, WeakHashMap<LinkChecker<?>, ArrayDeque<InternCheckableLink>>> LINKCHECKER;
    private static final Object LOCK;
    private final AtomicLong linksRequested = new AtomicLong(0L);
    private final boolean forceRecheck;
    private LinkCheckerHandler<E> handler = null;
    private static final int ROUNDSIZE = 100;
    private static final LinkCheckerEventSender EVENTSENDER;
    protected final AtomicLong checkerGeneration = new AtomicLong(0L);
    protected final AtomicBoolean runningState = new AtomicBoolean(false);

    public static LinkCheckerEventSender getEventSender() {
        return EVENTSENDER;
    }

    public LinkChecker() {
        this(false);
    }

    public LinkChecker(boolean forceRecheck) {
        this.forceRecheck = forceRecheck;
    }

    public boolean isForceRecheck() {
        return this.forceRecheck;
    }

    public void setLinkCheckHandler(LinkCheckerHandler<E> handler) {
        this.handler = handler;
    }

    public LinkCheckerHandler<E> getLinkCheckHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopChecking() {
        this.checkerGeneration.incrementAndGet();
        if (this.linksRequested.get() == 0L) {
            boolean stopEvent;
            AtomicInteger atomicInteger = CHECKER;
            synchronized (atomicInteger) {
                if (this.linksRequested.get() == 0L && this.runningState.compareAndSet(true, false)) {
                    stopEvent = true;
                    if (CHECKER.get() > 0) {
                        CHECKER.decrementAndGet();
                    }
                } else {
                    stopEvent = false;
                }
            }
            if (stopEvent) {
                EVENTSENDER.fireEvent((DefaultEvent)new LinkCheckerEvent(this, LinkCheckerEvent.Type.STOPPED));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void linkChecked(InternCheckableLink link) {
        LinkCheckerHandler<CheckableLink> h;
        if (link == null) {
            return;
        }
        if (link.isChecked()) {
            return;
        }
        if (link.check() && this.linksRequested.decrementAndGet() == 0L) {
            boolean stopEvent;
            AtomicInteger atomicInteger = CHECKER;
            synchronized (atomicInteger) {
                if (this.linksRequested.get() == 0L && this.runningState.compareAndSet(true, false)) {
                    stopEvent = true;
                    if (CHECKER.get() > 0) {
                        CHECKER.decrementAndGet();
                    }
                } else {
                    stopEvent = false;
                }
            }
            if (stopEvent) {
                EVENTSENDER.fireEvent((DefaultEvent)new LinkCheckerEvent(this, LinkCheckerEvent.Type.STOPPED));
            }
        }
        if ((h = this.handler) != null && link.linkCheckAllowed()) {
            h.linkCheckDone(link.getCheckableLink());
        }
    }

    public void check(E ... links) {
        if (links == null) {
            throw new IllegalArgumentException("links is null?");
        }
        for (E link : links) {
            this.check(link);
        }
    }

    public void check(List<E> links) {
        if (links == null) {
            throw new IllegalArgumentException("links is null?");
        }
        for (CheckableLink link : links) {
            this.check((E)link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(E link) {
        String specialHost;
        if (link == null || link.getDownloadLink() == null) {
            throw new IllegalArgumentException("links is null?");
        }
        DownloadLink dlLink = link.getDownloadLink();
        String host = dlLink.getHost();
        if (("ftp".equalsIgnoreCase(host) || "DirectHTTP".equalsIgnoreCase(host) || "http links".equalsIgnoreCase(host)) && (specialHost = Browser.getHost((String)dlLink.getPluginPatternMatcher())) != null) {
            host = host + "_" + specialHost;
        }
        InternCheckableLink checkableLink = new InternCheckableLink((CheckableLink)link, this);
        if (this.linksRequested.getAndIncrement() == 0L) {
            boolean event;
            AtomicInteger atomicInteger = CHECKER;
            synchronized (atomicInteger) {
                event = this.runningState.compareAndSet(false, true);
                if (event) {
                    CHECKER.incrementAndGet();
                }
            }
            if (event) {
                EVENTSENDER.fireEvent((DefaultEvent)new LinkCheckerEvent(this, LinkCheckerEvent.Type.STARTED));
            }
        }
        Object object = LOCK;
        synchronized (object) {
            ArrayDeque<InternCheckableLink> list;
            WeakHashMap<LinkChecker<Object>, ArrayDeque<InternCheckableLink>> map = LINKCHECKER.get(host);
            if (map == null) {
                map = new WeakHashMap();
                LINKCHECKER.put(host, map);
            }
            if ((list = map.get(this)) == null) {
                list = new ArrayDeque(64);
                map.put(this, list);
            }
            list.add(checkableLink);
            Thread thread = CHECK_THREADS.get(host);
            if (thread == null) {
                LinkChecker.startNewThreads();
            } else if (!thread.isAlive()) {
                CHECK_THREADS.remove(host);
                LinkChecker.startNewThreads();
            }
        }
    }

    public boolean isRunning() {
        return this.runningState.get();
    }

    public long checksRequested() {
        return this.linksRequested.get();
    }

    public static boolean isChecking() {
        return CHECKER.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForChecked() {
        while (this.isRunning()) {
            LinkChecker linkChecker = this;
            synchronized (linkChecker) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        return !this.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startNewThread(final String threadHost) {
        Object object = LOCK;
        synchronized (object) {
            if (CHECK_THREADS.size() >= MAX_THREADS) {
                return;
            }
            LinkCheckerThread newThread = new LinkCheckerThread(){

                /*
                 * Exception decompiling
                 */
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                private final boolean isNotEmpty(Collection<ArrayDeque<InternCheckableLink>> values) {
                    if (values != null) {
                        for (ArrayDeque<InternCheckableLink> list : values) {
                            if (list.size() <= 0) continue;
                            return true;
                        }
                    }
                    return false;
                }

                public boolean isDebug() {
                    return true;
                }

                public boolean isVerbose() {
                    return true;
                }
            };
            newThread.setName("LinkChecker: " + LINKCHECKER_THREAD_NUM.incrementAndGet() + ":" + threadHost);
            newThread.setDaemon(true);
            newThread.setPriority(1);
            CHECK_THREADS.put(threadHost, (Thread)((Object)newThread));
            newThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startNewThreads() {
        Object object = LOCK;
        synchronized (object) {
            HashSet<String> removeHosts = new HashSet<String>();
            Set<Map.Entry<String, WeakHashMap<LinkChecker<?>, ArrayDeque<InternCheckableLink>>>> allTodos = LINKCHECKER.entrySet();
            for (Map.Entry<String, WeakHashMap<LinkChecker<?>, ArrayDeque<InternCheckableLink>>> set : allTodos) {
                String host = set.getKey();
                Thread thread = CHECK_THREADS.get(host);
                if (thread != null && thread.isAlive()) continue;
                CHECK_THREADS.remove(host);
                WeakHashMap<LinkChecker<?>, ArrayDeque<InternCheckableLink>> map = set.getValue();
                if (map != null) {
                    Iterator<ArrayDeque<InternCheckableLink>> linkCheckerIt = map.values().iterator();
                    while (linkCheckerIt.hasNext()) {
                        ArrayDeque<InternCheckableLink> next = linkCheckerIt.next();
                        Iterator<InternCheckableLink> it = next.iterator();
                        while (it.hasNext()) {
                            InternCheckableLink link = it.next();
                            if (link.linkCheckAllowed()) continue;
                            it.remove();
                        }
                        if (next.size() != 0) continue;
                        linkCheckerIt.remove();
                    }
                }
                if (map == null || map.size() == 0) {
                    removeHosts.add(host);
                    continue;
                }
                if (CHECK_THREADS.size() >= MAX_THREADS) break;
                LinkChecker.startNewThread(host);
            }
            for (String host : removeHosts) {
                LINKCHECKER.remove(host);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void updateAvailableStatus(PluginForHost plgToUse, DownloadLink link, LogSource logger) {
        if (link.getAvailableStatus() != DownloadLink.AvailableStatus.UNCHECKED) {
            logger.clear();
            return;
        }
        DownloadLink.AvailableStatus availableStatus = null;
        try {
            logger.clear();
            Browser br = plgToUse.createNewBrowserInstance();
            plgToUse.setBrowser(br);
            plgToUse.reset();
            logger.info("Check FileInformation: " + link.getPluginPatternMatcher());
            plgToUse.setDownloadLink(link);
            availableStatus = plgToUse.checkLink(link);
            return;
        }
        catch (PluginException e) {
            logger.log((Throwable)e);
            switch (e.getLinkStatus()) {
                case 2048: 
                case 4096: {
                    availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
                    return;
                }
                case 32: {
                    availableStatus = DownloadLink.AvailableStatus.FALSE;
                    return;
                }
                case 256: {
                    if (e.getValue() == (long)PluginException.VALUE_ID_PREMIUM_ONLY) {
                        availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
                        return;
                    }
                }
                default: {
                    availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
                    plgToUse.errLog(e, plgToUse.getBrowser(), logger, link, null);
                    return;
                }
            }
        }
        catch (Throwable e) {
            logger.log(e);
            plgToUse.errLog(e, plgToUse.getBrowser(), logger, link, null);
            logger.flush();
            availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
            return;
        }
        finally {
            plgToUse.setDownloadLink(null);
            if (availableStatus == null) {
                logger.severe("Link " + link.getPluginPatternMatcher() + " is broken, status was null");
                availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
            }
            logger.info("Link " + link.getPluginPatternMatcher() + " is " + (Object)((Object)availableStatus));
            switch (availableStatus) {
                case UNCHECKABLE: {
                    logger.flush();
                    break;
                }
                case TRUE: {
                    if (FinalLinkState.OFFLINE.equals((Object)link.getFinalLinkState())) {
                        link.setFinalLinkState(null);
                    }
                }
                default: {
                    logger.clear();
                }
            }
            try {
                plgToUse.getBrowser().getHttpConnection().disconnect();
            }
            catch (Throwable e) {}
            link.setAvailableStatus(availableStatus);
        }
    }

    public static boolean isForcedLinkCheck(CheckableLink downloadLink) {
        LinkChecker<?> linkchecker;
        if (Thread.currentThread() instanceof LinkCheckerThread && (linkchecker = ((LinkCheckerThread)((Object)Thread.currentThread())).getLinkCheckerByLink(downloadLink)) != null) {
            return linkchecker.isForceRecheck();
        }
        return true;
    }

    static /* synthetic */ Object access$000() {
        return LOCK;
    }

    static /* synthetic */ HashMap access$100() {
        return LINKCHECKER;
    }

    static /* synthetic */ void access$200(PluginForHost x0, DownloadLink x1, LogSource x2) {
        LinkChecker.updateAvailableStatus(x0, x1, x2);
    }

    static /* synthetic */ int access$300() {
        return KEEP_ALIVE;
    }

    static /* synthetic */ HashMap access$400() {
        return CHECK_THREADS;
    }

    static /* synthetic */ void access$500() {
        LinkChecker.startNewThreads();
    }

    static {
        CHECK_THREADS = new HashMap();
        LINKCHECKER = new HashMap();
        LOCK = new Object();
        EVENTSENDER = new LinkCheckerEventSender();
        MAX_THREADS = Math.max(((LinkCheckerConfig)JsonConfig.create(LinkCheckerConfig.class)).getMaxThreads(), 1);
        KEEP_ALIVE = Math.max(((LinkCheckerConfig)JsonConfig.create(LinkCheckerConfig.class)).getThreadKeepAlive(), 100);
    }

    protected static class InternCheckableLink {
        protected final CheckableLink link;
        protected final long linkCheckerGeneration;
        protected final LinkChecker<? extends CheckableLink> checker;
        protected final AtomicBoolean checkFlag = new AtomicBoolean(false);

        public InternCheckableLink(CheckableLink link, LinkChecker<? extends CheckableLink> checker) {
            this.link = link;
            this.linkCheckerGeneration = checker.checkerGeneration.get();
            this.checker = checker;
        }

        public final CheckableLink getCheckableLink() {
            return this.link;
        }

        public final boolean isChecked() {
            return this.checkFlag.get();
        }

        public final boolean check() {
            return this.checkFlag.compareAndSet(false, true);
        }

        public final boolean linkCheckAllowed() {
            if (this.linkCheckerGeneration == this.getLinkChecker().checkerGeneration.get()) {
                DownloadLink dlLink;
                FilePackage fp;
                CrawledPackage cn;
                CrawledLink cl;
                UniqueAlltimeID pn;
                return !(this.link instanceof CrawledLink ? (pn = (cl = (CrawledLink)this.link).getPreviousParentNodeID()) != null && ((cn = cl.getParentNode()) == null || cn.getControlledBy() == null) : FilePackage.isDefaultFilePackage(fp = (dlLink = this.link.getDownloadLink()).getFilePackage()) || fp.getControlledBy() == null);
            }
            return false;
        }

        public final LinkChecker<? extends CheckableLink> getLinkChecker() {
            return this.checker;
        }
    }
}

