/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcollector;

import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import jd.config.Property;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogJob;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkchecker.LinkCheckerHandler;
import jd.controlling.linkcollector.GenericResetLinkgrabberRlyDialog;
import jd.controlling.linkcollector.LinkCollectingInformation;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollectorConfig;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorEventSender;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcollector.LinkCollectorStorable;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcollector.autostart.AutoStartManager;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.CrawledLinkProperty;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.LinkCrawlerDeepInspector;
import jd.controlling.linkcrawler.LinkCrawlerFilter;
import jd.controlling.linkcrawler.LinkCrawlerHandler;
import jd.controlling.linkcrawler.LinkCrawlerRule;
import jd.controlling.linkcrawler.PackageInfo;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.controlling.packagecontroller.PackageControllerQueue;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.parser.Regex;
import jd.plugins.CrawledLinkStorable;
import jd.plugins.CrawledPackageStorable;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import org.appwork.controlling.SingleReachableState;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.io.J7FileList;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.captcha.blacklist.BlockAllCrawlerCaptchasEntry;
import org.jdownloader.captcha.blacklist.CaptchaBlackList;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.controlling.filter.LinkFilterController;
import org.jdownloader.controlling.linkcrawler.GenericVariants;
import org.jdownloader.controlling.linkcrawler.LinkVariant;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkFactory;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTableModel;
import org.jdownloader.gui.views.linkgrabber.LinkgrabberSearchField;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.LinkgrabberSettings;
import org.jdownloader.gui.views.linkgrabber.contextmenu.ConfirmLinksContextAction;
import org.jdownloader.gui.views.linkgrabber.contextmenu.MenuManagerLinkgrabberTableContext;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_LINKCOLLECTOR;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;
import org.jdownloader.translate._JDT;

public class LinkCollector
extends PackageController<CrawledPackage, CrawledLink>
implements LinkCheckerHandler<CrawledLink>,
LinkCrawlerHandler,
ShutdownVetoListener {
    public static final String SOURCE_VARIANT_ID = "SOURCE_VARIANT_ID";
    private final WeakHashMap<JobLinkCrawler, Object> jobLinkCrawlers = new WeakHashMap();
    private transient LinkCollectorEventSender eventsender = new LinkCollectorEventSender();
    public final ScheduledExecutorService TIMINGQUEUE = DelayedRunnable.getNewScheduledExecutorService();
    public static SingleReachableState CRAWLERLIST_LOADED = new SingleReachableState("CRAWLERLIST_COMPLETE");
    private static LinkCollector INSTANCE = new LinkCollector();
    private volatile LinkChecker<CrawledLink> defaultLinkChecker = null;
    private final HashMap<String, WeakReference<CrawledLink>> dupeCheckMap = new HashMap();
    private final Map<CrawledPackageMappingID, CrawledPackage> packageMapIDtoPackage = new HashMap<CrawledPackageMappingID, CrawledPackage>();
    private final Map<CrawledPackage, CrawledPackageMappingID> packageMapPackageToID = new HashMap<CrawledPackage, CrawledPackageMappingID>();
    private final List<CrawledLink> filteredStuff = new CopyOnWriteArrayList<CrawledLink>();
    private volatile ExtractionExtension archiver;
    private final DelayedRunnable asyncSaving;
    protected volatile CrawledPackage offlinePackage;
    protected volatile CrawledPackage variousPackage;
    protected volatile CrawledPackage permanentofflinePackage;
    private final CopyOnWriteArrayList<File> linkcollectorLists = new CopyOnWriteArrayList();
    private final HashMap<CrawledPackageMappingID, List<CrawledLink>> offlineMap = new HashMap();
    private final HashMap<CrawledPackageMappingID, List<CrawledLink>> variousMap = new HashMap();
    private final HashMap<CrawledPackageMappingID, List<CrawledLink>> badMappingMap = new HashMap();
    private final WeakHashMap<CrawledPackage, HashMap<Object, Object>> autoRenameCache = new WeakHashMap();
    private final DelayedRunnable asyncCacheCleanup;
    private final AutoStartManager autoStartManager;
    private final boolean isDupeManagerEnabled;
    private Object shutdownLock = new Object();

    public static LinkCollector getInstance() {
        return INSTANCE;
    }

    private void onCrawlerAdded(LinkCollectorCrawler jobLinkCrawler) {
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.CRAWLER_ADDED, jobLinkCrawler, Queue.QueuePriority.NORM));
    }

    public void onCrawlerStopped(LinkCollectorCrawler crawledLinkCrawler) {
        this.getEventsender().removeListener(crawledLinkCrawler);
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.CRAWLER_STOPPED, crawledLinkCrawler, Queue.QueuePriority.NORM));
    }

    public void onCrawlerFinished(LinkCollectorCrawler crawledLinkCrawler) {
        this.getEventsender().removeListener(crawledLinkCrawler);
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.CRAWLER_FINISHED, crawledLinkCrawler, Queue.QueuePriority.NORM));
        this.autoStartManager.onCrawlerFinished(crawledLinkCrawler);
    }

    public void onCrawlerStarted(LinkCollectorCrawler crawledLinkCrawler) {
        this.getEventsender().addListener(crawledLinkCrawler, true);
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.CRAWLER_STARTED, crawledLinkCrawler, Queue.QueuePriority.NORM));
    }

    private LinkCollector() {
        this.autoStartManager = new AutoStartManager();
        ShutdownController.getInstance().addShutdownVetoListener((ShutdownVetoListener)this);
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public long getMaxDuration() {
                return 0L;
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                LinkCollector.this.abort();
                LinkCollector.this.QUEUE.addWait(new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

                    protected Void run() throws RuntimeException {
                        LinkCollector.this.saveLinkCollectorLinks(true);
                        return null;
                    }
                });
            }

            public String toString() {
                return "save linkcollector...";
            }
        });
        LinkCollectorConfig cfg = (LinkCollectorConfig)JsonConfig.create(LinkCollectorConfig.class);
        this.isDupeManagerEnabled = cfg.isDupeManagerEnabled();
        long minimumDelay = Math.max(DebugMode.TRUE_IN_IDE_ELSE_FALSE ? 1L : 5000L, cfg.getMinimumSaveDelay());
        long maximumDelay = cfg.getMaximumSaveDelay();
        maximumDelay = maximumDelay <= 0L ? -1L : Math.max(maximumDelay, minimumDelay);
        this.asyncSaving = new DelayedRunnable(this.TIMINGQUEUE, minimumDelay, maximumDelay){
            private final boolean ignoreShutDown = false;
            {
                this.ignoreShutDown = false;
            }

            public void run() {
                if (LinkCollector.this.isSavingAllowed(false)) {
                    super.run();
                }
            }

            public String getID() {
                return "LinkCollectorSave";
            }

            public void delayedrun() {
                if (LinkCollector.this.isSavingAllowed(false)) {
                    LinkCollector.this.QUEUE.addWait(new QueueAction<Void, RuntimeException>(){

                        protected Void run() throws RuntimeException {
                            LinkCollector.this.saveLinkCollectorLinks(false);
                            return null;
                        }
                    });
                }
            }
        };
        this.asyncCacheCleanup = new DelayedRunnable(this.TIMINGQUEUE, 30000L, 120000L){

            public String getID() {
                return "LinkCollectorCleanup";
            }

            public void delayedrun() {
                LinkCollector.this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        LinkCollector.this.autoRenameCache.clear();
                        return null;
                    }
                });
            }
        };
        this.eventsender.addListener(new LinkCollectorListener(){

            @Override
            public void onLinkCollectorAbort(LinkCollectorEvent event) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink parameter) {
                LinkCollector.this.asyncCacheCleanup.run();
            }

            @Override
            public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink parameter) {
            }

            @Override
            public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
            }

            @Override
            public void onLinkCrawlerAdded(LinkCollectorCrawler parameter) {
            }

            @Override
            public void onLinkCrawlerStarted(LinkCollectorCrawler parameter) {
            }

            @Override
            public void onLinkCrawlerStopped(LinkCollectorCrawler parameter) {
            }

            @Override
            public void onLinkCrawlerNewJob(LinkCollectingJob job) {
            }

            @Override
            public void onLinkCrawlerFinished() {
            }
        });
        CFG_LINKCOLLECTOR.DO_LINK_CHECK.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                LinkCollector.this.logger.info("LinkChecker Changed:" + newValue);
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        });
        this.logger.info("LinkChecker Enabled:" + CFG_LINKCOLLECTOR.DO_LINK_CHECK.isEnabled());
    }

    public AutoStartManager getAutoStartManager() {
        return this.autoStartManager;
    }

    public LinkCollectorEventSender getEventsender() {
        return this.eventsender;
    }

    @Override
    protected void _controllerPackageNodeAdded(CrawledPackage pkg, Queue.QueuePriority priority) {
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.ADD_CONTENT, pkg, priority));
    }

    @Override
    protected void _controllerPackageNodeRemoved(CrawledPackage pkg, Queue.QueuePriority priority) {
        if (CrawledPackage.TYPE.NORMAL != pkg.getType()) {
            switch (pkg.getType()) {
                case OFFLINE: {
                    this.offlinePackage = null;
                    break;
                }
                case POFFLINE: {
                    this.permanentofflinePackage = null;
                    break;
                }
                case VARIOUS: {
                    this.variousPackage = null;
                }
            }
        }
        this.autoRenameCache.remove(pkg);
        CrawledPackageMappingID mapping = this.removePackageMapping(pkg);
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REMOVE_CONTENT, pkg, priority));
        this.cleanupMaps(pkg, mapping, this.getChildrenCopy(pkg));
    }

    private CrawledPackageMappingID removePackageMapping(CrawledPackage pkg) {
        CrawledPackageMappingID id = this.packageMapPackageToID.remove(pkg);
        boolean removedFlag = JVMVersion.isMinimum((long)JVMVersion.JAVA_1_8) ? (id != null ? this.packageMapIDtoPackage.remove(id, pkg) : false) : (id != null && this.packageMapIDtoPackage.get(id) == pkg ? this.packageMapIDtoPackage.remove(id) == pkg : false);
        if (removedFlag) {
            return id;
        }
        return null;
    }

    private CrawledPackageMappingID getPackageMapping(CrawledPackage pkg) {
        CrawledPackageMappingID id = this.packageMapPackageToID.get(pkg);
        if (id != null && this.packageMapIDtoPackage.get(id) == pkg) {
            return id;
        }
        return null;
    }

    private void addPackageMapping(CrawledPackage pkg, CrawledPackageMappingID id) {
        this.packageMapIDtoPackage.put(id, pkg);
        this.packageMapPackageToID.put(pkg, id);
    }

    @Override
    protected void _controllerParentlessLinks(CrawledPackage pkg, List<CrawledLink> links, Queue.QueuePriority priority) {
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REMOVE_CONTENT, new ArrayList<CrawledLink>(links), priority));
        CrawledPackageMappingID mapping = this.getPackageMapping(pkg);
        this.cleanupMaps(pkg, mapping, links);
    }

    @Override
    protected void _controllerStructureChanged(Queue.QueuePriority priority) {
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REFRESH_STRUCTURE, priority));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.ABORT));
        WeakHashMap<JobLinkCrawler, Object> weakHashMap = this.jobLinkCrawlers;
        synchronized (weakHashMap) {
            for (JobLinkCrawler jobLinkCrawler : this.jobLinkCrawlers.keySet()) {
                jobLinkCrawler.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollecting() {
        WeakHashMap<JobLinkCrawler, Object> weakHashMap = this.jobLinkCrawlers;
        synchronized (weakHashMap) {
            for (JobLinkCrawler jobLinkCrawler : this.jobLinkCrawlers.keySet()) {
                if (!jobLinkCrawler.isCollecting()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobLinkCrawler> getJobLinkCrawlerByJobId(long ... ids) {
        ArrayList<JobLinkCrawler> result = new ArrayList<JobLinkCrawler>();
        Set<UniqueAlltimeID> jobs = UniqueAlltimeID.createSet(ids);
        WeakHashMap<JobLinkCrawler, Object> weakHashMap = this.jobLinkCrawlers;
        synchronized (weakHashMap) {
            for (JobLinkCrawler jobLinkCrawler : this.jobLinkCrawlers.keySet()) {
                if (jobs.remove((Object)jobLinkCrawler.getJob().getUniqueAlltimeID())) {
                    result.add(jobLinkCrawler);
                }
                if (jobs.size() != 0) continue;
                break;
            }
        }
        return result;
    }

    @Override
    protected void autoFileNameCorrection(List<CrawledLink> pkgchildren, CrawledPackage pkg) {
        String name;
        if (!CFG_LINKGRABBER.AUTO_FILENAME_CORRECTION_ENABLED.isEnabled()) {
            return;
        }
        HashSet<LazyHostPlugin> hosts = new HashSet<LazyHostPlugin>();
        ArrayList<DownloadLink> dlinks = new ArrayList<DownloadLink>();
        ArrayList<DownloadLink> maybebadfilenames = new ArrayList<DownloadLink>();
        ArrayList<CrawledLink> processLinks = new ArrayList<CrawledLink>();
        HashMap<Object, Object> cache = this.autoRenameCache.get(pkg);
        HashSet<String> nameCache = null;
        if (cache != null) {
            nameCache = (HashSet<String>)cache.get("nameCache");
        }
        if (nameCache == null) {
            nameCache = new HashSet<String>();
            if (cache != null) {
                cache.put("nameCache", nameCache);
            }
        }
        boolean newNames = false;
        for (CrawledLink link : pkgchildren) {
            name = link.getDownloadLink().getNameSetbyPlugin();
            if (!AvailableLinkState.ONLINE.equals((Object)link.getLinkState()) || name == null) continue;
            hosts.add(link.gethPlugin().getLazyP());
            if (!link.gethPlugin().isHosterManipulatesFilenames()) {
                nameCache.add(name);
                dlinks.add(link.getDownloadLink());
                continue;
            }
            processLinks.add(link);
            maybebadfilenames.add(link.getDownloadLink());
        }
        if (hosts.size() > 1 && processLinks.size() > 0) {
            for (CrawledLink link : processLinks) {
                name = link.getDownloadLink().getNameSetbyPlugin();
                if (newNames || nameCache == null || nameCache.contains(name)) continue;
                newNames = true;
                break;
            }
            if (newNames) {
                if (cache == null) {
                    cache = new HashMap();
                    this.autoRenameCache.put(pkg, cache);
                }
                cache.put("nameCache", nameCache);
                for (CrawledLink link : processLinks) {
                    name = link.getDownloadLink().getNameSetbyPlugin();
                    if (name == null) continue;
                    nameCache.add(name);
                    String newName = link.gethPlugin().autoFilenameCorrection(cache, name, link.getDownloadLink(), dlinks);
                    if (newName == null) {
                        newName = link.gethPlugin().autoFilenameCorrection(cache, name, link.getDownloadLink(), maybebadfilenames);
                    }
                    if (newName == null || name.equals(newName)) continue;
                    this.logger.info("Renamed file " + name + " to " + newName);
                    link.getDownloadLink().setForcedFileName(newName);
                }
            }
        }
    }

    @Override
    public void moveOrAddAt(final CrawledPackage pkg, final List<CrawledLink> movechildren, final int moveChildrenindex, final int pkgIndex) {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                for (CrawledLink l : movechildren) {
                    LinkCollector.this.putCrawledLinkByLinkID(l.getLinkID(), l);
                }
                LinkCollector.super.moveOrAddAt(pkg, movechildren, moveChildrenindex, pkgIndex);
                return null;
            }
        });
    }

    private List<CrawledLink> getIdentifiedMap(CrawledPackageMappingID crawledPackageMappingID, HashMap<CrawledPackageMappingID, List<CrawledLink>> map) {
        List<CrawledLink> list = map.get(crawledPackageMappingID);
        if (list == null) {
            list = new ArrayList<CrawledLink>();
            if (crawledPackageMappingID != null) {
                map.put(crawledPackageMappingID, list);
            }
        }
        return list;
    }

    public void addCrawledLink(final CrawledLink link) {
        final LinkCollectingInformation info = link.getCollectingInfo();
        if (info != null && info.isAborted()) {
            this.clearCrawledLinkReferences(link);
        } else {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){
                private LinkCollectingInformation lci;
                {
                    this.lci = info;
                }

                protected void onEnqueu(Queue queue) {
                    if (info != null) {
                        info.enqueu(this, link);
                    }
                }

                protected void postRun() {
                    this.dequeu();
                }

                private void dequeu() {
                    LinkCollectingInformation info2 = this.lci;
                    this.lci = null;
                    if (info2 != null) {
                        info2.dequeu(this, link);
                    }
                }

                private CrawledPackage addToNewPackage(List<CrawledLink> links, String newPackageName, CrawledPackageMappingID crawledPackageMappingID) {
                    CrawledPackage pkg = new CrawledPackage();
                    pkg.setExpanded(CFG_LINKCOLLECTOR.CFG.isPackageAutoExpanded());
                    pkg.setName(newPackageName);
                    pkg.setDownloadFolder(crawledPackageMappingID.getDownloadFolderRaw());
                    LinkCollector.this.addPackageMapping(pkg, crawledPackageMappingID);
                    if (links != null && links.size() > 0) {
                        LinkCollector.this.moveOrAddAt(pkg, links, -1);
                    }
                    if (crawledPackageMappingID.getPackageName() != null) {
                        List<CrawledLink> bad;
                        List various;
                        List offline = (List)LinkCollector.this.offlineMap.remove(crawledPackageMappingID);
                        if (offline != null && offline.size() > 0) {
                            LinkCollector.this.moveOrAddAt(pkg, offline, -1);
                        }
                        if ((various = (List)LinkCollector.this.variousMap.remove(crawledPackageMappingID)) != null && various.size() > 0) {
                            LinkCollector.this.moveOrAddAt(pkg, various, -1);
                        }
                        if ((bad = this.getBadMappings(crawledPackageMappingID, pkg)) != null && bad.size() > 0) {
                            LinkCollector.this.moveOrAddAt(pkg, bad, -1);
                        }
                    } else {
                        this.putBadMappings(newPackageName, crawledPackageMappingID, links);
                    }
                    return pkg;
                }

                private CrawledPackage addToExistingPackage(List<CrawledLink> links, CrawledPackage pkg, CrawledPackageMappingID crawledPackageMappingID) {
                    String packageName = pkg.getName();
                    if (links != null && links.size() > 0) {
                        LinkCollector.this.moveOrAddAt(pkg, links, -1);
                    }
                    if (crawledPackageMappingID.getPackageName() != null) {
                        if (!CrawledPackage.TYPE.VARIOUS.equals((Object)pkg.getType())) {
                            List<CrawledLink> bad;
                            List various;
                            List offline = (List)LinkCollector.this.offlineMap.remove(crawledPackageMappingID);
                            if (offline != null && offline.size() > 0) {
                                LinkCollector.this.moveOrAddAt(pkg, offline, -1);
                            }
                            if ((various = (List)LinkCollector.this.variousMap.remove(crawledPackageMappingID)) != null && various.size() > 0) {
                                LinkCollector.this.moveOrAddAt(pkg, various, -1);
                            }
                            if ((bad = this.getBadMappings(crawledPackageMappingID, pkg)) != null && bad.size() > 0) {
                                LinkCollector.this.moveOrAddAt(pkg, bad, -1);
                            }
                        }
                    } else {
                        this.putBadMappings(packageName, crawledPackageMappingID, links);
                    }
                    return pkg;
                }

                private void putBadMappings(String newPackageName, CrawledPackageMappingID crawledPackageMappingID, List<CrawledLink> links) {
                    CrawledPackageMappingID badID = new CrawledPackageMappingID(crawledPackageMappingID.getId(), null, crawledPackageMappingID.getDownloadFolderRaw());
                    ArrayList<CrawledLink> badMappings = (ArrayList<CrawledLink>)LinkCollector.this.badMappingMap.get(badID);
                    if (links != null) {
                        for (CrawledLink link2 : links) {
                            DownloadLink dlLink = link2.getDownloadLink();
                            if (dlLink.getContainerUrl() == null && dlLink.getOriginUrl() == null) continue;
                            if (badMappings == null) {
                                badMappings = new ArrayList<CrawledLink>();
                                LinkCollector.this.badMappingMap.put(badID, badMappings);
                            }
                            badMappings.add(link2);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private List<CrawledLink> getBadMappings(CrawledPackageMappingID crawledPackageMappingID, CrawledPackage pkg) {
                    ArrayList<CrawledLink> ret = new ArrayList<CrawledLink>();
                    CrawledPackageMappingID badID = new CrawledPackageMappingID(crawledPackageMappingID.getId(), null, crawledPackageMappingID.getDownloadFolderRaw());
                    List badMappings = (List)LinkCollector.this.badMappingMap.get(badID);
                    if (badMappings != null) {
                        DownloadLink dlLink;
                        HashSet<String> searchFor = new HashSet<String>();
                        boolean readL = pkg.getModifyLock().readLock();
                        try {
                            for (CrawledLink cLink : pkg.getChildren()) {
                                dlLink = cLink.getDownloadLink();
                                searchFor.add(dlLink.getContainerUrl());
                                searchFor.add(dlLink.getOriginUrl());
                            }
                        }
                        finally {
                            pkg.getModifyLock().readUnlock(readL);
                        }
                        searchFor.remove(null);
                        for (CrawledLink cLink : badMappings) {
                            dlLink = cLink.getDownloadLink();
                            if (!searchFor.contains(dlLink.getContainerUrl()) && !searchFor.contains(dlLink.getOriginUrl())) continue;
                            ret.add(cLink);
                        }
                        badMappings.removeAll(ret);
                        if (badMappings.size() == 0) {
                            LinkCollector.this.badMappingMap.remove(badID);
                        }
                    }
                    return ret;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private CrawledPackage getCrawledPackage(CrawledPackageMappingID crawledPackageMappingID, CrawledLink mappingLink) {
                    CrawledPackage ret = (CrawledPackage)LinkCollector.this.packageMapIDtoPackage.get(crawledPackageMappingID);
                    if (ret == null && crawledPackageMappingID.getPackageName() == null) {
                        String containerURL = mappingLink.getDownloadLink().getContainerUrl();
                        String originURL = mappingLink.getDownloadLink().getOriginUrl();
                        if (containerURL != null || originURL != null) {
                            HashMap bestMappings = new HashMap();
                            for (Map.Entry chance : LinkCollector.this.packageMapIDtoPackage.entrySet()) {
                                int equals = 0;
                                if (StringUtils.equals((String)crawledPackageMappingID.getId(), (String)((CrawledPackageMappingID)chance.getKey()).getId())) {
                                    ++equals;
                                }
                                if (StringUtils.equals((String)crawledPackageMappingID.getDownloadFolder(), (String)((CrawledPackageMappingID)chance.getKey()).getDownloadFolder())) {
                                    ++equals;
                                }
                                if (equals <= 0) continue;
                                Integer eq = equals;
                                HashMap mappings = (HashMap)bestMappings.get(eq);
                                if (mappings == null) {
                                    mappings = new HashMap();
                                    bestMappings.put(eq, mappings);
                                }
                                mappings.put(chance.getKey(), chance.getValue());
                            }
                            for (int x = 2; x > 0; --x) {
                                HashMap mappings = (HashMap)bestMappings.get(x);
                                if (mappings == null) continue;
                                for (Map.Entry mapping : mappings.entrySet()) {
                                    CrawledPackage pkg = (CrawledPackage)mapping.getValue();
                                    boolean readL = pkg.getModifyLock().readLock();
                                    try {
                                        for (CrawledLink cLink : pkg.getChildren()) {
                                            DownloadLink dlLink = cLink.getDownloadLink();
                                            if (dlLink == null || (containerURL == null || !StringUtils.equals((String)dlLink.getContainerUrl(), (String)containerURL)) && (originURL == null || !StringUtils.equals((String)dlLink.getOriginUrl(), (String)originURL))) continue;
                                            CrawledPackageMappingID id = (CrawledPackageMappingID)mapping.getKey();
                                            if (id.getPackageName() != null) {
                                                CrawledPackage crawledPackage = pkg;
                                                return crawledPackage;
                                            }
                                            if (ret == null) continue;
                                            ret = pkg;
                                        }
                                    }
                                    finally {
                                        pkg.getModifyLock().readUnlock(readL);
                                    }
                                }
                            }
                        }
                    }
                    return ret;
                }

                protected Void run() throws RuntimeException {
                    try {
                        if (info != null && info.isAborted()) {
                            Void void_ = null;
                            return void_;
                        }
                        CrawledLink existingLink = LinkCollector.this.findDupe(link);
                        if (existingLink != null && existingLink != link) {
                            if (existingLink.getMatchingFilter() != null && LinkCollector.this.filteredStuff.remove(existingLink)) {
                                LinkCollector.this.clearCrawledLinkReferences(existingLink);
                                LinkCollector.this.cleanupMaps(null, null, Arrays.asList(existingLink));
                                LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollector.this.filteredStuff.size() > 0 ? LinkCollectorEvent.TYPE.FILTERED_AVAILABLE : LinkCollectorEvent.TYPE.FILTERED_EMPTY));
                            } else {
                                LinkCollector.this.clearCrawledLinkReferences(link);
                                LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.DUPE_LINK, link, Queue.QueuePriority.NORM));
                                Void void_ = null;
                                return void_;
                            }
                        }
                        if (info == null || !info.isAborted()) {
                            ArrayList<CrawledLink> add;
                            CrawledPackageMappingID crawledPackageMapID;
                            CrawledPackage pkg;
                            String downloadFolder;
                            boolean ignoreSpecialPackages;
                            String linkID = link.getLinkID();
                            LinkCollector.this.putCrawledLinkByLinkID(linkID, link);
                            if (link.getDownloadLink() != null) {
                                link.getDownloadLink().setNodeChangeListener(link);
                            }
                            PackageInfo dpi = link.getDesiredPackageInfo();
                            UniqueAlltimeID uID = null;
                            String crawledPackageName = null;
                            String crawledPackageID = null;
                            boolean bl = ignoreSpecialPackages = dpi != null && (dpi.isPackagizerRuleMatched() || Boolean.TRUE.equals(dpi.isIgnoreVarious()));
                            if (dpi != null) {
                                crawledPackageName = dpi.getName();
                                String destinationFolder = dpi.getDestinationFolder();
                                if (destinationFolder == null) {
                                    destinationFolder = dpi.getDestinationFolderRoot();
                                } else if (!CrossSystem.isAbsolutePath((String)destinationFolder) && dpi.getDestinationFolderRoot() != null) {
                                    destinationFolder = new File(dpi.getDestinationFolderRoot(), destinationFolder).getPath();
                                }
                                downloadFolder = destinationFolder;
                                if (downloadFolder != null && !ignoreSpecialPackages) {
                                    String compareCustom = downloadFolder.replaceAll("(.+?)(/|\\\\)+$", "$1");
                                    String compareDefault = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder();
                                    if (compareDefault != null) {
                                        compareDefault = compareDefault.replaceAll("(.+?)(/|\\\\)+$", "$1");
                                    }
                                    if (CrossSystem.isWindows()) {
                                        if (!compareCustom.equalsIgnoreCase(compareDefault)) {
                                            ignoreSpecialPackages = true;
                                        }
                                    } else if (!compareCustom.equals(compareDefault)) {
                                        ignoreSpecialPackages = true;
                                    }
                                }
                                if ((uID = dpi.getUniqueId()) != null) {
                                    crawledPackageID = dpi.getUniqueId().toString();
                                    if (ignoreSpecialPackages && LinkCrawler.PERMANENT_OFFLINE_ID == uID) {
                                        crawledPackageID = null;
                                    }
                                }
                                if (StringUtils.isNotEmpty((String)dpi.getPackageKey())) {
                                    crawledPackageID = dpi.getPackageKey();
                                }
                            } else {
                                downloadFolder = null;
                            }
                            if (crawledPackageName == null) {
                                CrawledLinkFactory clf;
                                Archive archive;
                                ExtractionExtension lArchiver;
                                DownloadLink dlLink = link.getDownloadLink();
                                String fileName = link.isNameSet() || dlLink.isNameSet() ? link.getName() : LinkCrawler.getUnsafeName(link.getName(), null);
                                String filenameForPackagenameDerivation = null;
                                if (fileName != null) {
                                    if (AvailableLinkState.ONLINE.equals((Object)link.getLinkState())) {
                                        filenameForPackagenameDerivation = fileName;
                                    } else {
                                        CompiledFiletypeFilter.ExtensionsFilterInterface extension = link.getLinkInfo().getExtension();
                                        if (!"".equalsIgnoreCase(extension.name())) {
                                            if (!CompiledFiletypeFilter.DocumentExtensions.HTML.equals(extension.getSource()) && !CompiledFiletypeFilter.DocumentExtensions.PHP.equals(extension.getSource())) {
                                                filenameForPackagenameDerivation = fileName;
                                            } else {
                                                String tmpFileName = fileName.replaceFirst("(?i)\\.(html?|php)$", "");
                                                CompiledFiletypeFilter.CompiledFiletypeExtension tmpExtension = CompiledFiletypeFilter.getExtensionsFilterInterface(Files.getExtension((String)tmpFileName));
                                                if (tmpExtension != null) {
                                                    filenameForPackagenameDerivation = tmpFileName;
                                                }
                                            }
                                        }
                                    }
                                }
                                if (filenameForPackagenameDerivation == null && link.getLinkInfo().getExtension() instanceof CompiledFiletypeFilter.ArchiveExtensions && (lArchiver = LinkCollector.this.archiver) != null && CFG_LINKGRABBER.ARCHIVE_PACKAGIZER_ENABLED.isEnabled() && (archive = lArchiver.buildArchive((ArchiveFactory)(clf = new CrawledLinkFactory(link)))) != null && archive.getArchiveFiles().size() > 1) {
                                    if (crawledPackageID == null) {
                                        crawledPackageID = archive.getArchiveID();
                                    }
                                    filenameForPackagenameDerivation = archive.getName();
                                }
                                if (filenameForPackagenameDerivation == null) {
                                    filenameForPackagenameDerivation = link.getName();
                                }
                                if (filenameForPackagenameDerivation != null) {
                                    crawledPackageName = LinknameCleaner.derivePackagenameFromFilename(filenameForPackagenameDerivation);
                                    crawledPackageName = LinknameCleaner.cleanPackagename(crawledPackageName, true);
                                }
                            }
                            if ((pkg = this.getCrawledPackage(crawledPackageMapID = new CrawledPackageMappingID(crawledPackageID, crawledPackageName, downloadFolder), link)) == null) {
                                CrawledPackage newPkg;
                                List list;
                                if (!ignoreSpecialPackages && LinkCrawler.PERMANENT_OFFLINE_ID == uID) {
                                    add = new ArrayList(1);
                                    add.add(link);
                                    list = LinkCollector.this.getIdentifiedMap(crawledPackageMapID, LinkCollector.this.offlineMap);
                                    list.add(link);
                                    LinkCollector.this.moveOrAddAt(LinkCollector.this.getPermanentOfflineCrawledPackage(), add, -1);
                                } else if (!ignoreSpecialPackages && link.getLinkState() == AvailableLinkState.OFFLINE && CFG_LINKGRABBER.OFFLINE_PACKAGE_ENABLED.isEnabled()) {
                                    add = new ArrayList(1);
                                    add.add(link);
                                    list = LinkCollector.this.getIdentifiedMap(crawledPackageMapID, LinkCollector.this.offlineMap);
                                    list.add(link);
                                    LinkCollector.this.moveOrAddAt(LinkCollector.this.getOfflineCrawledPackage(), add, -1);
                                } else if (!ignoreSpecialPackages && (Integer)CFG_LINKGRABBER.VARIOUS_PACKAGE_LIMIT.getValue() > 0 && CFG_LINKGRABBER.VARIOUS_PACKAGE_ENABLED.isEnabled()) {
                                    List list2;
                                    if (!crawledPackageMapID.isNull() || !AvailableLinkState.OFFLINE.equals((Object)link.getLinkState())) {
                                        list2 = LinkCollector.this.getIdentifiedMap(crawledPackageMapID, LinkCollector.this.variousMap);
                                        list2.add(link);
                                    } else {
                                        list2 = null;
                                    }
                                    if (list2 != null && list2.size() > (Integer)CFG_LINKGRABBER.VARIOUS_PACKAGE_LIMIT.getValue()) {
                                        newPkg = this.addToNewPackage(list2, crawledPackageName, crawledPackageMapID);
                                        if (dpi != null) {
                                            newPkg.setComment(dpi.getComment());
                                        }
                                    } else {
                                        ArrayList<CrawledLink> add2 = new ArrayList<CrawledLink>(1);
                                        add2.add(link);
                                        this.addToExistingPackage(add2, LinkCollector.this.getVariousCrawledPackage(), crawledPackageMapID);
                                    }
                                } else {
                                    add = new ArrayList(1);
                                    add.add(link);
                                    newPkg = this.addToNewPackage(add, crawledPackageName, crawledPackageMapID);
                                    if (dpi != null) {
                                        newPkg.setComment(dpi.getComment());
                                    }
                                }
                            } else {
                                add = new ArrayList<CrawledLink>(1);
                                add.add(link);
                                this.addToExistingPackage(add, pkg, crawledPackageMapID);
                            }
                            this.dequeu();
                            LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.ADDED_LINK, link, Queue.QueuePriority.NORM));
                            LinkCollector.this.autoStartManager.onLinkAdded(link);
                        }
                        Void void_ = null;
                        return void_;
                    }
                    catch (Throwable e) {
                        LinkCollector.this.removeCrawledLinkByLinkID(link);
                        LinkCollector.this.logger.log(e);
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    finally {
                        LinkCollector.this.clearCrawledLinkReferences(link);
                    }
                }
            });
        }
    }

    private CrawledPackage getPermanentOfflineCrawledPackage() {
        CrawledPackage lpermanentofflinePackage = this.permanentofflinePackage;
        if (lpermanentofflinePackage != null && CrawledPackage.TYPE.POFFLINE == lpermanentofflinePackage.getType()) {
            return lpermanentofflinePackage;
        }
        lpermanentofflinePackage = new CrawledPackage();
        lpermanentofflinePackage.setExpanded(CFG_LINKCOLLECTOR.CFG.isPackageAutoExpanded());
        lpermanentofflinePackage.setName(_GUI.T.Permanently_Offline_Package());
        lpermanentofflinePackage.setType(CrawledPackage.TYPE.POFFLINE);
        this.permanentofflinePackage = lpermanentofflinePackage;
        return lpermanentofflinePackage;
    }

    private CrawledPackage getVariousCrawledPackage() {
        CrawledPackage lvariousPackage = this.variousPackage;
        if (lvariousPackage != null && CrawledPackage.TYPE.VARIOUS == lvariousPackage.getType()) {
            return lvariousPackage;
        }
        lvariousPackage = new CrawledPackage();
        lvariousPackage.setExpanded(CFG_LINKCOLLECTOR.CFG.isPackageAutoExpanded());
        lvariousPackage.setName(_JDT.T.LinkCollector_addCrawledLink_variouspackage());
        lvariousPackage.setType(CrawledPackage.TYPE.VARIOUS);
        this.variousPackage = lvariousPackage;
        return lvariousPackage;
    }

    private CrawledPackage getOfflineCrawledPackage() {
        CrawledPackage lofflinePackage = this.offlinePackage;
        if (lofflinePackage != null && CrawledPackage.TYPE.OFFLINE == lofflinePackage.getType()) {
            return lofflinePackage;
        }
        lofflinePackage = new CrawledPackage();
        lofflinePackage.setExpanded(CFG_LINKCOLLECTOR.CFG.isPackageAutoExpanded());
        lofflinePackage.setName(_JDT.T.LinkCollector_addCrawledLink_offlinepackage());
        lofflinePackage.setType(CrawledPackage.TYPE.OFFLINE);
        this.offlinePackage = lofflinePackage;
        return lofflinePackage;
    }

    public LinkCrawler addCrawlerJob(List<CrawledLink> links, LinkCollectingJob job) {
        if (ShutdownController.getInstance().isShutDownRequested()) {
            return null;
        }
        if (links == null || links.size() == 0) {
            throw new IllegalArgumentException("no links");
        }
        JobLinkCrawler lc = this.newJobLinkCrawler(job);
        lc.crawl(new ArrayList<CrawledLink>(links));
        return lc;
    }

    public JobLinkCrawler newJobLinkCrawler(LinkCollectingJob job) {
        JobLinkCrawler ret = new JobLinkCrawler(this, job);
        this.getEventsender().fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.NEW_CRAWLER_JOB, job, Queue.QueuePriority.NORM));
        this.logger.info("Added CrawlerJob:" + job);
        return ret;
    }

    public LinkCrawler addCrawlerJob(LinkCollectingJob job) {
        try {
            if (ShutdownController.getInstance().isShutDownRequested()) {
                return null;
            }
            if (job == null) {
                throw new IllegalArgumentException("job is null");
            }
            JobLinkCrawler lc = this.newJobLinkCrawler(job);
            String jobText = job.consumeText();
            if (StringUtils.isNotEmpty((String)jobText) && jobText.length() > 500) {
                job.setText(null);
            }
            lc.crawl(jobText, job.getCustomSourceUrl(), job.isDeepAnalyse());
            return lc;
        }
        catch (VerifyError e) {
            this.logger.log((Throwable)e);
            throw e;
        }
    }

    private void addFilteredStuff(final CrawledLink filtered, final boolean checkDupe) {
        final LinkCollectingInformation info = filtered.getCollectingInfo();
        filtered.setCollectingInfo(null);
        if (!CFG_LINKGRABBER.RESTORE_BUTTON_ENABLED.isEnabled() || Application.isHeadless()) {
            this.clearCrawledLinkReferences(filtered);
            return;
        }
        this.QUEUE.addAsynch((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected void onEnqueu(Queue queue) {
                if (info != null) {
                    info.enqueu(this, filtered);
                }
            }

            protected boolean allowAsync() {
                return true;
            }

            protected void postRun() {
                if (info != null) {
                    info.dequeu(this, filtered);
                }
            }

            protected Void run() throws RuntimeException {
                CrawledLink existingLink;
                if (checkDupe && (existingLink = LinkCollector.this.findDupe(filtered)) != null) {
                    LinkCollector.this.clearCrawledLinkReferences(filtered);
                    LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.DUPE_LINK, filtered, Queue.QueuePriority.NORM));
                    return null;
                }
                String linkID = filtered.getLinkID();
                LinkCollector.this.putCrawledLinkByLinkID(linkID, filtered);
                LinkCollector.this.filteredStuff.add(filtered);
                LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.FILTERED_AVAILABLE));
                return null;
            }
        });
    }

    protected CrawledLink findDupe(CrawledLink filtered) {
        PluginForHost hPlugin;
        String linkID = filtered.getLinkID();
        CrawledLink existingLink = this.getCrawledLinkByLinkID(linkID);
        while (existingLink != null && (hPlugin = filtered.gethPlugin()) != null && hPlugin.onLinkCollectorDupe(existingLink, filtered)) {
            linkID = filtered.getLinkID();
            existingLink = this.getCrawledLinkByLinkID(linkID);
        }
        return existingLink;
    }

    protected void cleanupMaps(CrawledPackage pkg, CrawledPackageMappingID lastKnownMapping, List<CrawledLink> links) {
        if (links == null || links.size() == 0) {
            return;
        }
        CrawledPackage.TYPE type = pkg != null ? pkg.getType() : null;
        for (CrawledLink l : links) {
            this.removeCrawledLinkByLinkID(l);
            if (lastKnownMapping != null) {
                if (this.removeFromMap(this.variousMap, lastKnownMapping, l) != null || this.removeFromMap(this.offlineMap, lastKnownMapping, l) != null || this.removeFromMap(this.badMappingMap, lastKnownMapping, l) == null) continue;
                continue;
            }
            if (CrawledPackage.TYPE.VARIOUS == type && this.removeFromMap(this.variousMap, null, l) != null || CrawledPackage.TYPE.OFFLINE == type && this.removeFromMap(this.offlineMap, null, l) != null || this.removeFromMap(this.badMappingMap, null, l) != null || this.removeFromMap(this.variousMap, null, l) != null) continue;
            this.removeFromMap(this.offlineMap, null, l);
        }
    }

    public void clearFilteredLinks() {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                LinkCollector.this.cleanupMaps(null, null, LinkCollector.this.filteredStuff);
                LinkCollector.this.filteredStuff.clear();
                LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.FILTERED_EMPTY));
                return null;
            }
        });
    }

    @Override
    public void clear() {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                LinkCollector.super.clear();
                LinkCollector.this.filteredStuff.clear();
                LinkCollector.this.dupeCheckMap.clear();
                LinkCollector.this.offlinePackage = null;
                LinkCollector.this.variousPackage = null;
                LinkCollector.this.permanentofflinePackage = null;
                LinkCollector.this.variousMap.clear();
                LinkCollector.this.badMappingMap.clear();
                LinkCollector.this.offlineMap.clear();
                LinkCollector.this.autoRenameCache.isEmpty();
                LinkCollector.this.asyncCacheCleanup.stop();
                LinkCollector.this.asyncCacheCleanup.delayedrun();
                LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.FILTERED_EMPTY));
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilePackage createFilePackage(CrawledPackage pkg, List<CrawledLink> plinks) {
        FilePackage ret = FilePackage.getInstance();
        ret.setPriorityEnum(pkg.getPriorityEnum());
        ret.setName(pkg.getName());
        ret.setDownloadDirectory(LinkTreeUtils.getDownloadDirectory(pkg).getAbsolutePath());
        ret.setCreated(pkg.getCreated());
        ret.setExpanded(pkg.isExpanded());
        ret.setComment(pkg.getComment());
        ArrayList<CrawledLink> pkgLinks = null;
        if (plinks != null && plinks.size() > 0) {
            pkgLinks = new ArrayList<CrawledLink>(plinks);
        } else {
            boolean readL = pkg.getModifyLock().readLock();
            try {
                pkgLinks = new ArrayList<CrawledLink>(pkg.getChildren());
            }
            finally {
                pkg.getModifyLock().readUnlock(readL);
            }
        }
        ArrayList<DownloadLink> links = new ArrayList<DownloadLink>(pkgLinks.size());
        for (CrawledLink link : pkgLinks) {
            DownloadLink dl = link.getDownloadLink();
            if (dl == null) continue;
            dl.setNodeChangeListener(null);
            if (link.isNameSet()) {
                dl.setForcedFileName(link.getName());
            }
            dl.setEnabled(link.isEnabled());
            dl.setCreated(link.getCreated());
            links.add(dl);
            dl.setParentNode(ret);
        }
        ret.getChildren().addAll(links);
        return ret;
    }

    public LinkCrawlerFilter getCrawlerFilter() {
        return LinkFilterController.getInstance();
    }

    public List<CrawledLink> getFilteredStuff(final boolean clearAfterGet) {
        return this.QUEUE.addWait(new QueueAction<List<CrawledLink>, RuntimeException>(){

            protected List<CrawledLink> run() throws RuntimeException {
                ArrayList<CrawledLink> ret2 = new ArrayList<CrawledLink>(LinkCollector.this.filteredStuff);
                if (clearAfterGet) {
                    LinkCollector.this.filteredStuff.clear();
                    LinkCollector.this.cleanupMaps(null, null, ret2);
                    LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.FILTERED_EMPTY));
                }
                return ret2;
            }
        });
    }

    public int getfilteredStuffSize() {
        return this.filteredStuff.size();
    }

    public synchronized LinkChecker<CrawledLink> getDefaultLinkChecker() {
        if (this.defaultLinkChecker == null) {
            LinkChecker<CrawledLink> linkChecker = new LinkChecker<CrawledLink>();
            linkChecker.setLinkCheckHandler(this);
            this.defaultLinkChecker = linkChecker;
        }
        return this.defaultLinkChecker;
    }

    @Override
    public void handleFilteredLink(CrawledLink link) {
        this.addFilteredStuff(link, true);
    }

    private final void clearCrawledLinkReferences(CrawledLink link) {
        if (link == null) {
            return;
        }
        link.setBrokenCrawlerHandler(null);
        link.setCustomCrawledLinkModifier(null);
        link.setUnknownHandler(null);
        link.setDesiredPackageInfo(null);
        link.setSourceLink(null);
        link.setCollectingInfo(null);
        link.setSourceJob(null);
        link.setMatchingFilter(null);
        link.setMatchingRule(null);
    }

    @Override
    public void handleFinalLink(CrawledLink link) {
        this.handleFinalLink(link, this.getDefaultLinkChecker());
    }

    public void handleFinalLink(final CrawledLink link, final LinkChecker<CrawledLink> linkChecker) {
        final LinkCollectingInformation info = link.getCollectingInfo();
        if (info != null && info.isAborted()) {
            this.clearCrawledLinkReferences(link);
        } else if (CFG_LINKCOLLECTOR.DO_LINK_CHECK.isEnabled()) {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.LOW){

                protected void onEnqueu(Queue queue) {
                    if (info != null) {
                        info.enqueu(this, link);
                    }
                }

                protected void postRun() {
                    if (info != null) {
                        info.dequeu(this, link);
                    }
                }

                protected Void run() throws RuntimeException {
                    if (info != null && info.isAborted()) {
                        LinkCollector.this.clearCrawledLinkReferences(link);
                    } else {
                        CrawledLink existingLink = LinkCollector.this.findDupe(link);
                        if (existingLink != null && existingLink.getMatchingFilter() == null) {
                            String linkID = link.getLinkID();
                            LinkCollector.this.logger.info("Filtered Dupe: " + linkID);
                            LinkCollector.this.clearCrawledLinkReferences(link);
                            LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.DUPE_LINK, link, Queue.QueuePriority.NORM));
                            return null;
                        }
                        linkChecker.check(link);
                    }
                    return null;
                }
            });
        } else {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.LOW){
                private LinkCollectingInformation lci;
                {
                    super(x0);
                    this.lci = info;
                }

                protected void onEnqueu(Queue queue) {
                    if (info != null) {
                        info.enqueu(this, link);
                    }
                }

                protected void postRun() {
                    this.dequeu();
                }

                private void dequeu() {
                    LinkCollectingInformation info2 = this.lci;
                    this.lci = null;
                    if (info2 != null) {
                        info2.dequeu(this, link);
                    }
                }

                protected Void run() throws RuntimeException {
                    if (info != null && info.isAborted()) {
                        LinkCollector.this.clearCrawledLinkReferences(link);
                    } else {
                        LinkCollector.applyJobCrawledLinkModifier(link, true, LinkCollector.this.logger);
                        PackagizerController pc = PackagizerController.getInstance();
                        if (pc != null) {
                            pc.runByUrl(link);
                        }
                        LinkCollector.applyJobCrawledLinkModifier(link, false, LinkCollector.this.logger);
                        this.dequeu();
                        LinkCollector.this.addCrawledLink(link);
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void linkCheckDone(final CrawledLink link) {
        if (this.getCrawlerFilter().dropByFileProperties(link)) {
            this.addFilteredStuff(link, false);
        } else {
            if (!this.addGenericVariant(link.getDownloadLink())) {
                return;
            }
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.LOW){

                protected Void run() throws RuntimeException {
                    LinkCollector.applyJobCrawledLinkModifier(link, true, LinkCollector.this.logger);
                    PackagizerController pc = PackagizerController.getInstance();
                    if (pc != null) {
                        pc.runByFile(link);
                    }
                    LinkCollector.applyJobCrawledLinkModifier(link, false, LinkCollector.this.logger);
                    LinkCollector.this.addCrawledLink(link);
                    return null;
                }
            });
        }
    }

    public static void applyJobCrawledLinkModifier(CrawledLink link, boolean prePackagizer, LogSource logger) {
        if (link == null) {
            return;
        }
        LinkCollectingJob job = link.getSourceJob();
        if (job == null) {
            return;
        }
        List<CrawledLinkModifier> modifiers = prePackagizer ? job.getPrePackagizerModifier() : job.getPostPackagizerModifier();
        for (CrawledLinkModifier modifier : modifiers) {
            try {
                modifier.modifyCrawledLink(link);
            }
            catch (Throwable e) {
                logger.log(e);
            }
        }
    }

    private boolean addGenericVariant(final DownloadLink downloadLink) {
        List<GenericVariants> converts;
        if (!downloadLink.hasVariantSupport() && (converts = downloadLink.getDefaultPlugin().getGenericVariants(downloadLink)) != null && converts.size() > 0) {
            final ArrayList<GenericVariants> variants = new ArrayList<GenericVariants>();
            variants.add(GenericVariants.ORIGINAL);
            variants.addAll(converts);
            if (variants.size() > 1) {
                return Boolean.TRUE.equals(this.getQueue().addWait(new QueueAction<Boolean, RuntimeException>(){

                    protected Boolean run() throws RuntimeException {
                        downloadLink.setProperty("GENERIC_VARIANTS", true);
                        downloadLink.setVariants(variants);
                        downloadLink.setVariant(GenericVariants.ORIGINAL);
                        CrawledLink existing = LinkCollector.this.getCrawledLinkByLinkID(downloadLink.getLinkID());
                        if (existing != null && existing.getDownloadLink() != downloadLink) {
                            LinkCollector.this.logger.info("Dupecheck Filtered Variant");
                            return Boolean.FALSE;
                        }
                        downloadLink.setVariantSupport(true);
                        return Boolean.TRUE;
                    }
                }));
            }
        }
        return true;
    }

    public List<FilePackage> convert(final List<CrawledLink> links, final boolean removeLinks) {
        if (links == null || links.size() == 0) {
            return null;
        }
        return this.QUEUE.addWait(new QueueAction<List<FilePackage>, RuntimeException>(){

            protected List<FilePackage> run() throws RuntimeException {
                ArrayList<FilePackage> ret = new ArrayList<FilePackage>();
                HashMap<CrawledPackage, ArrayList<CrawledLink>> map = new HashMap<CrawledPackage, ArrayList<CrawledLink>>();
                for (CrawledLink link : links) {
                    CrawledPackage parent = link.getParentNode();
                    if (parent == null || parent.getControlledBy() != LinkCollector.this) {
                        LinkCollector.this.logger.log(new Throwable("not controlled by this packagecontroller"));
                        continue;
                    }
                    ArrayList<CrawledLink> pkg_links = (ArrayList<CrawledLink>)map.get(parent);
                    if (pkg_links == null) {
                        pkg_links = new ArrayList<CrawledLink>();
                        map.put(parent, pkg_links);
                    }
                    pkg_links.add(link);
                }
                for (Map.Entry next : map.entrySet()) {
                    ret.add(LinkCollector.this.createFilePackage((CrawledPackage)next.getKey(), (List)next.getValue()));
                    if (!removeLinks) continue;
                    LinkCollector.this.removeChildren((AbstractPackageNode)next.getKey(), (List)next.getValue(), true);
                }
                return ret;
            }
        });
    }

    private CrawledPackageMappingID removeFromMap(Map<CrawledPackageMappingID, List<CrawledLink>> idListMap, CrawledPackageMappingID lastKnownMapping, CrawledLink l) {
        if (lastKnownMapping != null) {
            List<CrawledLink> list = idListMap.get(lastKnownMapping);
            if (list != null && list.remove(l)) {
                if (list.size() == 0) {
                    idListMap.remove(lastKnownMapping);
                }
                return lastKnownMapping;
            }
            return null;
        }
        Iterator<Map.Entry<CrawledPackageMappingID, List<CrawledLink>>> mapIt = idListMap.entrySet().iterator();
        while (mapIt.hasNext()) {
            Map.Entry<CrawledPackageMappingID, List<CrawledLink>> map = mapIt.next();
            List<CrawledLink> list = map.getValue();
            if (list == null || !list.remove(l)) continue;
            if (list.size() == 0) {
                mapIt.remove();
            }
            return map.getKey();
        }
        return null;
    }

    private CrawledPackageMappingID getIDFromMap(Map<CrawledPackageMappingID, List<CrawledLink>> idListMap, CrawledLink l) {
        for (Map.Entry<CrawledPackageMappingID, List<CrawledLink>> elem : idListMap.entrySet()) {
            CrawledPackageMappingID identifier = elem.getKey();
            List<CrawledLink> mapElems = elem.getValue();
            if (mapElems == null || !mapElems.contains(l)) continue;
            return identifier;
        }
        return null;
    }

    private ArrayList<File> findAvailableCollectorLists() {
        this.logger.info("Collect Lists");
        File[] filesInCfg = null;
        File cfg = Application.getResource((String)"cfg/");
        if (Application.getJavaVersion() >= Application.JAVA17) {
            try {
                filesInCfg = J7FileList.findFiles((Pattern)Pattern.compile("^linkcollector.*?\\.zip$", 2), (File)cfg, (boolean)true).toArray(new File[0]);
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
            }
        }
        if (filesInCfg == null || filesInCfg.length == 0) {
            filesInCfg = Application.getResource((String)"cfg/").listFiles();
        }
        ArrayList<Long> sortedAvailable = new ArrayList<Long>();
        ArrayList<File> ret = new ArrayList<File>();
        if (filesInCfg != null) {
            for (File collectorList : filesInCfg) {
                String counter;
                String name = collectorList.getName();
                if (!name.startsWith("linkcollector") || !collectorList.isFile() || (counter = new Regex(name, "linkcollector(\\d+)\\.zip$").getMatch(0)) == null) continue;
                sortedAvailable.add(Long.parseLong(counter));
            }
            Collections.sort(sortedAvailable, Collections.reverseOrder());
        }
        for (Long loadOrder : sortedAvailable) {
            ret.add(Application.getResource((String)("cfg/linkcollector" + loadOrder + ".zip")));
        }
        if (Application.getResource((String)"cfg/linkcollector.zip").exists()) {
            ret.add(Application.getResource((String)"cfg/linkcollector.zip"));
        }
        this.logger.info("Lists: " + ret);
        this.linkcollectorLists.addAll(ret);
        return ret;
    }

    public void initLinkCollector() {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                ArrayList availableCollectorLists = LinkCollector.this.findAvailableCollectorLists();
                if (((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isSaveLinkgrabberListEnabled()) {
                    LinkedList lpackages = null;
                    HashMap<CrawledPackage, CrawledPackageStorable> restoreMap = new HashMap<CrawledPackage, CrawledPackageStorable>();
                    Object loadedList = null;
                    for (Object collectorList : availableCollectorLists) {
                        try {
                            if (lpackages == null) {
                                restoreMap.clear();
                                lpackages = LinkCollector.this.load((File)collectorList, restoreMap);
                                continue;
                            }
                            loadedList = collectorList;
                            break;
                        }
                        catch (Throwable e) {
                            LinkCollector.this.logger.log(e);
                        }
                    }
                    if (lpackages != null) {
                        int links = 0;
                        for (CrawledPackage cp : lpackages) {
                            links += cp.getChildren().size();
                        }
                        LinkCollector.this.logger.info("CollectorList found: " + lpackages.size() + "/" + links);
                    } else {
                        LinkCollector.this.logger.info("CollectorList empty!");
                        restoreMap.clear();
                        lpackages = new LinkedList();
                    }
                    try {
                        LinkCollector.this.importList(lpackages, restoreMap);
                    }
                    catch (Throwable e) {
                        if (loadedList != null) {
                            File renameTo = new File(((File)loadedList).getAbsolutePath() + ".backup");
                            boolean backup = false;
                            try {
                                if (((File)loadedList).exists()) {
                                    if (!((File)loadedList).renameTo(renameTo)) {
                                        IO.copyFile((File)loadedList, (File)renameTo);
                                    }
                                    backup = true;
                                }
                            }
                            catch (Throwable e2) {
                                LinkCollector.this.logger.log(e2);
                            }
                            LinkCollector.this.logger.severe("Could backup " + loadedList + " to " + renameTo + " ->" + backup);
                        }
                        LinkCollector.this.logger.log(e);
                    }
                    finally {
                        CRAWLERLIST_LOADED.setReached();
                    }
                } else {
                    CRAWLERLIST_LOADED.setReached();
                }
                return null;
            }
        });
    }

    public void importList(final LinkedList<CrawledPackage> lpackages, final Map<CrawledPackage, CrawledPackageStorable> restoreMap) {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                if (lpackages != null) {
                    LinkCollector.this.preProcessCrawledPackages(lpackages);
                    try {
                        LinkCollector.this.writeLock();
                        block11: for (CrawledPackage filePackage : lpackages) {
                            for (CrawledLink link : filePackage.getChildren()) {
                                if (link.getDownloadLink() == null) continue;
                                link.getDownloadLink().setNodeChangeListener(link);
                            }
                            filePackage.setControlledBy(LinkCollector.this);
                            if (restoreMap == null) continue;
                            CrawledPackageStorable storable = (CrawledPackageStorable)restoreMap.get(filePackage);
                            switch (filePackage.getType()) {
                                case NORMAL: {
                                    if (storable.getPackageID() == null) break;
                                    CrawledPackageMappingID packageID = CrawledPackageMappingID.get(storable.getPackageID());
                                    if (packageID == null || packageID.isNull()) continue block11;
                                    LinkCollector.this.addPackageMapping(filePackage, packageID);
                                    break;
                                }
                                case VARIOUS: {
                                    List list;
                                    CrawledPackageMappingID packageID;
                                    String id;
                                    if (LinkCollector.this.variousPackage == null) {
                                        LinkCollector.this.variousPackage = filePackage;
                                    }
                                    for (CrawledLinkStorable link : storable.getLinks()) {
                                        id = link.getID();
                                        if (id == null || (packageID = CrawledPackageMappingID.get(id)) == null) continue;
                                        list = LinkCollector.this.getIdentifiedMap(packageID, LinkCollector.this.variousMap);
                                        list.add(link._getCrawledLink());
                                    }
                                    continue block11;
                                }
                                case OFFLINE: {
                                    List list;
                                    CrawledPackageMappingID packageID;
                                    String id;
                                    if (LinkCollector.this.offlinePackage == null) {
                                        LinkCollector.this.offlinePackage = filePackage;
                                    }
                                    for (CrawledLinkStorable link : storable.getLinks()) {
                                        id = link.getID();
                                        if (id == null || (packageID = CrawledPackageMappingID.get(id)) == null) continue;
                                        list = LinkCollector.this.getIdentifiedMap(packageID, LinkCollector.this.offlineMap);
                                        list.add(link._getCrawledLink());
                                    }
                                    continue block11;
                                }
                                case POFFLINE: {
                                    if (LinkCollector.this.permanentofflinePackage != null) break;
                                    LinkCollector.this.permanentofflinePackage = filePackage;
                                }
                            }
                        }
                        LinkCollector.this.updateUniqueAlltimeIDMaps(lpackages);
                        for (CrawledPackage filePackage : lpackages) {
                            for (CrawledLink link : filePackage.getChildren()) {
                                try {
                                    LinkCollector.this.putCrawledLinkByLinkID(link.getLinkID(), link);
                                }
                                catch (Throwable e) {
                                    LinkCollector.this.logger.log(e);
                                }
                            }
                        }
                        LinkCollector.this.packages.addAll(0, lpackages);
                    }
                    finally {
                        LinkCollector.this.writeUnlock();
                    }
                    long version = LinkCollector.this.backendChanged.incrementAndGet();
                    LinkCollector.this.childrenChanged.set(version);
                    LinkCollector.this.structureChanged.set(version);
                    LinkCollector.this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.REFRESH_STRUCTURE));
                }
                return null;
            }
        });
    }

    private void preProcessCrawledPackages(LinkedList<CrawledPackage> fps) {
        if (fps == null || fps.size() == 0) {
            return;
        }
        Iterator iterator = fps.iterator();
        PluginFinder pluginFinder = new PluginFinder((LogInterface)this.logger);
        while (iterator.hasNext()) {
            CrawledPackage fp = (CrawledPackage)iterator.next();
            if (fp.getChildren() != null) {
                Iterator<CrawledLink> it = fp.getChildren().iterator();
                while (it.hasNext()) {
                    CrawledLink localLink = it.next();
                    DownloadLink dlLink = localLink.getDownloadLink();
                    if (dlLink == null) {
                        it.remove();
                        continue;
                    }
                    pluginFinder.assignPlugin(dlLink, true);
                }
            }
            if (fp.getChildren() != null && fp.getChildren().size() != 0) continue;
            iterator.remove();
        }
    }

    public void checkPluginUpdates() {
        if (CRAWLERLIST_LOADED.isReached()) {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){
                private final PluginFinder finder;
                {
                    this.finder = new PluginFinder((LogInterface)LinkCollector.this.logger);
                }

                protected Void run() throws RuntimeException {
                    LinkCollector.this.getChildrenByFilter(new AbstractPackageChildrenNodeFilter<CrawledLink>(){

                        @Override
                        public int returnMaxResults() {
                            return 0;
                        }

                        private final void updatePluginInstance(DownloadLink link) {
                            String newDefaultHost;
                            long newDefaultVersion;
                            long currentDefaultVersion;
                            String currentDefaultHost;
                            PluginForHost defaultPlugin = link.getDefaultPlugin();
                            if (defaultPlugin != null) {
                                currentDefaultHost = defaultPlugin.getLazyP().getHost();
                                currentDefaultVersion = defaultPlugin.getLazyP().getVersion();
                            } else {
                                currentDefaultHost = null;
                                currentDefaultVersion = -1L;
                            }
                            PluginForHost newDefaultPlugin = finder.assignPlugin(link, true);
                            if (newDefaultPlugin != null) {
                                newDefaultVersion = newDefaultPlugin.getLazyP().getVersion();
                                newDefaultHost = newDefaultPlugin.getLazyP().getHost();
                            } else {
                                newDefaultVersion = -1L;
                                newDefaultHost = null;
                            }
                            if (!(newDefaultPlugin == null || currentDefaultVersion == newDefaultVersion && StringUtils.equals((String)currentDefaultHost, (String)newDefaultHost))) {
                                LinkCollector.this.logger.info("Update Plugin for: " + link.getName() + ":" + link.getHost() + ":" + currentDefaultVersion + " to " + newDefaultPlugin.getLazyP().getDisplayName() + ":" + newDefaultPlugin.getLazyP().getVersion());
                                if (link.getFinalLinkState() == FinalLinkState.PLUGIN_DEFECT) {
                                    link.setFinalLinkState(null);
                                }
                            }
                        }

                        @Override
                        public boolean acceptNode(CrawledLink node) {
                            if (node.getDownloadLink() != null) {
                                this.updatePluginInstance(node.getDownloadLink());
                            }
                            return false;
                        }
                    });
                    return null;
                }
            });
        }
    }

    private LinkedList<CrawledPackage> load(File file, HashMap<CrawledPackage, CrawledPackageStorable> restoreMap) {
        try {
            return this.loadFile(file, restoreMap, false);
        }
        catch (Throwable e) {
            if (file != null) {
                File backupTo = new File(file.getAbsolutePath() + ".backup");
                boolean backupSucceeded = false;
                Long size = null;
                try {
                    if (file.exists()) {
                        size = file.length();
                        if (size > 0L) {
                            if (!file.renameTo(backupTo)) {
                                IO.copyFile((File)file, (File)backupTo);
                                backupSucceeded = backupTo.exists();
                                if (backupSucceeded && file.exists() && !file.delete()) {
                                    file.deleteOnExit();
                                }
                            } else {
                                backupSucceeded = backupTo.exists();
                            }
                        } else {
                            file.delete();
                        }
                    }
                }
                catch (Throwable e2) {
                    this.logger.log(e2);
                }
                if (backupSucceeded) {
                    this.logger.severe("Could backup " + file + "<to>" + backupTo);
                } else {
                    this.logger.severe("Could not backup " + file + "<to>" + backupTo + " because size=" + size);
                }
            }
            this.logger.log(e);
            return null;
        }
    }

    public LinkedList<CrawledPackage> loadFile(File file, Map<CrawledPackage, CrawledPackageStorable> restoreMap, boolean rescueMode) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        ZipInputStream zis = null;
        SimpleMapper mapper = new SimpleMapper(){

            protected void initMapper() {
            }
        };
        try {
            fis = new FileInputStream(file);
            zis = new ZipInputStream(new BufferedInputStream(fis, 0x100000));
            ArrayList<CrawledLink> loadedCrawledLinks = new ArrayList<CrawledLink>();
            HashMap<Object, LoadedPackage> packageMap = new HashMap<Object, LoadedPackage>();
            LinkCollectorStorable lcs = null;
            TypeRef<CrawledLinkStorable> crawledLinkStorable = new TypeRef<CrawledLinkStorable>(){};
            TypeRef<CrawledPackageStorable> crawledPackageStorable = new TypeRef<CrawledPackageStorable>(){};
            TypeRef<LinkCollectorStorable> linkCollectorStorable = new TypeRef<LinkCollectorStorable>(){};
            ZipEntry entry = null;
            final ZipInputStream finalZis = zis;
            BufferedInputStream entryInputStream = new BufferedInputStream(new InputStream(){

                @Override
                public int read() throws IOException {
                    return finalZis.read();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return finalZis.read(b, off, len);
                }

                @Override
                public long skip(long n) throws IOException {
                    return finalZis.skip(n);
                }

                @Override
                public int available() throws IOException {
                    return finalZis.available();
                }

                @Override
                public boolean markSupported() {
                    return false;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public synchronized void mark(int readlimit) {
                }
            }, 1024){

                @Override
                public void close() throws IOException {
                }
            };
            int entries = 0;
            Pattern entryType = Pattern.compile("(\\d+)(?:_(\\d+))?|extraInfo", 2);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(){

                @Override
                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            Charset UTF8 = Charset.forName("UTF-8");
            while ((entry = zis.getNextEntry()) != null) {
                try {
                    LoadedPackage loadedPackage;
                    Object packageIndex;
                    ++entries;
                    Matcher entryName = entryType.matcher(entry.getName());
                    if (!entryName.matches()) continue;
                    if (entryName.group(2) != null) {
                        packageIndex = Integer.valueOf(entryName.group(1));
                        Integer n = Integer.valueOf(entryName.group(2));
                        loadedPackage = (LoadedPackage)packageMap.get(packageIndex);
                        if (loadedPackage == null) {
                            loadedPackage = new LoadedPackage();
                            packageMap.put(packageIndex, loadedPackage);
                        }
                        bos.reset();
                        IO.readStream((int)((int)entry.getSize()), (InputStream)entryInputStream, (ByteArrayOutputStream)bos);
                        CrawledLinkStorable storable = (CrawledLinkStorable)mapper.stringToObject(new String(bos.toByteArray(), 0, bos.size(), UTF8), (TypeRef)crawledLinkStorable);
                        if (storable != null) {
                            CrawledLink crawledLink = storable._getCrawledLink();
                            loadedCrawledLinks.add(crawledLink);
                            loadedPackage.crawledLinks.put(n, crawledLink);
                            continue;
                        }
                        throw new WTFException("restored a null CrawledLinkStorable");
                    }
                    if (entryName.group(1) != null) {
                        packageIndex = Integer.valueOf(entry.getName());
                        bos.reset();
                        IO.readStream((int)((int)entry.getSize()), (InputStream)entryInputStream, (ByteArrayOutputStream)bos);
                        CrawledPackageStorable crawledPackageStorable2 = (CrawledPackageStorable)mapper.stringToObject(new String(bos.toByteArray(), 0, bos.size(), UTF8), (TypeRef)crawledPackageStorable);
                        if (crawledPackageStorable2 != null) {
                            loadedPackage = (LoadedPackage)packageMap.get(packageIndex);
                            if (loadedPackage == null) {
                                loadedPackage = new LoadedPackage();
                                packageMap.put(packageIndex, loadedPackage);
                            }
                            loadedPackage.crawledPackage = crawledPackageStorable2._getCrawledPackage();
                            if (restoreMap == null) continue;
                            restoreMap.put(crawledPackageStorable2._getCrawledPackage(), crawledPackageStorable2);
                            continue;
                        }
                        throw new WTFException("restored a null CrawledPackageStorable");
                    }
                    lcs = (LinkCollectorStorable)mapper.inputStreamToObject((InputStream)entryInputStream, (TypeRef)linkCollectorStorable);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    if (entry != null) {
                        this.logger.info("Entry:" + entry + "|Size:" + entry.getSize() + "|Compressed Size:" + entry.getCompressedSize());
                    }
                    if (rescueMode) break;
                    throw e;
                }
            }
            if (entries == 0) {
                throw new WTFException("Empty/Invalid Zip:" + file + "|Size:" + file.length());
            }
            HashMap<String, String> stringDeduplication = new HashMap<String, String>();
            for (CrawledLink crawledLink : loadedCrawledLinks) {
                String[] sourceURLs = crawledLink.getSourceUrls();
                if (sourceURLs == null) continue;
                DownloadLink downloadLink = crawledLink.getDownloadLink();
                for (int i = 0; i < sourceURLs.length; ++i) {
                    String sourceURL = sourceURLs[i];
                    String dedupeString = null;
                    if (downloadLink != null && StringUtils.equals((String)sourceURL, (String)downloadLink.getPluginPatternMatcher())) {
                        dedupeString = downloadLink.getPluginPatternMatcher();
                    }
                    if (dedupeString == null) {
                        dedupeString = Property.returnDedupeStringInstance(sourceURL);
                    }
                    if (dedupeString == null) {
                        dedupeString = (String)stringDeduplication.get(sourceURL);
                    }
                    if (dedupeString == null) {
                        stringDeduplication.put(sourceURL, sourceURL);
                        dedupeString = sourceURL;
                    }
                    sourceURLs[i] = dedupeString;
                }
                crawledLink.setSourceUrls(sourceURLs);
            }
            ArrayList packageIndices = new ArrayList(packageMap.keySet());
            Collections.sort(packageIndices);
            ArrayList<CrawledPackage> ret2 = new ArrayList<CrawledPackage>(packageIndices.size());
            for (Integer packageIndex : packageIndices) {
                LoadedPackage loadedPackage = (LoadedPackage)packageMap.get(packageIndex);
                CrawledPackage crawledPackage = loadedPackage.getLoadedPackage();
                if (crawledPackage != null) {
                    ret2.add(crawledPackage);
                    continue;
                }
                throw new WTFException("CrawledPackage at Index " + packageIndex + " is missing!");
            }
            if (lcs != null && ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isConvertRelativePathsJDRoot()) {
                try {
                    String newRoot;
                    String string = lcs.getRootPath();
                    if (!StringUtils.isEmpty((String)string) && !string.equals(newRoot = JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath())) {
                        for (CrawledPackage pkg : ret2) {
                            String pkgPath;
                            if (!CrossSystem.isAbsolutePath((String)pkg.getDownloadFolder()) || !(pkgPath = LinkTreeUtils.getDownloadDirectory(pkg).toString()).startsWith(string + "/") && !pkgPath.startsWith(string + "\\")) continue;
                            String restPath = pkgPath.substring(string.length());
                            restPath = restPath.replaceFirst("^(/+|\\\\+)", "");
                            String newPath = new File(newRoot, restPath = CrossSystem.fixPathSeparators((String)restPath)).toString();
                            if (StringUtils.equals((String)pkgPath, (String)newPath)) continue;
                            pkg.setDownloadFolder(newPath);
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.logger.log(throwable);
                }
            }
            LinkedList<CrawledPackage> linkedList = new LinkedList<CrawledPackage>(ret2);
            return linkedList;
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                } else if (fis != null) {
                    fis.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private void save(final List<CrawledPackage> packages, final File destFile) {
        this.QUEUE.add(new PackageControllerQueue.ReadOnlyQueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                int bufferSize;
                boolean isShuttingDown = ShutdownController.getInstance().isShuttingDown();
                File file = destFile;
                if (file == null) {
                    if (LinkCollector.this.linkcollectorLists.size() > 0) {
                        String counter = new Regex(((File)LinkCollector.this.linkcollectorLists.get(0)).getName(), "linkcollector(\\d+)\\.zip").getMatch(0);
                        long count = 1L;
                        if (counter != null) {
                            count = Long.parseLong(counter) + 1L;
                        }
                        file = Application.getResource((String)("cfg/linkcollector" + count + ".zip"));
                    }
                    if (file == null) {
                        file = Application.getResource((String)"cfg/linkcollector.zip");
                    }
                }
                SimpleMapper mapper = new SimpleMapper(){

                    protected void initMapper() {
                    }

                    public boolean isPrettyPrintEnabled() {
                        return false;
                    }
                };
                boolean deleteFile = true;
                ZipOutputStream zos = null;
                FileOutputStream fos = null;
                if (LinkCollector.this.linkcollectorLists.size() > 0) {
                    long fileLength = ((File)LinkCollector.this.linkcollectorLists.get(0)).length();
                    if (fileLength > 0L) {
                        int paddedFileLength = ((int)fileLength / 32768 + 1) * 32768;
                        bufferSize = Math.max(32768, Math.min(0x100000, paddedFileLength));
                    } else {
                        bufferSize = 32768;
                    }
                } else {
                    bufferSize = 32768;
                }
                if (packages != null && file != null) {
                    try {
                        if (file.exists()) {
                            if (file.isDirectory()) {
                                throw new IOException("File " + file + " is a directory");
                            }
                            if (!FileCreationManager.getInstance().delete(file, null)) {
                                throw new IOException("Could not delete file " + file);
                            }
                        } else if (!file.getParentFile().exists() && !FileCreationManager.getInstance().mkdir(file.getParentFile())) {
                            throw new IOException("Could not create parentFolder for file " + file);
                        }
                        String packageFormat = packages.size() >= 10 ? String.format(Locale.ROOT, "%%0%dd", (int)Math.log10(packages.size()) + 1) : "%02d";
                        fos = new FileOutputStream(file){

                            @Override
                            public void close() throws IOException {
                                try {
                                    if (this.getChannel().isOpen()) {
                                        this.getChannel().force(true);
                                    }
                                }
                                finally {
                                    super.close();
                                }
                            }
                        };
                        final ZipOutputStream finalZos = zos = new ZipOutputStream(new BufferedOutputStream(fos, bufferSize));
                        OutputStream entryOutputStream = new OutputStream(){

                            @Override
                            public void write(int b) throws IOException {
                                finalZos.write(b);
                            }

                            @Override
                            public void write(byte[] b, int off, int len) throws IOException {
                                finalZos.write(b, off, len);
                            }

                            @Override
                            public void close() throws IOException {
                                finalZos.flush();
                            }

                            @Override
                            public void flush() throws IOException {
                                finalZos.flush();
                            }
                        };
                        int packageIndex = 0;
                        for (CrawledPackage pkg : packages) {
                            boolean readL = pkg.getModifyLock().readLock();
                            try {
                                int childrenSize = pkg.getChildren().size();
                                if (childrenSize <= 0) continue;
                                String packageEntryID = String.format(Locale.ROOT, packageFormat, packageIndex++);
                                CrawledPackageStorable packageStorable = new CrawledPackageStorable(pkg, false);
                                CrawledPackageMappingID crawledPackageMappingID = (CrawledPackageMappingID)LinkCollector.this.packageMapPackageToID.get(pkg);
                                if (crawledPackageMappingID != null) {
                                    packageStorable.setPackageID(crawledPackageMappingID.getMappingID());
                                }
                                ZipEntry packageEntry = new ZipEntry(packageEntryID);
                                packageEntry.setMethod(8);
                                byte[] entryBytes = mapper.objectToByteArray((Object)packageStorable);
                                packageEntry.setSize(entryBytes.length);
                                zos.putNextEntry(packageEntry);
                                entryOutputStream.write(entryBytes);
                                zos.closeEntry();
                                String childFormat = childrenSize >= 10 ? String.format(Locale.ROOT, "%%0%dd", (int)Math.log10(childrenSize) + 1) : "%02d";
                                int childIndex = 0;
                                for (CrawledLink link : pkg.getChildren()) {
                                    QueueAction<?, ? extends Throwable> waiting;
                                    if (!isShuttingDown && DebugMode.TRUE_IN_IDE_ELSE_FALSE && (waiting = LinkCollector.this.getQueue().peek()) instanceof PackageControllerQueue.ReadOnlyQueueAction) {
                                        LinkCollector.this.getQueue().executeQueuedAction(waiting);
                                    }
                                    CrawledLinkStorable linkStorable = new CrawledLinkStorable(link);
                                    CrawledPackageMappingID id = null;
                                    switch (pkg.getType()) {
                                        case VARIOUS: {
                                            id = LinkCollector.this.getIDFromMap(LinkCollector.this.variousMap, link);
                                            break;
                                        }
                                        case OFFLINE: {
                                            id = LinkCollector.this.getIDFromMap(LinkCollector.this.offlineMap, link);
                                            break;
                                        }
                                    }
                                    if (id != null) {
                                        linkStorable.setID(id.getMappingID());
                                    }
                                    String childEntryID = String.format(Locale.ROOT, childFormat, childIndex++);
                                    ZipEntry linkEntry = new ZipEntry(packageEntryID + "_" + childEntryID);
                                    linkEntry.setMethod(8);
                                    byte[] entryBytes2 = mapper.objectToByteArray((Object)linkStorable);
                                    linkEntry.setSize(entryBytes2.length);
                                    zos.putNextEntry(linkEntry);
                                    entryOutputStream.write(entryBytes2);
                                    zos.closeEntry();
                                }
                            }
                            finally {
                                pkg.getModifyLock().readUnlock(readL);
                            }
                        }
                        LinkCollectorStorable lcs = new LinkCollectorStorable();
                        try {
                            lcs.setRootPath(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath());
                        }
                        catch (Throwable e) {
                            LinkCollector.this.logger.log(e);
                        }
                        ZipEntry linkCollectorEntry = new ZipEntry("extraInfo");
                        linkCollectorEntry.setMethod(8);
                        zos.putNextEntry(linkCollectorEntry);
                        mapper.writeObject(entryOutputStream, (Object)lcs);
                        zos.closeEntry();
                        zos.close();
                        zos = null;
                        fos = null;
                        deleteFile = false;
                        try {
                            int keepXOld = Math.max(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getKeepXOldLists(), 0);
                            while (LinkCollector.this.linkcollectorLists.size() > keepXOld) {
                                File remove = (File)LinkCollector.this.linkcollectorLists.remove(LinkCollector.this.linkcollectorLists.size() - 1);
                                if (remove == null) continue;
                                boolean delete = FileCreationManager.getInstance().delete(remove, null);
                                if (!LogController.getInstance().isDebugMode()) continue;
                                LinkCollector.this.logger.info("Delete outdated CollectorList: " + remove + " " + delete);
                            }
                        }
                        catch (Throwable e) {
                            LinkCollector.this.logger.log(e);
                        }
                        finally {
                            LinkCollector.this.linkcollectorLists.add(0, file);
                        }
                        Void void_ = null;
                        return void_;
                    }
                    catch (Throwable e) {
                        LinkCollector.this.logger.log(e);
                    }
                    finally {
                        try {
                            if (zos != null) {
                                zos.close();
                            } else if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (Throwable e) {
                            LinkCollector.this.logger.log(e);
                        }
                        if (deleteFile && file.exists()) {
                            FileCreationManager.getInstance().delete(file, null);
                        }
                    }
                }
                return null;
            }
        });
    }

    private boolean isSavingAllowed(boolean ignoreShutDown) {
        return CRAWLERLIST_LOADED.isReached() && (ignoreShutDown || !ShutdownController.getInstance().isShuttingDown()) && ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isSaveLinkgrabberListEnabled();
    }

    private void saveLinkCollectorLinks(boolean ignoreShutdown) {
        if (this.isSavingAllowed(ignoreShutdown)) {
            try {
                this.save(this.getPackagesCopy(), null);
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
    }

    public void setArchiver(ExtractionExtension archiver) {
        this.archiver = archiver;
    }

    @Override
    public void handleBrokenLink(CrawledLink link) {
    }

    @Override
    public void handleUnHandledLink(CrawledLink link) {
    }

    @Override
    public void nodeUpdated(AbstractNode source, AbstractNodeNotifier.NOTIFY notify, Object param) {
        super.nodeUpdated(source, notify, param);
        switch (notify) {
            case PROPERTY_CHANGE: {
                if (param instanceof CrawledLinkProperty) {
                    CrawledLinkProperty eventPropery = (CrawledLinkProperty)param;
                    switch (eventPropery.getProperty()) {
                        case NAME: 
                        case ENABLED: 
                        case AVAILABILITY: 
                        case PRIORITY: {
                            eventPropery.getCrawledLink().getParentNode().getView().requestUpdate();
                        }
                    }
                }
                this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REFRESH_DATA, new Object[]{source, param}, Queue.QueuePriority.LOW));
                break;
            }
            case STRUCTURE_CHANGE: {
                this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REFRESH_STRUCTURE, new Object[]{source, param}, Queue.QueuePriority.LOW));
            }
        }
    }

    @Override
    protected void _controllerPackageNodeStructureChanged(CrawledPackage pkg, Queue.QueuePriority priority) {
        this.eventsender.fireEvent((DefaultEvent)new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REFRESH_STRUCTURE, pkg, priority));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShutdownVetoRequest(ShutdownRequest request) throws ShutdownVetoException {
        if (request.hasVetos()) {
            return;
        }
        if (request.isSilent()) {
            Object object = this.shutdownLock;
            synchronized (object) {
                if (LinkChecker.isChecking() || LinkCrawler.isCrawling()) {
                    throw new ShutdownVetoException("LinkCollector is still running", (ShutdownVetoListener)this);
                }
            }
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            if ((LinkChecker.isChecking() || LinkCrawler.isCrawling()) && JDGui.bugme((WarnLevel)WarnLevel.NORMAL)) {
                if (!UIOManager.I().showConfirmDialog(544, _JDT.T.LinkCollector_onShutdownRequest_(), _JDT.T.LinkCollector_onShutdownRequest_msg(), (Icon)new AbstractIcon("linkgrabber", 32), _JDT.T.literally_yes(), null)) {
                    throw new ShutdownVetoException("LinkCollector is still running", (ShutdownVetoListener)this);
                }
                return;
            }
        }
    }

    public long getShutdownVetoPriority() {
        return 0L;
    }

    public void onShutdown(ShutdownRequest request) {
    }

    public void onShutdownVeto(ShutdownRequest request) {
    }

    @Override
    public boolean hasNotificationListener() {
        return true;
    }

    public void moveLinksToDownloadList(SelectionInfo<CrawledPackage, CrawledLink> selection, ConfirmLinksSettings moveLinksSettings) {
        ArrayList<FilePackage> filePackagesToAdd = new ArrayList<FilePackage>();
        final ArrayList<DownloadLink> force = new ArrayList<DownloadLink>();
        boolean forcedAutoStart = Boolean.TRUE.equals(moveLinksSettings.isForceDownloads());
        boolean autoMode = MoveLinksMode.AUTO.equals((Object)moveLinksSettings.getMoveLinksMode());
        boolean autoStartLinks = false;
        for (SelectionInfo.PackageView<CrawledPackage, CrawledLink> packageView : selection.getPackageViews()) {
            List<CrawledLink> links = packageView.getChildren();
            List<FilePackage> convertedLinks = LinkCollector.getInstance().convert(links, true);
            Iterator<CrawledLink> iterator = links.iterator();
            while (iterator.hasNext()) {
                CrawledLink cl = iterator.next();
                autoStartLinks |= cl.isAutoStartEnabled();
                if (autoMode && cl.isForcedAutoStartEnabled() || forcedAutoStart) {
                    force.add(cl.getDownloadLink());
                }
                if (!Priority.DEFAULT.equals((Object)cl.getPriority()) || moveLinksSettings.getPriority() == null) continue;
                cl.setPriority(moveLinksSettings.getPriority());
            }
            if (convertedLinks == null) continue;
            filePackagesToAdd.addAll(convertedLinks);
        }
        ConfirmLinksContextAction.PackageExpandBehavior packageExpandBehavior = moveLinksSettings.getPackageExpandBehavior();
        if (packageExpandBehavior != ConfirmLinksContextAction.PackageExpandBehavior.UNCHANGED) {
            boolean expand = packageExpandBehavior == ConfirmLinksContextAction.PackageExpandBehavior.EXPANDED;
            for (FilePackage fp : filePackagesToAdd) {
                fp.setExpanded(expand);
            }
        }
        boolean addTop = CFG_LINKGRABBER.LINKGRABBER_ADD_AT_TOP.isEnabled();
        Boolean autoStart = moveLinksSettings.getAutoStartDownloads();
        final boolean finalAutoStart = autoMode ? autoStartLinks || Boolean.TRUE.equals(autoStart) : (autoStart != null ? autoStart : autoStartLinks);
        DownloadController.getInstance().addAllAt(filePackagesToAdd, addTop ? 0 : -(filePackagesToAdd.size() + 10));
        DownloadController.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (force.size() > 0) {
                    DownloadWatchDog.getInstance().forceDownload(force);
                    if (finalAutoStart) {
                        DownloadWatchDog.getInstance().enqueueJob(new DownloadWatchDogJob(){

                            @Override
                            public void interrupt() {
                            }

                            @Override
                            public void execute(DownloadSession currentSession) {
                                currentSession.setForcedOnlyModeEnabled(false);
                            }

                            @Override
                            public boolean isHighPriority() {
                                return false;
                            }
                        });
                    }
                } else if (finalAutoStart) {
                    DownloadWatchDog.getInstance().startDownloads();
                }
                return null;
            }
        });
    }

    @Override
    public void removeChildren(final List<CrawledLink> removechildren) {
        if (removechildren == null || removechildren.size() == 0) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                LinkCollector.this.internalRemoveChildren(removechildren);
                LinkCollector.this._controllerStructureChanged(this.getQueuePrio());
                return null;
            }
        });
    }

    public Thread getAddLinksThread(final LinkCollectingJob job, final AtomicReference<LinkCrawler> lcReference) {
        return new Thread("AddLinksThread:" + (Object)((Object)job.getOrigin().getOrigin())){
            private final HashSet<String> autoExtensionLearnBlackList;
            {
                super(x0);
                this.autoExtensionLearnBlackList = new HashSet();
                this.autoExtensionLearnBlackList.add("shtml");
                this.autoExtensionLearnBlackList.add("phtml");
                this.autoExtensionLearnBlackList.add("html");
                this.autoExtensionLearnBlackList.add("htm");
                this.autoExtensionLearnBlackList.add("php");
                this.autoExtensionLearnBlackList.add("js");
                this.autoExtensionLearnBlackList.add("css");
            }

            @Override
            public void run() {
                LinkCrawler lc = LinkCollector.getInstance().addCrawlerJob(job);
                if (lcReference != null) {
                    lcReference.set(lc);
                }
                if (lc == null) {
                    return;
                }
                lc.waitForCrawling();
                if (job.isDeepAnalyse()) {
                    return;
                }
                if (lc.getProcessedLinksCounter() == 0 && lc.getUnhandledLinksFoundCounter() > 0) {
                    boolean autoExtensionLearning;
                    ArrayList<CrawledLink> unhandledLinks;
                    block11: {
                        unhandledLinks = new ArrayList<CrawledLink>(lc.getUnhandledLinks());
                        LinkOrigin origin = job.getOrigin().getOrigin();
                        for (CrawledLink unhandledLink : unhandledLinks) {
                            unhandledLink.setCrawlDeep(true);
                        }
                        String[] origins = LinkCrawler.getConfig().getAutoLearnExtensionOrigins();
                        autoExtensionLearning = origins != null && unhandledLinks.size() == 1 ? Arrays.asList(origins).contains(origin.name()) : false;
                        if (!autoExtensionLearning) {
                            try {
                                ConfirmDialog dialog = new ConfirmDialog(0, _GUI.T.AddLinksAction_actionPerformed_deep_title(), _GUI.T.AddLinksAction_actionPerformed_deep_msg(), null, _GUI.T.literally_yes(), _GUI.T.literall_no());
                                dialog.show().throwCloseExceptions();
                            }
                            catch (DialogNoAnswerException e) {
                                e.printStackTrace();
                                if (e.isCausedByDontShowAgain()) break block11;
                                return;
                            }
                        }
                    }
                    lc = LinkCollector.getInstance().addCrawlerJob(unhandledLinks, job);
                    if (lcReference != null) {
                        lcReference.set(lc);
                    }
                    if (lc == null) {
                        return;
                    }
                    if (autoExtensionLearning) {
                        final LinkCrawlerDeepInspector defaultDeepInspector = lc.defaultDeepInspector();
                        lc.setDeepInspector(new LinkCrawlerDeepInspector(){

                            private final LinkCrawlerRule getDirectHTTPRule(LinkCrawler lc, URLConnectionAdapter urlConnection) {
                                List<LinkCrawlerRule> rules = lc.getLinkCrawlerRules();
                                if (rules == null) {
                                    return null;
                                }
                                String url = urlConnection.getURL().toString();
                                for (LinkCrawlerRule rule : rules) {
                                    if (!LinkCrawlerRule.RULE.DIRECTHTTP.equals((Object)rule.getRule()) || !rule.matches(url)) continue;
                                    return rule;
                                }
                                return null;
                            }

                            @Override
                            public List<CrawledLink> deepInspect(LinkCrawler lc, LinkCrawler.LinkCrawlerGeneration generation, Browser br, URLConnectionAdapter urlConnection, CrawledLink link) throws Exception {
                                LinkCrawlerRule matchingRule;
                                if (urlConnection.getResponseCode() == 200 && urlConnection.getRequest().getLocation() == null && (matchingRule = link.getMatchingRule()) == null && this.looksLikeDownloadableContent(urlConnection)) {
                                    LinkCrawlerRule rule = null;
                                    URL url = urlConnection.getURL();
                                    if (url.getPath() != null && url.getPath().matches(".*\\.(php|aspx)$") && url.getQuery() != null) {
                                        rule = this.getDirectHTTPRule(lc, urlConnection);
                                        if (rule == null) {
                                            String domain = Browser.getHost((URL)url, (boolean)false);
                                            rule = new LinkCrawlerRule();
                                            rule.setName("Learned php script download: " + domain + url.getPath());
                                            rule.setPattern("(?i)https?://.*?" + Pattern.quote(domain) + Pattern.quote(url.getPath()) + "\\?.+");
                                            rule.setRule(LinkCrawlerRule.RULE.DIRECTHTTP);
                                            lc.addLinkCrawlerRule(rule);
                                        }
                                    } else {
                                        String fileName = Plugin.getFileNameFromURL(url);
                                        String fileExtension = Files.getExtension((String)fileName);
                                        if (StringUtils.isNotEmpty((String)fileExtension) && !autoExtensionLearnBlackList.contains(fileExtension) && (rule = this.getDirectHTTPRule(lc, urlConnection)) == null) {
                                            rule = new LinkCrawlerRule();
                                            rule.setName("Learned file extension: " + fileExtension);
                                            rule.setPattern("(?i)https?://.*\\." + fileExtension + "($|\\?.*$)");
                                            rule.setRule(LinkCrawlerRule.RULE.DIRECTHTTP);
                                            lc.addLinkCrawlerRule(rule);
                                        }
                                    }
                                    urlConnection.disconnect();
                                    ArrayList<CrawledLink> ret = new ArrayList<CrawledLink>();
                                    CrawledLink direct = lc.createDirectHTTPCrawledLink(link, null, urlConnection);
                                    if (direct != null) {
                                        direct.setMatchingRule(rule);
                                        ret.add(direct);
                                    }
                                    return ret;
                                }
                                return defaultDeepInspector.deepInspect(lc, generation, br, urlConnection, link);
                            }
                        });
                    }
                    lc.waitForCrawling();
                }
            }
        };
    }

    public static void requestDeleteLinks(final List<CrawledLink> nodesToDelete, final boolean containsOnline, final String string, final boolean byPassDialog, final boolean isCancelLinkcrawlerJobs, final boolean isResetTableSorter, final boolean isClearSearchFilter, final boolean isClearFilteredLinks) {
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                boolean taskToDo = false;
                boolean bl = taskToDo = taskToDo || nodesToDelete.size() > 0;
                if (!Application.isHeadless()) {
                    taskToDo = taskToDo || isClearSearchFilter && !LinkgrabberSearchField.getInstance().isEmpty();
                }
                taskToDo = taskToDo || isResetTableSorter && LinkGrabberTableModel.getInstance().getSortColumn() != null;
                taskToDo = taskToDo || isClearFilteredLinks && LinkCollector.getInstance().isCollecting();
                boolean bl2 = taskToDo = taskToDo || isCancelLinkcrawlerJobs && LinkCollector.getInstance().getfilteredStuffSize() > 0;
                if (!taskToDo) {
                    if (!Application.isHeadless()) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    return null;
                }
                WarnLevel level = containsOnline ? WarnLevel.NORMAL : WarnLevel.LOW;
                boolean finalByPassDialog = !JDGui.bugme((WarnLevel)level) ? true : byPassDialog;
                if (!finalByPassDialog && !CFG_GUI.CFG.isBypassAllRlyDeleteDialogsEnabled()) {
                    GenericResetLinkgrabberRlyDialog dialog = new GenericResetLinkgrabberRlyDialog(nodesToDelete, containsOnline, string, isCancelLinkcrawlerJobs, isClearFilteredLinks, isClearSearchFilter, isResetTableSorter);
                    try {
                        Dialog.getInstance().showDialog((AbstractDialog)dialog);
                        if (dialog.isCancelCrawler()) {
                            LinkCollector.getInstance().abort();
                        }
                        if (dialog.isResetSort()) {
                            new EDTRunner(){

                                protected void runInEDT() {
                                    LinkGrabberTable table = MenuManagerLinkgrabberTableContext.getInstance().getTable();
                                    table.getModel().setSortColumn(null);
                                    table.getModel().refreshSort();
                                    table.getTableHeader().repaint();
                                }
                            };
                        }
                        if (dialog.isResetSearch()) {
                            LinkgrabberSearchField.getInstance().setText("");
                            LinkgrabberSearchField.getInstance().onChanged();
                        }
                        if (dialog.isDeleteLinks()) {
                            LinkCollector.getInstance().removeChildren(nodesToDelete);
                        }
                        if (dialog.isClearFiltered()) {
                            LinkCollector.getInstance().clearFilteredLinks();
                        }
                    }
                    catch (DialogClosedException e) {
                        e.printStackTrace();
                    }
                    catch (DialogCanceledException e) {
                        e.printStackTrace();
                    }
                } else {
                    if (isCancelLinkcrawlerJobs) {
                        LinkCollector.getInstance().abort();
                    }
                    if (isResetTableSorter) {
                        new EDTRunner(){

                            protected void runInEDT() {
                                LinkGrabberTable table = MenuManagerLinkgrabberTableContext.getInstance().getTable();
                                table.getModel().setSortColumn(null);
                                table.getModel().refreshSort();
                                table.getTableHeader().repaint();
                            }
                        };
                    }
                    if (isClearSearchFilter) {
                        LinkgrabberSearchField.getInstance().setText("");
                        LinkgrabberSearchField.getInstance().onChanged();
                    }
                    if (isClearFilteredLinks) {
                        LinkCollector.getInstance().clearFilteredLinks();
                    }
                    if (nodesToDelete.size() > 0) {
                        LinkCollector.getInstance().removeChildren(nodesToDelete);
                    }
                }
                return null;
            }
        });
    }

    public void setActiveVariantForLink(final CrawledLink crawledLink, final LinkVariant linkVariant) {
        this.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                CrawledPackage parent = crawledLink.getParentNode();
                if (parent == null || parent.getControlledBy() != LinkCollector.this) {
                    return null;
                }
                if (!crawledLink.hasVariantSupport()) {
                    return null;
                }
                LinkCollector.this.setActiveVariantForLink(crawledLink.getDownloadLink(), linkVariant);
                ArrayList<CrawledLink> checkableLinks = new ArrayList<CrawledLink>(1);
                checkableLinks.add(crawledLink);
                LinkChecker<ArrayList<CrawledLink>> linkChecker = new LinkChecker<ArrayList<CrawledLink>>(true);
                linkChecker.check(checkableLinks);
                return null;
            }
        });
    }

    public void setActiveVariantForLink(final DownloadLink link, final LinkVariant variant) {
        this.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                LinkVariant oldVariant = link.getDefaultPlugin().getActiveVariantByLink(link);
                link.getDefaultPlugin().setActiveVariantByLink(link, variant);
                String newLinkID = link.getLinkID();
                CrawledLink existing = LinkCollector.this.getCrawledLinkByLinkID(newLinkID);
                if (existing != null && link != existing.getDownloadLink()) {
                    LinkCollector.this.logger.info("Dupecheck Filtered Variant");
                    link.getDefaultPlugin().setActiveVariantByLink(link, oldVariant);
                    return null;
                }
                return null;
            }
        });
    }

    private CrawledLink getCrawledLinkByLinkID(String linkID) {
        WeakReference<CrawledLink> item = this.dupeCheckMap.get(linkID);
        if (item == null) {
            return null;
        }
        CrawledLink itemLink = (CrawledLink)item.get();
        if (itemLink == null || itemLink.getParentNode() == null || itemLink.getParentNode().getControlledBy() == null) {
            if (itemLink == null || itemLink.getParentNode() == null && !this.filteredStuff.contains(itemLink) || itemLink.getParentNode() != null && itemLink.getParentNode().getControlledBy() == null) {
                this.dupeCheckMap.remove(linkID);
            }
            return itemLink;
        }
        if (StringUtils.equals((String)itemLink.getLinkID(), (String)linkID)) {
            return itemLink;
        }
        this.logger.warning("DupeCheckMap pollution detected: " + linkID);
        this.dupeCheckMap.remove(linkID);
        if (this.putCrawledLinkByLinkID(itemLink.getLinkID(), itemLink) == null) {
            return this.getCrawledLinkByLinkID(linkID);
        }
        this.logger.warning("Failed to clean DupeCheckMap pollution: " + itemLink.getLinkID());
        return null;
    }

    private boolean removeCrawledLinkByLinkID(CrawledLink link) {
        String linkID = link.getLinkID();
        CrawledLink itemLink = this.getCrawledLinkByLinkID(linkID);
        if (itemLink == link) {
            this.dupeCheckMap.remove(linkID);
        } else if (itemLink != null) {
            this.logger.warning("Failed to remove item from DupeCheckMap: " + linkID);
            return false;
        }
        return true;
    }

    public boolean isDupeManagerEnabled() {
        return this.isDupeManagerEnabled;
    }

    private CrawledLink putCrawledLinkByLinkID(String linkID, CrawledLink link) {
        if (!this.isDupeManagerEnabled()) {
            return null;
        }
        WeakReference<CrawledLink> item = this.dupeCheckMap.put(linkID, new WeakReference<CrawledLink>(link));
        if (item == null) {
            return null;
        }
        CrawledLink itemLink = (CrawledLink)item.get();
        if (itemLink == null) {
            return null;
        }
        String itemLinkID = itemLink.getLinkID();
        if (itemLink == link) {
            return null;
        }
        if (StringUtils.equals((String)itemLinkID, (String)linkID)) {
            return itemLink;
        }
        this.logger.warning("DupeCheckMap pollution detected: " + linkID);
        if (this.putCrawledLinkByLinkID(itemLinkID, itemLink) != null) {
            this.logger.warning("Failed to clean DupeCheckMap pollution: " + itemLinkID);
        }
        return null;
    }

    public boolean containsLinkId(final String linkID) {
        return linkID != null && Boolean.TRUE.equals(this.getQueue().addWait(new PackageControllerQueue.ReadOnlyQueueAction<Boolean, RuntimeException>(){

            protected Boolean run() throws RuntimeException {
                return LinkCollector.this.getCrawledLinkByLinkID(linkID) != null;
            }
        }));
    }

    public CrawledLink addAdditional(final CrawledLink link, LinkVariant o) {
        DownloadLink dllink = new DownloadLink(link.getDownloadLink().getDefaultPlugin(), link.getDownloadLink().getView().getDisplayName(), link.getDownloadLink().getHost(), link.getDownloadLink().getPluginPatternMatcher(), true);
        dllink.setProperties(link.getDownloadLink().getProperties());
        dllink.setProperty(SOURCE_VARIANT_ID, link.getUniqueID().getID());
        dllink.setOriginUrl(link.getDownloadLink().getOriginUrl());
        dllink.setContentUrl(link.getDownloadLink().getContainerUrl());
        dllink.setReferrerUrl(link.getDownloadLink().getReferrerUrl());
        final CrawledLink cl = new CrawledLink(dllink);
        dllink.setNodeChangeListener(cl);
        cl.getDownloadLink().getDefaultPlugin().setActiveVariantByLink(cl.getDownloadLink(), o);
        return LinkCollector.getInstance().getQueue().addWait(new QueueAction<CrawledLink, RuntimeException>(){

            protected CrawledLink run() throws RuntimeException {
                if (LinkCollector.getInstance().containsLinkId(cl.getLinkID())) {
                    return null;
                }
                ArrayList<CrawledLink> list = new ArrayList<CrawledLink>();
                list.add(cl);
                LinkCollector.getInstance().moveOrAddAt(link.getParentNode(), list, link.getParentNode().indexOf(link) + 1);
                return cl;
            }
        });
    }

    public static final class ConfirmLinksSettings {
        private final MoveLinksMode moveLinksMode;
        private final boolean defaultAutoStartDownloads = this.getDefaultAutoStartDownloads();
        private Boolean autoStartDownloads = null;
        private final boolean defaultForceDownloads = this.getDefaultForceDownloads();
        private Boolean forceDownloads = null;
        private final boolean defaultClearLinkgrabberlistOnConfirm = this.getDefaultClearLinkgrabberlistOnConfirm();
        private Boolean clearLinkgrabberlistOnConfirm = null;
        private final Priority defaultPriority = this.getDefaultPriority();
        private Priority priority = null;
        private final boolean defaultSwitchToDownloadlistOnConfirm = this.getDefaultSwitchToDownloadlistOnConfirm();
        private Boolean switchToDownloadlistOnConfirm = null;
        private final ConfirmLinksContextAction.OnOfflineLinksAction defaultHandleOffline = this.getDefaultHandleOffline();
        private ConfirmLinksContextAction.OnOfflineLinksAction handleOffline = null;
        private final ConfirmLinksContextAction.OnDupesLinksAction defaultHandleDupes = this.getDefaultHandleDupes();
        private ConfirmLinksContextAction.OnDupesLinksAction handleDupes = null;
        private final ConfirmLinksContextAction.PackageExpandBehavior defaultPackageExpandBehavior = this.getDefaultPackageExpandBehavior();
        private ConfirmLinksContextAction.PackageExpandBehavior packageExpandBehavior = null;
        private final ConfirmLinksContextAction.ConfirmationDialogBehavior defaultConfirmationDialogBehavior = this.getDefaultConfirmationDialogBehavior();
        private ConfirmLinksContextAction.ConfirmationDialogBehavior confirmationDialogBehavior = null;
        private final int defaultConfirmationDialogThresholdMinPackages = this.getDefaultcConfirmationDialogThresholdMinPackages();
        private Integer confirmationDialogThresholdMinPackages = 1;
        private final int defaultConfirmationDialogThresholdMinLinks = this.getDefaultConfirmationDialogThresholdMinLinks();
        private Integer confirmationDialogThresholdMinLinks = null;
        private final boolean defaultMergeSameNamedPackagesOnConfirm = false;
        private Boolean mergeSameNamedPackagesOnConfirm = null;

        public final MoveLinksMode getMoveLinksMode() {
            return this.moveLinksMode;
        }

        public final boolean getAutoStartDownloads() {
            Boolean ret = this.autoStartDownloads;
            if (ret != null) {
                return ret;
            }
            return this.defaultAutoStartDownloads;
        }

        public final ConfirmLinksSettings setAutoStartDownloads(Boolean autoStartDownloads) {
            this.autoStartDownloads = autoStartDownloads == null || autoStartDownloads == this.defaultAutoStartDownloads ? null : autoStartDownloads;
            return this;
        }

        public final boolean isForceDownloads() {
            Boolean ret = this.forceDownloads;
            if (ret != null) {
                return ret;
            }
            return this.defaultForceDownloads;
        }

        public final ConfirmLinksSettings setForceDownloads(Boolean forceDownloads) {
            this.forceDownloads = forceDownloads == null || forceDownloads == this.defaultForceDownloads ? null : forceDownloads;
            return this;
        }

        public final ConfirmLinksContextAction.OnOfflineLinksAction getHandleOffline() {
            ConfirmLinksContextAction.OnOfflineLinksAction ret = this.handleOffline;
            if (ret != null) {
                return ret.getSelectedAction();
            }
            return this.defaultHandleOffline.getSelectedAction();
        }

        public final ConfirmLinksSettings setHandleOffline(ConfirmLinksContextAction.OnOfflineLinksAction handleOffline) {
            this.handleOffline = handleOffline == null || handleOffline.getSelectedAction() == this.defaultHandleOffline.getSelectedAction() ? null : handleOffline;
            return this;
        }

        public final boolean isClearLinkgrabberlistOnConfirm() {
            Boolean ret = this.clearLinkgrabberlistOnConfirm;
            if (ret != null) {
                return ret;
            }
            return this.defaultClearLinkgrabberlistOnConfirm;
        }

        public final ConfirmLinksSettings setClearLinkgrabberlistOnConfirm(Boolean clearLinkgrabberlistOnConfirm) {
            this.clearLinkgrabberlistOnConfirm = clearLinkgrabberlistOnConfirm == null || clearLinkgrabberlistOnConfirm == this.defaultClearLinkgrabberlistOnConfirm ? null : clearLinkgrabberlistOnConfirm;
            return this;
        }

        public final boolean isSwitchToDownloadlistOnConfirm() {
            Boolean ret = this.switchToDownloadlistOnConfirm;
            if (ret != null) {
                return ret;
            }
            return this.defaultSwitchToDownloadlistOnConfirm;
        }

        public final ConfirmLinksSettings setSwitchToDownloadlistOnConfirm(Boolean switchToDownloadlistOnConfirm) {
            this.switchToDownloadlistOnConfirm = switchToDownloadlistOnConfirm == null || switchToDownloadlistOnConfirm == this.defaultSwitchToDownloadlistOnConfirm ? null : switchToDownloadlistOnConfirm;
            return this;
        }

        public final Priority getPriority() {
            Priority ret = this.priority;
            if (ret != null) {
                return ret;
            }
            return this.defaultPriority;
        }

        public final ConfirmLinksSettings setPriority(Priority priority) {
            this.priority = priority == null || priority == this.defaultPriority ? null : priority;
            return this;
        }

        public final ConfirmLinksSettings setHandleDupes(ConfirmLinksContextAction.OnDupesLinksAction handleDupes) {
            this.handleDupes = handleDupes == null || handleDupes.getSelectedAction() == this.defaultHandleDupes.getSelectedAction() ? null : handleDupes;
            return this;
        }

        public final ConfirmLinksContextAction.OnDupesLinksAction getHandleDupes() {
            ConfirmLinksContextAction.OnDupesLinksAction ret = this.handleDupes;
            if (ret != null) {
                return ret.getSelectedAction();
            }
            return this.defaultHandleDupes.getSelectedAction();
        }

        public ConfirmLinksContextAction.PackageExpandBehavior getPackageExpandBehavior() {
            ConfirmLinksContextAction.PackageExpandBehavior ret = this.packageExpandBehavior;
            if (ret != null) {
                return ret;
            }
            return this.defaultPackageExpandBehavior;
        }

        public ConfirmLinksSettings setPackageExpandBehavior(ConfirmLinksContextAction.PackageExpandBehavior packageExpandBehavior) {
            this.packageExpandBehavior = packageExpandBehavior == null || packageExpandBehavior == this.defaultPackageExpandBehavior ? null : packageExpandBehavior;
            return this;
        }

        public final ConfirmLinksContextAction.ConfirmationDialogBehavior getConfirmationDialogBehavior() {
            ConfirmLinksContextAction.ConfirmationDialogBehavior ret = this.confirmationDialogBehavior;
            if (ret != null) {
                return ret;
            }
            return this.defaultConfirmationDialogBehavior;
        }

        public final ConfirmLinksSettings setConfirmationDialogBehavior(ConfirmLinksContextAction.ConfirmationDialogBehavior confirmationDialogBehavior) {
            this.confirmationDialogBehavior = confirmationDialogBehavior == null || confirmationDialogBehavior == this.defaultConfirmationDialogBehavior ? null : confirmationDialogBehavior;
            return this;
        }

        public final int getConfirmationDialogThresholdMinPackages() {
            Integer ret = this.confirmationDialogThresholdMinPackages;
            if (ret != null) {
                return ret;
            }
            return this.defaultConfirmationDialogThresholdMinPackages;
        }

        public final ConfirmLinksSettings setConfirmationDialogThresholdMinPackages(Integer confirmationDialogThresholdMinPackages) {
            this.confirmationDialogThresholdMinPackages = confirmationDialogThresholdMinPackages == null || confirmationDialogThresholdMinPackages < 0 || confirmationDialogThresholdMinPackages == this.defaultConfirmationDialogThresholdMinPackages ? null : confirmationDialogThresholdMinPackages;
            return this;
        }

        public final int getConfirmationDialogThresholdMinLinks() {
            Integer ret = this.confirmationDialogThresholdMinLinks;
            if (ret != null) {
                return ret;
            }
            return this.defaultConfirmationDialogThresholdMinLinks;
        }

        public final ConfirmLinksSettings setConfirmationDialogThresholdMinLinks(Integer confirmationDialogThresholdMinLinks) {
            this.confirmationDialogThresholdMinLinks = confirmationDialogThresholdMinLinks == null || confirmationDialogThresholdMinLinks < 0 || confirmationDialogThresholdMinLinks == this.defaultConfirmationDialogThresholdMinLinks ? null : confirmationDialogThresholdMinLinks;
            return this;
        }

        public boolean isMergeSameNamedPackagesOnConfirm() {
            if (this.mergeSameNamedPackagesOnConfirm == null) {
                return false;
            }
            return this.mergeSameNamedPackagesOnConfirm;
        }

        public ConfirmLinksSettings(MoveLinksMode mode) {
            this.moveLinksMode = mode != null ? mode : MoveLinksMode.AUTO;
        }

        private int getDefaultConfirmationDialogThresholdMinLinks() {
            return 1;
        }

        private int getDefaultcConfirmationDialogThresholdMinPackages() {
            return 1;
        }

        private ConfirmLinksContextAction.ConfirmationDialogBehavior getDefaultConfirmationDialogBehavior() {
            return ConfirmLinksContextAction.ConfirmationDialogBehavior.DISABLED;
        }

        private ConfirmLinksContextAction.PackageExpandBehavior getDefaultPackageExpandBehavior() {
            return ConfirmLinksContextAction.PackageExpandBehavior.UNCHANGED;
        }

        private ConfirmLinksContextAction.OnDupesLinksAction getDefaultHandleDupes() {
            ConfirmLinksContextAction.OnDupesLinksAction ret = CFG_LINKGRABBER.CFG.getDefaultOnAddedDupesLinksAction();
            if (ret != null) {
                return ret.getSelectedAction();
            }
            return ConfirmLinksContextAction.OnDupesLinksAction.ASK;
        }

        private ConfirmLinksContextAction.OnOfflineLinksAction getDefaultHandleOffline() {
            ConfirmLinksContextAction.OnOfflineLinksAction ret = CFG_LINKGRABBER.CFG.getDefaultOnAddedOfflineLinksAction();
            if (ret != null) {
                return ret.getSelectedAction();
            }
            return ConfirmLinksContextAction.OnOfflineLinksAction.ASK;
        }

        private boolean getDefaultSwitchToDownloadlistOnConfirm() {
            return ((LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class)).isAutoSwitchToDownloadTableOnConfirmDefaultEnabled();
        }

        private Priority getDefaultPriority() {
            Priority ret;
            if (MoveLinksMode.AUTO.equals((Object)this.getMoveLinksMode()) && CFG_LINKGRABBER.CFG.isAutoConfirmManagerAssignPriorityEnabled() && (ret = CFG_LINKGRABBER.CFG.getAutoConfirmManagerPriority()) != null) {
                return ret;
            }
            return Priority.DEFAULT;
        }

        private boolean getDefaultAutoStartDownloads() {
            ConfirmLinksContextAction.AutoStartOptions ret;
            if (MoveLinksMode.AUTO.equals((Object)this.getMoveLinksMode()) && (ret = CFG_LINKGRABBER.CFG.getAutoConfirmManagerAutoStart()) != null) {
                return ret.isEnabled();
            }
            return ConfirmLinksContextAction.AutoStartOptions.AUTO.isEnabled();
        }

        private boolean getDefaultClearLinkgrabberlistOnConfirm() {
            if (MoveLinksMode.AUTO.equals((Object)this.getMoveLinksMode())) {
                return CFG_LINKGRABBER.CFG.isAutoConfirmManagerClearListAfterConfirm();
            }
            return false;
        }

        private boolean getDefaultForceDownloads() {
            if (MoveLinksMode.AUTO.equals((Object)this.getMoveLinksMode())) {
                return CFG_LINKGRABBER.CFG.isAutoConfirmManagerForceDownloads();
            }
            return false;
        }
    }

    public static enum MoveLinksMode {
        MANUAL,
        AUTO;

    }

    private class LoadedPackage {
        private CrawledPackage crawledPackage = null;
        private final HashMap<Integer, CrawledLink> crawledLinks = new HashMap();

        private LoadedPackage() {
        }

        private CrawledPackage getLoadedPackage() {
            if (this.crawledPackage != null) {
                if (this.crawledPackage.getChildren().size() == 0) {
                    ArrayList<Integer> childIndices = new ArrayList<Integer>(this.crawledLinks.keySet());
                    Collections.sort(childIndices);
                    for (Integer childIndex : childIndices) {
                        CrawledLink child = this.crawledLinks.get(childIndex);
                        this.crawledPackage.getChildren().add(child);
                        child.setParentNode(this.crawledPackage);
                    }
                }
                return this.crawledPackage;
            }
            return null;
        }
    }

    private static class CrawledPackageMappingID {
        private final String id;
        private final String packageName;
        private final String downloadFolder;
        private final String downloadFolderRaw;
        private final int hashCode;

        private String getId() {
            return this.id;
        }

        private boolean isNull() {
            return this.getPackageName() == null && this.getDownloadFolder() == null && this.getDownloadFolderRaw() == null;
        }

        private String getPackageName() {
            return this.packageName;
        }

        private String getDownloadFolder() {
            return this.downloadFolder;
        }

        private String getDownloadFolderRaw() {
            return this.downloadFolderRaw;
        }

        private String getMappingID() {
            return this.getId() + "|_|" + this.getPackageName() + "|_|" + this.getDownloadFolderRaw();
        }

        private static CrawledPackageMappingID get(String combined) {
            if (combined == null) {
                return null;
            }
            String[] infos = new Regex(combined, "^(.*?)\\|_\\|(.*?)\\|_\\|(.*?)$").getRow(0);
            if (infos == null) {
                infos = new Regex(combined, "^(.*?)_\\|\\|_(.*?)_\\|\\|_(.*?)$").getRow(0);
            }
            if (infos != null && infos.length == 3) {
                if ("Null".equalsIgnoreCase(infos[0])) {
                    infos[0] = null;
                }
                if ("Null".equalsIgnoreCase(infos[1])) {
                    infos[1] = null;
                }
                if ("Null".equalsIgnoreCase(infos[2])) {
                    infos[2] = null;
                }
                if (infos[0] != null || infos[1] != null || infos[2] != null) {
                    return new CrawledPackageMappingID(infos[0], infos[1], infos[2]);
                }
            }
            return null;
        }

        private CrawledPackageMappingID(String id, String packageName, String downloadFolderRaw) {
            if (packageName != null) {
                packageName = JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7) ? packageName.replaceAll("(?U)[^\\w \\u2460-\\u24FF]", "").replaceAll("(?U)[_]", "").toLowerCase(Locale.ENGLISH) : packageName.replaceAll("[^a-zA-Z0-9 \\u2460-\\u24FF]", "").toLowerCase(Locale.ENGLISH);
                packageName = packageName.replaceAll("[ ]+", " ").trim();
            }
            this.id = id;
            this.packageName = packageName;
            this.downloadFolderRaw = Property.dedupeString(downloadFolderRaw);
            if (CrossSystem.isWindows() && downloadFolderRaw != null) {
                String downloadFolder = downloadFolderRaw.toLowerCase(Locale.ENGLISH);
                this.downloadFolder = Property.dedupeString(downloadFolder);
            } else {
                this.downloadFolder = this.downloadFolderRaw;
            }
            this.hashCode = (this.id + this.packageName + this.downloadFolder).hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj instanceof CrawledPackageMappingID) {
                CrawledPackageMappingID other = (CrawledPackageMappingID)obj;
                if (!StringUtils.equals((String)this.downloadFolder, (String)other.downloadFolder)) {
                    return false;
                }
                if (!StringUtils.equals((String)this.packageName, (String)other.packageName)) {
                    return false;
                }
                return StringUtils.equals((String)this.id, (String)other.id);
            }
            return false;
        }
    }

    public static final class JobLinkCrawler
    extends LinkCollectorCrawler {
        private final LinkCollectingJob job;
        private final LinkCollectingInformation collectingInfo;
        private final LinkCollector linkCollector;
        private final AtomicBoolean crawlerAdded = new AtomicBoolean(false);
        private final JobLinkChecker linkChecker;
        private final AtomicInteger waitingInQueue = new AtomicInteger(0);
        private final AtomicBoolean abortedFlag = new AtomicBoolean(false);

        protected LinkCollector getLinkCollector() {
            return this.linkCollector;
        }

        public LinkChecker<CrawledLink> getLinkChecker() {
            return this.linkChecker;
        }

        public boolean isCollecting() {
            return this.isRunning() || this.getLinkChecker().isRunning() || this.hasWaitingInQueue();
        }

        public final boolean hasWaitingInQueue() {
            return this.getQueueSize() > 0;
        }

        public final int getQueueSize() {
            return this.waitingInQueue.get();
        }

        protected void enqueuOrDequeue(CrawledLink link, boolean enqueueOrDequeue) {
            if (enqueueOrDequeue) {
                this.waitingInQueue.incrementAndGet();
            } else {
                this.waitingInQueue.decrementAndGet();
            }
        }

        public boolean isAborted() {
            return this.abortedFlag.get();
        }

        public boolean abort() {
            CaptchaBlackList.getInstance().add(new BlockAllCrawlerCaptchasEntry(this));
            boolean aborted = this.abortedFlag.compareAndSet(false, true);
            boolean wasCollecting = this.isCollecting();
            this.getLinkChecker().stopChecking();
            this.stopCrawling();
            return aborted || wasCollecting;
        }

        @Override
        public boolean isDoDuplicateFinderFinalCheck() {
            if (!this.linkCollector.isDupeManagerEnabled()) {
                return false;
            }
            return super.isDoDuplicateFinderFinalCheck();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JobLinkCrawler(final LinkCollector linkCollector, LinkCollectingJob job) {
            this.job = job;
            this.linkCollector = linkCollector;
            this.collectingInfo = new LinkCollectingInformation(this);
            this.linkChecker = new JobLinkChecker(this);
            this.linkChecker.setLinkCheckHandler(linkCollector);
            final LinkCrawlerHandler defaultHandler = this.defaultHandlerFactory();
            this.setHandler(new LinkCrawlerHandler(){

                @Override
                public void handleUnHandledLink(CrawledLink link) {
                    linkCollector.handleUnHandledLink(link);
                    defaultHandler.handleUnHandledLink(link);
                }

                @Override
                public void handleFinalLink(CrawledLink link) {
                    DownloadLink downloadLink;
                    link.setCollectingInfo(JobLinkCrawler.this.collectingInfo);
                    LinkCollectingJob job = JobLinkCrawler.this.getJob();
                    link.setSourceJob(job);
                    if (job.isAssignJobID() && (downloadLink = link.getDownloadLink()) != null) {
                        downloadLink.setProperty("JOB_ID", job.getUniqueAlltimeID().getIDLong());
                    }
                    linkCollector.handleFinalLink(link, JobLinkCrawler.this.getLinkChecker());
                    defaultHandler.handleFinalLink(link);
                }

                @Override
                public void handleFilteredLink(CrawledLink link) {
                    link.setSourceJob(JobLinkCrawler.this.getJob());
                    linkCollector.handleFilteredLink(link);
                    defaultHandler.handleFilteredLink(link);
                }

                @Override
                public void handleBrokenLink(CrawledLink link) {
                    linkCollector.handleBrokenLink(link);
                    defaultHandler.handleBrokenLink(link);
                }
            });
            WeakHashMap weakHashMap = linkCollector.jobLinkCrawlers;
            synchronized (weakHashMap) {
                linkCollector.jobLinkCrawlers.put(this, Boolean.TRUE);
            }
        }

        @Override
        protected void enqueueFinalCrawledLink(final LinkCrawler.LinkCrawlerGeneration generation, final CrawledLink link) {
            if (this.linkCollector.isDupeManagerEnabled()) {
                final LinkCrawler.LinkCrawlerTask task = this.checkStartNotify(generation, "enqueueFinalCrawledLink");
                if (task != null) {
                    this.linkCollector.getQueue().add((QueueAction)new QueueAction<Boolean, RuntimeException>(){

                        protected void postRun() {
                            JobLinkCrawler.checkFinishNotify(task);
                        }

                        protected Boolean run() throws RuntimeException {
                            if (generation.isValid()) {
                                CrawledLink existing = JobLinkCrawler.this.linkCollector.findDupe(link);
                                if (existing == null || existing.getMatchingFilter() != null) {
                                    JobLinkCrawler.super.enqueueFinalCrawledLink(generation, link);
                                    return Boolean.TRUE;
                                }
                                JobLinkCrawler.this.onCrawledLinkDuplicate(link, LinkCrawler.DUPLICATE.FINAL);
                                return Boolean.FALSE;
                            }
                            return null;
                        }
                    });
                }
            } else {
                super.enqueueFinalCrawledLink(generation, link);
            }
        }

        public LinkCollectingJob getJob() {
            return this.job;
        }

        @Override
        public LinkCrawlerFilter getFilter() {
            return this.linkCollector.getCrawlerFilter();
        }

        @Override
        protected CrawledLink crawledLinkFactorybyURL(CharSequence url) {
            CrawledLink ret = super.crawledLinkFactorybyURL(url);
            LinkCollectingJob job = this.getJob();
            if (job != null) {
                ret.setOrigin(job.getOrigin());
                ret.setSourceJob(job);
            }
            return ret;
        }

        @Override
        protected void crawlerStopped() {
            if (this.crawlerAdded.compareAndSet(true, false)) {
                this.linkCollector.onCrawlerStopped(this);
            }
            super.crawlerStopped();
        }

        @Override
        protected void crawlerStarted() {
            if (this.crawlerAdded.compareAndSet(false, true)) {
                this.linkCollector.onCrawlerAdded(this);
            }
            this.linkCollector.onCrawlerStarted(this);
            super.crawlerStarted();
        }

        @Override
        protected void crawlerFinished() {
            this.linkCollector.onCrawlerFinished(this);
            super.crawlerFinished();
        }
    }

    public static final class JobLinkChecker
    extends LinkChecker<CrawledLink> {
        private final JobLinkCrawler jobLinkCrawler;

        public final JobLinkCrawler getJobLinkCrawler() {
            return this.jobLinkCrawler;
        }

        protected JobLinkChecker(JobLinkCrawler jobLinkCrawler) {
            this.jobLinkCrawler = jobLinkCrawler;
        }
    }
}

