/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcollector;

import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.plugins.ParsedFilename;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.AbstractValidator;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.ObjectKeyHandler;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class LinknameCleaner {
    public static final Pattern pat0 = Pattern.compile("(.*)(\\.|_|-)pa?r?t?\\.?[0-9]+.(rar|rev|exe)($|\\.html?)", 2);
    public static final Pattern pat1 = Pattern.compile("(.*)(\\.|_|-)part\\.?[0]*[1].(rar|rev|exe)($|\\.html?)", 2);
    public static final Pattern pat3 = Pattern.compile("(.*)\\.(?:rar|rev)($|\\.html?)", 2);
    public static final Pattern pat4 = Pattern.compile("(.*)\\.r\\d+($|\\.html?)", 2);
    public static final Pattern pat5 = Pattern.compile("(.*)(\\.|_|-)\\d+($|\\.html?)", 2);
    public static final Pattern par2 = Pattern.compile("(.*?)(\\.vol\\d+\\.par2$|\\.vol\\d+(?:\\+|-)\\d+\\.par2$|\\.par2$)", 2);
    public static final Pattern par = Pattern.compile("(.*?)(\\.p\\d+$|\\.par$)", 2);
    public static final Pattern[] rarPats = new Pattern[]{pat0, pat1, pat3, pat4, pat5, par2, par};
    public static final Pattern pat6 = Pattern.compile("(.*)\\.zip($|\\.html?)", 2);
    public static final Pattern pat7 = Pattern.compile("(.*)\\.z\\d+($|\\.html?)", 2);
    public static final Pattern pat8 = Pattern.compile("(?is).*\\.7z\\.[\\d]+($|\\.html?)", 2);
    public static final Pattern pat9 = Pattern.compile("(.*)\\.a.($|\\.html?)", 2);
    public static final Pattern[] zipPats = new Pattern[]{pat6, pat7, pat8, pat9};
    public static final Pattern pat10 = Pattern.compile("(.*)\\._((_[a-z]{1})|([a-z]{2}))(\\.|$)");
    public static Pattern pat11 = null;
    public static Pattern[] ffsjPats = null;
    public static final Pattern pat13;
    public static final Pattern pat17;
    public static final Pattern pat18;
    public static final Pattern pat19;
    public static final Pattern[] iszPats;
    private static volatile Map<Pattern, String> FILENAME_REPLACEMAP;
    private static volatile Map<String, String> FILENAME_REPLACEMAP_DEFAULT;
    private static volatile Map<Pattern, String> FILENAME_TOO_LONG_REPLACEMAP;
    private static volatile Map<String, String> FILENAME_TOO_LONG_REPLACEMAP_DEFAULT;
    private static volatile Map<Pattern, String> PACKAGENAME_REPLACEMAP;
    private static volatile Map<String, String> PACKAGENAME_REPLACEMAP_DEFAULT;

    private static Map<Pattern, String> convertReplaceMap(Map<String, String> defaultReplaceMap, Map<String, String> replaceMap) {
        HashMap<Pattern, String> ret = new HashMap<Pattern, String>();
        HashSet<String> keys = new HashSet<String>();
        if (replaceMap != null) {
            for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                if (entry.getKey() == null || entry.getKey().length() == 0 || entry.getValue() == null) continue;
                try {
                    ret.put(Pattern.compile(entry.getKey()), Matcher.quoteReplacement(entry.getValue()));
                    keys.add(entry.getKey());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (defaultReplaceMap != null) {
            for (Map.Entry<String, String> entry : defaultReplaceMap.entrySet()) {
                if (entry.getKey() == null || entry.getKey().length() == 0 || entry.getValue() == null || keys.contains(entry.getKey())) continue;
                try {
                    ret.put(Pattern.compile(entry.getKey()), Matcher.quoteReplacement(entry.getValue()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (ret.size() > 0) {
            return ret;
        }
        return null;
    }

    private static String replaceCharactersByMap(String input, Map<Pattern, String> forbiddenCharacterRegexReplaceMap) {
        if (input == null) {
            return null;
        }
        if (forbiddenCharacterRegexReplaceMap == null || forbiddenCharacterRegexReplaceMap.size() == 0) {
            return input;
        }
        String newstr = input;
        for (Map.Entry<Pattern, String> entry : forbiddenCharacterRegexReplaceMap.entrySet()) {
            Pattern pattern = entry.getKey();
            String replacement = entry.getValue();
            if (replacement == null) continue;
            try {
                newstr = pattern.matcher(newstr).replaceAll(replacement);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isEmpty((String)newstr)) {
            return newstr;
        }
        return input;
    }

    public static String cleanFilename(String filename) {
        String ret = LinknameCleaner.replaceCharactersByMap(filename, FILENAME_REPLACEMAP);
        ret = CrossSystem.alleviatePathParts((String)ret, (boolean)false);
        return ret;
    }

    public static String shortenFilename(ParsedFilename pfilename, int maxLength) {
        if (pfilename == null) {
            throw new IllegalArgumentException();
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException();
        }
        if (pfilename.isMultipartArchive()) {
            return null;
        }
        String filenameWithoutExtension = pfilename.getFilenameWithoutExtensionAdvanced();
        String ext = pfilename.getExtensionAdvanced();
        if (ext != null && ext.length() > maxLength) {
            return null;
        }
        int maxLengthForFilenameWithoutExt = ext != null ? maxLength - ext.length() : maxLength;
        filenameWithoutExtension = LinknameCleaner.replaceCharactersByMap(filenameWithoutExtension, FILENAME_TOO_LONG_REPLACEMAP);
        if ((filenameWithoutExtension = filenameWithoutExtension.trim()).length() > maxLengthForFilenameWithoutExt) {
            filenameWithoutExtension = filenameWithoutExtension.substring(0, maxLengthForFilenameWithoutExt);
            filenameWithoutExtension = filenameWithoutExtension.trim();
        }
        if (ext != null) {
            filenameWithoutExtension = filenameWithoutExtension + ext;
        }
        return filenameWithoutExtension;
    }

    public static String cleanPackagename(String packageName, boolean allowCleanup) {
        String ret = LinknameCleaner.replaceCharactersByMap(packageName, PACKAGENAME_REPLACEMAP);
        if (ret != null && allowCleanup && CFG_GENERAL.CLEAN_UP_PACKAGENAMES.isEnabled()) {
            StringBuilder sb = new StringBuilder();
            boolean lastWasSpace = false;
            for (int i = 0; i < ret.length(); ++i) {
                char c = ret.charAt(i);
                if (c == '_' || c == '.') {
                    if (lastWasSpace || i + 1 < ret.length() && ret.charAt(i + 1) == ' ') continue;
                    sb.append(' ');
                    lastWasSpace = true;
                    continue;
                }
                if (c == ' ') {
                    if (lastWasSpace) continue;
                    sb.append(c);
                    lastWasSpace = true;
                    continue;
                }
                sb.append(c);
                lastWasSpace = false;
            }
            ret = sb.toString().trim();
        }
        ret = CrossSystem.alleviatePathParts((String)ret, (boolean)false);
        return ret;
    }

    public static String derivePackagenameFromFilename(String filename) {
        if (StringUtils.isEmpty((String)filename)) {
            return null;
        }
        String name = filename;
        boolean hasKnownExtension = false;
        ExtensionRemovalResult result = LinknameCleaner.removeKnownArchiveExtensions(name);
        name = result.processedName;
        hasKnownExtension = result.extensionFound;
        String tmpName = LinknameCleaner.cutNameMatch(name, pat13);
        if (tmpName.length() > 3) {
            name = tmpName;
        }
        name = LinknameCleaner.removeOtherFileExtensions(name, hasKnownExtension);
        name = LinknameCleaner.removeTrailingSeparators(name);
        return name;
    }

    private static ExtensionRemovalResult removeKnownArchiveExtensions(String name) {
        ExtensionRemovalResult result = LinknameCleaner.checkPatternList(name, rarPats);
        if (result.extensionFound) {
            return result;
        }
        result = LinknameCleaner.checkPatternList(name, zipPats);
        if (result.extensionFound) {
            return result;
        }
        result = LinknameCleaner.checkPatternList(name, iszPats);
        if (result.extensionFound) {
            return result;
        }
        String processed = LinknameCleaner.getNameMatch(name, pat17);
        if (!name.equals(processed)) {
            return new ExtensionRemovalResult(processed, true);
        }
        if (ffsjPats != null) {
            for (Pattern pattern : ffsjPats) {
                processed = LinknameCleaner.getNameMatch(name, pattern);
                if (name.equalsIgnoreCase(processed)) continue;
                return new ExtensionRemovalResult(processed, true);
            }
        }
        return new ExtensionRemovalResult(name, false);
    }

    private static ExtensionRemovalResult checkPatternList(String name, Pattern[] patterns) {
        for (Pattern pattern : patterns) {
            String processed = LinknameCleaner.getNameMatch(name, pattern);
            if (name.equals(processed)) continue;
            return new ExtensionRemovalResult(processed, true);
        }
        return new ExtensionRemovalResult(name, false);
    }

    private static String removeOtherFileExtensions(String name, boolean hasKnownExtension) {
        EXTENSION_SETTINGS extensionSettings = EXTENSION_SETTINGS.REMOVE_ALL;
        if (EXTENSION_SETTINGS.REMOVE_ALL.equals((Object)extensionSettings) || EXTENSION_SETTINGS.REMOVE_KNOWN.equals((Object)extensionSettings)) {
            int lastPoint;
            while ((lastPoint = name.lastIndexOf(".")) > 0) {
                String ext = name.substring(lastPoint + 1);
                int extLength = ext.length();
                CompiledFiletypeFilter.CompiledFiletypeExtension knownExt = CompiledFiletypeFilter.getExtensionsFilterInterface(ext);
                if (knownExt != null && !CompiledFiletypeFilter.ArchiveExtensions.NUM.equals(knownExt)) {
                    name = name.substring(0, lastPoint);
                    continue;
                }
                if (extLength > 4 || !EXTENSION_SETTINGS.REMOVE_ALL.equals((Object)extensionSettings) || !ext.matches("^[0-9a-zA-z]+$") || hasKnownExtension) break;
                name = name.substring(0, lastPoint);
            }
        }
        return name;
    }

    private static String removeTrailingSeparators(String name) {
        char c;
        int removeIndex = -1;
        int i = name.length() - 1;
        while (i >= 0 && ((c = name.charAt(i)) == ',' || c == '_' || c == '-')) {
            removeIndex = i--;
        }
        if (removeIndex > 0) {
            name = name.substring(0, removeIndex);
        }
        return name;
    }

    private static String getNameMatch(String name, Pattern pattern) {
        String match = new Regex(name, pattern).getMatch(0);
        if (match != null) {
            return match;
        }
        return name;
    }

    private static String cutNameMatch(String name, Pattern pattern) {
        if (name == null) {
            return null;
        }
        String match = new Regex(name, pattern).getMatch(0);
        if (match != null) {
            int firstpos = name.indexOf(match);
            String tmp = name.substring(0, firstpos);
            int lastpos = name.indexOf(match) + match.length();
            if (lastpos <= name.length()) {
                tmp = tmp + name.substring(lastpos);
            }
            name = tmp;
            name = name.replaceAll("\\.{2,}", ".");
            name = name.replaceAll("\\.{2,}", ".");
        }
        return name;
    }

    static {
        try {
            pat11 = Pattern.compile("(.+)(\\.(jdeatme|3gp|7zip|7z|abr|ac3|ace|aiff|aifc|aif|ai|au|avi|avif|appimage|apk|azw3|azw|adf|asc|ape|bin|ass|bmp|bat|bz2|cbr|csv|cab|cbz|ccf|chm|cr2|cso|cue|cpio|cvd|c\\d{2,4}|chd|dta|deb|diz|divx|djvu|dlc|dmg|dms|doc|docx|dot|dx2|eps|epub|exe|ff|flv|flac|f4v|gsd|gif|gpg|gpx|gz|gp|hqx|iwd|idx|iso|ipa|ipsw|java|jar|jpe?g|jp2|load|lha|lzh|m2ts|m4v|m4a|md5|midi?|mkv|mp2|mo3|mp3|mp4|mobi|mov|movie|mpeg|mpe|mpg|mpq|msi|msu|msp|mv|mws|nfo|npk|nfs|oga|ogg|ogm|ogv|otrkey|par2|pak|pkg|png|pdf|pptx?|ppsx?|ppz|pdb|pot|psd|ps|qt|rmvb|rm|rar|ra|rev|rnd|rpm|run|rsdf|reg|rtf|shnf|sh(?!tml)|ssa|smi|sig|sub|srt|snd|sfv|sfx|swf|swc|sid|sit|tar\\.(gz|bz2|xz)|tar|tgz|tiff?|ts|txt|viv|vivo|vob|vtt|webm|webp|wav|wad|wmv|wma|wpt|xla|xls|xpi|xtm|zeno|zip|[r-z]\\d{2}|_?[_a-z]{2}|\\d{1,4}(?=\\?|$|#|\"|\r|\n|;))$)", 2);
            ffsjPats = new Pattern[]{pat10, pat11};
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pat13 = Pattern.compile("(part\\d+)", 2);
        pat17 = Pattern.compile("(.+)\\.\\d+\\.xtm($|\\.html?)");
        pat18 = Pattern.compile("(.*)\\.isz($|\\.html?)", 2);
        pat19 = Pattern.compile("(.*)\\.i\\d{2}$", 2);
        iszPats = new Pattern[]{pat18, pat19};
        FILENAME_REPLACEMAP = new HashMap<Pattern, String>();
        FILENAME_REPLACEMAP_DEFAULT = new HashMap<String, String>();
        ObjectKeyHandler replaceMapKeyHandler = CFG_GENERAL.FILENAME_CHARACTER_REGEX_REPLACEMAP;
        FILENAME_REPLACEMAP_DEFAULT = (Map)replaceMapKeyHandler.getDefaultValue();
        replaceMapKeyHandler.getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                FILENAME_REPLACEMAP = LinknameCleaner.convertReplaceMap(FILENAME_REPLACEMAP_DEFAULT, (Map)newValue);
            }

            public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
            }
        });
        FILENAME_REPLACEMAP = LinknameCleaner.convertReplaceMap(FILENAME_REPLACEMAP_DEFAULT, (Map)replaceMapKeyHandler.getValue());
        FILENAME_TOO_LONG_REPLACEMAP = new HashMap<Pattern, String>();
        FILENAME_TOO_LONG_REPLACEMAP_DEFAULT = new HashMap<String, String>();
        replaceMapKeyHandler = CFG_GENERAL.FILENAME_TOO_LONG_REGEX_REPLACEMAP;
        FILENAME_TOO_LONG_REPLACEMAP_DEFAULT = (Map)replaceMapKeyHandler.getDefaultValue();
        replaceMapKeyHandler.getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                FILENAME_TOO_LONG_REPLACEMAP = LinknameCleaner.convertReplaceMap(FILENAME_TOO_LONG_REPLACEMAP_DEFAULT, (Map)newValue);
            }

            public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
            }
        });
        FILENAME_TOO_LONG_REPLACEMAP = LinknameCleaner.convertReplaceMap(FILENAME_TOO_LONG_REPLACEMAP_DEFAULT, (Map)replaceMapKeyHandler.getValue());
        PACKAGENAME_REPLACEMAP = new HashMap<Pattern, String>();
        PACKAGENAME_REPLACEMAP_DEFAULT = new HashMap<String, String>();
        replaceMapKeyHandler = CFG_GENERAL.PACKAGE_NAME_CHARACTER_REGEX_REPLACEMAP;
        PACKAGENAME_REPLACEMAP_DEFAULT = (Map)replaceMapKeyHandler.getDefaultValue();
        replaceMapKeyHandler.getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                PACKAGENAME_REPLACEMAP = LinknameCleaner.convertReplaceMap(PACKAGENAME_REPLACEMAP_DEFAULT, (Map)newValue);
            }

            public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
            }
        });
        PACKAGENAME_REPLACEMAP = LinknameCleaner.convertReplaceMap(PACKAGENAME_REPLACEMAP_DEFAULT, (Map)replaceMapKeyHandler.getValue());
    }

    private static class ExtensionRemovalResult {
        public final String processedName;
        public final boolean extensionFound;

        public ExtensionRemovalResult(String processedName, boolean extensionFound) {
            this.processedName = processedName;
            this.extensionFound = extensionFound;
        }
    }

    public static class ReplaceMapValidator
    extends AbstractValidator<Map<String, String>> {
        public void validate(KeyHandler<Map<String, String>> keyHandler, Map<String, String> value) throws ValidationException {
            try {
                for (Map.Entry<String, String> entry : value.entrySet()) {
                    if (entry.getKey() == null || entry.getKey().length() == 0 || entry.getValue() == null) continue;
                    Pattern.compile(entry.getKey());
                    Matcher.quoteReplacement(entry.getValue());
                }
            }
            catch (Exception e) {
                throw new ValidationException((Throwable)e);
            }
        }
    }

    public static enum EXTENSION_SETTINGS {
        KEEP,
        REMOVE_KNOWN,
        REMOVE_ALL;

    }
}

