/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.ChildrenView;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackageView;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelData;
import org.jdownloader.gui.views.downloads.columns.AvailabilityColumn;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.settings.GeneralSettings;

public class CrawledPackageView
extends ChildrenView<CrawledPackage, CrawledLink> {
    protected volatile long fileSize = -1L;
    private volatile DomainInfo[] domains = new DomainInfo[0];
    private volatile int enabled = 0;
    private volatile int offline = 0;
    private volatile int online = 0;
    private volatile int count = 0;
    private final AtomicLong updatesRequired = new AtomicLong(0L);
    private volatile long updatesDone = -1L;
    private volatile String commonSourceUrl;
    private volatile String availabilityColumnString = null;
    private volatile ChildrenView.ChildrenAvailablility availability = ChildrenView.ChildrenAvailablility.UNKNOWN;
    private final CrawledPackage pkg;
    protected static final boolean FORCED_MIRROR_CASE_INSENSITIVE = CrossSystem.isWindows() || ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isForceMirrorDetectionCaseInsensitive();
    protected final NumberFormat numberFormat = NumberFormat.getInstance();

    public CrawledPackageView(CrawledPackage pkg) {
        this.pkg = pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawledPackageView aggregate() {
        long lupdatesRequired = this.updatesRequired.get();
        CrawledPackageView crawledPackageView = this;
        synchronized (crawledPackageView) {
            Temp tmp = new Temp();
            PackageControllerTableModelData.PackageControllerTableModelDataPackage tableModelDataPackage = this.getTableModelDataPackage();
            if (tableModelDataPackage != null) {
                for (CrawledLink child : tableModelDataPackage.getVisibleChildren()) {
                    this.addLinkToTemp(tmp, child);
                }
            } else {
                boolean readL = this.pkg.getModifyLock().readLock();
                try {
                    for (CrawledLink link : this.pkg.getChildren()) {
                        this.addLinkToTemp(tmp, link);
                    }
                }
                finally {
                    this.pkg.getModifyLock().readUnlock(readL);
                }
            }
            this.writeTempToFields(tmp);
            this.updatesDone = lupdatesRequired;
            if (this.domains.length != tmp.domains.size() || !tmp.domains.values().containsAll(Arrays.asList(this.domains))) {
                ArrayList<DomainInfo> lst = new ArrayList<DomainInfo>(tmp.domains.values());
                if (lst.size() > 1) {
                    Collections.sort(lst, FilePackageView.DOMAININFOCOMPARATOR);
                }
                this.domains = lst.toArray(new DomainInfo[tmp.domains.size()]);
            }
        }
        return this;
    }

    protected void writeTempToFields(Temp tmp) {
        this.commonSourceUrl = tmp.sameSource;
        if (!tmp.sameSourceFullUrl) {
            this.commonSourceUrl = this.commonSourceUrl + "[...]";
        }
        long size = -1L;
        boolean atLeastOneEnabled = tmp.newEnabled > 0;
        for (LinkInfo linkInfo : tmp.linkInfos.values()) {
            if (atLeastOneEnabled && !linkInfo.enabled || linkInfo.bytesTotal == -1L) continue;
            if (size == -1L) {
                size = 0L;
            }
            size += linkInfo.bytesTotal;
        }
        this.fileSize = size;
        this.enabled = tmp.newEnabled;
        this.offline = tmp.newOffline;
        this.online = tmp.newOnline;
        this.count = tmp.count;
        this.updatesDone = tmp.lupdatesRequired;
        this.availability = this.updateAvailability(tmp);
        this.availabilityColumnString = _GUI.T.AvailabilityColumn_getStringValue_object_(StringUtils.toString((NumberFormat)this.numberFormat, (long)tmp.newOnline), StringUtils.toString((NumberFormat)this.numberFormat, (long)tmp.count));
    }

    protected void addLinkToTemp(Temp tmp, CrawledLink link) {
        String sourceUrl;
        ++tmp.count;
        DomainInfo domainInfo = link.getDomainInfo();
        tmp.domains.put(domainInfo.getTld(), domainInfo);
        DownloadLink dlLink = link.getDownloadLink();
        if (dlLink != null && (sourceUrl = dlLink.getView().getDisplayUrl()) != null) {
            tmp.sameSource = StringUtils.getCommonalities((String)tmp.sameSource, (String)sourceUrl);
            boolean bl = tmp.sameSourceFullUrl = tmp.sameSourceFullUrl && tmp.sameSource.equals(sourceUrl);
        }
        if (link.isEnabled()) {
            ++tmp.newEnabled;
        }
        if (link.getLinkState() == AvailableLinkState.OFFLINE) {
            ++tmp.newOffline;
        } else if (link.getLinkState() == AvailableLinkState.ONLINE) {
            ++tmp.newOnline;
        }
        String name = FORCED_MIRROR_CASE_INSENSITIVE ? link.getName().toLowerCase(Locale.ENGLISH) : link.getName();
        LinkInfo existing = tmp.linkInfos.get(name);
        long linkSize = link.getSize();
        if (existing == null) {
            existing = new LinkInfo();
            existing.bytesTotal = linkSize;
            tmp.linkInfos.put(name, existing);
        } else if (linkSize > existing.bytesTotal) {
            existing.bytesTotal = linkSize;
        }
        if (link.isEnabled()) {
            existing.enabled = true;
        }
    }

    public final ChildrenView.ChildrenAvailablility updateAvailability(Temp tmp) {
        int count = tmp.count;
        int online = tmp.newOnline;
        int offline = tmp.newOffline;
        if (online > 0 && online == count) {
            return ChildrenView.ChildrenAvailablility.ONLINE;
        }
        if (offline > 0 && offline == count) {
            return ChildrenView.ChildrenAvailablility.OFFLINE;
        }
        if (offline == 0 && online == 0 || online == 0 && offline > 0) {
            return ChildrenView.ChildrenAvailablility.UNKNOWN;
        }
        return ChildrenView.ChildrenAvailablility.MIXED;
    }

    public String getCommonSourceUrl() {
        return this.commonSourceUrl;
    }

    @Override
    public DomainInfo[] getDomainInfos() {
        return this.domains;
    }

    @Override
    public int getDisabledCount() {
        return Math.max(0, this.size() - this.getEnabledCount());
    }

    @Override
    public boolean isEnabled() {
        return this.getEnabledCount() > 0;
    }

    @Override
    public int getEnabledCount() {
        return this.enabled;
    }

    public int getOfflineCount() {
        return this.offline;
    }

    public int getOnlineCount() {
        return this.online;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void requestUpdate() {
        this.updatesRequired.incrementAndGet();
    }

    @Override
    public boolean updateRequired() {
        return this.updatesRequired.get() != this.updatesDone;
    }

    @Override
    public ChildrenView.ChildrenAvailablility getAvailability() {
        return this.availability;
    }

    @Override
    public String getMessage(Object requestor) {
        if (requestor instanceof AvailabilityColumn) {
            return this.availabilityColumnString;
        }
        return null;
    }

    @Override
    public int size() {
        return this.count;
    }

    static /* synthetic */ AtomicLong access$100(CrawledPackageView x0) {
        return x0.updatesRequired;
    }

    private class Temp {
        final HashMap<String, LinkInfo> linkInfos = new HashMap();
        final HashMap<String, DomainInfo> domains = new HashMap();
        int count = 0;
        int newOnline = 0;
        int newEnabled = 0;
        int newOffline = 0;
        String sameSource = null;
        boolean sameSourceFullUrl = true;
        long lupdatesRequired = CrawledPackageView.access$100(CrawledPackageView.this).get();

        private Temp() {
        }
    }

    private static class LinkInfo {
        private long bytesTotal = -1L;
        private boolean enabled = false;

        private LinkInfo() {
        }
    }
}

