/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import org.appwork.utils.StringUtils;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;

public class LinkCrawlerLock {
    protected final LazyCrawlerPlugin plugin;

    public LinkCrawlerLock(LazyCrawlerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean matches(LazyCrawlerPlugin plugin, CrawledLink crawledLink) {
        return this.isSameLazyCrawlerPlugin(this.plugin, plugin);
    }

    public String toString() {
        return this.plugin + "|" + this.getMaxConcurrency();
    }

    protected String getMatchingIdentifier() {
        return this.getMaxConcurrency() + this.plugin.getDisplayName().concat(this.plugin.getLazyPluginClass().getClassName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof LinkCrawlerLock) {
            LinkCrawlerLock other = (LinkCrawlerLock)obj;
            return StringUtils.equals((String)this.getMatchingIdentifier(), (String)other.getMatchingIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.plugin.getLazyPluginClass().getClassName().hashCode();
    }

    public int getMaxConcurrency() {
        return Math.max(1, this.plugin.getMaxConcurrentInstances());
    }

    public boolean isSameLazyCrawlerPlugin(LazyCrawlerPlugin x, LazyCrawlerPlugin y) {
        return x != null && y != null && StringUtils.equals((String)x.getDisplayName(), (String)y.getDisplayName()) && StringUtils.equals((String)x.getLazyPluginClass().getClassName(), (String)y.getLazyPluginClass().getClassName());
    }

    public static boolean requiresLocking(LazyCrawlerPlugin plugin) {
        int maxConcurrency = plugin.getMaxConcurrentInstances();
        return maxConcurrency >= 1 && maxConcurrency < LinkCrawler.getMaxThreads();
    }

    public boolean requiresLocking() {
        return this.getMaxConcurrency() < LinkCrawler.getMaxThreads();
    }
}

