/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.proxy;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.proxy.ConnectionBan;
import jd.controlling.proxy.ProxyController;
import jd.controlling.proxy.SelectProxyByURLHook;
import jd.http.ProxySelectorInterface;
import jd.http.Request;
import jd.plugins.Account;
import jd.plugins.Plugin;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.Exceptions;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyStorable;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.FilterList;
import org.jdownloader.updatev2.ProxyData;

public abstract class AbstractProxySelectorImpl
implements ProxySelectorInterface {
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private volatile FilterList filter;
    private boolean resumeIsAllowed = true;
    protected final CopyOnWriteArraySet<SingleDownloadController> activeSingleDownloadControllers = new CopyOnWriteArraySet();
    protected final CopyOnWriteArrayList<SelectProxyByURLHook> selectProxyByURLHooks = new CopyOnWriteArrayList();
    private boolean reconnectSupported;
    protected final CopyOnWriteArrayList<ConnectionBan> banList = new CopyOnWriteArrayList();

    public boolean reportConnectException(Request request, int retryCounter, IOException e) {
        return ProxyController.getInstance().reportConnectException(request, retryCounter, e);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public boolean setEnabled(boolean enabled) {
        boolean ret = this.enabled.getAndSet(enabled);
        if (enabled) {
            this.clearBanList();
        }
        return ret;
    }

    protected void clearBanList() {
        this.banList.clear();
    }

    public FilterList getFilter() {
        return this.filter;
    }

    public boolean isAllowedByFilter(String host, Account acc) {
        FilterList lFilter = this.filter;
        return lFilter == null || lFilter.validate(host, acc == null ? null : acc.getUser());
    }

    public void setFilter(FilterList filter) {
        this.filter = filter;
    }

    public abstract ProxyData toProxyData();

    protected ProxyData toProxyData(HTTPProxyStorable proxy) {
        ProxyData ret = new ProxyData(proxy);
        ret.setEnabled(this.isEnabled());
        ret.setFilter(this.getFilter());
        ret.setRangeRequestsSupported(this.isResumeAllowed());
        return ret;
    }

    public abstract String toDetailsString();

    public String toString() {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("class", this.getClass().getName());
            data.put("proxy", (String)this.toProxyData());
            data.put("banlist", this.banList.toString());
            return JSonStorage.toString(data);
        }
        catch (Throwable e) {
            return Exceptions.getStackTrace((Throwable)e);
        }
    }

    public abstract Type getType();

    public void setType(Type value) {
        throw new IllegalStateException("This operation is not allowed on this Factory Type");
    }

    public abstract boolean isPreferNativeImplementation();

    public abstract void setPreferNativeImplementation(boolean var1);

    public abstract String toExportString();

    public boolean isReconnectSupported() {
        return this.reconnectSupported;
    }

    public void setReconnectSupported(boolean reconnectSupported) {
        this.reconnectSupported = reconnectSupported;
    }

    public boolean add(SingleDownloadController singleDownloadController) {
        return singleDownloadController != null && this.activeSingleDownloadControllers.add(singleDownloadController);
    }

    public boolean remove(SingleDownloadController singleDownloadController) {
        return singleDownloadController != null && this.activeSingleDownloadControllers.remove(singleDownloadController);
    }

    public Set<SingleDownloadController> getSingleDownloadControllers() {
        return this.activeSingleDownloadControllers;
    }

    public void setResumeAllowed(boolean b) {
        this.resumeIsAllowed = b;
    }

    public boolean isResumeAllowed() {
        return this.isLocal() || this.resumeIsAllowed;
    }

    protected abstract boolean isLocal();

    public abstract boolean isResolveDNSLocally();

    public abstract void setResolveDNSLocally(boolean var1);

    public List<ConnectionBan> getBanList() {
        return Collections.unmodifiableList(this.banList);
    }

    public void addSessionBan(ConnectionBan newBan) {
        if (newBan != null) {
            boolean addFlag = true;
            for (ConnectionBan oldBan : this.banList) {
                if (oldBan.isExpired()) {
                    this.banList.remove(oldBan);
                    continue;
                }
                if (oldBan.canSwallow(newBan)) {
                    addFlag = false;
                    continue;
                }
                if (!newBan.canSwallow(oldBan)) continue;
                this.banList.remove(oldBan);
            }
            if (addFlag && this.banList.addIfAbsent(newBan)) {
                LogController.CL().log((Throwable)new Exception(newBan.toString()));
            }
        }
    }

    public boolean isProxyBannedFor(HTTPProxy orgReference, URL url, Plugin pluginFromThread, boolean ignoreConnectBans) {
        for (ConnectionBan ban : this.banList) {
            if (ban.isExpired()) {
                this.banList.remove(ban);
                continue;
            }
            if (!ban.isProxyBannedByUrlOrPlugin(orgReference, url, pluginFromThread, ignoreConnectBans)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectorBannedFor(Plugin pluginForHost, boolean ignoreConnectBans) {
        for (ConnectionBan ban : this.banList) {
            if (ban.isExpired()) {
                this.banList.remove(ban);
                continue;
            }
            if (!ban.isSelectorBannedByPlugin(pluginForHost, ignoreConnectBans)) continue;
            return true;
        }
        return false;
    }

    public void addSelectProxyByUrlHook(SelectProxyByURLHook selectProxyByUrlHook) {
        if (selectProxyByUrlHook != null) {
            this.selectProxyByURLHooks.addIfAbsent(selectProxyByUrlHook);
        }
    }

    public void removeSelectProxyByUrlHook(SelectProxyByURLHook selectProxyByUrlHook) {
        if (selectProxyByUrlHook != null) {
            this.selectProxyByURLHooks.remove(selectProxyByUrlHook);
        }
    }

    public static enum Type {
        NONE,
        DIRECT,
        SOCKS4,
        SOCKS4A,
        SOCKS5,
        HTTP,
        HTTPS,
        PAC;

    }
}

