/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.proxy;

import java.net.URL;
import jd.controlling.proxy.AbstractBan;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.ConnectionBan;
import jd.http.Browser;
import jd.plugins.Plugin;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.jdownloader.translate._JDT;

public class EndPointConnectExceptionBan
extends AbstractBan {
    private final URL url;
    private volatile long created = Time.systemIndependentCurrentJVMTimeMillis();

    @Override
    public String getAuth() {
        return this.auth;
    }

    protected URL getURL() {
        return this.url;
    }

    public EndPointConnectExceptionBan(AbstractProxySelectorImpl selector, HTTPProxy proxy, URL url) {
        super(proxy, selector);
        this.url = url;
    }

    protected String getHost() {
        return Browser.getHost((URL)this.getURL());
    }

    public String toString() {
        return _JDT.T.ConnectExceptionInPluginBan(this.getProtocol() + "://" + this.getURL().getHost().concat(":").concat(Integer.toString(this.getPort())));
    }

    protected int getPort() {
        return this.getPort(this.getURL());
    }

    protected String getProtocol() {
        return this.getURL().getProtocol();
    }

    protected long getExpireTimeout() {
        return 900000L;
    }

    @Override
    public boolean isSelectorBannedByPlugin(Plugin plugin, boolean ignoreConnectBans) {
        String host = plugin.getHost();
        return !ignoreConnectBans && StringUtils.containsIgnoreCase((String)this.getHost(), (String)host);
    }

    @Override
    public boolean isProxyBannedByUrlOrPlugin(HTTPProxy proxy, URL url, Plugin pluginFromThread, boolean ignoreConnectBans) {
        if (!ignoreConnectBans && this.proxyEquals(this.getProxy(), proxy)) {
            boolean ret = this.getPort() == this.getPort(url) && StringUtils.containsIgnoreCase((String)this.getHost(), (String)Browser.getHost((URL)url)) && StringUtils.equals((String)this.getProtocol(), (String)url.getProtocol());
            return ret;
        }
        return false;
    }

    @Override
    public boolean isExpired() {
        return Time.systemIndependentCurrentJVMTimeMillis() - this.getCreated() > this.getExpireTimeout() || super.isExpired();
    }

    protected long getCreated() {
        return this.created;
    }

    @Override
    public boolean canSwallow(ConnectionBan ban) {
        if (ban instanceof EndPointConnectExceptionBan) {
            EndPointConnectExceptionBan other = (EndPointConnectExceptionBan)ban;
            if (this.proxyEquals(this.getProxy(), other.getProxy()) && this.getPort() == other.getPort() && StringUtils.equals((String)this.getHost(), (String)other.getHost()) && StringUtils.equals((String)this.getProtocol(), (String)other.getProtocol())) {
                this.created = Math.max(other.getCreated(), this.getCreated());
                return true;
            }
        }
        return false;
    }
}

