/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.proxy;

import com.btr.proxy.selector.pac.PacProxySelector;
import com.btr.proxy.selector.pac.PacScriptSource;
import com.btr.proxy.selector.pac.UrlPacScriptSource;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.ProxyController;
import jd.controlling.proxy.SelectProxyByURLHook;
import jd.controlling.proxy.SelectedProxy;
import jd.http.Request;
import jd.nutils.encoding.Encoding;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyStorable;
import org.appwork.utils.net.socketconnection.SocketConnection;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.InternetConnectionSettings;
import org.jdownloader.updatev2.ProxyData;

public class PacProxySelectorImpl
extends AbstractProxySelectorImpl {
    private static final LogSource logger = LogController.getInstance().getLogger(PacProxySelectorImpl.class.getName());
    private volatile String pacUrl;
    private final HashMap<String, PacProxySelector> selectors = new HashMap();
    private final AtomicLong latestValidation = new AtomicLong(-1L);
    private final AtomicLong doNotValidateUntil = new AtomicLong(-1L);
    private final HashMap<String, HTTPProxy> cacheMap = new HashMap();
    private final HashMap<String, String[]> tempAuthMap = new HashMap();
    private boolean nativeProxy = false;
    private String user;
    private String password;

    public PacProxySelectorImpl(String url, String user, String pass) {
        if (!((InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class)).isProxyVoleAutodetectionEnabled()) {
            throw new WTFException("Proxy Vole is Disabled");
        }
        this.pacUrl = url;
        this.user = user;
        this.password = pass;
    }

    @Override
    public String toDetailsString() {
        String ret = "AutoProxy Script: " + this.getPACUrl();
        if (StringUtils.isNotEmpty((String)this.getUser())) {
            return this.getUser() + "@" + ret;
        }
        return ret;
    }

    public PacProxySelectorImpl(ProxyData proxyData) {
        if (!((InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class)).isProxyVoleAutodetectionEnabled()) {
            throw new WTFException("Proxy Vole is Disabled");
        }
        this.pacUrl = proxyData.getProxy().getAddress();
        this.user = proxyData.getProxy().getUsername();
        this.password = proxyData.getProxy().getPassword();
        this.setEnabled(proxyData.isEnabled());
        this.setPreferNativeImplementation(proxyData.getProxy().isPreferNativeImplementation());
        this.setFilter(proxyData.getFilter());
        this.setReconnectSupported(proxyData.isReconnectSupported());
    }

    @Override
    public void setResolveDNSLocally(boolean resolveLocally) {
    }

    @Override
    public boolean isResolveDNSLocally() {
        return false;
    }

    public List<HTTPProxy> getProxiesByURL(URL url) {
        List<HTTPProxy> ret = this.getProxyByUrlInternal(url);
        for (SelectProxyByURLHook hook : this.selectProxyByURLHooks) {
            hook.onProxyChoosen(url, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HTTPProxy> getProxyByUrlInternal(URL url) {
        ArrayList<HTTPProxy> ret;
        block27: {
            PacProxySelector lSelector = this.getPacProxySelector();
            if (lSelector == null) {
                return null;
            }
            ret = new ArrayList<HTTPProxy>();
            if (url != null) {
                try {
                    List result;
                    StringBuilder sb = new StringBuilder();
                    sb.append(url.getProtocol());
                    sb.append("://");
                    sb.append(url.getHost());
                    if (url.getPort() != -1) {
                        sb.append(":");
                        sb.append(url.getPort());
                    }
                    if ((result = lSelector.select(new URI(sb.toString()))) == null) break block27;
                    block15: for (Proxy p : result) {
                        String ID2 = p.toString();
                        try {
                            HTTPProxy cached = null;
                            PacProxySelectorImpl pacProxySelectorImpl = this;
                            synchronized (pacProxySelectorImpl) {
                                cached = this.cacheMap.get(ID2);
                                if (cached == null) {
                                    HTTPProxy httpProxy;
                                    switch (p.type()) {
                                        case DIRECT: {
                                            if (p.address() == null) {
                                                httpProxy = new HTTPProxy(HTTPProxy.TYPE.NONE);
                                                break;
                                            }
                                            httpProxy = new HTTPProxy(((InetSocketAddress)p.address()).getAddress());
                                            break;
                                        }
                                        case HTTP: {
                                            if (p.address() != null) {
                                                httpProxy = new HTTPProxy(HTTPProxy.TYPE.HTTP, SocketConnection.getHostName((SocketAddress)p.address()), ((InetSocketAddress)p.address()).getPort());
                                                break;
                                            }
                                            continue block15;
                                        }
                                        case SOCKS: {
                                            if (p.address() != null) {
                                                httpProxy = new HTTPProxy(HTTPProxy.TYPE.SOCKS5, SocketConnection.getHostName((SocketAddress)p.address()), ((InetSocketAddress)p.address()).getPort());
                                                break;
                                            }
                                            continue block15;
                                        }
                                        default: {
                                            continue block15;
                                        }
                                    }
                                    cached = new SelectedProxy(this, httpProxy);
                                    this.cacheMap.put(ID2, cached);
                                }
                            }
                            cached.setPreferNativeImplementation(this.isPreferNativeImplementation());
                            if (cached.isRemote()) {
                                String pw = this.getPassword();
                                String us = this.getUser();
                                PacProxySelectorImpl pacProxySelectorImpl2 = this;
                                synchronized (pacProxySelectorImpl2) {
                                    String[] tmp = this.tempAuthMap.get(this.toID(cached));
                                    if (tmp != null) {
                                        if (tmp[0] != null) {
                                            us = tmp[0];
                                        }
                                        if (tmp[1] != null) {
                                            pw = tmp[1];
                                        }
                                    }
                                }
                                cached.setPass(pw);
                                cached.setUser(us);
                            }
                            ret.add(cached);
                        }
                        catch (Throwable e) {
                            logger.log(e);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.log(e);
                }
            }
        }
        return ret;
    }

    private synchronized PacProxySelector getPacProxySelector() {
        final String lPacURL = this.pacUrl;
        if (lPacURL.startsWith("pac://")) {
            PacScriptSource pacSource = new PacScriptSource(){

                public String getScriptContent() throws IOException {
                    if (StringUtils.equalsIgnoreCase((String)lPacURL, (String)"pac://")) {
                        return ((InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class)).getLocalPacScript();
                    }
                    return Encoding.urlDecode((String)lPacURL.substring(6), (boolean)false);
                }

                public boolean isScriptValid() {
                    try {
                        String script = this.getScriptContent();
                        if (script == null || script.trim().length() == 0) {
                            logger.info("PAC script is empty. Skipping script!");
                            return false;
                        }
                        if (script.indexOf("FindProxyForURL") == -1) {
                            logger.info("PAC script entry point FindProxyForURL not found. Skipping script!");
                            return false;
                        }
                        return true;
                    }
                    catch (IOException e) {
                        logger.log((Throwable)e);
                        return false;
                    }
                }
            };
            if (pacSource.isScriptValid()) {
                return new PacProxySelector(pacSource);
            }
        } else {
            PacProxySelector selector = this.selectors.get(this.pacUrl);
            if ((selector == null || System.currentTimeMillis() - this.latestValidation.get() > 900000L) && this.doNotValidateUntil.get() < System.currentTimeMillis()) {
                this.tempAuthMap.clear();
                this.cacheMap.clear();
                this.selectors.clear();
                this.latestValidation.set(-1L);
                UrlPacScriptSource pacSource = new UrlPacScriptSource(lPacURL);
                logger.info("Download PAC Script!");
                long t = System.currentTimeMillis();
                if (pacSource.isScriptValid()) {
                    selector = new PacProxySelector((PacScriptSource)pacSource);
                    this.latestValidation.set(System.currentTimeMillis());
                    this.selectors.put(lPacURL, selector);
                } else {
                    selector = null;
                    if (System.currentTimeMillis() - t > 5000L) {
                        this.doNotValidateUntil.set(System.currentTimeMillis() + 300000L);
                    }
                }
            }
            return selector;
        }
        return null;
    }

    @Override
    public void setType(AbstractProxySelectorImpl.Type value) {
        throw new IllegalStateException("This operation is not allowed on this Factory Type");
    }

    @Override
    public ProxyData toProxyData() {
        HTTPProxyStorable proxy = new HTTPProxyStorable();
        proxy.setUsername(this.getUser());
        proxy.setPassword(this.getPassword());
        proxy.setAddress(this.getPACUrl());
        proxy.setPreferNativeImplementation(this.isPreferNativeImplementation());
        ProxyData ret = super.toProxyData(proxy);
        ret.setPac(true);
        ret.setReconnectSupported(this.isReconnectSupported());
        return ret;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        if (!StringUtils.equals((String)user, (String)this.user)) {
            this.user = user;
            this.clearBanList();
        }
    }

    public void setPassword(String password) {
        if (!StringUtils.equals((String)password, (String)this.password)) {
            this.password = password;
            this.clearBanList();
        }
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public AbstractProxySelectorImpl.Type getType() {
        return AbstractProxySelectorImpl.Type.PAC;
    }

    public String getPACUrl() {
        return this.pacUrl;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(PacProxySelectorImpl.class) && StringUtils.equalsIgnoreCase((String)this.getPACUrl(), (String)((PacProxySelectorImpl)obj).getPACUrl());
    }

    public int hashCode() {
        return PacProxySelectorImpl.class.hashCode();
    }

    public void setPACUrl(String value) {
        if (!StringUtils.equals((String)this.pacUrl, (String)value)) {
            this.pacUrl = value;
            this.clearBanList();
        }
    }

    @Override
    public String toExportString() {
        String pacURL = this.getPACUrl();
        if (StringUtils.isNotEmpty((String)this.getUser())) {
            return "pac://" + this.getUser() + "@" + pacURL;
        }
        return "pac://" + pacURL;
    }

    @Override
    public boolean isPreferNativeImplementation() {
        return this.nativeProxy;
    }

    @Override
    public void setPreferNativeImplementation(boolean preferNativeImplementation) {
        if (this.isPreferNativeImplementation() != preferNativeImplementation) {
            this.nativeProxy = preferNativeImplementation;
            this.clearBanList();
        }
    }

    @Override
    protected boolean isLocal() {
        return false;
    }

    public boolean updateProxy(Request request, int retryCounter) {
        return ProxyController.getInstance().updateProxy(this, request, retryCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTempAuth(HTTPProxy usedProxy, String user2, String pass) {
        PacProxySelectorImpl pacProxySelectorImpl = this;
        synchronized (pacProxySelectorImpl) {
            if (user2 == null && pass == null) {
                this.tempAuthMap.remove(this.toID(usedProxy));
            } else {
                this.tempAuthMap.put(this.toID(usedProxy), new String[]{user2, pass});
            }
        }
        usedProxy.setUser(user2 == null ? this.getUser() : user2);
        usedProxy.setPass(pass == null ? this.getPassword() : pass);
    }

    private String toID(HTTPProxy usedProxy) {
        return usedProxy.getHost() + ":" + usedProxy.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProxyBannedFor(HTTPProxy orgReference, URL url, Plugin pluginFromThread, boolean ignoreConnectBans) {
        PacProxySelectorImpl pacProxySelectorImpl = this;
        synchronized (pacProxySelectorImpl) {
            if (!this.cacheMap.containsValue(orgReference)) {
                return false;
            }
        }
        return super.isProxyBannedFor(orgReference, url, pluginFromThread, ignoreConnectBans);
    }

    @Override
    public boolean isSelectorBannedFor(Plugin pluginForHost, boolean ignoreConnectionBans) {
        return super.isSelectorBannedFor(pluginForHost, ignoreConnectionBans);
    }

    public boolean isSelectorBannedFor(URL url) {
        return false;
    }
}

