/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.proxy;

import com.btr.proxy.search.ProxySearchStrategy;
import com.btr.proxy.search.browser.firefox.FirefoxProxySearchStrategy;
import com.btr.proxy.search.desktop.DesktopProxySearchStrategy;
import com.btr.proxy.search.env.EnvProxySearchStrategy;
import com.btr.proxy.search.java.JavaProxySearchStrategy;
import com.btr.proxy.selector.pac.PacProxySelector;
import com.btr.proxy.selector.pac.PacScriptParser;
import com.btr.proxy.selector.pac.PacScriptSource;
import com.btr.proxy.selector.pac.UrlPacScriptSource;
import com.btr.proxy.selector.whitelist.ProxyBypassListSelector;
import com.btr.proxy.util.Logger;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import jd.controlling.accountchecker.AccountChecker;
import jd.controlling.accountchecker.AccountCheckerThread;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.linkchecker.LinkCheckerThread;
import jd.controlling.linkcrawler.LinkCrawlerThread;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.AuthExceptionGenericBan;
import jd.controlling.proxy.ConnectExceptionInPluginBan;
import jd.controlling.proxy.EndPointConnectExceptionBan;
import jd.controlling.proxy.GenericConnectExceptionBan;
import jd.controlling.proxy.NoProxySelector;
import jd.controlling.proxy.PacProxySelectorImpl;
import jd.controlling.proxy.PluginRelatedConnectionBan;
import jd.controlling.proxy.ProxyEvent;
import jd.controlling.proxy.ProxyExportImport;
import jd.controlling.proxy.SelectedProxy;
import jd.controlling.proxy.SingleBasicProxySelectorImpl;
import jd.controlling.proxy.SingleDirectGatewaySelector;
import jd.http.Browser;
import jd.http.ClonedProxy;
import jd.http.ProxySelectorInterface;
import jd.http.Request;
import jd.nutils.encoding.Encoding;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.MultiHostHost;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.ConfigEvent;
import org.appwork.storage.config.events.ConfigEventSender;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEventListener;
import org.appwork.utils.event.DefaultEventSender;
import org.appwork.utils.event.EventSuppressor;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyException;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.ProxyEndpointConnectException;
import org.appwork.utils.net.socketconnection.SocketConnection;
import org.appwork.utils.net.socketconnection.Socks5SocketConnection;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.ProxyDialog;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.FilterList;
import org.jdownloader.updatev2.InternetConnectionSettings;
import org.jdownloader.updatev2.ProxyClone;
import org.jdownloader.updatev2.ProxyData;

public class ProxyController
implements ProxySelectorInterface {
    public static final URLStreamHandler SOCKETURLSTREAMHANDLER = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            throw new IOException("not implemented");
        }
    };
    private static final ProxyController INSTANCE = new ProxyController();
    private volatile CopyOnWriteArrayList<AbstractProxySelectorImpl> list = new CopyOnWriteArrayList();
    private final DefaultEventSender<ProxyEvent<AbstractProxySelectorImpl>> eventSender;
    private final InternetConnectionSettings config;
    private final LogSource logger;
    private final Queue QUEUE = new Queue(this.getClass().getName()){

        public void killQueue() {
            LogController.CL().log(new Throwable("YOU CANNOT KILL ME!"));
        }
    };
    private final ConfigEventSender<Object> customProxyListEventSender;
    private final EventSuppressor<ConfigEvent> eventSuppressor = new EventSuppressor<ConfigEvent>(){

        public boolean suppressEvent(ConfigEvent eventType) {
            return true;
        }
    };
    private final HashMap<SelectedProxy, SelectedProxyLock> LOCKS = new HashMap();

    public static final ProxyController getInstance() {
        return INSTANCE;
    }

    public Queue getQUEUE() {
        return this.QUEUE;
    }

    private ProxyController() {
        this.eventSender = new DefaultEventSender();
        this.config = (InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class);
        this.logger = LogController.getInstance().getLogger(ProxyController.class.getName());
        if (Logger.getBackend() == null) {
            Logger.setBackend((Logger.LogBackEnd)new Logger.LogBackEnd(){

                public void log(Class<?> arg0, Logger.LogLevel arg1, String arg2, Object ... arg3) {
                    ProxyController.this.logger.log(Level.ALL, arg2, arg3);
                }

                public boolean isLogginEnabled(Logger.LogLevel arg0) {
                    return true;
                }
            });
        }
        this.list = new CopyOnWriteArrayList<AbstractProxySelectorImpl>(this.loadProxySettings(true));
        GenericConfigEventListener<Object> updateListener = new GenericConfigEventListener<Object>(){

            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                ProxyController.this.setList(ProxyController.this.loadProxySettings(true));
            }

            public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
            }
        };
        this.customProxyListEventSender = this.config._getStorageHandler().getKeyHandler("CustomProxyList").getEventSender();
        this.customProxyListEventSender.addListener((EventListener)updateListener);
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent((GenericConfigEventListener)updateListener){
            final /* synthetic */ GenericConfigEventListener val$updateListener;
            {
                this.val$updateListener = genericConfigEventListener;
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                ProxyController.this.customProxyListEventSender.removeListener((EventListener)this.val$updateListener);
                ProxyController.this.saveProxySettings();
            }

            public String toString() {
                return "ProxyController: save config";
            }
        });
        this.getEventSender().addListener((EventListener)new DefaultEventListener<ProxyEvent<AbstractProxySelectorImpl>>(){
            final DelayedRunnable asyncSaving = new DelayedRunnable(5000L, 60000L){

                public void delayedrun() {
                    ProxyController.this.saveProxySettings();
                }

                public String getID() {
                    return "ProxyController";
                }
            };

            public void onEvent(ProxyEvent<AbstractProxySelectorImpl> event) {
                this.asyncSaving.resetAndStart();
            }
        });
        this.updateProxyFilterList();
    }

    public void updateProxyFilterList() {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                PluginFinder pluginFinder = new PluginFinder((LogInterface)ProxyController.this.logger);
                for (AbstractProxySelectorImpl proxySelector : ProxyController.this._getList()) {
                    if (proxySelector.getFilter() == null || proxySelector.getFilter().size() <= 0) continue;
                    ProxyController.this.updateProxyFilterList(proxySelector, pluginFinder);
                }
                return null;
            }
        });
    }

    private String assignHost(PluginFinder pluginFinder, Map<String, String> mapping, String host) {
        AccountInfo ai;
        List<MultiHostHost> assigned;
        if (mapping != null && mapping.containsKey(host)) {
            return mapping.get(host);
        }
        String assignedHost = pluginFinder.assignHost(host);
        if (assignedHost == null && (assigned = (ai = new AccountInfo()).setMultiHostSupportV2(null, Arrays.asList(new MultiHostHost(host)), pluginFinder)) != null && assigned.size() == 1) {
            assignedHost = assigned.get(0).getDomain();
        }
        if (assignedHost == null) {
            block0: for (LazyCrawlerPlugin crawler : CrawlerPluginController.getInstance().list()) {
                String[] sitesSupportedNames = crawler.getSitesSupported();
                if (sitesSupportedNames == null) continue;
                for (String siteSupportedName : sitesSupportedNames) {
                    if (!StringUtils.equalsIgnoreCase((String)host, (String)siteSupportedName)) continue;
                    assignedHost = crawler.getDisplayName();
                    continue block0;
                }
            }
        }
        if (mapping != null) {
            mapping.put(host, assignedHost);
        }
        return assignedHost;
    }

    private void updateProxyFilterList(AbstractProxySelectorImpl proxy, PluginFinder pluginFinder) {
        FilterList filter = proxy.getFilter();
        if (filter != null && pluginFinder != null) {
            String[] entries = filter.getEntries();
            HashMap<String, String> mapping = new HashMap<String, String>();
            ArrayList<String> updatedEntries = new ArrayList<String>();
            for (String entry : entries) {
                if (entry == null) continue;
                if (entry.length() == 0 || entry.startsWith("//") || entry.startsWith("#")) {
                    updatedEntries.add(entry);
                    continue;
                }
                if (entry.matches("(?i)^.*appwork.org$") || entry.matches("(?i)^.*jdownloader.org$")) {
                    updatedEntries.add(entry.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                int index = entry.lastIndexOf("@");
                if (index != -1) {
                    String host;
                    if (index + 1 >= entry.length() || !(host = entry.substring(index + 1)).matches("^[a-zA-Z0-9.\\-]+$") || !host.contains(".") || host.length() < 3) continue;
                    String username = entry.substring(0, index);
                    String assignedHost = this.assignHost(pluginFinder, mapping, host);
                    if (assignedHost != null && !StringUtils.equals((String)host, (String)assignedHost)) {
                        updatedEntries.add("#auto assigned correct plugin:" + host + "->" + assignedHost);
                        updatedEntries.add(username.concat("@").concat(assignedHost));
                        continue;
                    }
                    updatedEntries.add(entry);
                    continue;
                }
                if (!entry.matches("^[a-zA-Z0-9.\\-]+$") || !entry.contains(".") || entry.length() < 3) continue;
                String assignedHost = this.assignHost(pluginFinder, mapping, entry);
                if (assignedHost != null && !StringUtils.equals((String)entry, (String)assignedHost)) {
                    updatedEntries.add("#auto assigned correct plugin:" + entry + "->" + assignedHost);
                    updatedEntries.add(assignedHost);
                    continue;
                }
                updatedEntries.add(entry);
            }
            filter.setEntries(updatedEntries.toArray(new String[0]));
        }
    }

    public int indexOf(final AbstractProxySelectorImpl proxy) {
        return proxy != null ? (Integer)this.QUEUE.addWait((QueueAction)new QueueAction<Integer, RuntimeException>(){

            protected Integer run() throws RuntimeException {
                return ProxyController.this._getList().indexOf(proxy);
            }
        }) : -1;
    }

    public void addProxy(final AbstractProxySelectorImpl proxy) {
        if (proxy != null) {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    switch (proxy.getType()) {
                        case NONE: 
                        case DIRECT: 
                        case HTTP: 
                        case HTTPS: 
                        case SOCKS4: 
                        case SOCKS4A: 
                        case SOCKS5: 
                        case PAC: {
                            CopyOnWriteArrayList list;
                            if (proxy.getFilter() != null && proxy.getFilter().size() > 0) {
                                ProxyController.this.updateProxyFilterList(proxy, new PluginFinder((LogInterface)ProxyController.this.logger));
                            }
                            if (!(list = ProxyController.this._getList()).addIfAbsent(proxy)) break;
                            ProxyController.this.eventSender.fireEvent(new ProxyEvent(ProxyController.this, ProxyEvent.Types.ADDED, proxy));
                            break;
                        }
                        default: {
                            ProxyController.this.logger.info("Invalid Type " + (Object)((Object)proxy.getType()));
                        }
                    }
                    return null;
                }
            });
        }
    }

    public void setProxy(final AbstractProxySelectorImpl proxy) {
        if (proxy != null) {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    switch (proxy.getType()) {
                        case NONE: 
                        case DIRECT: 
                        case HTTP: 
                        case HTTPS: 
                        case SOCKS4: 
                        case SOCKS4A: 
                        case SOCKS5: 
                        case PAC: {
                            CopyOnWriteArrayList list;
                            if (proxy.getFilter() != null && proxy.getFilter().size() > 0) {
                                ProxyController.this.updateProxyFilterList(proxy, new PluginFinder((LogInterface)ProxyController.this.logger));
                            }
                            if (!(list = ProxyController.this._getList()).addIfAbsent(proxy)) break;
                            NoProxySelector none = ProxyController.this.getNone();
                            if (proxy.isEnabled() && none != null && none.isEnabled()) {
                                ProxyController.this.setEnabled(none, false);
                            }
                            ProxyController.this.eventSender.fireEvent(new ProxyEvent(ProxyController.this, ProxyEvent.Types.ADDED, proxy));
                            break;
                        }
                        default: {
                            ProxyController.this.logger.info("Invalid Type " + (Object)((Object)proxy.getType()));
                        }
                    }
                    return null;
                }
            });
        }
    }

    public void move(final List<AbstractProxySelectorImpl> transferData, final int dropRow) {
        if (transferData != null && transferData.size() > 0) {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    CopyOnWriteArrayList currentList = ProxyController.this._getList();
                    int dropRowIndex = dropRow;
                    if (dropRowIndex < 0) {
                        dropRowIndex = 0;
                    } else if (dropRowIndex > currentList.size()) {
                        dropRowIndex = currentList.size();
                    }
                    ArrayList newList = new ArrayList();
                    ArrayList before = new ArrayList(currentList.subList(0, dropRowIndex));
                    ArrayList after = new ArrayList(currentList.subList(dropRowIndex, currentList.size()));
                    before.removeAll(transferData);
                    after.removeAll(transferData);
                    newList.addAll(before);
                    newList.addAll(transferData);
                    newList.addAll(after);
                    ProxyController.this.list = new CopyOnWriteArrayList(newList);
                    ProxyController.this.eventSender.fireEvent(new ProxyEvent(ProxyController.this, ProxyEvent.Types.REFRESH, null));
                    return null;
                }
            });
        }
    }

    private void setList(final List<AbstractProxySelectorImpl> newList) {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                PluginFinder pluginFinder = new PluginFinder((LogInterface)ProxyController.this.logger);
                for (AbstractProxySelectorImpl proxySelector : newList) {
                    if (proxySelector.getFilter() == null || proxySelector.getFilter().size() <= 0) continue;
                    ProxyController.this.updateProxyFilterList(proxySelector, pluginFinder);
                }
                ProxyController.this.list = new CopyOnWriteArrayList(newList);
                ProxyController.this.eventSender.fireEvent(new ProxyEvent(ProxyController.this, ProxyEvent.Types.REFRESH, null));
                return null;
            }
        });
    }

    public List<AbstractProxySelectorImpl> getProxySelectors(DownloadLinkCandidate downloadLinkCandidate, boolean ignoreConnectBans, boolean ignoreAllBans) {
        LinkedHashSet<AbstractProxySelectorImpl> ret = new LinkedHashSet<AbstractProxySelectorImpl>();
        try {
            ArrayList<String> hosts = new ArrayList<String>();
            AccountCache.CachedAccount cachedAccount = downloadLinkCandidate.getCachedAccount();
            Account acc = cachedAccount.getAccount();
            PluginForHost pluginForHost = cachedAccount.getPlugin();
            String tldHost = pluginForHost.getHost(downloadLinkCandidate.getLink(), acc, false);
            hosts.add(tldHost);
            if (pluginForHost.isHandlingMultipleHosts()) {
                String fullHost;
                PluginFinder pluginFinder = new PluginFinder(pluginForHost.getLogger());
                String assignedHost = this.assignHost(pluginFinder, null, tldHost);
                if (assignedHost != null && !hosts.contains(assignedHost)) {
                    hosts.add(0, assignedHost);
                }
                if (!hosts.contains(fullHost = pluginForHost.getHost(downloadLinkCandidate.getLink(), acc, true))) {
                    hosts.add(0, fullHost);
                    assignedHost = this.assignHost(pluginFinder, null, fullHost);
                    if (assignedHost != null && !hosts.contains(assignedHost)) {
                        hosts.add(0, assignedHost);
                    }
                }
            }
            int maxResults = pluginForHost.isProxyRotationEnabled(cachedAccount.getAccount() != null) ? Integer.MAX_VALUE : 1;
            ArrayList<AbstractProxySelectorImpl> selectors = new ArrayList<AbstractProxySelectorImpl>(this._getList());
            block2: for (String host : hosts) {
                if (selectors.size() != 0 && maxResults != 0) {
                    Iterator it = selectors.iterator();
                    while (it.hasNext()) {
                        AbstractProxySelectorImpl selector = (AbstractProxySelectorImpl)it.next();
                        if (maxResults == 0) continue block2;
                        if (!selector.isEnabled()) {
                            it.remove();
                            continue;
                        }
                        if (!selector.isAllowedByFilter(host, acc) || maxResults-- <= 0) continue;
                        it.remove();
                        if (!ignoreAllBans && selector.isSelectorBannedFor(pluginForHost, ignoreConnectBans)) continue;
                        ret.add(selector);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        return new ArrayList<AbstractProxySelectorImpl>(ret);
    }

    private Account getAccountFromThread() {
        Thread thread = Thread.currentThread();
        if (thread instanceof AccountCheckerThread) {
            AccountChecker.AccountCheckJob job = ((AccountCheckerThread)((Object)thread)).getJob();
            if (job != null) {
                Account account = job.getAccount();
                return account;
            }
        } else if (thread instanceof LinkCheckerThread) {
            PluginForHost plg = ((LinkCheckerThread)((Object)thread)).getPlugin();
            if (plg != null) {
                return null;
            }
        } else {
            Object owner;
            if (thread instanceof SingleDownloadController) {
                return ((SingleDownloadController)((Object)thread)).getDownloadLinkCandidate().getCachedAccount().getAccount();
            }
            if (thread instanceof LinkCrawlerThread && (owner = ((LinkCrawlerThread)((Object)thread)).getCurrentOwner()) instanceof Plugin) {
                return null;
            }
        }
        return null;
    }

    private Plugin getPluginFromThread() {
        return Plugin.getCurrentActivePlugin();
    }

    public void setFilter(final AbstractProxySelectorImpl proxySelector, final FilterList filterList) {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                proxySelector.setFilter(filterList);
                if (proxySelector.getFilter() != null && proxySelector.getFilter().size() > 0) {
                    ProxyController.this.updateProxyFilterList(proxySelector, new PluginFinder((LogInterface)ProxyController.this.logger));
                }
                if (ProxyController.this._getList().contains(proxySelector)) {
                    ProxyController.this.eventSender.fireEvent(new ProxyEvent(ProxyController.this, ProxyEvent.Types.REFRESH, proxySelector));
                }
                return null;
            }
        });
    }

    public void exportTo(File saveTo) throws UnsupportedEncodingException, IOException {
        ProxyExportImport save = new ProxyExportImport();
        ArrayList<ProxyData> ret = new ArrayList<ProxyData>();
        for (AbstractProxySelectorImpl sel : this.getList()) {
            switch (sel.getType()) {
                case NONE: 
                case DIRECT: 
                case HTTP: 
                case HTTPS: 
                case SOCKS4: 
                case SOCKS4A: 
                case SOCKS5: {
                    ret.add(sel.toProxyData());
                    break;
                }
                case PAC: {
                    if (((PacProxySelectorImpl)sel).getPACUrl().startsWith("pac://")) {
                        ProxyData pd = sel.toProxyData();
                        pd.getProxy().setAddress("pac://" + Encoding.urlEncode((String)this.config.getLocalPacScript()));
                        ret.add(pd);
                        break;
                    }
                    ret.add(sel.toProxyData());
                    break;
                }
            }
        }
        save.setCustomProxyList(ret);
        IO.secureWrite((File)saveTo, (byte[])JSonStorage.serializeToJson((Object)save).getBytes("UTF-8"));
    }

    private CopyOnWriteArrayList<AbstractProxySelectorImpl> _getList() {
        return this.list;
    }

    public List<AbstractProxySelectorImpl> getList() {
        return Collections.unmodifiableList(new ArrayList<AbstractProxySelectorImpl>(this._getList()));
    }

    private NoProxySelector getNone() {
        NoProxySelector none = new NoProxySelector();
        for (AbstractProxySelectorImpl proxy : this._getList()) {
            if (!none.equals(proxy)) continue;
            return (NoProxySelector)proxy;
        }
        this.addProxy(none);
        return none;
    }

    public void importFrom(final File selected) throws IOException {
        final ProxyExportImport restore = (ProxyExportImport)JSonStorage.restoreFromString((String)IO.readFileToString((File)selected), (TypeRef)new TypeRef<ProxyExportImport>(){});
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                ProxyController.this.config.setLatestProfile(selected.getAbsolutePath());
                ProxyController.this.saveProxySettings(restore.getCustomProxyList());
                ProxyController.this.setList(ProxyController.this.loadProxySettings(false));
                return null;
            }
        });
    }

    public DefaultEventSender<ProxyEvent<AbstractProxySelectorImpl>> getEventSender() {
        return this.eventSender;
    }

    public String getLatestProfilePath() {
        return this.config.getLatestProfile();
    }

    public AbstractProxySelectorImpl convert(HTTPProxy proxy) {
        if (proxy != null) {
            switch (proxy.getType()) {
                case NONE: {
                    return new NoProxySelector(proxy);
                }
                case DIRECT: {
                    if (proxy.getLocal() == null) {
                        return new NoProxySelector(proxy);
                    }
                    return new SingleDirectGatewaySelector(proxy);
                }
                case HTTP: 
                case HTTPS: 
                case SOCKS4: 
                case SOCKS4A: 
                case SOCKS5: {
                    return new SingleBasicProxySelectorImpl(proxy);
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AbstractProxySelectorImpl> loadProxySettings(boolean allowInit) {
        LinkedHashSet<AbstractProxySelectorImpl> proxies = new LinkedHashSet<AbstractProxySelectorImpl>();
        PacProxySelectorImpl advancedCondigPac = null;
        this.logger.info("Load Proxy Settings");
        ArrayList cfgProxies = this.config.getCustomProxyList();
        this.logger.info("Customs: " + (cfgProxies == null ? 0 : cfgProxies.size()));
        boolean noPSFirst = false;
        if (cfgProxies != null) {
            block24: for (ProxyData proxyData : cfgProxies) {
                try {
                    AbstractProxySelectorImpl proxy = null;
                    if (proxyData.isPac()) {
                        proxy = new PacProxySelectorImpl(proxyData);
                        if (StringUtils.equalsIgnoreCase((String)proxyData.getProxy().getAddress(), (String)"pac://")) {
                            advancedCondigPac = proxy;
                        }
                    } else {
                        switch (proxyData.getProxy().getType()) {
                            case NONE: {
                                proxy = new NoProxySelector(proxyData);
                                break;
                            }
                            case DIRECT: {
                                proxy = new SingleDirectGatewaySelector(proxyData);
                                break;
                            }
                            case HTTP: 
                            case HTTPS: 
                            case SOCKS4: 
                            case SOCKS4A: 
                            case SOCKS5: {
                                proxy = new SingleBasicProxySelectorImpl(proxyData);
                                break;
                            }
                            default: {
                                continue block24;
                            }
                        }
                    }
                    if (proxy == null || !proxies.add(proxy)) continue;
                    proxies.add(proxy);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
        } else if (allowInit) {
            noPSFirst = true;
            this.logger.info("Init Proxy Controller fresh");
            if (((InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class)).isProxyVoleAutodetectionEnabled()) {
                File crashTest = Application.getTempResource((String)"proxyVoleRunningProxyController");
                if (crashTest.exists()) {
                    this.logger.log((Throwable)new WTFException("Proxy Vole Crashed"));
                } else {
                    try {
                        crashTest.createNewFile();
                        ArrayList<Object> strategies = new ArrayList<Object>();
                        try {
                            if (!Application.isHeadless()) {
                                strategies.add(new DesktopProxySearchStrategy());
                                strategies.add(new FirefoxProxySearchStrategy());
                            }
                            strategies.add(new EnvProxySearchStrategy());
                            strategies.add(new JavaProxySearchStrategy());
                        }
                        catch (Throwable e) {
                            this.logger.log(e);
                        }
                        for (ProxySearchStrategy proxySearchStrategy : strategies) {
                            this.logger.info("Selector: " + proxySearchStrategy);
                            try {
                                Field field;
                                ProxySelector selector = proxySearchStrategy.getProxySelector();
                                if (selector == null) continue;
                                if (selector instanceof ProxyBypassListSelector) {
                                    field = ProxyBypassListSelector.class.getDeclaredField("delegate");
                                    field.setAccessible(true);
                                    selector = (ProxySelector)field.get(selector);
                                }
                                if (selector instanceof PacProxySelector) {
                                    PacProxySelectorImpl pac;
                                    if (!((InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class)).isProxyVoleAutodetectionEnabled()) continue;
                                    field = PacProxySelector.class.getDeclaredField("pacScriptParser");
                                    field.setAccessible(true);
                                    PacScriptParser source = (PacScriptParser)field.get(selector);
                                    PacScriptSource pacSource = source.getScriptSource();
                                    if (pacSource == null || !(pacSource instanceof UrlPacScriptSource)) continue;
                                    field = UrlPacScriptSource.class.getDeclaredField("scriptUrl");
                                    field.setAccessible(true);
                                    Object pacURL = field.get(pacSource);
                                    if (!StringUtils.isNotEmpty((String)((String)pacURL)) || !proxies.add(pac = new PacProxySelectorImpl((String)pacURL, null, null))) continue;
                                    this.logger.info("Add pac: " + pacURL);
                                    continue;
                                }
                                List<Proxy> sproxies = selector.select(new URI("http://google.com"));
                                if (sproxies == null) continue;
                                block26: for (Proxy p : sproxies) {
                                    switch (p.type()) {
                                        case DIRECT: {
                                            if (p.address() == null) {
                                                if (!proxies.add(new NoProxySelector())) break;
                                                this.logger.info("Add None");
                                                break;
                                            }
                                            HTTPProxy httpProxy = new HTTPProxy(((InetSocketAddress)p.address()).getAddress());
                                            SingleDirectGatewaySelector direct = new SingleDirectGatewaySelector(httpProxy);
                                            if (!proxies.add(direct)) continue block26;
                                            this.logger.info("Add Direct: " + direct);
                                            break;
                                        }
                                        case HTTP: {
                                            if (p.address() == null) break;
                                            HTTPProxy httpProxy = new HTTPProxy(HTTPProxy.TYPE.HTTP, SocketConnection.getHostName((SocketAddress)p.address()), ((InetSocketAddress)p.address()).getPort());
                                            SingleBasicProxySelectorImpl basic = new SingleBasicProxySelectorImpl(httpProxy);
                                            if (!proxies.add(basic)) continue block26;
                                            this.logger.info("Add Basic: " + basic);
                                            break;
                                        }
                                        case SOCKS: {
                                            SingleBasicProxySelectorImpl socks;
                                            HTTPProxy httpProxy;
                                            if (p.address() == null || !proxies.add(socks = new SingleBasicProxySelectorImpl(httpProxy = new HTTPProxy(HTTPProxy.convertNativeProxyType((Proxy)p), SocketConnection.getHostName((SocketAddress)p.address()), ((InetSocketAddress)p.address()).getPort())))) break;
                                            this.logger.info("Add Socks: " + socks);
                                        }
                                    }
                                }
                            }
                            catch (UnsatisfiedLinkError e) {
                                if (e.getMessage() != null && e.getMessage().contains("Can't find dependent libraries")) {
                                    this.logger.info("The Library Path probably contains special chars: " + Application.getResource((String)"tmp/jna").getAbsolutePath());
                                    this.logger.log((Throwable)e);
                                    break;
                                }
                                this.logger.log((Throwable)e);
                            }
                            catch (Throwable e) {
                                this.logger.log(e);
                            }
                        }
                    }
                    catch (IOException e) {
                        this.logger.log((Throwable)e);
                    }
                    finally {
                        crashTest.delete();
                    }
                }
            }
            List sproxy = HTTPProxy.getFromSystemProperties();
            for (HTTPProxy proxyData : sproxy) {
                try {
                    SingleBasicProxySelectorImpl singleBasicProxySelectorImpl = new SingleBasicProxySelectorImpl(proxyData);
                    if (!proxies.add(singleBasicProxySelectorImpl)) continue;
                    this.logger.info("Add System Proxy: " + singleBasicProxySelectorImpl);
                }
                catch (Throwable throwable) {
                    this.logger.log(throwable);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)this.config.getLocalPacScript()) && advancedCondigPac == null) {
            advancedCondigPac = new PacProxySelectorImpl("pac://", null, null);
            proxies.add(advancedCondigPac);
        }
        ArrayList<AbstractProxySelectorImpl> ret = new ArrayList<AbstractProxySelectorImpl>(proxies);
        boolean enabled = false;
        for (AbstractProxySelectorImpl abstractProxySelectorImpl : ret) {
            if (!abstractProxySelectorImpl.isEnabled()) continue;
            enabled = true;
            break;
        }
        AbstractProxySelectorImpl noPS = new NoProxySelector();
        if (!enabled || !ret.contains(noPS)) {
            int n = ret.indexOf(noPS);
            if (n >= 0) {
                noPS = ret.get(n);
                noPSFirst = noPSFirst && n > 0;
            } else {
                ret.add(0, noPS);
                noPSFirst = false;
            }
            if (!enabled) {
                noPS.setEnabled(true);
            }
        }
        if (noPSFirst) {
            ret.remove(noPS);
            ret.add(0, noPS);
        }
        return ret;
    }

    public void remove(final AbstractProxySelectorImpl proxy) {
        if (proxy != null) {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    if (!AbstractProxySelectorImpl.Type.NONE.equals((Object)proxy.getType()) && ProxyController.this._getList().remove(proxy)) {
                        ProxyController.this.validateGateways();
                        ProxyController.this.eventSender.fireEvent(new ProxyEvent(ProxyController.this, ProxyEvent.Types.REMOVED, proxy));
                    }
                    return null;
                }
            });
        }
    }

    private void saveProxySettings() {
        List<AbstractProxySelectorImpl> list = this.getList();
        if (list.size() > 0) {
            ArrayList<ProxyData> ret = new ArrayList<ProxyData>();
            for (AbstractProxySelectorImpl proxy : list) {
                ProxyData pd = proxy.toProxyData();
                ret.add(pd);
            }
            this.saveProxySettings(ret);
        }
    }

    private void saveProxySettings(ArrayList<ProxyData> list) {
        if (list != null && list.size() > 0) {
            try {
                this.customProxyListEventSender.addEventSuppressor(this.eventSuppressor);
                this.config.setCustomProxyList(list);
                this.config._getStorageHandler().write();
            }
            finally {
                this.customProxyListEventSender.removeEventSuppressor(this.eventSuppressor);
            }
        }
    }

    public boolean updateProxy(AbstractProxySelectorImpl selector, Request request, int retryCounter) {
        try {
            SelectedProxy selectedProxy = ProxyController.getSelectedProxy(request.getProxy());
            if (selectedProxy != null && selector == selectedProxy.getSelector()) {
                List proxyAuths = request.getHttpConnection().getHeaderFields("Proxy-Authorization");
                return this.updateProxy(selectedProxy, request.getProxy(), proxyAuths, new URL(request.getUrl()), retryCounter);
            }
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        return false;
    }

    private LogInterface getLogger() {
        LogInterface ret;
        Plugin plugin = this.getPluginFromThread();
        LogInterface logInterface = ret = plugin != null ? plugin.getLogger() : null;
        if (ret == null && (ret = LogController.getRebirthLogger((LogInterface)this.logger)) == null) {
            ret = LogController.CL();
        }
        return ret;
    }

    private boolean askForProxyAuth(SelectedProxy selectedProxy, final int flags, final boolean typeEditable, URL url, String msg, String title) throws IOException {
        AbstractProxySelectorImpl selector = selectedProxy.selector;
        Plugin plugin = this.getPluginFromThread();
        if (!selector.isProxyBannedFor(selectedProxy, url, plugin, false)) {
            String passWord;
            String userName;
            HTTPProxy proxy = null;
            LogInterface logger = this.getLogger();
            boolean rememberCheckBox = false;
            try {
                ProxyDialog pd = new ProxyDialog(selectedProxy, msg){
                    {
                        super(x0, x1);
                        this.flagMask |= flags;
                        this.flagMask |= 4;
                    }

                    protected boolean isShowRemember() {
                        return true;
                    }

                    public void pack() {
                        if (!this.getDialog().isMinimumSizeSet()) {
                            this.getDialog().setMinimumSize(new Dimension(450, this.getRawPreferredSize().height));
                        }
                        super.pack();
                    }

                    public boolean isTypeEditable() {
                        return super.isTypeEditable() && typeEditable;
                    }

                    public boolean isHostEditable() {
                        return super.isHostEditable() && typeEditable;
                    }

                    public boolean isPortEditable() {
                        return super.isPortEditable() && typeEditable;
                    }
                };
                pd.setTimeout(300000);
                pd.setAuthRequired(true);
                pd.setTitle(title);
                proxy = (HTTPProxy)Dialog.getInstance().showDialog((AbstractDialog)pd);
                rememberCheckBox = pd.isRememberChecked();
            }
            catch (DialogNoAnswerException e) {
                logger.log((Throwable)e);
                proxy = null;
            }
            if (proxy != null) {
                userName = proxy.getUser();
                passWord = proxy.getPass();
                logger.info("askForProxyAuth:" + rememberCheckBox + "|" + proxy);
            } else {
                passWord = null;
                userName = null;
                logger.info("askForProxyAuth:" + rememberCheckBox + "|" + userName + "|" + passWord);
            }
            if (selector instanceof PacProxySelectorImpl) {
                PacProxySelectorImpl pacProxySelector = (PacProxySelectorImpl)selector;
                if (proxy != null) {
                    if (rememberCheckBox) {
                        pacProxySelector.setUser(userName);
                        pacProxySelector.setPassword(passWord);
                    }
                    pacProxySelector.setTempAuth(selectedProxy, userName, passWord);
                    return true;
                }
                pacProxySelector.setTempAuth(selectedProxy, userName, passWord);
            } else if (selector instanceof SingleBasicProxySelectorImpl) {
                SingleBasicProxySelectorImpl singleBasic = (SingleBasicProxySelectorImpl)selector;
                if (proxy != null) {
                    if (rememberCheckBox) {
                        singleBasic.setUser(userName);
                        singleBasic.setPassword(passWord);
                    }
                    singleBasic.setTempAuth(userName, passWord);
                    return true;
                }
                singleBasic.setTempAuth(null, null);
            }
            if (proxy == null) {
                if (plugin != null) {
                    selector.addSessionBan(new PluginRelatedConnectionBan(plugin, selector, selectedProxy));
                } else {
                    selector.addSessionBan(new AuthExceptionGenericBan(selector, selectedProxy, url));
                }
            }
        }
        return false;
    }

    private synchronized SelectedProxyLock requestLock(SelectedProxy selectedProxy) {
        SelectedProxyLock lockObject = this.LOCKS.get((Object)selectedProxy);
        if (lockObject == null) {
            lockObject = new SelectedProxyLock(selectedProxy);
            this.LOCKS.put(selectedProxy, lockObject);
        }
        lockObject.incrementAndGet();
        return lockObject;
    }

    private synchronized void unLock(SelectedProxyLock lockObject) {
        SelectedProxyLock selectedProxyLock = this.LOCKS.get((Object)lockObject.selectedProxy);
        if (selectedProxyLock != null && selectedProxyLock.decrementAndGet() == 0) {
            this.LOCKS.remove((Object)selectedProxyLock.selectedProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateProxy(SelectedProxy selectedProxy, HTTPProxy proxy, List<String> proxyAuths, URL url, int retryCounter) {
        try {
            SelectedProxyLock lockObject;
            SelectedProxyLock selectedProxyLock = lockObject = this.requestLock(selectedProxy);
            synchronized (selectedProxyLock) {
                try {
                    boolean ret;
                    if (proxy != null && !proxy.equalsWithSettings((HTTPProxy)selectedProxy)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (retryCounter >= 10) return false;
                    if (proxy != null && proxyAuths != null) {
                        for (String authMethod : proxyAuths) {
                            if (!"NTLM".equalsIgnoreCase(authMethod)) continue;
                            if (selectedProxy.isPreferNativeImplementation()) break;
                            selectedProxy.setPreferNativeImplementation(true);
                            boolean bl = true;
                            return bl;
                        }
                    }
                    if ((ret = this.askForProxyAuth(selectedProxy, 4, false, url, _JDT.T.ProxyController_updateProxy_proxy_auth_required_msg(url.getHost()), _JDT.T.ProxyController_updateProxy_proxy_auth_required_title())) && proxy != null && proxy.equalsWithSettings((HTTPProxy)selectedProxy)) {
                        ret = false;
                    }
                    boolean bl = ret;
                    return bl;
                }
                finally {
                    this.unLock(lockObject);
                }
            }
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        return false;
    }

    public HTTPProxy updateProxyAuthForUpdater(int retries, HTTPProxy proxy, List<String> proxyAuths, URL url) {
        try {
            SelectedProxy selectedProxy = ProxyController.getSelectedProxy(proxy);
            if (retries < 10 && selectedProxy != null) {
                while (this.updateProxy(selectedProxy, proxy, proxyAuths, url, retries)) {
                    if (!selectedProxy.equals(proxy)) {
                        return new ProxyClone((HTTPProxy)selectedProxy);
                    }
                    if (retries++ <= 10) continue;
                    return null;
                }
            }
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        return null;
    }

    public List<HTTPProxy> getProxiesForUpdater(URL url) {
        return this.getProxiesWithNoneFallBack(url, true);
    }

    public List<HTTPProxy> getProxiesWithNoneFallBack(URL url, boolean includeNoneFallback) {
        SelectedProxy noneFallBack;
        List<HTTPProxy> ret = this.getProxiesByURL(url);
        if ((ret == null || ret.size() == 0) && includeNoneFallback && (noneFallBack = this.getNone().getProxy()) != null) {
            if (ret == null) {
                ret = new ArrayList<HTTPProxy>();
            }
            ret.add(noneFallBack);
        }
        return ret;
    }

    public List<HTTPProxy> getProxiesByURL(URL url) {
        List<HTTPProxy> ret = this.getProxiesByURL(url, false, false);
        if (ret == null || ret.size() == 0) {
            ret = this.getProxiesByURL(url, true, false);
        }
        if (ret == null || ret.size() == 0) {
            ret = this.getProxiesByURL(url, true, true);
        }
        return ret;
    }

    public List<HTTPProxy> getProxiesByURL(URL url, boolean ignoreConnectionBans, boolean ignoreAllBans) {
        LinkedHashSet<HTTPProxy> ret = new LinkedHashSet<HTTPProxy>();
        try {
            String tldHost;
            boolean proxyRotationEnabled;
            Account acc;
            Plugin plugin = this.getPluginFromThread();
            if (plugin != null) {
                acc = this.getAccountFromThread();
                Thread thread = Thread.currentThread();
                proxyRotationEnabled = thread instanceof AccountCheckerThread ? plugin.isProxyRotationEnabled(true) : (thread instanceof LinkCheckerThread ? ((PluginForHost)plugin).isProxyRotationEnabledForLinkChecker() : (thread instanceof SingleDownloadController && ((SingleDownloadController)((Object)thread)).getDownloadLinkCandidate().getCachedAccount().getAccount() != null ? plugin.isProxyRotationEnabled(true) : (thread instanceof LinkCrawlerThread ? plugin.isProxyRotationEnabledForLinkCrawler() : plugin.isProxyRotationEnabled(false))));
            } else {
                acc = null;
                proxyRotationEnabled = true;
            }
            ArrayList<String> hosts = new ArrayList<String>();
            if (plugin == null) {
                tldHost = Browser.getHost((URL)url, (boolean)false);
                hosts.add(tldHost);
                String fullHost = Browser.getHost((URL)url, (boolean)true);
                if (!hosts.contains(fullHost)) {
                    hosts.add(0, fullHost);
                }
            } else if (plugin.isHandlingMultipleHosts()) {
                String fullHost;
                tldHost = Browser.getHost((URL)url, (boolean)false);
                hosts.add(tldHost);
                PluginFinder pluginFinder = new PluginFinder(plugin.getLogger());
                String assignedHost = this.assignHost(pluginFinder, null, tldHost);
                if (assignedHost != null && !hosts.contains(assignedHost)) {
                    hosts.add(0, assignedHost);
                }
                if (!hosts.contains(fullHost = Browser.getHost((URL)url, (boolean)true))) {
                    hosts.add(0, fullHost);
                    assignedHost = this.assignHost(pluginFinder, null, fullHost);
                    if (assignedHost != null && !hosts.contains(assignedHost)) {
                        hosts.add(0, assignedHost);
                    }
                }
            } else {
                hosts.add(plugin.getHost());
            }
            ArrayList<AbstractProxySelectorImpl> selectors = new ArrayList<AbstractProxySelectorImpl>(this._getList());
            for (String host : hosts) {
                if (selectors.size() == 0) break;
                Iterator it = selectors.iterator();
                while (it.hasNext()) {
                    AbstractProxySelectorImpl selector = (AbstractProxySelectorImpl)it.next();
                    if (!selector.isEnabled()) {
                        it.remove();
                        continue;
                    }
                    if (!selector.isAllowedByFilter(host, acc)) continue;
                    it.remove();
                    List lst = selector.getProxiesByURL(url);
                    if (lst == null) continue;
                    for (HTTPProxy p : lst) {
                        if (ignoreAllBans || !selector.isProxyBannedFor(p, url, plugin, ignoreConnectionBans)) {
                            ret.add(p);
                            continue;
                        }
                        if (proxyRotationEnabled) continue;
                        return new ArrayList<HTTPProxy>(ret);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        return new ArrayList<HTTPProxy>(ret);
    }

    public boolean updateProxy(Request request, int retryCounter) {
        SelectedProxy selectedProxy = ProxyController.getSelectedProxy(request.getProxy());
        return selectedProxy != null && this.updateProxy(selectedProxy.getSelector(), request, retryCounter);
    }

    public static SelectedProxy getSelectedProxy(HTTPProxy proxy) {
        if (proxy != null) {
            if (proxy instanceof SelectedProxy) {
                return (SelectedProxy)proxy;
            }
            if (proxy instanceof ClonedProxy && ((ClonedProxy)proxy).getParent() instanceof SelectedProxy) {
                return (SelectedProxy)((ClonedProxy)proxy).getParent();
            }
            if (proxy instanceof ProxyClone && ((ProxyClone)proxy).getOrgReference() instanceof SelectedProxy) {
                return (SelectedProxy)((ProxyClone)proxy).getOrgReference();
            }
        }
        return null;
    }

    public void setEnabled(final AbstractProxySelectorImpl proxy, final boolean value) {
        if (proxy != null) {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    if (proxy.setEnabled(value) != value) {
                        if (!value) {
                            ProxyController.this.validateGateways();
                        }
                        ProxyController.this.eventSender.fireEvent(new ProxyEvent(ProxyController.this, ProxyEvent.Types.REFRESH, null));
                    }
                    return null;
                }
            });
        }
    }

    private void validateGateways() {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                for (AbstractProxySelectorImpl pi : ProxyController.this._getList()) {
                    if (!pi.isEnabled()) continue;
                    return null;
                }
                NoProxySelector none = ProxyController.this.getNone();
                ProxyController.this.setEnabled(none, true);
                return null;
            }
        });
    }

    public String toString() {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("class", this.getClass().getName());
            data.put("proxy", this.list.toString());
            return JSonStorage.toString(data);
        }
        catch (Throwable e) {
            return Exceptions.getStackTrace((Throwable)e);
        }
    }

    public boolean reportHTTPProxyException(HTTPProxy proxy, URL url, IOException e) {
        try {
            SelectedProxy selectedProxy;
            if (proxy != null && e != null && url != null && e instanceof HTTPProxyException && (selectedProxy = ProxyController.getSelectedProxy(proxy)) != null && selectedProxy.getSelector() != null) {
                AbstractProxySelectorImpl selector = selectedProxy.getSelector();
                if (e instanceof ProxyEndpointConnectException) {
                    Socks5SocketConnection.Socks5EndpointConnectException socks5EndpointConnectException = (Socks5SocketConnection.Socks5EndpointConnectException)Exceptions.getInstanceof((Throwable)e, Socks5SocketConnection.Socks5EndpointConnectException.class);
                    if (socks5EndpointConnectException != null) {
                        switch (socks5EndpointConnectException.getError()) {
                            case TTL_EXPIRED: {
                                return false;
                            }
                        }
                    }
                    selector.addSessionBan(new EndPointConnectExceptionBan(selector, selectedProxy, url));
                    return true;
                }
                if (e instanceof ProxyConnectException) {
                    selector.addSessionBan(new GenericConnectExceptionBan(selector, selectedProxy, url));
                    return true;
                }
                if (e instanceof ProxyAuthException) {
                    selector.addSessionBan(new AuthExceptionGenericBan(selector, selectedProxy, url));
                    return true;
                }
            }
        }
        catch (Throwable e1) {
            this.getLogger().log(e1);
        }
        return false;
    }

    public boolean reportConnectException(Request request, int retryCounter, IOException e) {
        try {
            SelectedProxy selectedProxy;
            if (e instanceof ProxyAuthException) {
                return false;
            }
            if (e instanceof ProxyConnectException && (selectedProxy = ProxyController.getSelectedProxy(request.getProxy())) != null && selectedProxy.getSelector() != null) {
                AbstractProxySelectorImpl selector = selectedProxy.getSelector();
                Plugin plg = this.getPluginFromThread();
                if (plg != null) {
                    selector.addSessionBan(new ConnectExceptionInPluginBan(plg, selector, selectedProxy));
                } else if (e instanceof ProxyEndpointConnectException) {
                    Socks5SocketConnection.Socks5EndpointConnectException socks5EndpointConnectException = (Socks5SocketConnection.Socks5EndpointConnectException)Exceptions.getInstanceof((Throwable)e, Socks5SocketConnection.Socks5EndpointConnectException.class);
                    if (socks5EndpointConnectException != null) {
                        switch (socks5EndpointConnectException.getError()) {
                            case TTL_EXPIRED: {
                                return false;
                            }
                        }
                    }
                    selector.addSessionBan(new EndPointConnectExceptionBan(selector, selectedProxy, request.getURL()));
                } else {
                    selector.addSessionBan(new GenericConnectExceptionBan(selector, selectedProxy, request.getURL()));
                }
            }
        }
        catch (Throwable e1) {
            this.getLogger().log(e1);
        }
        return false;
    }

    private class SelectedProxyLock {
        private final SelectedProxy selectedProxy;
        private volatile int counter = 0;

        private SelectedProxyLock(SelectedProxy selectedProxy) {
            this.selectedProxy = selectedProxy;
        }

        private int incrementAndGet() {
            ++this.counter;
            return this.counter;
        }

        private int decrementAndGet() {
            --this.counter;
            return this.counter;
        }
    }
}

