/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.reconnect.ipcheck.IP;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.DynByteBuffer;
import jd.nutils.Executer;
import jd.nutils.ProcessListener;
import jd.utils.JDUtilities;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.InternetConnectionSettings;

public class RouterUtils {
    private static final String PATTERN_WIN_ARP = "..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?";
    private static final LogSource LOGGER = LogController.getInstance().getLogger("RouterUtils");
    private static volatile InetAddress ADDRESS_CACHE;

    private static String callArpTool(String ipAddress) throws IOException, InterruptedException {
        if (CrossSystem.isWindows()) {
            return RouterUtils.callArpToolWindows(ipAddress);
        }
        return RouterUtils.callArpToolDefault(ipAddress);
    }

    private static String callArpToolDefault(String ipAddress) throws IOException, InterruptedException {
        String out;
        block8: {
            ProcessBuilder pb;
            InetAddress hostAddress;
            block7: {
                out = null;
                hostAddress = RouterUtils.resolveHostname(ipAddress);
                pb = null;
                try {
                    pb = ProcessBuilderFactory.create((String[])new String[]{"ping", ipAddress});
                    pb.start();
                    out = JDUtilities.runCommand("arp", new String[]{"-n", ipAddress}, null, 10);
                    pb.directory();
                    if (!out.matches("(?is).*((" + hostAddress.getHostName() + "|" + hostAddress.getHostAddress() + ").*..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?|.*..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?.*(" + hostAddress.getHostName() + "|" + hostAddress.getHostAddress() + ")).*")) {
                        out = null;
                    }
                }
                catch (Exception e) {
                    if (pb == null) break block7;
                    pb.directory();
                }
            }
            if (out == null || out.trim().length() == 0) {
                try {
                    pb = ProcessBuilderFactory.create((String[])new String[]{"ping", ipAddress});
                    pb.start();
                    out = JDUtilities.runCommand("ip", new String[]{"neigh", "show"}, null, 10);
                    pb.directory();
                    if (out != null) {
                        out = !out.matches("(?is).*((" + hostAddress.getHostName() + "|" + hostAddress.getHostAddress() + ").*..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?|.*..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?.*(" + hostAddress.getHostName() + "|" + hostAddress.getHostAddress() + ")).*") ? null : new Regex(out, "(" + hostAddress.getHostName() + "|" + hostAddress.getHostAddress() + ")[^\r\n]*").getMatch(-1);
                    }
                }
                catch (Exception e) {
                    if (pb == null) break block8;
                    pb.directory();
                }
            }
        }
        return out;
    }

    private static String callArpToolWindows(String ipAddress) throws IOException, InterruptedException {
        ProcessBuilder pb = ProcessBuilderFactory.create((String[])new String[]{"ping", ipAddress});
        pb.start();
        String[] parts = JDUtilities.runCommand("arp", new String[]{"-a"}, null, 10).split(System.getProperty("line.separator"));
        pb.directory();
        for (String part : parts) {
            if (part.indexOf(ipAddress) <= -1 || !new Regex(part, PATTERN_WIN_ARP).matches()) continue;
            return part;
        }
        return null;
    }

    public static boolean checkPort(String host) {
        return RouterUtils.checkPort(host, 80) || RouterUtils.checkPort(host, 443);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkPort(String host, int port) {
        URLConnectionAdapter con = null;
        LogSource logger = LogController.CL(false);
        logger.setAllowTimeoutFlush(false);
        try {
            String redirect;
            logger.info("Check " + host + ":" + port);
            Browser br = new Browser();
            br.setIPVersion(HTTPConnectionUtils.IPVERSION.IPV4_IPV6);
            br.setLogger((LogInterface)logger);
            br.setDebug(true);
            br.setVerbose(true);
            br.setProxy(HTTPProxy.NONE);
            InternetConnectionSettings config = (InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class);
            br.setConnectTimeout(Math.max(1000, config.getRouterIPCheckConnectTimeout()));
            br.setReadTimeout(Math.max(1000, config.getRouterIPCheckReadTimeout2()));
            br.setFollowRedirects(false);
            for (int i = 0; i < 3; ++i) {
                try {
                    try {
                        if (con != null) {
                            con.disconnect();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (port == 443) {
                        con = br.openGetConnection("https://" + host);
                        break;
                    }
                    if (port != 80) {
                        con = br.openGetConnection("http://" + host + ":" + port);
                        break;
                    }
                    con = br.openGetConnection("http://" + host);
                    break;
                }
                catch (Browser.BrowserException e) {
                    if (Exceptions.getInstanceof((Throwable)e, UnknownHostException.class) != null) {
                        logger.clear();
                    }
                    logger.log((Throwable)e);
                    SocketTimeoutException timeout = (SocketTimeoutException)Exceptions.getInstanceof((Throwable)e, SocketTimeoutException.class);
                    if (timeout == null) throw e;
                    if (!StringUtils.equalsIgnoreCase((String)timeout.getMessage(), (String)"Read timed out")) throw e;
                    Thread.sleep(500L);
                    continue;
                }
            }
            if ((redirect = br.getRedirectLocation()) == null) {
                logger.clear();
                boolean e = true;
                return e;
            }
            String domain = Browser.getHost((String)redirect);
            logger.info("Redirect To: " + redirect + "|Domain:" + domain);
            if (redirect != null && !RouterUtils.resolveHostname(domain).equals(RouterUtils.resolveHostname(host))) {
                boolean bl = false;
                return bl;
            }
            logger.clear();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.log((Throwable)e);
            return false;
        }
        finally {
            logger.close();
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static synchronized InetAddress getAddress(boolean force) throws InterruptedException {
        if (!force && ADDRESS_CACHE != null) {
            return ADDRESS_CACHE;
        }
        InetAddress address = null;
        try {
            try {
                address = RouterUtils.getIPFormNetStat();
            }
            catch (Exception e) {
                LOGGER.log((Throwable)e);
            }
            if (address == null) {
                try {
                    address = RouterUtils.getIPFromRouteCommand();
                }
                catch (Exception e) {
                    LOGGER.log((Throwable)e);
                }
            }
            if (address == null) {
                address = RouterUtils.getIpFormHostTable();
            }
            InetAddress inetAddress = address;
            return inetAddress;
        }
        finally {
            ADDRESS_CACHE = address;
        }
    }

    private static InetAddress getIpFormHostTable() throws InterruptedException {
        List<String> hostNames = RouterUtils.getHostTable();
        final AtomicReference ret = new AtomicReference();
        final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(4, 4, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        threadPool.allowCoreThreadTimeOut(true);
        for (final String host : hostNames) {
            try {
                if (ret.get() != null) continue;
                threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (ret.get() == null) {
                                InetAddress ia = IP.resolveSiteLocalAddress(host);
                                if (ret.get() == null && IP.isValidRouterIP(ia.getHostAddress()) && ret.compareAndSet(null, ia)) {
                                    threadPool.shutdown();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Throwable throwable) {}
        }
        threadPool.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        return (InetAddress)ret.get();
    }

    public static InetAddress getIPFormNetStat() throws InterruptedException, UnsupportedEncodingException, IOException {
        String[] out;
        Pattern pat = Pattern.compile("^\\s*(?:0\\.0\\.0\\.0\\s*){1,2}((?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)).*");
        ProcessBuilder pb = ProcessBuilderFactory.create((String[])new String[]{"netstat", "-rn"});
        pb.redirectErrorStream(true);
        Process p = pb.start();
        String result = IO.readInputStreamToString((InputStream)p.getInputStream());
        for (String string : out = Regex.getLines((String)result)) {
            System.out.println("NetStat: " + string);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            String m = new Regex(string, pat).getMatch(0);
            if (m == null || "0.0.0.0".equals(m) || !IP.isValidRouterIP(m)) continue;
            return RouterUtils.resolveHostname(m);
        }
        return null;
    }

    public static InetAddress resolveHostname(String hostName) throws UnknownHostException {
        return HTTPConnectionUtils.resolvHostIP((String)hostName, (HTTPConnectionUtils.IPVERSION)HTTPConnectionUtils.IPVERSION.IPV4_IPV6)[0];
    }

    public static InetAddress[] resolveHostnames(String hostName) throws UnknownHostException {
        return HTTPConnectionUtils.resolvHostIP((String)hostName, (HTTPConnectionUtils.IPVERSION)HTTPConnectionUtils.IPVERSION.IPV4_IPV6);
    }

    public static InetAddress getIPFromRouteCommand() {
        block8: {
            if (!CrossSystem.isUnix() && !CrossSystem.isMac() || !new File("/sbin/route").exists()) break block8;
            if (CrossSystem.isMac()) {
                Executer exec = new Executer("/sbin/route");
                exec.addParameters(new String[]{"-n", "get", "default"});
                exec.setRunin("/");
                exec.setWaitTimeout(5);
                exec.start();
                exec.waitTimeout();
                String routingt = exec.getOutputStream() + " \r\n " + exec.getErrorStream();
                Pattern pattern = Pattern.compile("gateway: (\\S*)", 2);
                Matcher matcher = pattern.matcher(routingt);
                while (matcher.find()) {
                    String hostname = matcher.group(1).trim();
                    if (hostname.matches("[\\s]*\\*[\\s]*")) continue;
                    try {
                        InetAddress ia = RouterUtils.resolveHostname(hostname);
                        if (!IP.isValidRouterIP(ia.getHostAddress())) continue;
                        return ia;
                    }
                    catch (Exception e) {
                        LogController.CL().log((Throwable)e);
                    }
                }
            } else {
                Executer exec = new Executer("/sbin/route");
                exec.addParameters(new String[]{"-n"});
                exec.setRunin("/");
                exec.setWaitTimeout(5);
                exec.start();
                exec.waitTimeout();
                String routingt = exec.getOutputStream() + " \r\n " + exec.getErrorStream();
                routingt = routingt.replaceFirst(".*\n.*", "");
                Pattern pattern = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+.*?(\\d+\\.\\d+\\.\\d+\\.\\d+).*?G", 2);
                Matcher matcher = pattern.matcher(routingt);
                while (matcher.find()) {
                    String hostname = matcher.group(1).trim();
                    if (hostname.matches("[\\s]*\\*[\\s]*")) continue;
                    try {
                        InetAddress ia = RouterUtils.resolveHostname(hostname);
                        if (!IP.isValidRouterIP(ia.getHostAddress())) continue;
                        return ia;
                    }
                    catch (Exception e) {
                        LogController.CL().log((Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public static String getMacAddress(InetAddress hostAddress) throws IOException, InterruptedException {
        String resultLine = RouterUtils.callArpTool(hostAddress.getHostAddress());
        if (resultLine == null) {
            return null;
        }
        String rd = new Regex(resultLine, PATTERN_WIN_ARP).getMatch(-1).replaceAll("-", ":");
        if (rd == null) {
            return null;
        }
        rd = rd.replaceAll("\\s", "0");
        String[] d = rd.split("[:\\-]");
        StringBuilder ret = new StringBuilder(18);
        for (String string : d) {
            if (string.length() < 2) {
                ret.append('0');
            }
            ret.append(string);
            ret.append(':');
        }
        return ret.toString().substring(0, 17);
    }

    public static String getMacAddress(String ip) throws UnknownHostException, IOException, InterruptedException {
        String ret = RouterUtils.getMacAddress(RouterUtils.resolveHostname(ip));
        if (ret != null) {
            return ret.replace(":", "").replace("-", "").toUpperCase();
        }
        return ret;
    }

    public static InetAddress getWindowsGateway() {
        if (CrossSystem.isWindows()) {
            final InetAddress[] ret = new InetAddress[1];
            Executer exec = new Executer("tracert ");
            exec.addProcessListener(new ProcessListener(){
                private int counter = 0;

                public void onProcess(Executer exec, String latestLine, DynByteBuffer totalBuffer) {
                    Matcher matcher;
                    if (latestLine.contains("*")) {
                        exec.interrupt();
                    }
                    if ((matcher = Pattern.compile("\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b", 34).matcher(latestLine)).find() && this.counter++ > 0) {
                        try {
                            String firstRouteIP = matcher.group(0);
                            ret[0] = IP.resolveSiteLocalAddress(firstRouteIP);
                        }
                        catch (UnknownHostException e) {
                            exec.interrupt();
                        }
                    }
                }

                public void onBufferChanged(Executer exec, DynByteBuffer totalBuffer, int latestReadNum) {
                }
            }, Executer.LISTENER_STDSTREAM);
            exec.addParameters(new String[]{"-d", "-h", "10", "-4", "jdownloader.org"});
            exec.setRunin("/");
            exec.setWaitTimeout(15);
            exec.start();
            exec.waitTimeout();
            try {
                return ret[0];
            }
            catch (Throwable e) {
                return null;
            }
        }
        throw new IllegalStateException("OS not supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWindowsModemConnection() {
        if (!CrossSystem.isWindows()) throw new IllegalStateException("OS not supported");
        Executer exec = new Executer("tracert ");
        exec.addParameters(new String[]{"-d", "-h", "1", "-4", "-w", "500", "jdownloader.org"});
        exec.setRunin("/");
        exec.setWaitTimeout(5);
        exec.start();
        exec.waitTimeout();
        String routingt = exec.getOutputStream();
        String[] lines = Regex.getLines((String)routingt.trim());
        if (lines.length < 2) throw new IllegalStateException("Not available (Offline?) Exception");
        for (int i = 1; i < lines.length; ++i) {
            Matcher matcher = Pattern.compile("\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b", 34).matcher(lines[i]);
            if (!matcher.find()) continue;
            String firstRouteIP = matcher.group(0);
            return !IP.isLocalIP(firstRouteIP);
        }
        return true;
    }

    private static List<String> getHostTable() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("fritz.fonwlan.box");
        ret.add("speedport.ip");
        ret.add("fritz.box");
        ret.add("dsldevice.lan");
        ret.add("speedtouch.lan");
        ret.add("mygateway1.ar7");
        ret.add("fritz.fon.box");
        ret.add("home");
        ret.add("arcor.easybox");
        ret.add("fritz.slwlan.box");
        ret.add("eumex.ip");
        ret.add("easy.box");
        ret.add("my.router");
        ret.add("fritz.fon");
        ret.add("router");
        ret.add("mygateway.ar7");
        ret.add("login.router");
        ret.add("SX541");
        ret.add("SE515.home");
        ret.add("sinus.ip");
        ret.add("fritz.wlan.box");
        ret.add("my.siemens");
        ret.add("local.gateway");
        ret.add("congstar.box");
        ret.add("login.modem");
        ret.add("homegate.homenet.telecomitalia.it");
        ret.add("SE551");
        ret.add("home.gateway");
        ret.add("alice.box");
        ret.add("buffalo.setup");
        ret.add("vood.lan");
        ret.add("DD-WRT");
        ret.add("versatel.modem");
        ret.add("myrouter.home");
        ret.add("MyDslModem.local.lan");
        ret.add("alicebox");
        ret.add("HSIB.home");
        ret.add("AolynkDslRouter.local.lan");
        ret.add("SL2141I.home");
        ret.add("e.home");
        ret.add("dsldevice.domain.name");
        for (InetAddress ia : HTTPProxyUtils.getLocalIPs()) {
            try {
                String ip;
                if (ia instanceof Inet6Address) continue;
                if (ia instanceof Inet4Address && (ip = ia.getHostAddress()) != null && ip.lastIndexOf(".") != -1) {
                    String host = ip.substring(0, ip.lastIndexOf(".")) + ".";
                    for (int i = 1; i < 255; ++i) {
                        String lhost = host + i;
                        if (lhost.equals(ip) || ret.contains(lhost)) continue;
                        ret.add(lhost);
                    }
                }
                ret.remove(ia.getHostName());
                ret.remove(ia.getHostAddress());
            }
            catch (Exception exc) {
                LogController.CL().log((Throwable)exc);
            }
        }
        return ret;
    }
}

