/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.ipcheck;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.IPCheckProvider;
import jd.http.Browser;
import org.appwork.storage.config.JsonConfig;

public class CustomWebIpCheck
implements IPCheckProvider {
    private final Browser br = new Browser();
    private static final CustomWebIpCheck INSTANCE = new CustomWebIpCheck();

    public static CustomWebIpCheck getInstance() {
        return INSTANCE;
    }

    private CustomWebIpCheck() {
    }

    @Override
    public IP getExternalIP() throws IPCheckException {
        String site = ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getGlobalIPCheckUrl();
        String patt = ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getGlobalIPCheckPattern();
        try {
            new URL(site);
            this.br.setConnectTimeout(15000);
            this.br.setReadTimeout(15000);
            Matcher matcher = Pattern.compile(patt, 34).matcher(this.br.getPage(site));
            if (matcher.find() && matcher.groupCount() > 0) {
                return IP.getInstance(matcher.group(1));
            }
        }
        catch (Exception e) {
            throw new IPCheckException(e);
        }
        throw new IPCheckException("NO IP found");
    }

    @Override
    public int getIpCheckInterval() {
        return 5;
    }
}

