/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.ipcheck;

import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import org.jdownloader.translate._JDT;

public class IPConnectionState {
    private final IP ip;
    private final IPCheckException cause;

    public String toString() {
        if (this.isOffline()) {
            return _JDT.T.literally_offline();
        }
        return this.ip.toString();
    }

    public IPConnectionState(IP ip2) {
        if (ip2 == null) {
            throw new NullPointerException();
        }
        this.ip = ip2;
        this.cause = null;
    }

    public IPConnectionState(IPCheckException e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.cause = e;
        this.ip = null;
    }

    private boolean equalsCause(IPConnectionState currentIP) {
        if (this.cause == null && currentIP.cause != null) {
            return false;
        }
        if (currentIP.cause == null && this.cause != null) {
            return false;
        }
        if (this.cause == currentIP.cause) {
            return true;
        }
        return this.cause.getMessage().equals(currentIP.cause.getMessage());
    }

    public boolean equalsLog(IPConnectionState currentIP) {
        if (this.ip == null && currentIP.ip == null) {
            return this.equalsCause(currentIP);
        }
        if (currentIP.ip == null && this.ip != null) {
            return false;
        }
        if (this.ip == null && currentIP.ip != null) {
            return false;
        }
        return this.ip.equals(currentIP.ip);
    }

    public IPCheckException getCause() {
        return this.cause;
    }

    public IP getExternalIp() {
        return this.ip;
    }

    public boolean isOffline() {
        return this.ip == null;
    }

    public boolean isOnline() {
        return this.ip != null;
    }
}

