/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.batch;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import jd.config.SubConfiguration;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectInvoker;
import jd.controlling.reconnect.RouterPlugin;
import jd.controlling.reconnect.pluginsinc.batch.translate.T;
import jd.gui.swing.components.ComboBrowseFile;
import jd.utils.JDUtilities;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.utils.Regex;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.TextComponentChangeListener;
import org.jdownloader.images.AbstractIcon;

public class ExternBatchReconnectPlugin
extends RouterPlugin
implements ActionListener {
    private static final String BATCH_TEXT = "BATCH_COMMAND";
    private static final String TERMINAL_COMMAND = "TERMINAL";
    private static final String EXECUTE_IN = "EXECUTE_IN";
    private static final String WAIT_FOR_RETURN_SECONDS = "WAIT_FOR_RETURN_SECONDS";
    public static final String ID = "ExternBatchReconnect";
    private JTextField txtCommand;
    private ComboBrowseFile browse;
    private JTextPane txtBatch;
    private Icon icon = new AbstractIcon("batch", 16);
    private ReconnectInvoker invoker = new ReconnectInvoker(this){

        @Override
        public void run() throws ReconnectException {
            int waitForReturn = ExternBatchReconnectPlugin.this.getWaitForReturn();
            String executeIn = ExternBatchReconnectPlugin.this.getExecuteIn();
            String command = ExternBatchReconnectPlugin.this.getTerminalCommand();
            if (command != null) {
                String[] cmds = command.split("\\ ");
                int cmdsLength1 = cmds.length - 1;
                command = cmds[0];
                for (int i = 0; i < cmdsLength1; ++i) {
                    cmds[i] = cmds[i + 1];
                }
                String batch = ExternBatchReconnectPlugin.this.getBatchText();
                String[] lines = Regex.getLines((String)batch);
                this.logger.info("Using Batch-Mode: using " + command + " as interpreter! (default: windows(cmd.exe) linux&mac(/bin/bash) )");
                String[] stringArray = lines;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String element;
                    cmds[cmdsLength1] = element = stringArray[i];
                    this.logger.finer("Execute Batchline: " + JDUtilities.runCommand(command, cmds, executeIn, lines.length >= 2 ? waitForReturn : -1));
                }
            }
        }

        @Override
        protected void testRun() throws ReconnectException, InterruptedException {
            this.run();
        }
    };

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setExecuteIn(this.browse.getText());
    }

    private String getBatchText() {
        return (String)this.getStorage().get(BATCH_TEXT, (Object)SubConfiguration.getConfig("BATCHRECONNECT").getStringProperty("BATCH_TEXT", ""));
    }

    private Storage getStorage() {
        return JSonStorage.getPlainStorage((String)this.getID());
    }

    private String getExecuteIn() {
        return (String)this.getStorage().get(EXECUTE_IN, (Object)SubConfiguration.getConfig("BATCHRECONNECT").getStringProperty("RECONNECT_EXECUTE_FOLDER", ""));
    }

    @Override
    public JComponent getGUI() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 2", "[][grow,fill]", "[][][grow,fill][]"));
        p.setOpaque(false);
        this.txtCommand = new JTextField();
        this.txtBatch = new JTextPane();
        this.browse = new ComboBrowseFile(this.getID());
        this.browse.setEditable(true);
        this.browse.addActionListener((ActionListener)this);
        this.browse.setFileSelectionMode(1);
        this.browse.setDialogType(Integer.valueOf(1));
        p.add((Component)new JLabel(T.T.interaction_batchreconnect_terminal()), "sg left");
        p.add(this.txtCommand);
        p.add((Component)new JLabel(T.T.interaction_batchreconnect_batch()), "newline,spanx,sg left");
        p.add((Component)new JScrollPane(this.txtBatch), "spanx,newline,pushx,growx");
        p.add((Component)new JLabel(T.T.interaction_batchreconnect_executein()), "sg left");
        p.add((Component)this.browse);
        new TextComponentChangeListener(this.txtCommand){

            protected void onChanged(DocumentEvent e) {
                ExternBatchReconnectPlugin.this.setCommand(ExternBatchReconnectPlugin.this.txtCommand.getText());
            }
        };
        new TextComponentChangeListener(this.txtBatch){

            protected void onChanged(DocumentEvent e) {
                ExternBatchReconnectPlugin.this.setBatchText(ExternBatchReconnectPlugin.this.txtBatch.getText());
            }
        };
        this.updateGUI();
        return p;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return T.T.jd_controlling_reconnect_plugins_batch_ExternBatchReconnectPlugin_getName();
    }

    private String getTerminalCommand() {
        if (CrossSystem.isWindows()) {
            return (String)this.getStorage().get(TERMINAL_COMMAND, (Object)SubConfiguration.getConfig("BATCHRECONNECT").getStringProperty(TERMINAL_COMMAND, "cmd /c"));
        }
        return (String)this.getStorage().get(TERMINAL_COMMAND, (Object)SubConfiguration.getConfig("BATCHRECONNECT").getStringProperty(TERMINAL_COMMAND, "/bin/bash"));
    }

    private int getWaitForReturn() {
        return (Integer)this.getStorage().get(WAIT_FOR_RETURN_SECONDS, (Object)0);
    }

    private void setBatchText(String text) {
        this.getStorage().put(BATCH_TEXT, text);
        this.updateGUI();
    }

    private void setCommand(String text) {
        this.getStorage().put(TERMINAL_COMMAND, text);
        this.updateGUI();
    }

    private void setExecuteIn(String text) {
        this.getStorage().put(EXECUTE_IN, text);
        this.updateGUI();
    }

    private void updateGUI() {
        new EDTRunner(){

            protected void runInEDT() {
                try {
                    ExternBatchReconnectPlugin.this.txtCommand.setText(ExternBatchReconnectPlugin.this.getTerminalCommand());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    ExternBatchReconnectPlugin.this.txtBatch.setText(ExternBatchReconnectPlugin.this.getBatchText());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    ExternBatchReconnectPlugin.this.browse.setText(ExternBatchReconnectPlugin.this.getExecuteIn());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public Icon getIcon16() {
        return this.icon;
    }

    @Override
    public ReconnectInvoker getReconnectInvoker() {
        return this.invoker;
    }
}

