/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import jd.controlling.faviconcontroller.FavIcons;
import jd.controlling.reconnect.ProcessCallBack;
import jd.controlling.reconnect.ProcessCallBackAdapter;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectInvoker;
import jd.controlling.reconnect.ReconnectPluginController;
import jd.controlling.reconnect.ReconnectResult;
import jd.controlling.reconnect.RouterUtils;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPController;
import jd.controlling.reconnect.pluginsinc.liveheader.DataCompareDialog;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderInvoker;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnect;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnectSettings;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderScriptConfirmDialog;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderScriptConfirmUploadDialog;
import jd.controlling.reconnect.pluginsinc.liveheader.recoll.AddRouterResponse;
import jd.controlling.reconnect.pluginsinc.liveheader.recoll.RecollController;
import jd.controlling.reconnect.pluginsinc.liveheader.remotecall.RouterData;
import jd.controlling.reconnect.pluginsinc.liveheader.translate.T;
import jd.controlling.reconnect.pluginsinc.liveheader.validate.RetryWithReplacedScript;
import jd.controlling.reconnect.pluginsinc.liveheader.validate.ScriptValidationExeption;
import jd.controlling.reconnect.pluginsinc.liveheader.validate.Scriptvalidator;
import jd.controlling.reconnect.pluginsinc.upnp.UPNPRouterPlugin;
import jd.controlling.reconnect.pluginsinc.upnp.cling.UpnpRouterDevice;
import jd.gui.swing.jdgui.views.settings.panels.reconnect.ReconnectDialog;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.OKCancelCloseUserIODefinition;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.translate._JDT;

public class LiveHeaderDetectionWizard {
    private String mac;
    private String manufactor;
    private InetAddress gatewayAdress;
    private String username;
    private String password;
    private String firmware;
    private String sslResponse;
    private String sslTitle;
    private int sslPTagsCount;
    private int sslFrameTagCount;
    private String sslFavIconHash;
    private String sslException;
    private int sslResponseCode;
    private HashMap<String, String> sslResponseHeaders;
    private String response;
    private String title;
    private int pTagsCount;
    private int frameTagCount;
    private String favIconHash;
    private String exception;
    private int responseCode;
    private HashMap<String, String> responseHeaders;
    private String sslTagFootprint;
    private String tagFootprint;
    private LogSource logger = LogController.getInstance().getLogger(LiveHeaderDetectionWizard.class.getName());
    private static final HashSet<String> ALLOWED_HEADER_KEYS = new HashSet();
    private UpnpRouterDevice myUpnpDevice = null;
    private String routerName;
    private String gatewayAdressHost;
    private String gatewayAdressIP;

    private LiveHeaderReconnect getPlugin() {
        return (LiveHeaderReconnect)ReconnectPluginController.getInstance().getPluginByID("httpliveheader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReconnectResult> runTests(List<RouterData> tests, ProcessCallBack processCallBack) throws InterruptedException, DialogClosedException, DialogCanceledException {
        boolean pre = ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).isIPCheckGloballyDisabled();
        try {
            List<RouterData> bestMatches;
            List<ReconnectResult> ret;
            if (pre) {
                UIOManager.I().showConfirmDialog(0, _GUI.T.literally_warning(), T.T.ipcheck());
                ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).setIPCheckGloballyDisabled(false);
            }
            if ((ret = this.testList(bestMatches = this.filterBestMatches(tests), processCallBack)) != null && ret.size() > 0 && ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).isAutoSearchBestMatchFilterEnabled()) {
                List<ReconnectResult> list = ret;
                return list;
            }
            List<ReconnectResult> list = ret = this.testList(tests, processCallBack);
            return list;
        }
        finally {
            ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).setIPCheckGloballyDisabled(pre);
            if (pre) {
                UIOManager.I().showMessageDialog(T.T.ipcheckreverted());
            }
        }
    }

    private List<RouterData> filterBestMatches(List<RouterData> tests) {
        int total = 0;
        Iterator<RouterData> it = tests.iterator();
        while (it.hasNext()) {
            total += it.next().getPriorityIndicator();
        }
        float avg = (float)total / (float)tests.size();
        ArrayList<RouterData> ret = new ArrayList<RouterData>();
        Iterator<RouterData> it2 = tests.iterator();
        while (it2.hasNext()) {
            RouterData next = it2.next();
            if (!this.isTopMatch(next, avg)) continue;
            ret.add(next);
            it2.remove();
        }
        return ret;
    }

    private String getRegex(String routerName) {
        if (routerName == null || routerName.trim().length() == 0) {
            return null;
        }
        String ret = routerName.replaceAll("[^a-zA-Z0-9]+", ".*");
        StringBuilder r = new StringBuilder();
        r.append(ret.charAt(0));
        for (int i = 1; i < ret.length(); ++i) {
            char c = ret.charAt(i - 1);
            char c1 = ret.charAt(i);
            if (Character.isDigit(c) && !Character.isDigit(c1) || !Character.isDigit(c) && Character.isDigit(c1)) {
                r.append(".*");
            }
            r.append(c1);
        }
        return r.toString();
    }

    private boolean isTopMatch(RouterData rd, float avg) {
        if ((float)rd.getPriorityIndicator() > avg * 2.0f) {
            return true;
        }
        if (!this.matches(this.firmware, rd.getFirmware())) {
            return false;
        }
        if (!this.matches(this.routerName, rd.getRouterName())) {
            return false;
        }
        return this.matches(this.manufactor, rd.getManufactor());
    }

    private boolean matches(String userInput, String database) {
        String regex = this.getRegex(userInput);
        if (regex != null) {
            if (database == null) {
                return false;
            }
            String m = new Regex(userInput, regex).getMatch(-1);
            return database.equals(m);
        }
        return true;
    }

    public List<ReconnectResult> testList(List<RouterData> tests, ProcessCallBack processCallBack) throws InterruptedException, DialogClosedException, DialogCanceledException {
        if (this.username.trim().length() < 2 || this.password.trim().length() < 2) {
            for (int i = 0; i < tests.size(); ++i) {
                String sc = tests.get(i).getScript().toLowerCase(Locale.ENGLISH);
                if (!sc.contains("%%%username%%%") && !sc.contains("%%%user%%%") && !sc.contains("%%%pass%%%") && !sc.contains("%%%password%%%")) continue;
                DataCompareDialog dcd = new DataCompareDialog(this.gatewayAdressHost, this.firmware, this.manufactor, this.routerName, ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getUserName(), ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getPassword());
                dcd.setLoginsOnly(true);
                DataCompareDialog impl = (DataCompareDialog)UIOManager.I().show(null, (UserIODefinition)dcd);
                this.username = impl.getUsername();
                this.password = impl.getPassword();
                break;
            }
        }
        ArrayList<ReconnectResult> ret = new ArrayList<ReconnectResult>();
        for (int i = 0; i < tests.size(); ++i) {
            RouterData test = tests.get(i);
            processCallBack.setStatusString(this.getPlugin(), T.T.jd_controlling_reconnect_plugins_liveheader_LiveHeaderDetectionWizard_runTests(i + 1, tests.size(), test.getManufactor() + " - " + test.getRouterName()));
            String sc = tests.get(i).getScript().toLowerCase(Locale.ENGLISH);
            if (this.username.trim().length() < 2 && (sc.contains("%%%username%%%") || sc.contains("%%%user%%%")) || this.password.trim().length() < 2 && (sc.contains("%%%pass%%%") || sc.contains("%%%password%%%"))) {
                processCallBack.setProgress(this.getPlugin(), Math.min(99, (i + 1) * 100 / tests.size()));
                Thread.sleep(1000L);
                continue;
            }
            try {
                LiveHeaderInvoker inv;
                ReconnectResult res;
                if (processCallBack.isMethodConfirmEnabled()) {
                    LiveHeaderScriptConfirmDialog d = new LiveHeaderScriptConfirmDialog(test, this.gatewayAdressHost, test.getRouterName()){

                        protected String getDontShowAgainLabelText() {
                            return _GUI.T.UPNPRouterPlugin_accept_all();
                        }

                        public String getDontShowAgainKey() {
                            return null;
                        }
                    };
                    OKCancelCloseUserIODefinition answer = (OKCancelCloseUserIODefinition)UIOManager.I().show(OKCancelCloseUserIODefinition.class, (UserIODefinition)d);
                    if (answer.getCloseReason() == CloseReason.OK) {
                        if (answer.isDontShowAgainSelected()) {
                            processCallBack.setMethodConfirmEnabled(false);
                        }
                    } else {
                        if (answer.getCloseReason() != CloseReason.CLOSE && (answer.getCloseReason() != CloseReason.CANCEL || !answer.isDontShowAgainSelected())) continue;
                        break;
                    }
                }
                if ((res = (inv = new LiveHeaderInvoker(this.getPlugin(), test.getScript(), this.username, this.password, this.gatewayAdressHost, this.routerName != null && this.routerName.trim().length() > 0 ? this.routerName : test.getRouterName())).validate(test)) != null && res.isSuccess()) {
                    ret.add(res);
                    processCallBack.setStatus(this, ret);
                    if (i < tests.size() - 1) {
                        if (ret.size() == 1 && !UIOManager.I().showConfirmDialog(0, _GUI.T.LiveHeaderDetectionWizard_testList_firstSuccess_title(), _GUI.T.LiveHeaderDetectionWizard_testList_firstsuccess_msg(TimeFormatter.formatMilliSeconds((long)res.getSuccessDuration(), (int)0)), (Icon)new AbstractIcon("ok", 32), _GUI.T.LiveHeaderDetectionWizard_testList_ok(), _GUI.T.LiveHeaderDetectionWizard_testList_use())) break;
                        return ret;
                    }
                }
            }
            catch (ReconnectException e) {
                LoggerFactory.getDefaultLogger().log((Throwable)e);
            }
            processCallBack.setProgress(this.getPlugin(), Math.min(99, (i + 1) * 100 / tests.size()));
        }
        return ret;
    }

    public List<ReconnectResult> runOnlineScan(ProcessCallBack processCallBack) throws InterruptedException, UnknownHostException {
        try {
            processCallBack.setStatusString(this, _GUI.T.LiveaheaderDetection_wait_for_online());
            IPController.getInstance().waitUntilWeAreOnline();
            processCallBack.setStatusString(this.getPlugin(), T.T.LiveHeaderDetectionWizard_runOnlineScan_collect());
            if (!RecollController.getInstance().isAlive()) {
                UIOManager.I().showConfirmDialog(16, T.T.LiveHeaderDetectionWizard_runOnlineScan_notavailable_t(), T.T.LiveHeaderDetectionWizard_runOnlineScan_notavailable_mm(), (Icon)new AbstractIcon("error", 32), null, _JDT.T.lit_hide());
                throw new InterruptedException("RecollServ not available");
            }
            this.collectInfo();
            this.specialCollectInfo();
            do {
                this.userConfirm();
            } while (!IP.isValidRouterIP(this.gatewayAdressIP) && !UIOManager.I().showConfirmDialog(0, _GUI.T.literally_warning(), T.T.LiveHeaderDetectionWizard_runOnlineScan_warning_badip(this.gatewayAdressHost), (Icon)new AbstractIcon("warning", 32), _GUI.T.literally_yes(), _GUI.T.literally_edit()));
            this.scanRemoteInfo();
            this.specials();
            List<RouterData> list = this.downloadRouterDatasByAutoDetectValues();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("amount", list.size() + "");
            return this.runTests(list, processCallBack);
        }
        catch (DialogNoAnswerException e) {
            throw new InterruptedException();
        }
        catch (InterruptedException e) {
            throw e;
        }
    }

    private void specialCollectInfo() throws InterruptedException {
        if ("speedport.ip".equalsIgnoreCase(this.gatewayAdressHost)) {
            String status;
            try {
                String name;
                status = this.getBrowser().getPage("http://speedport.ip/top_status.stm");
                String fw = new Regex(status, "runtime_code_version=\"(.*?)\"").getMatch(0);
                if (fw != null) {
                    this.firmware = fw;
                }
                if ((name = new Regex(status, "var prodname=\"(.*?)\"").getMatch(0)) != null) {
                    this.routerName = name.replace("_", " ");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            try {
                String fw;
                status = this.getBrowser().getPage("https://speedport.ip/top_status.stm");
                String name = new Regex(status, "var prodname=\"(.*?)\"").getMatch(0);
                if (name != null) {
                    this.routerName = name.replace("_", " ");
                }
                if ((fw = new Regex(status, "runtime_code_version=\"(.*?)\"").getMatch(0)) != null) {
                    this.firmware = fw;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void specials() {
    }

    private String trim(String stringToTrim) {
        return stringToTrim == null ? null : stringToTrim.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanRemoteInfo() {
        Browser br = this.getBrowser();
        try {
            this.sslResponse = br.getPage("https://" + this.gatewayAdressHost);
            this.sslTagFootprint = this.createHtmlFootprint(this.sslResponse.toLowerCase(Locale.ENGLISH));
            this.sslTitle = br.getRegex("<title>(.*?)</title>").getMatch(0);
            this.sslPTagsCount = this.sslResponse.split("<p>").length;
            this.sslFrameTagCount = this.sslResponse.split("<frame").length;
            FileOutputStream fos = null;
            try {
                BufferedImage image = FavIcons.downloadFavIcon(this.gatewayAdressHost);
                File imageFile = Application.getTempResource((String)"routerfav.png");
                FileCreationManager.getInstance().delete(imageFile, null);
                imageFile.deleteOnExit();
                fos = new FileOutputStream(imageFile);
                ImageProvider.writeImage((RenderedImage)image, (String)"png", (OutputStream)fos);
                fos.flush();
                fos.close();
                this.sslFavIconHash = Hash.getMD5((File)imageFile);
            }
            catch (Exception image) {
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable image) {}
            }
        }
        catch (Throwable e) {
            this.sslException = e.getClass().getSimpleName() + ": " + e.getMessage();
        }
        URLConnectionAdapter con = br.getHttpConnection();
        if (con != null) {
            this.sslResponseCode = con.getResponseCode();
            this.sslResponseHeaders = new HashMap();
            for (Map.Entry next : con.getHeaderFields().entrySet()) {
                for (String value : (List)next.getValue()) {
                    this.sslResponseHeaders.put(((String)next.getKey()).toLowerCase(), value);
                }
            }
            this.filterHeaders(this.sslResponseHeaders);
        }
        try {
            this.response = br.getPage("http://" + this.gatewayAdressHost);
            this.tagFootprint = this.createHtmlFootprint(this.response.toLowerCase(Locale.ENGLISH));
            this.title = br.getRegex("<title>(.*?)</title>").getMatch(0);
            this.pTagsCount = this.response.split("<p>").length;
            this.frameTagCount = this.response.split("<frame").length;
            FileOutputStream fos = null;
            try {
                BufferedImage image = FavIcons.downloadFavIcon(this.gatewayAdressHost);
                File imageFile = Application.getTempResource((String)"routerfav.png");
                FileCreationManager.getInstance().delete(imageFile, null);
                imageFile.deleteOnExit();
                fos = new FileOutputStream(imageFile);
                ImageProvider.writeImage((RenderedImage)image, (String)"png", (OutputStream)fos);
                fos.flush();
                fos.close();
                this.favIconHash = Hash.getMD5((File)imageFile);
            }
            catch (Exception image) {
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable image) {}
            }
        }
        catch (IOException e) {
            this.exception = e.getClass().getSimpleName() + ": " + e.getMessage();
        }
        con = br.getHttpConnection();
        if (con != null) {
            this.responseCode = con.getResponseCode();
            this.responseHeaders = new HashMap();
            for (Map.Entry next : con.getHeaderFields().entrySet()) {
                for (String value : (List)next.getValue()) {
                    this.responseHeaders.put(((String)next.getKey()).toLowerCase(), value);
                }
            }
            this.filterHeaders(this.responseHeaders);
        }
    }

    private void filterHeaders(HashMap<String, String> headerMap) {
        Iterator<Map.Entry<String, String>> it = headerMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> next = it.next();
            if (ALLOWED_HEADER_KEYS.contains(next.getKey().toLowerCase())) continue;
            it.remove();
        }
    }

    private Browser getBrowser() {
        Browser br = new Browser();
        br.setProxy(HTTPProxy.NONE);
        return br;
    }

    private String createHtmlFootprint(String sslResponse2) {
        if (sslResponse2 == null) {
            return null;
        }
        String str = Regex.replace((String)sslResponse2, (String)"<\\!\\-\\-.*?\\-\\->", (String)"");
        str = Regex.replace((String)str, (String)">.*?<", (String)"><");
        str = Regex.replace((String)str, (String)"<(\\w+) .*?>", (String)"<$1>");
        return str;
    }

    private List<RouterData> downloadRouterDatasByAutoDetectValues() throws InterruptedException {
        RouterData rd = this.getRouterData();
        List<RouterData> scripts = RecollController.getInstance().findRouter(rd);
        return scripts;
    }

    public static ArrayList<RouterData> toUnique(List<RouterData> scripts) {
        HashMap<String, RouterData> helper = new HashMap<String, RouterData>();
        ArrayList<RouterData> unique = new ArrayList<RouterData>(scripts.size());
        for (RouterData e : scripts) {
            if (e.getScript() == null) continue;
            String script = LiveHeaderDetectionWizard.prepScript(e.getScript());
            System.out.println("____________________________________________________________");
            System.out.println(Hash.getMD5((String)script) + " : " + script + " " + script.toCharArray().length);
            if (!helper.containsKey(script)) {
                System.out.println("ADD");
                helper.put(script, e);
                unique.add(e);
                e.setPriorityIndicator(e.getSuccess() - e.getFailed() + e.getCommitDupe());
                continue;
            }
            System.out.println("DUPE");
            RouterData m = (RouterData)helper.get(script);
            m.setPriorityIndicator(m.getPriorityIndicator() + 1 + e.getSuccess() - e.getFailed() + e.getCommitDupe());
        }
        return unique;
    }

    private static String prepScript(String script) {
        script = script.toUpperCase(Locale.ENGLISH).replaceAll("\\s+", "");
        return script;
    }

    private RouterData getRouterData() {
        RouterData search = new RouterData();
        search.setSslTagFootprint(this.sslTagFootprint);
        search.setTagFootprint(this.tagFootprint);
        search.setException(this.exception);
        search.setFavIconHash(this.favIconHash);
        search.setFirmware(this.firmware);
        search.setFrameTagCount(this.frameTagCount);
        search.setMac(this.mac);
        search.setManufactor(this.manufactor);
        search.setpTagsCount(this.pTagsCount);
        search.setResponse(this.response);
        search.setResponseCode(this.responseCode);
        search.setResponseHeaders(this.responseHeaders);
        search.setRouterIP(this.gatewayAdressIP);
        search.setRouterHost(this.gatewayAdressHost);
        search.setRouterName(this.routerName);
        search.setSslException(this.sslException);
        search.setSslFavIconHash(this.sslFavIconHash);
        search.setSslFrameTagCount(this.sslFrameTagCount);
        search.setSslPTagsCount(this.sslPTagsCount);
        search.setSslResponse(this.sslResponse);
        search.setSslResponseCode(this.sslResponseCode);
        search.setSslResponseHeaders(this.sslResponseHeaders);
        search.setSslTitle(this.sslTitle);
        search.setTitle(this.title);
        return search;
    }

    private void userConfirm() throws DialogClosedException, DialogCanceledException {
        while (true) {
            System.out.println("UserConfirm");
            DataCompareDialog dcd = new DataCompareDialog(this.gatewayAdressHost, this.firmware, this.manufactor, this.routerName, ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getUserName(), ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getPassword());
            DataCompareDialog impl = (DataCompareDialog)UIOManager.I().show(null, (UserIODefinition)dcd);
            dcd.throwCloseExceptions();
            this.username = impl.getUsername();
            this.password = impl.getPassword();
            this.manufactor = impl.getManufactor();
            this.routerName = impl.getRouterName();
            this.firmware = impl.getFirmware();
            try {
                this.gatewayAdress = RouterUtils.resolveHostname(impl.getHostName());
                this.gatewayAdressIP = this.gatewayAdress.getHostAddress();
                this.gatewayAdressHost = this.gatewayAdress.getHostName();
            }
            catch (IOException e) {
                new ConfirmDialog(0, _GUI.T.literall_error(), T.T.LiveHeaderDetectionWizard_runOnlineScan_warning_badhost(dcd.getHostName()), (Icon)new AbstractIcon("error", 32), _GUI.T.literally_edit(), null).show().throwCloseExceptions();
                continue;
            }
            break;
        }
    }

    private void collectInfo() throws UnknownHostException, InterruptedException {
        InetAddress ia;
        String gatewayIP;
        UPNPRouterPlugin upnp = (UPNPRouterPlugin)ReconnectPluginController.getInstance().getPluginByID("SIMPLEUPNP");
        List<UpnpRouterDevice> devices = upnp.getCachedDevices();
        if (devices == null) {
            devices = upnp.getDevices();
        }
        if (!IP.isValidRouterIP(gatewayIP = ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getRouterIP()) && (ia = RouterUtils.getAddress(true)) != null && IP.isValidRouterIP(ia.getHostAddress())) {
            gatewayIP = ia.getHostName();
        }
        this.mac = null;
        this.manufactor = null;
        this.gatewayAdress = RouterUtils.resolveHostname(gatewayIP);
        this.gatewayAdressHost = this.gatewayAdress.getHostName();
        this.gatewayAdressIP = this.gatewayAdress.getHostAddress();
        try {
            this.mac = RouterUtils.getMacAddress(this.gatewayAdress).replace(":", "").toUpperCase(Locale.ENGLISH);
            this.manufactor = RecollController.getInstance().getManufactor(this.mac);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.myUpnpDevice = null;
        for (UpnpRouterDevice d : devices) {
            if (d._getHost() == null) continue;
            try {
                List<InetAddress> check = Arrays.asList(RouterUtils.resolveHostname(d._getHost()));
                if (!check.contains(this.gatewayAdress)) continue;
                this.myUpnpDevice = d;
                break;
            }
            catch (UnknownHostException unknownHostException) {
            }
        }
        if (this.myUpnpDevice != null && this.myUpnpDevice.getManufactor() != null) {
            this.manufactor = this.myUpnpDevice.getManufactor();
        }
        if (this.myUpnpDevice != null) {
            if (this.myUpnpDevice.getModelname() != null) {
                this.routerName = this.myUpnpDevice.getModelname();
            } else if (this.myUpnpDevice.getFriendlyname() != null) {
                this.routerName = this.myUpnpDevice.getFriendlyname();
            }
        }
    }

    public RouterData collectRouterDataInfo() throws InterruptedException, UnknownHostException {
        try {
            this.collectInfo();
            this.specialCollectInfo();
            this.scanRemoteInfo();
            this.specials();
            if ((this.routerName == null || this.routerName.trim().length() == 0 || "unknown".equalsIgnoreCase(this.routerName)) && !this.gatewayAdressHost.equals(this.gatewayAdressIP)) {
                this.routerName = this.gatewayAdressHost;
                int i = this.routerName.lastIndexOf(".");
                if (i > 0) {
                    this.routerName = this.routerName.substring(0, i);
                }
            }
            RouterData rd = this.getRouterData();
            return rd;
        }
        catch (InterruptedException e) {
            this.logger.log((Throwable)e);
            throw e;
        }
    }

    public void sendRouter(ProcessCallBackAdapter processCallBack) throws UnknownHostException, InterruptedException {
        try {
            LiveHeaderReconnectSettings settings = (LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class);
            String script = settings.getScript();
            processCallBack.setProgress(this, -1);
            processCallBack.setStatusString(this, _GUI.T.LiveaheaderDetection_wait_for_online());
            IPController.getInstance().waitUntilWeAreOnline();
            if (!RecollController.getInstance().isAlive()) {
                UIOManager.I().showErrorMessage(_GUI.T.LiveHeaderDetectionWizard_sendRouter_na());
                return;
            }
            processCallBack.setStatusString(this.getPlugin(), T.T.LiveHeaderDetectionWizard_runOnlineScan_collect());
            this.collectInfo();
            this.specialCollectInfo();
            while (true) {
                ConfirmDialog d;
                try {
                    while (true) {
                        DataCompareDialog dcd = new DataCompareDialog(this.gatewayAdressHost, this.firmware, this.manufactor, this.routerName, ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getUserName(), ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getPassword());
                        dcd.setLoginsText(T.T.LiveHeaderDetectionWizard_userConfirm_loginstext());
                        DataCompareDialog impl = (DataCompareDialog)UIOManager.I().show(null, (UserIODefinition)dcd);
                        dcd.throwCloseExceptions();
                        this.username = impl.getUsername();
                        this.password = impl.getPassword();
                        this.manufactor = impl.getManufactor();
                        this.routerName = impl.getRouterName();
                        this.firmware = impl.getFirmware();
                        try {
                            this.gatewayAdress = RouterUtils.resolveHostname(impl.getHostName());
                            this.gatewayAdressIP = this.gatewayAdress.getHostAddress();
                            this.gatewayAdressHost = this.gatewayAdress.getHostName();
                        }
                        catch (IOException e) {
                            if (UIOManager.I().showConfirmDialog(0, _GUI.T.literall_error(), T.T.LiveHeaderDetectionWizard_runOnlineScan_warning_badhost(dcd.getHostName()), (Icon)new AbstractIcon("error", 32), _GUI.T.literally_edit(), null)) continue;
                            return;
                        }
                        if (IP.isValidRouterIP(this.gatewayAdressIP) || UIOManager.I().showConfirmDialog(0, _GUI.T.literally_warning(), T.T.LiveHeaderDetectionWizard_runOnlineScan_warning_badip(this.gatewayAdressHost), (Icon)new AbstractIcon("warning", 32), _GUI.T.literally_yes(), _GUI.T.literally_edit())) break;
                    }
                    script = this.validateBeforeSend(script);
                    RouterData rd = this.getRouterData();
                    rd.setScript(script);
                    LiveHeaderScriptConfirmUploadDialog confirm = new LiveHeaderScriptConfirmUploadDialog(rd, rd.getRouterIP(), rd.getRouterName());
                    ((LiveHeaderScriptConfirmUploadDialog)UIOManager.I().show(null, (UserIODefinition)confirm)).throwCloseExceptions();
                    script = rd.getScript();
                    this.test(processCallBack, script);
                    if (StringUtils.isNotEmpty((String)this.password)) {
                        settings.setPassword(this.password);
                    }
                    if (StringUtils.isNotEmpty((String)this.username)) {
                        settings.setUserName(this.username);
                    }
                    settings.setScript(script);
                    settings.setRouterData(rd);
                }
                catch (ScriptValidationExeption e) {
                    this.logger.log((Throwable)e);
                    if (StringUtils.isNotEmpty((String)e.getMessage())) {
                        d = new ConfirmDialog(0, _AWU.T.DIALOG_ERROR_TITLE(), T.T.LiveHeaderDetectionWizard_share_reconnectFailed2(e.getMessage()), (Icon)new AbstractIcon("warning_red", 32), T.T.try_again(), null);
                        ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
                        continue;
                    }
                    d = new ConfirmDialog(0, _AWU.T.DIALOG_ERROR_TITLE(), T.T.LiveHeaderDetectionWizard_share_reconnectFailed(), (Icon)new AbstractIcon("warning_red", 32), T.T.try_again(), null);
                    ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
                    continue;
                }
                catch (ReconnectException e) {
                    this.logger.log((Throwable)e);
                    if (StringUtils.isNotEmpty((String)e.getMessage())) {
                        d = new ConfirmDialog(0, _AWU.T.DIALOG_ERROR_TITLE(), T.T.LiveHeaderDetectionWizard_share_reconnectFailed2(e.getMessage()), (Icon)new AbstractIcon("warning_red", 32), T.T.try_again(), null);
                        ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
                        continue;
                    }
                    d = new ConfirmDialog(0, _AWU.T.DIALOG_ERROR_TITLE(), T.T.LiveHeaderDetectionWizard_share_reconnectFailed(), (Icon)new AbstractIcon("warning_red", 32), T.T.try_again(), null);
                    ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
                    continue;
                }
                break;
            }
            this.scanRemoteInfo();
            this.specials();
            this.uploadData(script);
        }
        catch (DialogNoAnswerException e) {
            throw new InterruptedException();
        }
        catch (InterruptedException e) {
            this.logger.log((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            Dialog.I().showExceptionDialog(_GUI.T.lit_error_occured(), e.getMessage(), (Throwable)e);
        }
    }

    private void test(ProcessCallBackAdapter processCallBack, String script) throws ReconnectException, InterruptedException, DialogClosedException, DialogCanceledException {
        ConfirmDialog d = new ConfirmDialog(0, T.T.test_required(), T.T.test_required_msg(), null, _GUI.T.lit_continue(), null);
        ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
        processCallBack.setStatusString(this, _GUI.T.LiveHeaderDetectionWizard_sendRouter_havetovalidate());
        LiveHeaderInvoker ret = new LiveHeaderInvoker(this.getPlugin(), script, this.username, this.password, StringUtils.isEmpty((String)this.gatewayAdressHost) ? this.gatewayAdressIP : this.gatewayAdressHost, this.routerName);
        ReconnectDialog reconnect = new ReconnectDialog(){

            protected void reportException(ReconnectException e) {
            }

            protected void onFinished() {
                new EDTRunner(){

                    protected void runInEDT() {
                        this.dispose();
                    }
                };
            }
        };
        reconnect.setInvoker((ReconnectInvoker)ret);
        UIOManager.I().show(null, (UserIODefinition)reconnect);
        if (reconnect.getException() != null) {
            throw reconnect.getException();
        }
        if (reconnect.getResult() == null || !reconnect.getResult().isSuccess()) {
            throw new ReconnectException("Reconnect Failed");
        }
        ConfirmDialog confirm = new ConfirmDialog(0, T.T.confirm_success_title(), T.T.confirm_success_message(), (Icon)new AbstractIcon("question", 32), _GUI.T.lit_yes(), _GUI.T.lit_no());
        confirm.setPreferredWidth(500);
        ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)confirm)).throwCloseExceptions();
    }

    private String validateBeforeSend(String script) throws ScriptValidationExeption {
        RouterData rd = new RouterData();
        rd.setScript(script);
        try {
            new Scriptvalidator(rd){
                private HashSet<String> confirmed;
                {
                    this.confirmed = new HashSet();
                }

                @Override
                protected void replaceAuthHeader(String authorization, String lUsername, String lPassword) throws RetryWithReplacedScript, Exception {
                    if (this.defaultPasswords.contains(lPassword.toLowerCase(Locale.ENGLISH)) && this.defaultUsernames.contains(lUsername.toLowerCase(Locale.ENGLISH))) {
                        return;
                    }
                    if (StringUtils.isEmpty((String)LiveHeaderDetectionWizard.this.password)) {
                        LiveHeaderDetectionWizard.this.password = lPassword;
                    }
                    if (StringUtils.isEmpty((String)LiveHeaderDetectionWizard.this.username)) {
                        LiveHeaderDetectionWizard.this.username = lUsername;
                    }
                    if (StringUtils.isNotEmpty((String)LiveHeaderDetectionWizard.this.password) && !StringUtils.equals((String)LiveHeaderDetectionWizard.this.password, (String)lPassword)) {
                        if (UIOManager.I().showConfirmDialog(0, T.T.please_check(), T.T.please_confirm_password_change(authorization, lPassword), null, _GUI.T.lit_yes(), _GUI.T.lit_no())) {
                            LiveHeaderDetectionWizard.this.password = lPassword;
                        } else {
                            throw new Exception("Password Mismatch " + LiveHeaderDetectionWizard.this.password + "!=" + lPassword);
                        }
                    }
                    if (StringUtils.isNotEmpty((String)LiveHeaderDetectionWizard.this.username) && !StringUtils.equals((String)LiveHeaderDetectionWizard.this.username, (String)lUsername)) {
                        if (UIOManager.I().showConfirmDialog(0, T.T.please_check(), T.T.please_confirm_username_change(authorization, lUsername), null, _GUI.T.lit_yes(), _GUI.T.lit_no())) {
                            LiveHeaderDetectionWizard.this.password = lPassword;
                        } else {
                            throw new Exception("Username Mismatch " + LiveHeaderDetectionWizard.this.username + "!=" + lUsername);
                        }
                    }
                    throw new RetryWithReplacedScript(this.rd.getScript(), authorization.substring("Basic ".length()), "%%%basicauth%%%");
                }

                @Override
                protected void replacePasswordParameter(String key, String value) throws RetryWithReplacedScript, Exception {
                    if (this.defaultPasswords.contains(value.toLowerCase(Locale.ENGLISH))) {
                        return;
                    }
                    if (this.confirmed.contains(key + "=" + value)) {
                        return;
                    }
                    if (StringUtils.equals((String)value, (String)LiveHeaderDetectionWizard.this.password)) {
                        super.replacePasswordParameter(key, value);
                    } else if (this.confirm(key, value)) {
                        if (StringUtils.isNotEmpty((String)LiveHeaderDetectionWizard.this.password) && !StringUtils.equals((String)LiveHeaderDetectionWizard.this.password, (String)value)) {
                            if (UIOManager.I().showConfirmDialog(0, T.T.please_check(), T.T.please_confirm_password_change_parameter(value), null, _GUI.T.lit_yes(), _GUI.T.lit_no())) {
                                LiveHeaderDetectionWizard.this.password = value;
                            } else {
                                throw new Exception("Password Mismatch " + LiveHeaderDetectionWizard.this.password + "!=" + value);
                            }
                        }
                        if (StringUtils.isEmpty((String)LiveHeaderDetectionWizard.this.password)) {
                            LiveHeaderDetectionWizard.this.password = value;
                        }
                        super.replacePasswordParameter(key, value);
                    } else {
                        this.confirmed.add(key + "=" + value);
                    }
                }

                protected boolean confirm(String key, String value) {
                    ConfirmDialog d = new ConfirmDialog(0, T.T.please_check(), T.T.please_check_sensitive_data_before_share(key + "=" + value), (Icon)new AbstractIcon("question", 32), T.T.yes_replace(), T.T.no_keep());
                    d.setPreferredWidth(500);
                    try {
                        ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
                        return true;
                    }
                    catch (DialogClosedException e) {
                        e.printStackTrace();
                    }
                    catch (DialogCanceledException e) {
                        e.printStackTrace();
                    }
                    return false;
                }

                @Override
                protected void onHost(String host) throws Exception {
                    if (!host.startsWith("your.router.ip")) {
                        throw new RetryWithReplacedScript(this.rd.getScript(), host, "%%%routerip%%%");
                    }
                }

                @Override
                protected void replaceUsernameParameter(String key, String value) throws RetryWithReplacedScript, Exception {
                    if (this.defaultUsernames.contains(value.toLowerCase(Locale.ENGLISH))) {
                        return;
                    }
                    if (this.confirmed.contains(key + "=" + value)) {
                        return;
                    }
                    if (StringUtils.equals((String)value, (String)LiveHeaderDetectionWizard.this.username)) {
                        super.replaceUsernameParameter(key, value);
                    } else if (this.confirm(key, value)) {
                        if (StringUtils.isNotEmpty((String)LiveHeaderDetectionWizard.this.username) && !StringUtils.equals((String)LiveHeaderDetectionWizard.this.username, (String)value)) {
                            if (UIOManager.I().showConfirmDialog(0, T.T.please_check(), T.T.please_confirm_username_change_parameter(value), null, _GUI.T.lit_yes(), _GUI.T.lit_no())) {
                                LiveHeaderDetectionWizard.this.username = value;
                            } else {
                                throw new Exception("Username Mismatch " + LiveHeaderDetectionWizard.this.username + "!=" + value);
                            }
                        }
                        if (StringUtils.isEmpty((String)LiveHeaderDetectionWizard.this.username)) {
                            LiveHeaderDetectionWizard.this.username = value;
                        }
                        super.replaceUsernameParameter(key, value);
                    } else {
                        this.confirmed.add(key + "=" + value);
                    }
                }
            }.run();
            return rd.getScript();
        }
        catch (Exception e) {
            throw new ScriptValidationExeption(e);
        }
    }

    private void uploadData(String script) {
        RouterData rd = this.getRouterData();
        rd.setScript(script);
        AddRouterResponse resp = RecollController.getInstance().addRouter(rd);
        if (resp == null) {
            UIOManager.I().showMessageDialog(T.T.LiveHeaderDetectionWizard_runOnlineScan_notavailable_mm());
            return;
        }
        rd.setScriptID(resp.getScriptID());
        ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setRouterData(rd);
        ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setScript(rd.getScript());
        ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setUserName(this.username);
        ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setPassword(this.password);
        if (!resp.isDupe()) {
            UIOManager.I().showMessageDialog(T.T.LiveHeaderDetectionWizard_uploadData_sent_ok());
        } else {
            UIOManager.I().showMessageDialog(T.T.LiveHeaderDetectionWizard_uploadData_sent_failed());
        }
    }

    static {
        ALLOWED_HEADER_KEYS.add("Accept-Ranges".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Allow".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Cache-Control".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Connection".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Content-Encoding".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Content-Language".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Content-Length".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Content-Location".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Content-MD5".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Content-Disposition".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Content-Range".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Content-Type".toLowerCase());
        ALLOWED_HEADER_KEYS.add("ETag".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Link".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Location".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Pragma".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Refresh".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Retry-After".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Server".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Trailer".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Transfer-Encoding".toLowerCase());
        ALLOWED_HEADER_KEYS.add("Warning".toLowerCase());
    }
}

