/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader.recorder;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import jd.config.SubConfiguration;
import jd.controlling.reconnect.pluginsinc.liveheader.recorder.Proxy;
import org.appwork.utils.Regex;
import org.jdownloader.logging.LogController;

public class ReconnectRecorder {
    public static Vector<String> steps;
    static boolean running;
    static ServerSocket Server_Socket_HTTP;
    static ServerSocket Server_Socket_HTTPS;
    static final String PROPERTY_PORT = "PARAM_PORT";
    static String AUTH;

    public static void startServer(String serverip, boolean rawmode) {
        steps = new Vector();
        AUTH = null;
        running = true;
        steps.add("[[[HSRC]]]");
        int port = 80;
        try {
            Server_Socket_HTTP = new ServerSocket(SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty(PROPERTY_PORT, 8972));
            Server_Socket_HTTPS = new ServerSocket(SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty(PROPERTY_PORT, 8972) + 1);
            if (serverip.contains(":")) {
                String ports = new Regex(serverip, ".*?:(\\d+)").getMatch(0);
                port = Integer.parseInt(ports);
                serverip = new Regex(serverip, "(.*?):").getMatch(0);
            }
            new JDRRServer(Server_Socket_HTTP, serverip, port, false, rawmode).start();
            new JDRRServer(Server_Socket_HTTPS, serverip, 443, true, rawmode).start();
        }
        catch (Exception e) {
            LogController.CL().log((Throwable)e);
        }
    }

    public static void stopServer() {
        if (!running) {
            return;
        }
        running = false;
        if (steps != null) {
            steps.add("[[[/HSRC]]]");
        }
        try {
            Server_Socket_HTTP.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            Server_Socket_HTTP = null;
        }
        try {
            Server_Socket_HTTPS.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            Server_Socket_HTTPS = null;
        }
    }

    static {
        running = false;
    }

    public static class JDRRServer
    extends Thread {
        final ServerSocket Server_Socket;
        final String serverip;
        final int port;
        final boolean ishttps;
        final boolean israw;

        public JDRRServer(ServerSocket Server_Socket, String server, int port, boolean ishttps, boolean israw) {
            this.Server_Socket = Server_Socket;
            this.serverip = server;
            this.setName("JDRRServer " + port + " " + server);
            this.port = port;
            this.ishttps = ishttps;
            this.israw = israw;
        }

        @Override
        public void run() {
            try {
                while (running) {
                    Socket Client_Socket = null;
                    try {
                        Client_Socket = this.Server_Socket.accept();
                    }
                    catch (Exception e) {
                        break;
                    }
                    if (!running) continue;
                    new Proxy(Client_Socket, steps, this.serverip, this.port, this.ishttps, this.israw).start();
                }
            }
            finally {
                running = false;
                try {
                    this.Server_Socket.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

