/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader.recorder;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import jd.config.SubConfiguration;
import jd.controlling.reconnect.pluginsinc.liveheader.recorder.ProxyThread;
import jd.controlling.reconnect.pluginsinc.liveheader.recorder.ReconnectRecorder;
import jd.nutils.encoding.Encoding;
import jd.utils.JDHexUtils;
import org.appwork.utils.Regex;
import org.appwork.utils.formatter.HexFormatter;

public final class Utils {
    private Utils() {
    }

    public static String readline(BufferedInputStream in) {
        StringBuilder data = new StringBuilder("");
        try {
            int c;
            in.mark(1);
            if (in.read() == -1) {
                return null;
            }
            in.reset();
            while ((c = in.read()) >= 0 && c != 0 && c != 10 && c != 13) {
                data.append((char)c);
            }
            if (c == 13) {
                in.mark(1);
                if (in.read() != 10) {
                    in.reset();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data.toString();
    }

    public static InputStream newInputStream(final ByteBuffer buf) {
        return new InputStream(){

            @Override
            public synchronized int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get();
            }

            @Override
            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, buf.remaining());
                buf.get(bytes, off, len);
                return len;
            }
        };
    }

    public static void createStep(LinkedHashMap<String, String> headers, byte[] postdata, Vector<String> steps, boolean ishttps, boolean rawmode) {
        if (!new Regex(headers.get(null), ".*?\\.(gif|jpg|png|bmp|ico|css).*?").matches()) {
            String rawFlag = rawmode ? " raw=\"true\"" : "";
            String httpsFlag = ishttps ? " https=\"true\"" : "";
            boolean isPost = headers.get(null).contains("POST") && postdata != null;
            String postFlag = isPost ? " postraw=\"true\"" : "";
            StringBuilder hlh = new StringBuilder();
            hlh.append("    [[[STEP]]]\r\n");
            hlh.append("        [[[REQUEST" + httpsFlag + rawFlag + postFlag + "]]]\r\n");
            if (rawmode) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String key = entry.getKey();
                    if (key == null) {
                        hlh.append("        " + headers.get(null) + "\r\n");
                        continue;
                    }
                    if (key.equalsIgnoreCase("referer")) continue;
                    if (key.equalsIgnoreCase("host")) {
                        hlh.append("        Host: %%%routerip%%%\r\n");
                        continue;
                    }
                    hlh.append("        " + key + ": " + entry.getValue() + "\r\n");
                }
            } else {
                hlh.append("        " + headers.get(null) + "\r\n");
                hlh.append("        Host: %%%routerip%%%\r\n");
                if (headers.containsKey("authorization")) {
                    String auth = new Regex(headers.get("authorization"), "Basic (.+)").getMatch(0);
                    if (auth != null) {
                        ReconnectRecorder.AUTH = Encoding.Base64Decode((String)auth.trim());
                    }
                    hlh.append("        Authorization: Basic %%%basicauth%%%\r\n");
                }
            }
            if (isPost) {
                hlh.append("\r\n");
                hlh.append(HexFormatter.byteArrayToHex((byte[])postdata));
                hlh.append("\r\n");
            }
            hlh.append("        [[[/REQUEST]]]\r\n");
            hlh.append("    [[[/STEP]]]\r\n");
            steps.add(hlh.toString());
        }
    }

    public static void rewriteLocationHeader(ProxyThread instance) {
        String location = JDHexUtils.toString(new Regex(instance.buffer, Pattern.compile(JDHexUtils.getHexString("Location: ") + "(.*?)" + JDHexUtils.REGEX_HTTP_NEWLINE, 34)).getMatch(0));
        if (location != null && new Regex(location, "https?://(.*?)/?").getMatch(0) != null) {
            String oldlocation = location;
            location = new Regex(location, "https?://.*?/(.+)", 32).getMatch(0);
            location = !oldlocation.startsWith("https") ? (location != null ? "http://localhost:" + SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + "/" + location : "http://localhost:" + SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + "/") : (location != null ? "https://localhost:" + SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + "/" + location : "https://localhost:" + (SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + 1) + "/");
            instance.buffer = instance.buffer.replaceAll(JDHexUtils.getHexString("Location: " + oldlocation), JDHexUtils.getHexString("Location: " + location));
            instance.renewbuffer = true;
        }
    }

    public static void rewriteHostHeader(ProxyThread instance) {
        String host = JDHexUtils.toString(new Regex(instance.buffer, Pattern.compile(JDHexUtils.getHexString("Host: ") + "(.*?)" + JDHexUtils.REGEX_HTTP_NEWLINE, 34)).getMatch(0));
        if (host != null && new Regex(host, "(.*?):?").getMatch(0) != null) {
            String oldhost = host;
            host = instance.getHost();
            instance.buffer = instance.buffer.replaceAll(JDHexUtils.getHexString("Host: " + oldhost), JDHexUtils.getHexString("Host: " + host));
            instance.renewbuffer = true;
        }
    }

    public static void rewriteConnectionHeader(ProxyThread instance) {
        String type;
        String con = JDHexUtils.toString(new Regex(instance.buffer, Pattern.compile(JDHexUtils.getHexString("Connection: ") + "(.*?)" + JDHexUtils.REGEX_HTTP_NEWLINE, 34)).getMatch(0));
        if (con != null && (type = new Regex(con, "(.+)").getMatch(0)) != null && !type.equalsIgnoreCase("close")) {
            String oldcon = con;
            con = "close";
            instance.buffer = instance.buffer.replaceAll(JDHexUtils.getHexString("Connection: " + oldcon), JDHexUtils.getHexString("Connection: " + con));
            instance.renewbuffer = true;
        }
    }

    public static void rewriteRefererHeader(ProxyThread instance) {
        String ref = JDHexUtils.toString(new Regex(instance.buffer, Pattern.compile(JDHexUtils.getHexString("Referer: ") + "(.*?)" + JDHexUtils.REGEX_HTTP_NEWLINE, 34)).getMatch(0));
        if (ref != null && new Regex(ref, "https?://(.*?)/?").getMatch(0) != null) {
            String oldref = ref;
            String ref2 = new Regex(ref, "https?://.*?/(.+)", 32).getMatch(0);
            ref = !oldref.startsWith("https") ? (ref2 != null ? "http://" + instance.getHost() + "/" + ref2.trim() : (new Regex(ref, "https?://.*?/", 32).matches() ? "http://" + instance.getHost() + "/" : "http://" + instance.getHost())) : (ref2 != null ? "https://" + instance.getHost() + "/" + ref2.trim() : (new Regex(ref, "https?://.*?/", 32).matches() ? "https://" + instance.getHost() + "/" : "https://" + instance.getHost()));
            instance.buffer = instance.buffer.replaceAll(JDHexUtils.getHexString("Referer: " + oldref), JDHexUtils.getHexString("Referer: " + ref));
            instance.renewbuffer = true;
        }
    }
}

