/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.upnp;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import jd.controlling.reconnect.ProcessCallBack;
import jd.controlling.reconnect.ProcessCallBackAdapter;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectResult;
import jd.controlling.reconnect.RouterUtils;
import jd.controlling.reconnect.pluginsinc.liveheader.ReconnectFindDialog;
import jd.controlling.reconnect.pluginsinc.upnp.UPNPRouterPlugin;
import jd.controlling.reconnect.pluginsinc.upnp.translate.T;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.components.tooltips.BasicTooltipFactory;
import org.appwork.swing.components.tooltips.TooltipFactory;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;

public class AutoDetectUpnpAction
extends BasicAction {
    private UPNPRouterPlugin plugin;
    private boolean modemChoose;

    public AutoDetectUpnpAction(UPNPRouterPlugin upnpRouterPlugin) {
        this.plugin = upnpRouterPlugin;
        this.putValue("Name", T.T.auto());
        this.putValue("SmallIcon", new AbstractIcon("wizard", 18));
        this.setTooltipFactory((TooltipFactory)new BasicTooltipFactory(this.getName(), T.T.AutoDetectUpnpAction_AutoDetectUpnpAction_(), (Icon)new AbstractIcon("upnp", 32)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        ReconnectFindDialog d;
        LogSource logger = LogController.getInstance().getLogger("UPNPReconnect");
        ConfirmDialog confirm = new ConfirmDialog(0, _GUI.T.AutoSetupAction_actionPerformed_warn_title(), _GUI.T.AutoSetupAction_actionPerformed_warn_message(), new AbstractIcon("warning", 32), _GUI.T.AutoSetupAction_actionPerformed_warn_message_continue(), null){

            protected int getPreferredWidth() {
                return 750;
            }

            public boolean isRemoteAPIEnabled() {
                return false;
            }
        };
        try {
            ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)confirm)).throwCloseExceptions();
        }
        catch (Throwable e2) {
            logger.log(e2);
            return;
        }
        try {
            if (RouterUtils.isWindowsModemConnection()) {
                this.modemChoose = false;
                d = new ConfirmDialog(0, _GUI.T.literally_warning(), _GUI.T.AutoSetupAction_actionPerformed_modem(), (Icon)new AbstractIcon("modem", 32), _GUI.T.AutoSetupAction_actionPerformed_dont_know(), _GUI.T.AutoSetupAction_actionPerformed_router());
                d.setLeftActions(new AbstractAction[]{new AbstractAction((ConfirmDialog)d){
                    final /* synthetic */ ConfirmDialog val$d;
                    {
                        this.val$d = confirmDialog;
                        this.putValue("Name", _GUI.T.AutoSetupAction_actionPerformed_choose_modem());
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AutoDetectUpnpAction.this.modemChoose = true;
                        this.val$d.dispose();
                    }
                }});
                try {
                    Dialog.getInstance().showDialog((AbstractDialog)d);
                    if (this.modemChoose) {
                        Dialog.getInstance().showErrorDialog(_GUI.T.AutoSetupAction_actionPerformed_noautoformodem());
                        CrossSystem.openURL((String)"https://jdownloader.org/knowledge/wiki/reconnect/modem");
                        return;
                    }
                    CrossSystem.openURL((String)"https://jdownloader.org/knowledge/wiki/reconnect/modem");
                }
                catch (DialogCanceledException dialogCanceledException) {}
            }
        }
        catch (Throwable d2) {
            // empty catch block
        }
        logger.info("RUN");
        d = new ReconnectFindDialog(){

            @Override
            public void run() throws InterruptedException {
                final AtomicBoolean methodConfirmEnabled = new AtomicBoolean(true);
                final List<ReconnectResult> scripts = AutoDetectUpnpAction.this.plugin.runDetectionWizard(new ProcessCallBack(){

                    @Override
                    public void setStatusString(Object caller, String string) {
                        this.setBarText(string);
                    }

                    @Override
                    public void setProgress(Object caller, int percent) {
                        this.setBarProgress(percent);
                    }

                    @Override
                    public void setStatus(Object caller, Object statusObject) {
                    }

                    @Override
                    public void setMethodConfirmEnabled(boolean b) {
                        methodConfirmEnabled.set(b);
                    }

                    @Override
                    public boolean isMethodConfirmEnabled() {
                        return methodConfirmEnabled.get();
                    }
                });
                if (scripts != null && scripts.size() > 0) {
                    if (((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getOptimizationRounds() > 1) {
                        long bestTime = Long.MAX_VALUE;
                        long optiduration = 0L;
                        for (ReconnectResult found : scripts) {
                            bestTime = Math.min(bestTime, found.getSuccessDuration());
                            optiduration = (long)((double)optiduration + (double)(found.getSuccessDuration() * (long)(((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getOptimizationRounds() - 1)) * 1.5);
                        }
                        try {
                            ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)new ConfirmDialog(0, _GUI.T.AutoDetectAction_actionPerformed_dooptimization_title(), _GUI.T.AutoDetectAction_actionPerformed_dooptimization_msg(scripts.size(), TimeFormatter.formatMilliSeconds((long)optiduration, (int)0), TimeFormatter.formatMilliSeconds((long)bestTime, (int)0)), (Icon)new AbstractIcon("ok", 32), _GUI.T.AutoDetectAction_run_optimization(), _GUI.T.AutoDetectAction_skip_optimization()))).throwCloseExceptions();
                            this.setBarProgress(0);
                            int ii = 0;
                            while (ii < scripts.size()) {
                                ReconnectResult found;
                                found = scripts.get(ii);
                                this.setBarText(_GUI.T.AutoDetectAction_run_optimize(found.getInvoker().getName()));
                                final int step = ii++;
                                found.optimize(new ProcessCallBackAdapter(){

                                    @Override
                                    public void setProgress(Object caller, int percent) {
                                        this.setBarProgress(step * (100 / scripts.size()) + percent / scripts.size());
                                    }

                                    @Override
                                    public void setStatusString(Object caller, String string) {
                                        this.setBarText(_GUI.T.AutoDetectAction_run_optimize(string));
                                    }
                                });
                            }
                        }
                        catch (DialogNoAnswerException dialogNoAnswerException) {
                            // empty catch block
                        }
                    }
                    Collections.sort(scripts, new Comparator<ReconnectResult>(){

                        @Override
                        public int compare(ReconnectResult o1, ReconnectResult o2) {
                            return CompareUtils.compareLong((long)o2.getAverageSuccessDuration(), (long)o1.getAverageSuccessDuration());
                        }
                    });
                    System.out.println("Scripts " + scripts);
                    scripts.get(0).getInvoker().getPlugin().setSetup(scripts.get(0));
                } else {
                    UIOManager.I().showErrorMessage(T.T.AutoDetectAction_run_failed2());
                }
            }
        };
        try {
            UIOManager.I().show(null, (UserIODefinition)d);
        }
        finally {
            System.out.println("CLOSED");
        }
    }
}

