/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.upnp;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectInvoker;
import jd.controlling.reconnect.ReconnectResult;
import jd.controlling.reconnect.pluginsinc.upnp.UPNPReconnectResult;
import jd.controlling.reconnect.pluginsinc.upnp.UPNPRouterPlugin;
import jd.controlling.reconnect.pluginsinc.upnp.UPUPReconnectSettings;
import jd.controlling.reconnect.pluginsinc.upnp.translate.T;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;

public class UPNPReconnectInvoker
extends ReconnectInvoker {
    private final String serviceType;
    private final String controlURL;

    public UPNPReconnectInvoker(UPNPRouterPlugin upnpRouterPlugin, String serviceType2, String controlURL2) {
        super(upnpRouterPlugin);
        this.serviceType = serviceType2;
        this.controlURL = controlURL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String internalSendRequest(Logger logger, String serviceType, String controlUrl, String command) throws IOException {
        String data = "<?xml version='1.0' encoding='utf-8'?> <s:Envelope s:encodingStyle='http://schemas.xmlsoap.org/soap/encoding/' xmlns:s='http://schemas.xmlsoap.org/soap/envelope/'> <s:Body> <u:" + command + " xmlns:u='" + serviceType + "' /> </s:Body> </s:Envelope>";
        URL url = new URL(controlUrl);
        HTTPConnectionImpl con = new HTTPConnectionImpl(url);
        con.setIPVersion(HTTPConnectionUtils.IPVERSION.IPV4_IPV6);
        if ("GetExternalIPAddress".equalsIgnoreCase(command)) {
            con.setReadTimeout(2000);
        }
        con.setAllowedResponseCodes(new int[]{-1});
        con.setRequestMethod(HTTPConnection.RequestMethod.POST);
        con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
        con.setRequestProperty("SOAPAction", serviceType + "#" + command);
        byte[] datas = data.getBytes("UTF-8");
        con.setRequestProperty("Content-Length", datas.length + "");
        con.setRequestProperty("Connection", "close");
        BufferedReader rd = null;
        if (logger != null) {
            logger.info(con + "");
        }
        try {
            con.connect();
            con.getOutputStream().write(datas);
            con.getOutputStream().flush();
            rd = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String xmlstr = "";
            try {
                String nextln;
                while ((nextln = rd.readLine()) != null) {
                    xmlstr = xmlstr + nextln.trim();
                    System.out.println(nextln);
                    if (!nextln.toLowerCase(Locale.ENGLISH).contains("</s:body>")) continue;
                    break;
                }
            }
            catch (IOException e) {
                logger.info(con.toString());
                LogSource.exception((Logger)logger, (Throwable)e);
                if (!StringUtils.isEmpty((String)xmlstr)) {
                    String string = xmlstr;
                    try {
                        rd.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        con.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (logger != null) {
                        logger.info(con + "");
                    }
                    return string;
                }
                throw e;
            }
            if (logger != null) {
                logger.info(con + "");
                logger.info(xmlstr);
            }
            String string = xmlstr;
            return string;
        }
        finally {
            try {
                rd.close();
            }
            catch (Throwable throwable) {}
            try {
                con.disconnect();
            }
            catch (Throwable throwable) {}
            if (logger != null) {
                logger.info(con + "");
            }
        }
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getControlURL() {
        return this.controlURL;
    }

    @Override
    public String getName() {
        return T.T.UPNPReconnectInvoker_getName_();
    }

    public static String sendRequest(Logger logger, String serviceType, String controlUrl, String command) throws IOException {
        try {
            String result = UPNPReconnectInvoker.internalSendRequest(logger, serviceType, controlUrl, command);
            if (!StringUtils.containsIgnoreCase((String)result, (String)"UPnPError")) {
                return result;
            }
            Thread.sleep(1000L);
            return UPNPReconnectInvoker.internalSendRequest(logger, serviceType, controlUrl, command);
        }
        catch (EOFException e) {
            if (StringUtils.contains((String)"empty HTTP-Response", (String)e.getMessage())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    throw e;
                }
                return UPNPReconnectInvoker.internalSendRequest(logger, serviceType, controlUrl, command);
            }
            throw e;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private static String sendForceTermination(Logger logger, String serviceType, String controlUrl) throws IOException {
        return UPNPReconnectInvoker.sendRequest(logger, serviceType, controlUrl, "ForceTermination");
    }

    private static String sendRequestConnection(Logger logger, String serviceType, String controlUrl) throws IOException {
        return UPNPReconnectInvoker.sendRequest(logger, serviceType, controlUrl, "RequestConnection");
    }

    @Override
    public void run() throws ReconnectException, InterruptedException {
        try {
            this.logger.info("RUN");
            if (StringUtils.isEmpty((String)this.getServiceType())) {
                throw new ReconnectException(T.T.malformedservicetype());
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            UPNPReconnectInvoker.sendForceTermination((Logger)this.getLogger(), this.getServiceType(), this.getControlURL());
            int firstWait = ((UPUPReconnectSettings)JsonConfig.create(UPUPReconnectSettings.class)).getFirstReconnectWaitTimeout();
            if (firstWait > 0) {
                Thread.sleep(firstWait);
            }
            Throwable throwable = null;
            for (int requestTry = 0; requestTry < 10; ++requestTry) {
                try {
                    Thread.sleep(2000L);
                    try {
                        String result = UPNPReconnectInvoker.sendRequestConnection((Logger)this.getLogger(), this.getServiceType(), this.getControlURL());
                        if (StringUtils.containsIgnoreCase((String)result, (String)"UPnPError")) continue;
                        return;
                    }
                    catch (Throwable e) {
                        throwable = e;
                        this.logger.log(e);
                    }
                    continue;
                }
                catch (InterruptedException ie) {
                    try {
                        String result = UPNPReconnectInvoker.sendRequestConnection((Logger)this.getLogger(), this.getServiceType(), this.getControlURL());
                        if (!StringUtils.containsIgnoreCase((String)result, (String)"UPnPError")) {
                            return;
                        }
                    }
                    catch (Throwable e) {
                        throwable = e;
                        this.logger.log(e);
                    }
                    throw (InterruptedException)Exceptions.addSuppressed((Throwable)ie, (Throwable)throwable);
                }
            }
            if (throwable != null) {
                throw throwable;
            }
        }
        catch (ReconnectException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            throw new ReconnectException(T.T.malformedurl(), e);
        }
        catch (Throwable e) {
            throw new ReconnectException(e);
        }
    }

    @Override
    protected ReconnectResult createReconnectResult() {
        return new UPNPReconnectResult();
    }

    @Override
    protected void testRun() throws ReconnectException, InterruptedException {
        this.run();
    }
}

