/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.upnp.cling;

import java.net.InetAddress;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.reconnect.RouterUtils;
import jd.controlling.reconnect.pluginsinc.upnp.cling.StreamClientImpl;
import jd.controlling.reconnect.pluginsinc.upnp.cling.UpnpRouterDevice;
import jd.controlling.reconnect.pluginsinc.upnp.translate.T;
import jd.http.Browser;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.fourthline.cling.DefaultUpnpServiceConfiguration;
import org.fourthline.cling.UpnpServiceConfiguration;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.meta.Action;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDAServiceType;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.registry.RegistryListener;
import org.fourthline.cling.transport.RouterException;
import org.fourthline.cling.transport.impl.StreamClientConfigurationImpl;
import org.jdownloader.logging.LogController;

public class UPNPDeviceScanner {
    private LogSource logger = LogController.getInstance().getLogger(UPNPDeviceScanner.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UpnpRouterDevice> scan() throws InterruptedException {
        this.logger.info("Starting Cling...");
        final HashSet ret = new HashSet();
        final AtomicLong lastreceive = new AtomicLong(System.currentTimeMillis());
        DefaultUpnpServiceConfiguration config = new DefaultUpnpServiceConfiguration(){

            public Executor getMulticastReceiverExecutor() {
                return super.getMulticastReceiverExecutor();
            }

            public Integer getRemoteDeviceMaxAgeSeconds() {
                return super.getRemoteDeviceMaxAgeSeconds();
            }

            public StreamClientImpl createStreamClient() {
                return new StreamClientImpl(new StreamClientConfigurationImpl(this.getSyncProtocolExecutorService()));
            }
        };
        UpnpServiceImpl upnpService = new UpnpServiceImpl((UpnpServiceConfiguration)config, new RegistryListener[]{new RegistryListener(){

            public void remoteDeviceDiscoveryStarted(Registry registry, RemoteDevice device) {
                UPNPDeviceScanner.this.logger.info("Discovery started: " + device.getDisplayString() + " - " + device.getType());
            }

            public void remoteDeviceDiscoveryFailed(Registry registry, RemoteDevice device, Exception ex) {
                UPNPDeviceScanner.this.logger.info("Discovery failed: " + device.getDisplayString() + " => " + ((ValidationException)ex).getErrors());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remoteDeviceAdded(Registry registry, RemoteDevice device) {
                block11: {
                    UPNPDeviceScanner.this.logger.info("Remote device available: " + device.getDisplayString() + " - " + device.getType());
                    try {
                        HashSet hashSet;
                        URL url;
                        UpnpRouterDevice d;
                        Action action;
                        Service service = device.findService((ServiceType)new UDAServiceType("WANIPConnection", 1));
                        if (service != null && service instanceof RemoteService && (action = service.getAction("ForceTermination")) != null) {
                            d = new UpnpRouterDevice();
                            d.setModelname(device.getDisplayString());
                            d.setWanservice(T.T.interaction_UpnpReconnect_wanservice_ip());
                            url = ((RemoteDevice)((RemoteService)service).getDevice()).normalizeURI(((RemoteService)service).getControlURI());
                            d.setControlURL(url + "");
                            d.setServiceType(((RemoteService)service).getServiceType() + "");
                            d.setFriendlyname(device.getDetails().getFriendlyName());
                            d.setManufactor(device.getDetails().getManufacturerDetails().getManufacturer());
                            UPNPDeviceScanner.this.logger.info("Found " + JSonStorage.serializeToJson((Object)d));
                            hashSet = ret;
                            synchronized (hashSet) {
                                ret.add(d);
                            }
                            lastreceive.set(System.currentTimeMillis());
                        }
                        try {
                            service = device.findService((ServiceType)new UDAServiceType("WANPPPConnection", 1));
                            if (service == null || !(service instanceof RemoteService) || (action = service.getAction("ForceTermination")) == null) break block11;
                            d = new UpnpRouterDevice();
                            d.setModelname(device.getDisplayString());
                            d.setWanservice(T.T.interaction_UpnpReconnect_wanservice_ppp());
                            url = ((RemoteDevice)((RemoteService)service).getDevice()).normalizeURI(((RemoteService)service).getControlURI());
                            d.setServiceType(((RemoteService)service).getServiceType() + "");
                            d.setControlURL(url + "");
                            d.setFriendlyname(device.getDetails().getFriendlyName());
                            d.setManufactor(device.getDetails().getManufacturerDetails().getManufacturer());
                            UPNPDeviceScanner.this.logger.info("Found " + JSonStorage.serializeToJson((Object)d));
                            hashSet = ret;
                            synchronized (hashSet) {
                                ret.add(d);
                            }
                            lastreceive.set(System.currentTimeMillis());
                        }
                        catch (Exception e) {
                            UPNPDeviceScanner.this.logger.log((Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        UPNPDeviceScanner.this.logger.log((Throwable)e);
                    }
                }
            }

            public void remoteDeviceUpdated(Registry registry, RemoteDevice device) {
            }

            public void remoteDeviceRemoved(Registry registry, RemoteDevice device) {
            }

            public void localDeviceAdded(Registry registry, LocalDevice device) {
            }

            public void localDeviceRemoved(Registry registry, LocalDevice device) {
            }

            public void beforeShutdown(Registry registry) {
                UPNPDeviceScanner.this.logger.info("Before shutdown, the registry has devices: " + registry.getDevices().size());
            }

            public void afterShutdown() {
                UPNPDeviceScanner.this.logger.info("Shutdown of registry complete!");
            }
        }});
        upnpService.getControlPoint().search();
        try {
            ArrayList<UpnpRouterDevice> devices;
            this.logger.info("Waiting 15 seconds before shutting down...");
            Thread.sleep(15000L);
            AbstractCollection abstractCollection = ret;
            synchronized (abstractCollection) {
                devices = new ArrayList<UpnpRouterDevice>(ret);
            }
            if (devices.size() > 1) {
                InetAddress gateWay = null;
                try {
                    gateWay = RouterUtils.getIPFormNetStat();
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
                if (gateWay == null) {
                    try {
                        gateWay = RouterUtils.getIPFromRouteCommand();
                    }
                    catch (Throwable e) {
                        this.logger.log(e);
                    }
                }
                if (gateWay != null) {
                    String gateWayAddress = gateWay.getHostAddress();
                    UpnpRouterDevice tryFirst = null;
                    for (UpnpRouterDevice device : devices) {
                        String host = Browser.getHost((String)device.getControlURL(), (boolean)false);
                        if (!StringUtils.equals((String)host, (String)gateWayAddress)) continue;
                        tryFirst = device;
                        break;
                    }
                    if (tryFirst != null) {
                        devices.remove(tryFirst);
                        devices.add(0, tryFirst);
                    }
                }
            }
            abstractCollection = devices;
            return abstractCollection;
        }
        finally {
            UPNPDeviceScanner.shutdown(upnpService);
        }
    }

    public static void shutdown(final UpnpServiceImpl upnpService) {
        if (upnpService == null) {
            return;
        }
        new Thread("UpnpService:shutting down"){
            {
                super(x0);
                this.setDaemon(true);
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        upnpService.getRegistry().shutdown();
                        upnpService.getRouter().shutdown();
                        upnpService.getConfiguration().shutdown();
                        upnpService.shutdown();
                    }
                    catch (RouterException routerException) {}
                    finally {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public static void main(String[] args) throws InterruptedException {
        new UPNPDeviceScanner().scan();
    }
}

