/*
 * Decompiled with CFR 0.152.
 */
package jd.parser.html;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.nutils.encoding.Encoding;
import org.appwork.utils.Application;
import org.appwork.utils.CharSequenceUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Hex;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.PublicSuffixList;
import org.appwork.utils.net.URLHelper;

public class HTMLParser {
    private static final Httppattern[] linkAndFormPattern = new Httppattern[]{new Httppattern(Pattern.compile("src\\s*=\\s*('|\\\\\"|\")(.*?)(\\1)", 34), 2), new Httppattern(Pattern.compile("(<\\s*a[^>]*href\\s*=\\s*|<\\s*form[^>]*action\\s*=\\s*)('|\\\\\"|\")(.*?)(\\2)", 34), 3), new Httppattern(Pattern.compile("(<\\s*a[^>]*href\\s*=\\s*|<\\s*form[^>]*action\\s*=\\s*)([^'\"][^\\s]*)", 34), 2), new Httppattern(Pattern.compile("\\[(link|url)\\](.*?)\\[/(link|url)\\]", 34), 2)};
    public static final String protocolFile = "file:/";
    private static final String protocolPrefixes = "((?:chrome|directhttp://https?|usenet|flashget|https?viajd|m3u8://https?|https?|ccf|dlc|ftp|ftpviajd|jd|rsdf|jdlist|ipfs|nxm|youtubev2" + (!Application.isJared(null) ? "|jdlog" : "") + ")(?:(:|\\\\x3A|\\\\u003A)(/|\\\\x2F|\\\\u002F)(/|\\\\x2F|\\\\u002F))|" + "file:/" + "|magnet:|mega:)";
    private static final Pattern[] basePattern = new Pattern[]{Pattern.compile("<[^>]*base[^>]*href\\s*=\\s*('|\")(.*?)\\1", 2), Pattern.compile("<[^>]*base[^>]*(href)\\s*=\\s*([^'\"][^\\s]*)", 2)};
    private static final Pattern[] hrefPattern = new Pattern[]{Pattern.compile("data-\\w+\\s*=\\s*('|\")\\s*(.*?)\\s*(\\1)", 2), Pattern.compile("href\\s*=\\s*('|\")\\s*(.*?)\\s*(\\1)", 2), Pattern.compile("src\\s*=\\s*('|\")\\s*(.*?)\\s*(\\1)", 2)};
    private static final Pattern pat1 = Pattern.compile("(" + protocolPrefixes + "|(?<!://)www\\.)", 34);
    private static final Pattern protocols = Pattern.compile("(" + protocolPrefixes + ")");
    private static final Pattern LINKPROTOCOL = Pattern.compile("^" + protocolPrefixes, 2);
    private static final Pattern mergePattern_Root = Pattern.compile("(.*?(\\.[a-z0-9]+|\\])(:\\d+)?)(/|$)", 34);
    private static final Pattern mergePattern_Directory = Pattern.compile("(.*?(\\.[a-z0-9]+|\\])(:\\d+)?/[^?#]+/)", 34);
    private static final Pattern mergePattern_Path = Pattern.compile("(.*?(\\.[a-z0-9]+|\\])(:\\d+)?/[^?#]+)", 34);
    private static Pattern mp = null;
    private static final int MIN_VALID;
    private static final Pattern checkPatternBase64;
    private static final Pattern checkPatternUnicode;
    private static final Pattern unescapePattern;
    private static final Pattern checkPatternHREFUNESCAPESRC;
    private static final Pattern checkPatternHREFSRC;
    private static final Pattern unhexPattern;
    private static final Pattern paramsCut1;
    private static final Pattern paramsCut2;
    private static final Pattern inTagsPattern;
    private static final Pattern endTagPattern;
    private static final Pattern taglessPattern;
    private static final HtmlParserCharSequence directHTTP;
    private static final HtmlParserCharSequence httpviajd;
    private static final HtmlParserCharSequence httpsviajd;
    private static final HtmlParserCharSequence http;
    private static final Pattern dummyCnl;
    private static final Pattern httpRescue;
    private static final Pattern tagsPattern;
    private static final Pattern singleSpacePattern;
    private static final Pattern findSpacePattern;
    private static final Pattern hdotsPattern;
    private static final Pattern specialReplacePattern;
    private static final Pattern questionMarkPattern;
    private static final Pattern maybeHostPattern;
    private static final Pattern missingHTTPPattern;
    private static final Pattern urlEncodedProtocol;
    private static final Pattern escapedJSONPattern;
    private static final String TAGOPEN;
    private static final String TAGCLOSE;
    private static final Pattern findParamPattern;
    private static final LinkedHashMap<Pattern, String> URLDECODE;
    private static final Pattern ltPattern;
    private static final Pattern gtPattern;
    private static final Pattern ampPattern;
    private static final Pattern quotPattern;
    private static final Pattern brPattern;
    private static final Pattern wbrPattern;
    private static final Pattern parseLocationPatternSchemeHostLoc;

    private static HtmlParserCharSequenceHierarchy next(HtmlParserCharSequenceHierarchy path, HtmlParserCharSequence next) {
        if (path == null) {
            return new HtmlParserCharSequenceHierarchy(next);
        }
        if (next != null && !next.equals(path.lastElement())) {
            return new HtmlParserCharSequenceHierarchy(path, next);
        }
        return path;
    }

    private static HtmlParserResultSet _getHttpLinksDeepWalker(HtmlParserCharSequenceHierarchy path, HtmlParserResultSet results, HtmlParserOptions options) {
        List<HtmlParserCharSequence> unescaped;
        HtmlParserCharSequence next;
        boolean historyContains;
        StringBuilder reversedata;
        if (options == null) {
            options = new HtmlParserOptions();
        }
        if (results == null) {
            results = new HtmlParserResultSet();
        }
        HtmlParserCharSequence data = path.lastElement();
        results = results.start(data);
        if (data != null) {
            data = data.trim();
            path = HTMLParser.next(path, data);
        }
        if (data == null || data.length() < MIN_VALID) {
            return results.stop();
        }
        if ((data.startsWith(directHTTP) || data.startsWith(httpviajd) || data.startsWith(httpsviajd)) && results.contains(data)) {
            return results.stop();
        }
        if (data.matches(dummyCnl)) {
            return results.stop();
        }
        int indexBefore = results.getLastResultIndex();
        if (options.isReverse() && !data.equals(reversedata = new StringBuilder(data).reverse()) && !(historyContains = path.contains(next = new HtmlParserCharSequence(reversedata)))) {
            HTMLParser._getHttpLinksFinder(HTMLParser.next(path, next), results, options.reverse(false));
            HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(path, next), results, options);
        }
        HtmlParserCharSequence urlDecoded = HTMLParser.decodeURLParamEncodedURL(path, false);
        if (options.isBase64()) {
            List<HtmlParserCharSequence> base64Matches = data.getColumn(1, checkPatternBase64);
            for (HtmlParserCharSequence base64Match : base64Matches) {
                CharSequence base64Data;
                int padding = 4 - base64Match.length() % 4;
                if (padding != 0) {
                    switch (padding) {
                        case 1: {
                            base64Match = new HtmlParserCharSequence(new ConcatCharSequence(base64Match, "="));
                            break;
                        }
                        case 2: {
                            base64Match = new HtmlParserCharSequence(new ConcatCharSequence(base64Match, "=="));
                            break;
                        }
                    }
                }
                if ((base64Data = Encoding.Base64Decode((CharSequence)base64Match)).length() <= 0 || urlDecoded.equals(base64Data) && data.equals(base64Data)) continue;
                HtmlParserCharSequenceHierarchy nextPath = HTMLParser.next(path, base64Match);
                HtmlParserCharSequence next2 = new HtmlParserCharSequence(base64Data);
                boolean historyContains2 = path.contains(next2);
                if (historyContains2) continue;
                HTMLParser._getHttpLinksFinder(HTMLParser.next(nextPath, next2), results, options.base64(false));
                int undefined = next2.count("\ufffd", 1);
                if (undefined != 0) continue;
                HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(nextPath, next2), results, options);
            }
        }
        if (options.isUnescape() && data.length() > 23 && data.contains("unescape") && (unescaped = data.getColumn(2, unescapePattern)) != null && unescaped.size() > 0) {
            for (HtmlParserCharSequence unescape : unescaped) {
                HtmlParserCharSequenceHierarchy nextPath = HTMLParser.next(path, unescape);
                HtmlParserCharSequence next3 = new HtmlParserCharSequence(new HtmlParserCharSequence(Encoding.htmlDecode((String)unescape.toString())));
                boolean historyContains3 = path.contains(next3);
                if (historyContains3) continue;
                HTMLParser._getHttpLinksFinder(HTMLParser.next(nextPath, next3), results, options.unescape(false));
                int undefined = next3.count("\ufffd", 1);
                if (undefined != 0) continue;
                HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(nextPath, next3), results, options);
            }
        }
        if (options.isHex() && HTMLParser.deepWalkCheck(path, options, results, indexBefore) && data.length() >= 24) {
            HtmlParserCharSequence hex = data.replaceAll(singleSpacePattern, "");
            hex = data.group(1, unhexPattern);
            if (hex != null && hex.length() >= 24) {
                try {
                    hex = hex.replaceAll(singleSpacePattern, "");
                    HtmlParserCharSequenceHierarchy nextPath = HTMLParser.next(path, hex);
                    String hexString = Hex.hex2String((CharSequence)hex);
                    HtmlParserCharSequence next4 = new HtmlParserCharSequence(hexString);
                    boolean historyContains4 = path.contains(next4);
                    if (!historyContains4) {
                        HTMLParser._getHttpLinksFinder(HTMLParser.next(nextPath, next4), results, options.hex(false));
                        int undefined = next4.count("\ufffd", 1);
                        if (undefined == 0) {
                            HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(nextPath, next4), results, options);
                        }
                    }
                }
                catch (Throwable e) {
                    LoggerFactory.getDefaultLogger().log(e);
                }
            }
        }
        if (HTMLParser.checkForUnicode(options, data) && !(historyContains = path.contains(next = HTMLParser.unicodeDecode(urlDecoded)))) {
            if (urlDecoded.find(checkPatternUnicode)) {
                HTMLParser._getHttpLinksFinder(HTMLParser.next(path, next), results, options);
                HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(path, next), results, options);
            } else {
                HTMLParser._getHttpLinksFinder(HTMLParser.next(path, next), results, options.unicode(false));
                HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(path, next), results, options);
            }
        }
        if (options.isUrlEncoded() && HTMLParser.deepWalkCheck(path, options, results, indexBefore) && !urlDecoded.equals(data) && !(historyContains = path.contains(next = new HtmlParserCharSequence(urlDecoded)))) {
            if (urlDecoded.find(urlEncodedProtocol)) {
                HTMLParser._getHttpLinksFinder(HTMLParser.next(path, next), results, options);
                HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(path, next), results, options);
            } else {
                HTMLParser._getHttpLinksFinder(HTMLParser.next(path, next), results, options.urlEncoded(false));
                HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(path, next), results, options);
            }
        }
        return results.stop();
    }

    private static void addToResultSet(HtmlParserCharSequenceHierarchy path, HtmlParserResultSet results, HtmlParserOptions options) {
        HtmlParserCharSequence data;
        if (results.add(HTMLParser.correctURL(path, results, options)) && (data = path.lastElement()).find(urlEncodedProtocol)) {
            int lastIndexOf = 0;
            while (true) {
                int indexOf;
                if ((indexOf = data.indexOf("?", lastIndexOf)) == -1) {
                    indexOf = data.indexOf("&", lastIndexOf);
                }
                if (indexOf == -1) break;
                HtmlParserCharSequence subSequence = data.subSequence(lastIndexOf, indexOf);
                lastIndexOf = indexOf + 1;
                if (!subSequence.find(urlEncodedProtocol)) continue;
                HtmlParserCharSequenceHierarchy next = HTMLParser.next(path, subSequence);
                HtmlParserCharSequence urlDecoded = HTMLParser.decodeURLParamEncodedURL(next, true);
                HTMLParser._getHttpLinksWalker(HTMLParser.next(next, urlDecoded), results, null, options);
            }
        }
    }

    private static boolean skip(HtmlParserCharSequence link) {
        return link == null || link.equals("about:blank") || link.equals("/") || link.startsWith("#");
    }

    protected static HtmlParserCharSequence convert(HtmlParserCharSequence sequence) {
        if (sequence.length() > 2 && sequence.length() % 4 == 0 && sequence.charAt(0) == '\\' && sequence.charAt(1) == 'x') {
            return new HexHtmlParserCharSequence(sequence);
        }
        return sequence;
    }

    private static HtmlParserResultSet _getHttpLinksFinder(HtmlParserCharSequenceHierarchy path, HtmlParserResultSet results, HtmlParserOptions options) {
        if (results == null) {
            results = new HtmlParserResultSet();
        }
        HtmlParserCharSequence data = path.lastElement();
        results = results.start(data);
        if (data != null) {
            data = data.trim();
            path = HTMLParser.next(path, data);
        }
        if (data == null || data.length() == 0) {
            return results.stop();
        }
        if (data.contains(":\\/\\/")) {
            data = data.replaceAll(escapedJSONPattern, "");
        }
        if (!data.matches(tagsPattern)) {
            int c = data.count(pat1, 2);
            if (c == 0) {
                if (!data.matches(checkPatternHREFSRC)) {
                    if (data.count(questionMarkPattern, 2) < 2) {
                        HtmlParserCharSequence location = HTMLParser.parseLocation(results, results.getBaseURL(), data, true);
                        if (HTMLParser.getProtocol(location) != null) {
                            return HTMLParser._getHttpLinksFinder(HTMLParser.next(path, location), results, options);
                        }
                        HtmlParserCharSequence host = data.group(1, maybeHostPattern);
                        if (host != null && host.equals(PublicSuffixList.getInstance().getDomain(host.toString()))) {
                            HtmlParserCharSequence missingProtocol = new HtmlParserCharSequence(new ConcatCharSequence("http://", data));
                            return HTMLParser._getHttpLinksFinder(HTMLParser.next(path, missingProtocol), results, options);
                        }
                    }
                    return results.stop();
                }
            } else if (c == 1 && data.length() < 256) {
                Object protocol = null;
                HtmlParserCharSequence link = data;
                protocol = HTMLParser.getProtocol(link);
                if (protocol == null && !link.contains("%2F")) {
                    link = data.replaceFirst(hdotsPattern, "http://").replaceFirst(missingHTTPPattern, "http://www.");
                }
                if ((protocol = HTMLParser.getProtocol(link)) != null) {
                    if (((HtmlParserCharSequence)protocol).startsWith(protocolFile)) {
                        HTMLParser.addToResultSet(HTMLParser.next(path, link), results, options);
                        return results.stop();
                    }
                    while (link.length() > 2 && link.charAt(0) == '<' && link.charAt(link.length() - 1) == '>') {
                        link = link.subSequence(1, link.length() - 1);
                    }
                    while (link.length() > 2 && link.charAt(0) == '\"' && link.charAt(link.length() - 1) == '\"') {
                        link = link.subSequence(1, link.length() - 1);
                    }
                    if (!link.find(findSpacePattern)) {
                        HTMLParser.addToResultSet(HTMLParser.next(path, link), results, options);
                        return results.stop();
                    }
                }
            }
        }
        HtmlParserCharSequence baseURL = HTMLParser.getBaseURL(data, results);
        for (Pattern pattern : hrefPattern) {
            List<HtmlParserCharSequence> hrefs = data.getColumn(2, pattern);
            for (HtmlParserCharSequence hrefURL : hrefs) {
                if (HTMLParser.skip(hrefURL = HTMLParser.convert(hrefURL)) || HTMLParser.getProtocol(hrefURL = baseURL != null ? HTMLParser.parseLocation(results, baseURL, hrefURL) : HTMLParser.parseLocation(results, http, hrefURL)) == null) continue;
                HTMLParser.addToResultSet(HTMLParser.next(path, hrefURL), results, options);
            }
        }
        for (Httppattern element : linkAndFormPattern) {
            List<HtmlParserCharSequence> links = data.getColumn(element.group, element.p);
            for (HtmlParserCharSequence link : links) {
                if (HTMLParser.skip(link = HTMLParser.convert(link))) continue;
                HtmlParserCharSequence protocol = HTMLParser.getProtocol(link);
                if (protocol == null) {
                    link = link.replaceAll(httpRescue, "http://");
                    link = baseURL != null ? HTMLParser.parseLocation(results, baseURL, link) : HTMLParser.parseLocation(results, http, link);
                    protocol = HTMLParser.getProtocol(link);
                }
                if (protocol == null) continue;
                HTMLParser.addToResultSet(HTMLParser.next(path, link), results, options);
            }
        }
        if (mp != null) {
            Matcher m = mp.matcher(data);
            HtmlParserCharSequence link = null;
            while ((link = data.group(2, m)) != null) {
                link = HTMLParser.convert(link);
                HtmlParserCharSequence protocol = HTMLParser.getProtocol(link = link.trim());
                if (protocol == null && !link.contains("%2F")) {
                    link = link.replaceFirst(missingHTTPPattern, "http://www\\.");
                }
                HTMLParser.addToResultSet(HTMLParser.next(path, link), results, options);
                if (protocol != null && protocol.startsWith("directhttp://")) continue;
                Matcher mlinks = protocols.matcher(link);
                int start = -1;
                while (mlinks.find()) {
                    if (start == -1) {
                        start = mlinks.start();
                        continue;
                    }
                    HtmlParserCharSequence link2 = link.subSequence(start, mlinks.start());
                    HTMLParser.addToResultSet(HTMLParser.next(path, link2), results, options);
                    start = mlinks.start();
                }
                if (start > 0) {
                    link = link.subSequence(start);
                    HTMLParser.addToResultSet(HTMLParser.next(path, link), results, options);
                }
                if (!data.equals(link)) continue;
                return results.stop();
            }
        }
        return results.stop();
    }

    private static HtmlParserCharSequence getBaseURL(HtmlParserCharSequence data, HtmlParserResultSet results) {
        HtmlParserCharSequence baseURL = results.getBaseURL();
        if (results.isSkipBaseURL() == null) {
            HtmlParserCharSequence htmlBaseURL = null;
            for (Pattern pattern : basePattern) {
                HtmlParserCharSequence found = data.group(2, pattern);
                if (HTMLParser.skip(found)) continue;
                htmlBaseURL = found;
                break;
            }
            if (htmlBaseURL != null && HTMLParser.getProtocol(htmlBaseURL) != null) {
                results.setBaseURL(htmlBaseURL);
                baseURL = htmlBaseURL;
                results.setSkipBaseURL(true);
            } else {
                results.setSkipBaseURL(false);
            }
        }
        return baseURL;
    }

    private static HtmlParserResultSet _getHttpLinksWalker(HtmlParserCharSequenceHierarchy path, HtmlParserResultSet results, Pattern tagRegex, HtmlParserOptions options) {
        HtmlParserCharSequence data;
        block17: {
            if (options == null) {
                options = new HtmlParserOptions();
            }
            if (results == null) {
                results = new HtmlParserResultSet();
            }
            data = path.lastElement();
            results = results.start(data);
            if (data != null) {
                data = data.trim();
                path = HTMLParser.next(path, data);
            }
            if (data == null || data.length() < MIN_VALID) {
                return results.stop();
            }
            if (results.isSkipBaseURL() == null) {
                HTMLParser.getBaseURL(data, results);
            }
            while (true) {
                HtmlParserCharSequence nexttag;
                if (tagRegex == null) {
                    tagRegex = inTagsPattern;
                }
                if ((nexttag = data.group(1, tagRegex)) == null || nexttag.length() == 0) break block17;
                HTMLParser._getHttpLinksWalker(HTMLParser.next(path, nexttag), results, inTagsPattern, options);
                int tagOpen = data.indexOf(new ConcatCharSequence(TAGOPEN, nexttag));
                int tagClose = -1;
                if (tagOpen >= 0) {
                    tagClose = tagOpen + nexttag.length() + 1;
                }
                if (tagClose >= 0 && data.length() >= tagClose + 1) {
                    if (tagOpen > 0) {
                        HtmlParserCharSequence dataLeft = data.subSequence(0, tagOpen);
                        HtmlParserCharSequence dataLeft2 = data.subSequence(tagClose + 1);
                        data = null;
                        if (dataLeft.contains(TAGCLOSE)) {
                            HTMLParser._getHttpLinksWalker(HTMLParser.next(path, dataLeft), results, endTagPattern, options);
                        } else {
                            HTMLParser._getHttpLinksWalker(HTMLParser.next(path, dataLeft), results, taglessPattern, options);
                        }
                        data = dataLeft2;
                        continue;
                    }
                    if ((data = data.subSequence(tagClose + 1)).length() != 0) continue;
                    return results.stop();
                }
                if (tagClose < 0 ? (data = data.subSequence(nexttag.length())).length() == 0 : (data = data.subSequence(tagClose + 1)).length() == 0) break;
            }
            return results.stop();
        }
        if (data.length() < MIN_VALID) {
            return results.stop();
        }
        if (!(data.contains("://") || data.contains(protocolFile) || data.contains(":\\/\\/") || data.contains("www.") || protocols.matcher(data).find() || HTMLParser.checkForBase64(options, data) || HTMLParser.checkForReverse(options, data) || HTMLParser.checkForUrlEncoded(options, data) || HTMLParser.checkForUnescape(options, data) || HTMLParser.checkForUnicode(options, data))) {
            return results.stop();
        }
        int indexBefore = results.getResults().size();
        HTMLParser._getHttpLinksFinder(path, results, options);
        if (HTMLParser.deepWalkCheck(path, options, results, indexBefore)) {
            HTMLParser._getHttpLinksDeepWalker(path, results, options);
            HtmlParserCharSequence newdata = data.group(1, paramsCut1);
            if (newdata != null && !data.equals(newdata)) {
                HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(path, newdata), results, options);
            }
            if ((newdata = data.group(1, paramsCut2)) != null && !data.equals(newdata)) {
                HTMLParser._getHttpLinksDeepWalker(HTMLParser.next(path, newdata), results, options);
            }
        }
        return results.stop();
    }

    private static boolean checkForReverse(HtmlParserOptions options, HtmlParserCharSequence data) {
        return !(options != null && !options.isReverse() || !data.contains("//:ptth") && !data.contains("//:sptth") && !data.contains("//:ptf"));
    }

    private static boolean checkForUrlEncoded(HtmlParserOptions options, HtmlParserCharSequence data) {
        return (options == null || options.isUrlEncoded()) && data.find(urlEncodedProtocol);
    }

    private static boolean checkForBase64(HtmlParserOptions options, HtmlParserCharSequence data) {
        return (options == null || options.isBase64()) && data.find(checkPatternBase64);
    }

    private static boolean checkForUnicode(HtmlParserOptions options, HtmlParserCharSequence data) {
        return (options == null || options.isUnicode()) && data.find(checkPatternUnicode);
    }

    private static boolean checkForUnescape(HtmlParserOptions options, HtmlParserCharSequence data) {
        return (options == null || options.isUnescape()) && data.find(checkPatternHREFUNESCAPESRC);
    }

    private static void logInfo(HtmlParserResultSet results, String log) {
        LogInterface logger;
        if (results != null && log != null && (logger = results.getLogger()) != null) {
            logger.info(log);
        }
    }

    private static void logThrowable(HtmlParserResultSet results, Throwable throwable) {
        LogInterface logger;
        if (results != null && throwable != null && (logger = results.getLogger()) != null) {
            logger.log(throwable);
        }
    }

    private static HtmlParserCharSequence correctURL(HtmlParserCharSequenceHierarchy path, HtmlParserResultSet results, HtmlParserOptions options) {
        HtmlParserCharSequence check;
        int indexofb;
        int indexofa;
        HtmlParserCharSequence input = path.lastElement();
        if (input.contains("\\x3A)") || input.contains("\\x2F")) {
            input = HTMLParser.unicodeDecode(input);
        } else if (input.contains("\\u003A)") || input.contains("\\u002F")) {
            input = HTMLParser.unicodeDecode(input);
        }
        int specialCutOff = input.indexOf("', ");
        if (specialCutOff >= 0) {
            HtmlParserCharSequence cutoff = input.subSequence(0, specialCutOff);
            HTMLParser.logInfo(results, "Apply auto special cut off|" + input + "|" + cutoff);
            input = cutoff;
        }
        if (options.isHtmlDecode()) {
            input = HTMLParser.htmlDecode(input);
        }
        if ((indexofa = input.indexOf("&")) > 0 && input.indexOf("?") == -1 && ((indexofb = input.indexOf("#")) < 0 || indexofb > indexofa) && (check = input.subSequence(indexofa)).find(findParamPattern)) {
            boolean autoCutOff = false;
            for (HtmlParserCharSequenceHierarchy currentPath = path; currentPath != null; currentPath = currentPath.previousPath()) {
                HtmlParserCharSequence element = currentPath.lastElement();
                if (element == input || element == null || !element.find(Pattern.compile("((&|\\?)[^=]*=?|[a-z_0-9%]=)" + Pattern.quote(input.toString())))) continue;
                autoCutOff = true;
                break;
            }
            if (autoCutOff) {
                HtmlParserCharSequence cutoff = input.subSequence(0, indexofa);
                HTMLParser.logInfo(results, "Apply auto cut off|" + input + "|" + cutoff);
                input = cutoff;
            }
        }
        try {
            URL url = URLHelper.createURL((String)input.toString());
            String originalPath = url.getPath();
            if (originalPath != null) {
                String pathString = originalPath;
                pathString = specialReplacePattern.matcher(pathString).replaceAll("%27");
                if (!originalPath.equals(pathString = singleSpacePattern.matcher(pathString).replaceAll("%20"))) {
                    String ret = URLHelper.createURL((String)url.getProtocol(), (String)url.getUserInfo(), (String)url.getHost(), (int)url.getPort(), (String)pathString, (String)url.getQuery(), (String)url.getRef());
                    return new HtmlParserCharSequence(ret);
                }
            }
            if (input.equals(url.toString())) {
                return input;
            }
            return new HtmlParserCharSequence(url.toString());
        }
        catch (Throwable e) {
            HtmlParserCharSequence protocol = HTMLParser.getProtocol(input);
            if (protocol == null) {
                HTMLParser.logThrowable(results, e);
            }
            return input;
        }
    }

    private static HtmlParserCharSequence decodeURLParamEncodedURL(HtmlParserCharSequenceHierarchy path, boolean forceDecode) {
        HtmlParserCharSequence url = path.lastElement();
        if (url != null && (forceDecode || url.find(urlEncodedProtocol))) {
            for (Map.Entry<Pattern, String> replace : URLDECODE.entrySet()) {
                url = url.replaceAll(replace.getKey(), replace.getValue());
            }
        }
        return url;
    }

    private static boolean deepWalkCheck(HtmlParserCharSequenceHierarchy path, HtmlParserOptions options, HtmlParserResultSet results, int indexBefore) {
        boolean ret;
        int latestIndex = results.getLastResultIndex();
        boolean bl = ret = latestIndex == indexBefore;
        if (!ret) {
            List<HtmlParserCharSequence> subList = results.getResultsSublist(indexBefore);
            for (HtmlParserCharSequence check : subList) {
                if (HTMLParser.checkForReverse(options, check)) {
                    return true;
                }
                if (HTMLParser.checkForUnescape(options, check)) {
                    return true;
                }
                if (HTMLParser.checkForUrlEncoded(options, check)) {
                    return true;
                }
                if (HTMLParser.checkForBase64(options, check)) {
                    return true;
                }
                if (!HTMLParser.checkForUnicode(options, check)) continue;
                return true;
            }
        } else {
            HtmlParserCharSequence data = path.lastElement();
            if (HTMLParser.checkForReverse(options, data)) {
                return true;
            }
            if (HTMLParser.checkForUnescape(options, data)) {
                return true;
            }
            if (HTMLParser.checkForUrlEncoded(options, data)) {
                return true;
            }
            if (HTMLParser.checkForBase64(options, data)) {
                return true;
            }
            if (HTMLParser.checkForUnicode(options, data)) {
                return true;
            }
        }
        return ret;
    }

    public static String getFormInputHidden(String data) {
        return HTMLParser.joinMap(HTMLParser.getInputHiddenFields(data), "=", "&");
    }

    public static String[] getHttpLinks(String data, String url) {
        return HTMLParser.getHttpLinks(data, url, null);
    }

    public static String[] getHttpLinks(String data, String url, HtmlParserResultSet results) {
        Collection<String> links = HTMLParser.getHttpLinksIntern(data, url, results);
        if (links == null || links.size() == 0) {
            return new String[0];
        }
        LinkedHashSet<String> tmplinks = new LinkedHashSet<String>(links.size());
        block0: while (links.size() > 0) {
            Iterator<String> it = links.iterator();
            while (it.hasNext()) {
                String link = it.next();
                it.remove();
                if (link.contains("...")) {
                    String search = Pattern.quote(link);
                    search = search.replaceAll("(\\.{3,})([^\\.])", Matcher.quoteReplacement("\\E") + ".*?" + Matcher.quoteReplacement("\\Q") + "$2");
                    Iterator<String> it2 = links.iterator();
                    while (it2.hasNext()) {
                        String replacement = it2.next();
                        if (replacement.contains("...") || !replacement.matches("(?i)" + search)) continue;
                        tmplinks.add(replacement);
                        it2.remove();
                        continue block0;
                    }
                }
                tmplinks.add(link);
            }
        }
        links = null;
        return tmplinks.toArray(new String[tmplinks.size()]);
    }

    public static Collection<String> getHttpLinksIntern(String content, String baseURLString) {
        return HTMLParser.getHttpLinksIntern(content, baseURLString, null);
    }

    public static Collection<String> getHttpLinksIntern(String content, String baseURLString, HtmlParserResultSet results) {
        Collection<String> ret;
        if (content == null || content.length() == 0) {
            return null;
        }
        HtmlParserCharSequence data = new HtmlParserCharSequence(content);
        if ((data = data.trim()).length() == 0) {
            return null;
        }
        data = data.replaceAll(ltPattern, ">");
        data = data.replaceAll(gtPattern, "<");
        data = data.replaceAll(ampPattern, "&");
        data = data.replaceAll(quotPattern, "\"");
        data = data.replaceAll(brPattern, "\r\n");
        data = data.replaceAll(wbrPattern, "");
        data = data.replaceAll(Pattern.compile("</?(i|b|u|s)>"), "");
        data = data.replaceAll(Pattern.compile("(?s)\\[(url|link)\\](.*?)\\[/(\\2)\\]"), "<$2>");
        HtmlParserResultSet resultSet = results != null ? results : new HtmlParserResultSet();
        if (baseURLString != null && HTMLParser.isSupportedProtocol(baseURLString)) {
            resultSet.setBaseURL(new HtmlParserCharSequence(baseURLString));
        }
        HTMLParser._getHttpLinksWalker(HTMLParser.next(null, data), resultSet, null, null);
        data = null;
        if (Boolean.TRUE.equals(resultSet.isSkipBaseURL()) && resultSet.getBaseURL() != null) {
            resultSet.remove(resultSet.getBaseURL());
        }
        if ((ret = resultSet.exportResults()).size() == 0) {
            return null;
        }
        return ret;
    }

    public static HashMap<String, String> getInputHiddenFields(String data) {
        Pattern intput1 = Pattern.compile("(?s)<\\s*input([^>]*type\\s*=\\s*['\"]?hidden['\"]?[^>]*?)[/]?>", 2);
        Pattern intput2 = Pattern.compile("name\\s*=\\s*['\"]([^'\"]*?)['\"]", 2);
        Pattern intput3 = Pattern.compile("value\\s*=\\s*['\"]([^'\"]*?)['\"]", 2);
        Pattern intput4 = Pattern.compile("name\\s*=\\s*([^\\s]*)", 2);
        Pattern intput5 = Pattern.compile("value\\s*=\\s*([^\\s]*)", 2);
        Matcher matcher1 = intput1.matcher(data);
        HashMap<String, String> ret = new HashMap<String, String>();
        while (matcher1.find()) {
            Matcher matcher2 = intput2.matcher(matcher1.group(1) + " ");
            Matcher matcher3 = intput3.matcher(matcher1.group(1) + " ");
            Matcher matcher4 = intput4.matcher(matcher1.group(1) + " ");
            Matcher matcher5 = intput5.matcher(matcher1.group(1) + " ");
            boolean iscompl = false;
            String value = null;
            String key = null;
            if (matcher2.find()) {
                iscompl = true;
                key = matcher2.group(1);
            } else if (matcher4.find()) {
                iscompl = true;
                key = matcher4.group(1);
            }
            if (matcher3.find() && iscompl) {
                value = matcher3.group(1);
            } else if (matcher5.find() && iscompl) {
                value = matcher5.group(1);
            } else {
                iscompl = false;
            }
            ret.put(key, value);
        }
        return ret;
    }

    private static HtmlParserCharSequence getProtocol(HtmlParserCharSequence url) {
        HtmlParserCharSequence ret;
        HtmlParserCharSequence htmlParserCharSequence = ret = url != null ? url.group(1, LINKPROTOCOL) : null;
        if (ret != null) {
            if (ret.contains("\\x3A)") || ret.contains("\\x2F")) {
                ret = HTMLParser.unicodeDecode(ret);
            } else if (ret.contains("\\u003A)") || ret.contains("\\u002F")) {
                ret = HTMLParser.unicodeDecode(ret);
            }
        }
        return ret;
    }

    private static HtmlParserCharSequence unicodeDecode(CharSequence cs) {
        CharSequence decoded = Encoding.unicodeDecode((CharSequence)cs, (boolean)true);
        if (!CharSequenceUtils.contentEquals((CharSequence)decoded, (CharSequence)cs)) {
            return new HtmlParserCharSequence(decoded);
        }
        if (cs instanceof HtmlParserCharSequence) {
            return (HtmlParserCharSequence)cs;
        }
        return new HtmlParserCharSequence(cs);
    }

    private static HtmlParserCharSequence htmlDecode(CharSequence cs) {
        String decoded = Encoding.htmlOnlyDecode((String)cs.toString(), (boolean)true);
        if (!CharSequenceUtils.contentEquals((CharSequence)decoded, (CharSequence)cs)) {
            return new HtmlParserCharSequence(decoded);
        }
        if (cs instanceof HtmlParserCharSequence) {
            return (HtmlParserCharSequence)cs;
        }
        return new HtmlParserCharSequence(cs);
    }

    public static String getProtocol(String url) {
        HtmlParserCharSequence ret;
        if (url != null && (ret = HTMLParser.getProtocol(new HtmlParserCharSequence(url))) != null) {
            return ret.toString();
        }
        return null;
    }

    public static boolean isSupportedProtocol(String url) {
        if (url != null) {
            return HTMLParser.getProtocol(new HtmlParserCharSequence(url)) != null;
        }
        return false;
    }

    public static String joinMap(Map<String, String> map, String delPair, String delMap) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(delMap);
            }
            buffer.append(entry.getKey());
            buffer.append(delPair);
            buffer.append(entry.getValue());
        }
        return buffer.toString();
    }

    private static HtmlParserCharSequence parseLocation(HtmlParserResultSet results, HtmlParserCharSequence baseURL, HtmlParserCharSequence loc) {
        return HTMLParser.parseLocation(results, baseURL, loc, false);
    }

    private static HtmlParserCharSequence parseLocation(HtmlParserResultSet results, HtmlParserCharSequence baseURL, HtmlParserCharSequence loc, boolean schemeAndHostOnlyMode) {
        if (HTMLParser.getProtocol(loc) != null) {
            return loc;
        }
        HtmlParserCharSequence baseProtocol = HTMLParser.getProtocol(baseURL);
        if (loc == null || baseURL == null || baseProtocol == null || loc.length() == 0) {
            return null;
        }
        if (loc.matches(parseLocationPatternSchemeHostLoc)) {
            HtmlParserCharSequence root = baseURL.group(1, mergePattern_Root);
            return new HtmlParserCharSequence(new ConcatCharSequence(root, loc));
        }
        if (loc.startsWith("//")) {
            return new HtmlParserCharSequence(new ConcatCharSequence(baseProtocol.subSequence(0, baseProtocol.length() - 2), loc));
        }
        if (schemeAndHostOnlyMode) {
            return null;
        }
        if (loc.startsWith("/")) {
            HtmlParserCharSequence root = baseURL.group(1, mergePattern_Root);
            if (root != null) {
                return new HtmlParserCharSequence(new ConcatCharSequence(root, loc));
            }
        } else {
            if (loc.startsWith("./")) {
                HtmlParserCharSequence path = baseURL.group(1, mergePattern_Directory);
                if (path != null) {
                    return new HtmlParserCharSequence(new ConcatCharSequence(path, loc.subSequence(2)));
                }
                return HTMLParser.parseLocation(results, baseURL, loc.subSequence(1));
            }
            if (loc.startsWith("../")) {
                try {
                    String url = URLHelper.parseLocation((URL)new URL(baseURL.toURL()), (String)loc.toURL());
                    return new HtmlParserCharSequence(url);
                }
                catch (Throwable e) {
                    HTMLParser.logThrowable(results, e);
                }
            } else {
                if (loc.startsWith("#")) {
                    return null;
                }
                if (loc.startsWith("?")) {
                    HtmlParserCharSequence path = baseURL.group(1, mergePattern_Path);
                    if (path != null) {
                        return new HtmlParserCharSequence(new ConcatCharSequence(path, loc));
                    }
                    HtmlParserCharSequence root = baseURL.group(1, mergePattern_Root);
                    if (root != null) {
                        return new HtmlParserCharSequence(new ConcatCharSequence(root, "/", loc));
                    }
                } else if (loc.startsWith("&")) {
                    try {
                        String url = URLHelper.parseLocation((URL)new URL(baseURL.toURL()), (String)loc.toURL());
                        return new HtmlParserCharSequence(url);
                    }
                    catch (Throwable e) {
                        HTMLParser.logThrowable(results, e);
                    }
                } else {
                    HtmlParserCharSequence path = baseURL.group(1, mergePattern_Directory);
                    if (path != null) {
                        return new HtmlParserCharSequence(new ConcatCharSequence(path, loc));
                    }
                    HtmlParserCharSequence root = baseURL.group(1, mergePattern_Root);
                    if (root != null) {
                        return new HtmlParserCharSequence(new ConcatCharSequence(root, "/", loc));
                    }
                }
            }
        }
        return null;
    }

    static {
        try {
            mp = Pattern.compile("(\\\\\"|\"|')?((" + protocolPrefixes + "|www\\.).+?(?=((\\s+" + protocolPrefixes + ")|\\1|<|>|\\[/|\r|\n|\f|\t|$|';|'\\)|\"\\s*|'\\+)))", 34);
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        MIN_VALID = "ftp://1.23".length();
        checkPatternBase64 = Pattern.compile("([A-Za-z0-9+/]{16,}={0,2})", 32);
        checkPatternUnicode = Pattern.compile("(\\\\u[0-9a-fA-F]{2,})", 32);
        unescapePattern = Pattern.compile("unescape\\(('|\")(.*?)(\\1)", 34);
        checkPatternHREFUNESCAPESRC = Pattern.compile("(href\\s*=|unescape|src\\s*=).", 34);
        checkPatternHREFSRC = Pattern.compile(".*?(href\\s*=|src\\s*=).+", 34);
        unhexPattern = Pattern.compile("(([0-9a-fA-F]{2}){" + MIN_VALID + ",})");
        paramsCut1 = Pattern.compile("://[^\r\n\"' ]*?/[^\r\n\"']+\\?.[^\r\n\"']*?=([^\r\n\"']*?)($|\r|\n|\"|')", 34);
        paramsCut2 = Pattern.compile("://[^\r\n\"' ]*?/[^\r\n\"']*?\\?([^\r\n\"']*?)($|\r|\n|\"|')", 34);
        inTagsPattern = Pattern.compile("<([^<]*)>");
        endTagPattern = Pattern.compile("^([^>]*)>", 32);
        taglessPattern = Pattern.compile("^(.*)$", 32);
        directHTTP = new HtmlParserCharSequence("directhttp://");
        httpviajd = new HtmlParserCharSequence("httpviajd://");
        httpsviajd = new HtmlParserCharSequence("httpsviajd://");
        http = new HtmlParserCharSequence("http://");
        dummyCnl = Pattern.compile("https?://dummycnl.jdownloader.org/#?[a-f0-9A-F]+");
        httpRescue = Pattern.compile("h.{2,3}://", 2);
        tagsPattern = Pattern.compile(".*<.*>.*", 32);
        singleSpacePattern = Pattern.compile(" ");
        findSpacePattern = Pattern.compile("\\s");
        hdotsPattern = Pattern.compile("h.{2,3}://", 2);
        specialReplacePattern = Pattern.compile("'");
        questionMarkPattern = Pattern.compile("\\?");
        maybeHostPattern = Pattern.compile("^([^/]+)/.+");
        missingHTTPPattern = Pattern.compile("^www\\.", 2);
        urlEncodedProtocol = Pattern.compile("(%3A%2F%2F|%253A%252F%252F|%3A//|%3A%2F/|%3A/%2F|:%2F%2F|:%2F/|:/%2F)", 2);
        escapedJSONPattern = Pattern.compile("\\\\");
        TAGOPEN = String.valueOf('<');
        TAGCLOSE = String.valueOf('>');
        findParamPattern = Pattern.compile("^&[a-zA-Z0-9%]+=.{0,1}");
        URLDECODE = new LinkedHashMap();
        URLDECODE.put(Pattern.compile("%25"), "%");
        URLDECODE.put(Pattern.compile("%2F"), "/");
        URLDECODE.put(Pattern.compile("%3A"), ":");
        URLDECODE.put(Pattern.compile("%3F"), "?");
        URLDECODE.put(Pattern.compile("%3D"), "=");
        URLDECODE.put(Pattern.compile("%26"), "&");
        URLDECODE.put(Pattern.compile("%23"), "#");
        ltPattern = Pattern.compile("&lt;");
        gtPattern = Pattern.compile("&gt;");
        ampPattern = Pattern.compile("&amp;");
        quotPattern = Pattern.compile("&quot;");
        brPattern = Pattern.compile("<br[^>]*>");
        wbrPattern = Pattern.compile("<wbr[^>]*>");
        parseLocationPatternSchemeHostLoc = Pattern.compile("^:\\d+/.*");
    }

    protected static class HexHtmlParserCharSequence
    extends HtmlParserCharSequence {
        protected HexHtmlParserCharSequence(CharSequence charSequence) {
            super(charSequence);
        }

        @Override
        protected char rawCharAt(int index) {
            char h1 = this.charSequence.charAt(index * 4 + 2);
            char h2 = this.charSequence.charAt(index * 4 + 3);
            return (char)Long.parseLong("" + h1 + h2, 16);
        }

        @Override
        public int getStopIndex() {
            return super.getStopIndex() / 4;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = this.getStartIndex(); i < this.getStopIndex(); ++i) {
                sb.append(this.charAt(i));
            }
            return sb.toString();
        }
    }

    private static final class HtmlParserOptions {
        private final boolean reverse;
        private final boolean hex;
        private final boolean base64;
        private final boolean urlEncoded;
        private final boolean unescape;
        private final boolean unicode;
        private final boolean htmlDecode;

        private boolean isReverse() {
            return this.reverse;
        }

        private boolean isHex() {
            return this.hex;
        }

        private boolean isBase64() {
            return this.base64;
        }

        private boolean isUrlEncoded() {
            return this.urlEncoded;
        }

        private boolean isUnicode() {
            return this.unicode;
        }

        private boolean isHtmlDecode() {
            return this.htmlDecode;
        }

        private boolean isUnescape() {
            return this.unescape;
        }

        private HtmlParserOptions() {
            this(true, true, true, true, true, true, true);
        }

        private HtmlParserOptions(boolean reverse, boolean hex, boolean base64, boolean urlEncoded, boolean unescape, boolean unicode, boolean htmlDecode) {
            this.reverse = reverse;
            this.hex = hex;
            this.base64 = base64;
            this.urlEncoded = urlEncoded;
            this.unescape = unescape;
            this.unicode = unicode;
            this.htmlDecode = htmlDecode;
        }

        private HtmlParserOptions reverse(boolean reverse) {
            return new HtmlParserOptions(reverse, this.hex, this.base64, this.urlEncoded, this.unescape, this.unicode, this.htmlDecode);
        }

        private HtmlParserOptions hex(boolean hex) {
            return new HtmlParserOptions(this.reverse, hex, this.base64, this.urlEncoded, this.unescape, this.unicode, this.htmlDecode);
        }

        private HtmlParserOptions base64(boolean base64) {
            return new HtmlParserOptions(this.reverse, this.hex, base64, this.urlEncoded, this.unescape, this.unicode, this.htmlDecode);
        }

        private HtmlParserOptions urlEncoded(boolean urlEncoded) {
            return new HtmlParserOptions(this.reverse, this.hex, this.base64, urlEncoded, this.unescape, this.unicode, this.htmlDecode);
        }

        private HtmlParserOptions unescape(boolean unescape) {
            return new HtmlParserOptions(this.reverse, this.hex, this.base64, this.urlEncoded, unescape, this.unicode, this.htmlDecode);
        }

        private HtmlParserOptions unicode(boolean unicode) {
            return new HtmlParserOptions(this.reverse, this.hex, this.base64, this.urlEncoded, this.unescape, unicode, this.htmlDecode);
        }

        private HtmlParserOptions htmlDecode(boolean decode) {
            return new HtmlParserOptions(this.reverse, this.hex, this.base64, this.urlEncoded, this.unescape, this.unicode, decode);
        }
    }

    static final class Httppattern {
        public Pattern p;
        public int group;

        public Httppattern(Pattern p, int group) {
            this.p = p;
            this.group = group;
        }
    }

    public static class HtmlParserResultSet {
        protected final ArrayList<HtmlParserCharSequence> results = new ArrayList();
        protected final HashSet<HtmlParserCharSequence> dupeCheck = new HashSet();
        private HtmlParserCharSequence baseURL = null;
        private Boolean skipBaseURL = null;

        protected void setSkipBaseURL(Boolean skipBaseURL) {
            this.skipBaseURL = skipBaseURL;
        }

        protected Boolean isSkipBaseURL() {
            return this.skipBaseURL;
        }

        protected HtmlParserResultSet stop() {
            return this;
        }

        protected HtmlParserResultSet start(HtmlParserCharSequence data) {
            return this;
        }

        public HtmlParserCharSequence getBaseURL() {
            return this.baseURL;
        }

        private void setBaseURL(HtmlParserCharSequence baseURL) {
            if (baseURL != null && !baseURL.equals("about:blank")) {
                this.baseURL = baseURL;
            }
        }

        public boolean add(HtmlParserCharSequence e) {
            if (e != null && this.dupeCheck.add(e)) {
                this.results.add(e);
                return true;
            }
            return false;
        }

        public LogInterface getLogger() {
            return null;
        }

        public boolean remove(HtmlParserCharSequence e) {
            if (e != null && this.dupeCheck.remove(e)) {
                this.results.remove(e);
                return true;
            }
            return false;
        }

        public int getLastResultIndex() {
            return this.results.size();
        }

        protected List<HtmlParserCharSequence> getResults() {
            return this.results;
        }

        protected Collection<String> exportResults() {
            ArrayList<String> ret = new ArrayList<String>();
            for (HtmlParserCharSequence result : this.getResults()) {
                String url = result.toURL();
                if (!StringUtils.isNotEmpty((String)url)) continue;
                ret.add(url);
            }
            return ret;
        }

        public List<HtmlParserCharSequence> getResultsSublist(int index) {
            return this.results.subList(index, this.results.size());
        }

        public boolean contains(HtmlParserCharSequence data) {
            return data != null && this.dupeCheck.contains(data);
        }
    }

    public static class HtmlParserCharSequence
    implements CharSequence {
        final char[] chars;
        final CharSequence charSequence;
        final CharSequence source;
        final int start;
        final int end;
        HashMap<Pattern, Boolean> findsPattern = null;
        HashMap<Pattern, Boolean> matchesPattern = null;
        HashMap<CharSequence, Boolean> containsCharSequence = null;
        int hashCodeCache = 0;
        int hashCode = -1;

        private HtmlParserCharSequence(HtmlParserCharSequence source, int start, int end) {
            this.chars = source.chars;
            this.charSequence = source.charSequence;
            this.source = source;
            this.start = start;
            this.end = end;
        }

        private Boolean getValue(Map<Pattern, Boolean> map, Pattern key) {
            if (map == null || map.size() == 0) {
                return null;
            }
            Boolean ret = map.get(key);
            if (ret != null || map.containsKey(key)) {
                return ret;
            }
            for (Map.Entry<Pattern, Boolean> entry : map.entrySet()) {
                if (!entry.getKey().pattern().equals(key.pattern()) || entry.getKey().flags() != key.flags()) continue;
                return entry.getValue();
            }
            return null;
        }

        private HtmlParserCharSequence(CharSequence source) {
            this.chars = null;
            this.charSequence = source;
            this.source = source;
            this.start = 0;
            this.end = source.length();
        }

        public int getRetainedLength() {
            if (this.chars != null) {
                return this.chars.length;
            }
            return this.charSequence.length();
        }

        @Override
        public char charAt(int index) {
            if ((index += this.getStartIndex()) > this.getStopIndex()) {
                throw new IndexOutOfBoundsException("index " + index + " > end " + this.getStopIndex());
            }
            return this.rawCharAt(index);
        }

        protected char rawCharAt(int index) {
            if (this.chars != null) {
                return this.chars[index];
            }
            return this.charSequence.charAt(index);
        }

        public int hashCode() {
            if (this.hashCodeCache != this.hashCode) {
                int h = 0;
                int length = this.length();
                if (length > 0) {
                    for (int i = 0; i < length; ++i) {
                        h = 31 * h + this.charAt(i);
                    }
                }
                this.hashCodeCache = h;
                this.hashCode = h;
                return h;
            }
            return this.hashCodeCache;
        }

        protected <T> T getSource(Class<? extends CharSequence> T2) {
            CharSequence ret = this.source;
            if (T2.isAssignableFrom(ret.getClass())) {
                return (T)ret;
            }
            return null;
        }

        public boolean contains(CharSequence s) {
            Boolean result;
            Boolean bl = result = this.containsCharSequence != null ? this.containsCharSequence.get(s) : null;
            if (result != null) {
                return result;
            }
            HtmlParserCharSequence source = (HtmlParserCharSequence)this.getSource(HtmlParserCharSequence.class);
            if (source != null && source.containsCharSequence != null && Boolean.FALSE.equals(result = source.containsCharSequence.get(s))) {
                return false;
            }
            result = this.indexOf(s, 0) >= 0;
            if (this.containsCharSequence == null) {
                this.containsCharSequence = new HashMap();
            }
            this.containsCharSequence.put(s, result);
            return result;
        }

        public boolean equals(CharSequence anotherString) {
            int n;
            if (this == anotherString) {
                return true;
            }
            if (anotherString != null && (n = this.length()) == anotherString.length()) {
                int i = 0;
                while (n-- != 0) {
                    if (this.charAt(i) != anotherString.charAt(i)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject != null && anObject instanceof CharSequence) {
                return this.equals((CharSequence)anObject);
            }
            return false;
        }

        public int getStartIndex() {
            return this.start;
        }

        public int getStopIndex() {
            return this.end;
        }

        protected int indexOf(int sourceOffset, int sourceCount, CharSequence target, int targetOffset, int targetCount, int fromIndex) {
            if (fromIndex >= sourceCount) {
                return targetCount == 0 ? sourceCount : -1;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (targetCount == 0) {
                return fromIndex;
            }
            char first = target.charAt(targetOffset);
            int max = sourceOffset + sourceCount - targetCount;
            if (this.chars != null) {
                for (int i = sourceOffset + fromIndex; i <= max; ++i) {
                    if (this.chars[i] != first) {
                        while (++i <= max && this.chars[i] != first) {
                        }
                    }
                    if (i > max) continue;
                    int j = i + 1;
                    int end = j + targetCount - 1;
                    int k = targetOffset + 1;
                    while (j < end && this.chars[j] == target.charAt(k)) {
                        ++j;
                        ++k;
                    }
                    if (j != end) continue;
                    return i - sourceOffset;
                }
            } else {
                for (int i = sourceOffset + fromIndex; i <= max; ++i) {
                    if (this.rawCharAt(i) != first) {
                        while (++i <= max && this.rawCharAt(i) != first) {
                        }
                    }
                    if (i > max) continue;
                    int j = i + 1;
                    int end = j + targetCount - 1;
                    int k = targetOffset + 1;
                    while (j < end && this.rawCharAt(j) == target.charAt(k)) {
                        ++j;
                        ++k;
                    }
                    if (j != end) continue;
                    return i - sourceOffset;
                }
            }
            return -1;
        }

        public int indexOf(CharSequence str) {
            return this.indexOf(str, 0);
        }

        public int count(CharSequence str, int countMax) {
            return this.count(str, 0, countMax);
        }

        public int count(CharSequence str, int fromIndex, int countMax) {
            int index;
            int ret = 0;
            int lastIndex = fromIndex;
            while ((index = this.indexOf(str, lastIndex)) != -1) {
                lastIndex = index;
                if (countMax <= 0 || ++ret < countMax) continue;
                break;
            }
            return ret;
        }

        public int indexOf(CharSequence indexOf, int fromIndex) {
            return this.indexOf(this.getStartIndex(), this.length(), indexOf, 0, indexOf.length(), fromIndex);
        }

        @Override
        public int length() {
            return this.getStopIndex() - this.getStartIndex();
        }

        public boolean matches(Pattern regex) {
            Boolean result = this.getValue(this.matchesPattern, regex);
            if (result != null) {
                return result;
            }
            HtmlParserCharSequence source = (HtmlParserCharSequence)this.getSource(HtmlParserCharSequence.class);
            if (source != null && source.matchesPattern != null) {
                result = this.getValue(source.matchesPattern, regex);
                if (!regex.pattern().contains("^") && !regex.pattern().contains("$") && Boolean.FALSE.equals(result)) {
                    return false;
                }
            }
            result = regex.matcher(this).matches();
            if (this.matchesPattern == null) {
                this.matchesPattern = new HashMap();
            }
            this.matchesPattern.put(regex, result);
            return result;
        }

        public boolean find(Pattern regex) {
            Boolean result = this.getValue(this.findsPattern, regex);
            if (result != null) {
                return result;
            }
            HtmlParserCharSequence source = (HtmlParserCharSequence)this.getSource(HtmlParserCharSequence.class);
            if (source != null && source.findsPattern != null) {
                result = this.getValue(source.findsPattern, regex);
                if (!regex.pattern().contains("^") && !regex.pattern().contains("$") && Boolean.FALSE.equals(result)) {
                    return false;
                }
            }
            result = regex.matcher(this).find();
            if (this.findsPattern == null) {
                this.findsPattern = new HashMap();
            }
            this.findsPattern.put(regex, result);
            return result;
        }

        public int count(Pattern regex, int countMax) {
            boolean findResult = this.find(regex);
            if (!findResult) {
                return 0;
            }
            if (findResult && countMax == 1) {
                return 1;
            }
            Matcher matcher = regex.matcher(this);
            int ret = 0;
            while (matcher.find() && ++ret < countMax) {
            }
            return ret;
        }

        public HtmlParserCharSequence replaceAll(Pattern regex, String replacement) {
            if (replacement == null) {
                throw new NullPointerException("replacement");
            }
            if (!this.find(regex)) {
                return this;
            }
            Matcher matcher = regex.matcher(this);
            matcher.reset();
            if (!matcher.find()) {
                return this;
            }
            StringBuffer sb = new StringBuffer();
            do {
                matcher.appendReplacement(sb, replacement);
            } while (matcher.find());
            matcher.appendTail(sb);
            if (this.equals(sb)) {
                return this;
            }
            return new HtmlParserCharSequence(sb);
        }

        public HtmlParserCharSequence replaceFirst(Pattern regex, String replacement) {
            if (replacement == null) {
                throw new NullPointerException("replacement");
            }
            if (!this.find(regex)) {
                return this;
            }
            Matcher matcher = regex.matcher(this);
            matcher.reset();
            if (!matcher.find()) {
                return this;
            }
            StringBuffer sb = new StringBuffer();
            matcher.appendReplacement(sb, replacement);
            matcher.appendTail(sb);
            if (this.equals(sb)) {
                return this;
            }
            return new HtmlParserCharSequence(sb);
        }

        public boolean endsWith(String suffix) {
            return this.startsWith(suffix, this.length() - suffix.length());
        }

        public boolean startsWith(CharSequence prefix) {
            return this.startsWith(prefix, 0);
        }

        public boolean startsWith(CharSequence prefix, int toffset) {
            int to = toffset;
            int po = 0;
            int pc = prefix.length();
            if (toffset < 0 || toffset > this.length() - pc) {
                return false;
            }
            while (--pc >= 0) {
                if (this.charAt(to++) == prefix.charAt(po++)) continue;
                return false;
            }
            return true;
        }

        public List<HtmlParserCharSequence> getColumn(int group, Pattern pattern) {
            HtmlParserCharSequence match;
            ArrayList<HtmlParserCharSequence> result = new ArrayList<HtmlParserCharSequence>();
            if (!this.find(pattern)) {
                return result;
            }
            Matcher matcher = pattern.matcher(this);
            while ((match = this.group(group, matcher)) != null) {
                result.add(match);
            }
            return result;
        }

        private HtmlParserCharSequence group(int group, Matcher matcher) {
            if (!matcher.find()) {
                return null;
            }
            return this.subSequence(matcher.start(group), matcher.end(group));
        }

        public HtmlParserCharSequence group(int group, Pattern pattern) {
            if (!this.find(pattern)) {
                return null;
            }
            Matcher matcher = pattern.matcher(this);
            return this.group(group, matcher);
        }

        public HtmlParserCharSequence subSequence(int start) {
            if (start > 0) {
                return new HtmlParserCharSequence(this, this.getStartIndex() + start, this.getStopIndex());
            }
            return this;
        }

        @Override
        public HtmlParserCharSequence subSequence(int start, int end) {
            if (start > 0 || end < this.getStopIndex()) {
                return new HtmlParserCharSequence(this, this.getStartIndex() + start, this.getStartIndex() + end);
            }
            return this;
        }

        @Override
        public String toString() {
            if (this.chars != null) {
                return new String(this.chars, this.getStartIndex(), this.length());
            }
            return this.charSequence.subSequence(this.getStartIndex(), this.getStopIndex()).toString();
        }

        public String toURL() {
            return "" + this.toCharSequenceURL();
        }

        public CharSequence toCharSequenceURL() {
            int slash = 0;
            for (int index = 0; index < this.length(); ++index) {
                if (this.charAt(index) != '/' || ++slash != 3) continue;
                if (this.length() - index > 1) {
                    HtmlParserCharSequence host = this.subSequence(0, index);
                    HtmlParserCharSequence rest = this.subSequence(index);
                    ConcatCharSequence ret = new ConcatCharSequence(host, Encoding.urlEncodeCharSequence_light((CharSequence)rest));
                    return ret;
                }
                return this;
            }
            return this;
        }

        public HtmlParserCharSequence trim() {
            int st;
            int len = this.length();
            for (st = 0; st < len && this.charAt(st) <= ' '; ++st) {
            }
            while (st < len && this.charAt(len - 1) <= ' ') {
                --len;
            }
            return st > 0 || len < this.length() ? this.subSequence(st, len) : this;
        }
    }

    public static class HtmlParserCharSequenceHierarchy {
        private final HtmlParserCharSequence htmlParserCharSequence;
        private final HtmlParserCharSequenceHierarchy previous;

        public HtmlParserCharSequenceHierarchy(HtmlParserCharSequence htmlParserCharSequence) {
            this(null, htmlParserCharSequence);
        }

        public HtmlParserCharSequenceHierarchy(HtmlParserCharSequenceHierarchy previous, HtmlParserCharSequence htmlParserCharSequence) {
            this.previous = previous;
            this.htmlParserCharSequence = htmlParserCharSequence;
        }

        public HtmlParserCharSequenceHierarchy previousPath() {
            return this.previous;
        }

        public HtmlParserCharSequence lastElement() {
            return this.htmlParserCharSequence;
        }

        public boolean contains(HtmlParserCharSequence htmlParserCharSequence) {
            for (HtmlParserCharSequenceHierarchy current = this; current != null; current = current.previousPath()) {
                HtmlParserCharSequence elem = current.lastElement();
                if (elem == null || !elem.equals(htmlParserCharSequence)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ConcatCharSequence
    implements CharSequence {
        private final CharSequence[] charSequences;
        private final int offset;
        private final int end;
        private final int length;

        public ConcatCharSequence(CharSequence ... charSequences) {
            this.charSequences = charSequences;
            int length = 0;
            for (CharSequence charSequence : charSequences) {
                length += charSequence.length();
            }
            this.offset = 0;
            this.end = length;
            this.length = length;
        }

        private ConcatCharSequence(int offset, int start, int end, ConcatCharSequence concatCharSequence) {
            this.charSequences = concatCharSequence.charSequences;
            this.end = end;
            this.offset = offset + start;
            this.length = end - start;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.length());
            sb.ensureCapacity(this.length());
            for (int index = 0; index < this.length(); ++index) {
                sb.append(this.charAt(index));
            }
            return sb.toString();
        }

        @Override
        public char charAt(int index) {
            int offsetEnd = this.end + this.offset;
            if ((index += this.offset) < 0 || index >= offsetEnd) {
                throw new IndexOutOfBoundsException("Index " + index);
            }
            int range = 0;
            for (CharSequence charSequence : this.charSequences) {
                if (index < offsetEnd && index < range + charSequence.length()) {
                    return charSequence.charAt(index - range);
                }
                range += charSequence.length();
            }
            throw new IndexOutOfBoundsException("Index " + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ConcatCharSequence(this.offset, start, end, this);
        }
    }
}

