/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import jd.plugins.Account;
import jd.plugins.AccountInfo;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.clickcaptcha.ClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CloudflareTurnstileChallenge;
import org.jdownloader.captcha.v2.challenge.cutcaptcha.CutCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;

public class CaptchaType {
    private Boolean enabled = null;
    private AccountInfo accountInfo = null;
    final CAPTCHA_TYPE ctype;

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    protected void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public CaptchaType(CAPTCHA_TYPE ctype) {
        this.ctype = ctype;
    }

    private boolean isEnabled(Boolean booleanValue) {
        return booleanValue == null || booleanValue != false;
    }

    private String getEnabledProperty() {
        return "captcha_type_" + (Object)((Object)this.ctype) + "_enabled";
    }

    public boolean isEnabled() {
        Account ac = this.getAccount();
        boolean ret = ac == null ? this.isEnabled(this.enabled) : ac.getBooleanProperty(this.getEnabledProperty(), this.isEnabled(this.enabled)).booleanValue();
        return ret;
    }

    protected Account getAccount() {
        AccountInfo ai = this.getAccountInfo();
        if (ai == null) {
            return null;
        }
        return ai.getAccount();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Account ac = this.getAccount();
        if (ac != null) {
            ac.setProperty(this.getEnabledProperty(), this.enabled);
        }
    }

    public CAPTCHA_TYPE getCAPTCHA_TYPE_STATIC() {
        return this.ctype;
    }

    public String toString() {
        return (Object)((Object)this.ctype) + " | enabled: " + this.enabled;
    }

    public static enum CAPTCHA_TYPE {
        IMAGE{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof ImageCaptchaChallenge;
            }

            @Override
            public String getDisplayName() {
                return "Image Captcha";
            }

            @Override
            public String getDemoUrl() {
                return null;
            }

            @Override
            public String getDescription() {
                return "Simple image-based captcha where you need to solve a visual challenge";
            }

            @Override
            public String getDomain() {
                return null;
            }
        }
        ,
        SINGLE_CLICK_CAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof ClickCaptchaChallenge;
            }

            @Override
            public String getDisplayName() {
                return "Single Click image Captcha";
            }

            @Override
            public String getDemoUrl() {
                return null;
            }

            @Override
            public String getDescription() {
                return "Simple click-based captcha where you click on a single element";
            }

            @Override
            public String getDomain() {
                return null;
            }
        }
        ,
        MULTI_CLICK_CAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof MultiClickCaptchaChallenge;
            }

            @Override
            public String getDisplayName() {
                return "Multi Click image Captcha";
            }

            @Override
            public String getDemoUrl() {
                return null;
            }

            @Override
            public String getDescription() {
                return "Advanced click-based captcha requiring multiple clicks on specific elements";
            }

            @Override
            public String getDomain() {
                return null;
            }
        }
        ,
        RECAPTCHA_V2_INVISIBLE{

            @Override
            public boolean canHandle(Challenge<?> c) {
                if (!(c instanceof RecaptchaV2Challenge)) {
                    return false;
                }
                RecaptchaV2Challenge cl = (RecaptchaV2Challenge)c;
                return cl.isInvisible();
            }

            @Override
            public String getDisplayName() {
                return "reCAPTCHA v2 Invisible";
            }

            @Override
            public String getDemoUrl() {
                return "https://www.google.com/recaptcha/api2/demo";
            }

            @Override
            public String getDescription() {
                return "Google's invisible reCAPTCHA v2 that runs in the background without user interaction";
            }

            @Override
            public String getDomain() {
                return "google.com";
            }
        }
        ,
        RECAPTCHA_V2_ENTERPRISE{

            @Override
            public boolean canHandle(Challenge<?> c) {
                if (!(c instanceof RecaptchaV2Challenge)) {
                    return false;
                }
                RecaptchaV2Challenge cl = (RecaptchaV2Challenge)c;
                return cl.isEnterprise();
            }

            @Override
            public String getDisplayName() {
                return "reCAPTCHA v2 Enterprise";
            }

            @Override
            public String getDemoUrl() {
                return "https://recaptcha-demo.appspot.com/recaptcha-v2-invisible.php";
            }

            @Override
            public String getDescription() {
                return "Google's enterprise reCAPTCHA v2 with advanced security features";
            }

            @Override
            public String getDomain() {
                return "google.com";
            }
        }
        ,
        RECAPTCHA_V2{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof RecaptchaV2Challenge;
            }

            @Override
            public String getDisplayName() {
                return "reCAPTCHA v2";
            }

            @Override
            public String getDemoUrl() {
                return "https://www.google.com/recaptcha/api2/demo";
            }

            @Override
            public String getDescription() {
                return "Google's reCAPTCHA v2 with checkbox verification";
            }

            @Override
            public String getDomain() {
                return "google.com";
            }
        }
        ,
        HCAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof HCaptchaChallenge;
            }

            @Override
            public String getDisplayName() {
                return "hCaptcha";
            }

            @Override
            public String getDemoUrl() {
                return "https://hcaptcha.com/?tab=demo";
            }

            @Override
            public String getDescription() {
                return "Privacy-focused alternative to reCAPTCHA with image-based challenges";
            }

            @Override
            public String getDomain() {
                return "hcaptcha.com";
            }
        }
        ,
        CUTCAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof CutCaptchaChallenge;
            }

            @Override
            public String getDisplayName() {
                return "Cutcaptcha";
            }

            @Override
            public String getDemoUrl() {
                return "https://www.cutcaptcha.com/";
            }

            @Override
            public String getDescription() {
                return "Interactive puzzle-based captcha service. Mostly used for provider 'Filecrypt'.";
            }

            @Override
            public String getDomain() {
                return "cutcaptcha.com";
            }
        }
        ,
        GEETEST_V1{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return false;
            }

            @Override
            public String getDisplayName() {
                return "Geetest v1";
            }

            @Override
            public String getDemoUrl() {
                return "https://www.geetest.com/en/adaptive-captcha-demo";
            }

            @Override
            public String getDescription() {
                return "Geetest v1 captcha (not currently supported)";
            }

            @Override
            public String getDomain() {
                return "geetest.com";
            }

            @Override
            public boolean isJDownloaderSupported() {
                return false;
            }
        }
        ,
        GEETEST_V4{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return false;
            }

            @Override
            public String getDisplayName() {
                return "Geetest v4";
            }

            @Override
            public String getDemoUrl() {
                return "https://www.geetest.com/en/adaptive-captcha-demo";
            }

            @Override
            public String getDescription() {
                return "Geetest v4 captcha (not currently supported)";
            }

            @Override
            public String getDomain() {
                return "geetest.com";
            }

            @Override
            public boolean isJDownloaderSupported() {
                return false;
            }
        }
        ,
        CLOUDFLARE_TURNSTILE{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof CloudflareTurnstileChallenge;
            }

            @Override
            public String getDisplayName() {
                return "Cloudflare Turnstile";
            }

            @Override
            public String getDemoUrl() {
                return "https://2captcha.com/demo/cloudflare-turnstile";
            }

            @Override
            public String getDescription() {
                return "Cloudflare's Turnstile captcha alternative with improved performance";
            }

            @Override
            public String getDomain() {
                return "cloudflare.com";
            }
        }
        ,
        MT_CAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return false;
            }

            @Override
            public String getDisplayName() {
                return "mTCaptcha";
            }

            @Override
            public String getDemoUrl() {
                return "https://www.mtcaptcha.com/";
            }

            @Override
            public String getDescription() {
                return "mTCaptcha service (not currently supported)";
            }

            @Override
            public String getDomain() {
                return "mtcaptcha.com";
            }

            @Override
            public boolean isJDownloaderSupported() {
                return false;
            }
        }
        ,
        FRIENDLY_CAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return false;
            }

            @Override
            public String getDisplayName() {
                return "Friendly Captcha";
            }

            @Override
            public String getDemoUrl() {
                return "https://friendlycaptcha.com/#demo";
            }

            @Override
            public String getDescription() {
                return "Friendly Captcha 'Truly Invisible CAPTCHA, Privacy-First, Bot Protection'";
            }

            @Override
            public String getDomain() {
                return "friendlycaptcha.com";
            }

            @Override
            public boolean isJDownloaderSupported() {
                return false;
            }
        };


        public abstract boolean canHandle(Challenge<?> var1);

        public abstract String getDisplayName();

        public abstract String getDemoUrl();

        public abstract String getDescription();

        public abstract String getDomain();

        public boolean isJDownloaderSupported() {
            return true;
        }

        public static CAPTCHA_TYPE getCaptchaTypeForChallenge(Challenge<?> c) {
            if (c == null) {
                return null;
            }
            for (CAPTCHA_TYPE type : CAPTCHA_TYPE.values()) {
                if (!type.canHandle(c)) continue;
                return type;
            }
            return null;
        }
    }
}

