/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.Color;
import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import jd.http.Cookies;
import jd.plugins.Account;
import jd.plugins.PluginForHost;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtPasswordField;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.ExtTextHighlighter;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.gui.InputChangedCallbackInterface;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.accounts.AccountBuilderInterface;

public class DefaultEditAccountPanel
extends MigPanel
implements AccountBuilderInterface {
    private static final long serialVersionUID = 1L;
    private final ExtTextField name;
    private final ExtPasswordField pass;
    private final InputChangedCallbackInterface callback;
    private static String EMPTYPW = "                 ";
    private JLabel usernameLabel = null;
    private JLabel passwordLabel = null;
    private boolean allowCookiesInPasswordField = false;
    private final PluginForHost plg;

    protected String getPassword() {
        if (this.pass == null) {
            return null;
        }
        if (EMPTYPW.equals(new String(this.pass.getPassword()))) {
            return null;
        }
        return new String(this.pass.getPassword());
    }

    protected String getUsername() {
        if (this.name == null) {
            return "";
        }
        if (_GUI.T.jd_gui_swing_components_AccountDialog_help_username().equals(this.name.getText())) {
            return null;
        }
        return this.name.getText();
    }

    @Override
    public boolean updateAccount(Account input, Account output) {
        boolean changed = false;
        if (!StringUtils.equals((String)input.getUser(), (String)output.getUser())) {
            output.setUser(input.getUser());
            changed = true;
        }
        if (!StringUtils.equals((String)input.getPass(), (String)output.getPass())) {
            output.setPass(input.getPass());
            changed = true;
        }
        return changed;
    }

    public DefaultEditAccountPanel(final InputChangedCallbackInterface callback, PluginForHost plg, boolean allowCookieLogin) {
        super("ins 0, wrap 2", "[][grow,fill]", "");
        this.callback = callback;
        this.plg = plg;
        this.usernameLabel = new JLabel(_GUI.T.jd_gui_swing_components_AccountDialog_name());
        this.add(this.usernameLabel);
        this.name = new ExtTextField(){
            {
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("^(\\s+)")));
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("(\\s+)$")));
                this.refreshTextHighlighter();
            }

            public void onChanged() {
                callback.onChangedInput(DefaultEditAccountPanel.this.name);
            }
        };
        this.add((Component)this.name);
        this.name.setHelpText(_GUI.T.jd_gui_swing_components_AccountDialog_help_username());
        this.passwordLabel = new JLabel(_GUI.T.jd_gui_swing_components_AccountDialog_pass());
        this.add(this.passwordLabel);
        this.pass = new ExtPasswordField(){
            {
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("^(\\s+)")));
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("(\\s+)$")));
                this.applyTextHighlighter(null);
            }

            public void onChanged() {
                callback.onChangedInput(DefaultEditAccountPanel.this.pass);
            }
        };
        this.add((Component)this.pass, "");
        if (allowCookieLogin) {
            this.pass.setHelpText(_GUI.T.BuyAndAddPremiumAccount_layoutDialogContent_pass_or_cookies());
        } else {
            this.pass.setHelpText(_GUI.T.BuyAndAddPremiumAccount_layoutDialogContent_pass());
        }
        this.allowCookiesInPasswordField = allowCookieLogin;
    }

    public InputChangedCallbackInterface getCallback() {
        return this.callback;
    }

    @Override
    public void setAccount(Account defaultAccount) {
        if (this.name != null) {
            this.name.setText(defaultAccount.getUser());
        }
        this.pass.setText(defaultAccount.getPass());
    }

    @Override
    public boolean validateInputs() {
        boolean userok;
        if (this.name != null) {
            if (StringUtils.isEmpty((String)this.getUsername())) {
                this.usernameLabel.setForeground(Color.RED);
                userok = false;
            } else {
                this.usernameLabel.setForeground(Color.BLACK);
                userok = true;
            }
        } else {
            userok = true;
        }
        String pw = this.getPassword();
        Cookies cookies = Cookies.parseCookiesFromString((String)pw);
        boolean passok = StringUtils.isEmpty((String)pw) ? false : cookies == null || this.allowCookiesInPasswordField;
        if (!passok) {
            this.passwordLabel.setForeground(Color.RED);
        } else {
            this.passwordLabel.setForeground(Color.BLACK);
        }
        return userok && passok;
    }

    @Override
    public Account getAccount() {
        return new Account(this.getUsername(), this.getPassword());
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean handleClipboardAutoFill() {
        boolean isCookies;
        ExtTextField dummy = new ExtTextField();
        dummy.paste();
        String clipboardContent = StringUtils.trim((String)dummy.getText());
        if (StringUtils.isEmpty((String)clipboardContent)) {
            return false;
        }
        boolean bl = isCookies = Cookies.parseCookiesFromJsonString((String)clipboardContent, (LogInterface)this.plg.getLogger()) != null;
        if (this.allowCookiesInPasswordField && isCookies) {
            this.pass.setPassword(clipboardContent.toCharArray());
            return true;
        }
        if (this.name != null && !isCookies) {
            this.name.setText(StringUtils.trim((String)clipboardContent));
            return true;
        }
        return false;
    }
}

