/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.views.settings.ConfigurationView;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.ComboBox;
import jd.gui.swing.jdgui.views.settings.components.Label;
import jd.gui.swing.jdgui.views.settings.components.MultiComboBox;
import jd.gui.swing.jdgui.views.settings.components.Spinner;
import jd.gui.swing.jdgui.views.settings.components.TextInput;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountEntry;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountManagerSettings;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.PremiumAccountTableModel;
import jd.nutils.Formatter;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountTrafficView;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.ByteKeyHandler;
import org.appwork.storage.config.handler.DoubleKeyHandler;
import org.appwork.storage.config.handler.EnumKeyHandler;
import org.appwork.storage.config.handler.FloatKeyHandler;
import org.appwork.storage.config.handler.IntegerKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.LongKeyHandler;
import org.appwork.storage.config.handler.ObjectKeyHandler;
import org.appwork.storage.config.handler.ShortKeyHandler;
import org.appwork.storage.config.handler.StringKeyHandler;
import org.appwork.storage.config.swing.models.ConfigByteSpinnerModel;
import org.appwork.storage.config.swing.models.ConfigDoubleSpinnerModel;
import org.appwork.storage.config.swing.models.ConfigFloatSpinnerModel;
import org.appwork.storage.config.swing.models.ConfigIntSpinnerModel;
import org.appwork.storage.config.swing.models.ConfigLongSpinnerModel;
import org.appwork.storage.config.swing.models.ConfigShortSpinnerModel;
import org.appwork.swing.components.ExtCheckBox;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.ColorUtils;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.DebugMode;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.DontThrowFromCurrentThreadEventSuppressor;
import org.appwork.utils.event.EventSuppressor;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.DomainInfo;
import org.jdownloader.extensions.Header;
import org.jdownloader.gui.settings.AbstractConfigPanel;
import org.jdownloader.gui.settings.Pair;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.config.AccountConfigInterface;
import org.jdownloader.plugins.config.AccountJsonConfig;
import org.jdownloader.plugins.config.CustomUI;
import org.jdownloader.plugins.config.Group;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginConfigPanelEventSenderEvent;
import org.jdownloader.plugins.config.PluginConfigPanelEventSenderEventSender;
import org.jdownloader.plugins.config.PluginConfigPanelEventSenderListener;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.premium.BuyAndAddPremiumAccount;
import org.jdownloader.premium.BuyAndAddPremiumDialogInterface;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class PluginConfigPanelNG
extends AbstractConfigPanel
implements AccountControllerListener {
    private List<Group> groups = new ArrayList<Group>();
    private boolean seperatorRequired;
    private static final String ACCOUNT = "ACCOUNT";
    private boolean updateAccounts;
    private HashSet<Component> accountSettingsComponents;
    private Plugin plugin;
    private Object translation;
    private String gapleft = "0";
    private String gapright = "";
    private int headerHight;
    private boolean added;
    private PluginConfigPanelEventSenderEventSender eventSender;
    private HashMap<JLabel, Account> accountMap;
    private final CopyOnWriteArraySet<ConfigInterface> interfaces = new CopyOnWriteArraySet();

    public void addGroup(Group g) {
        this.groups.add(g);
    }

    public void addGroup(String title, String regex) {
        this.addGroup(new Group(title, regex, null));
    }

    public synchronized PluginConfigPanelEventSenderEventSender getEventSender() {
        if (this.eventSender == null) {
            this.eventSender = new PluginConfigPanelEventSenderEventSender();
        }
        return this.eventSender;
    }

    public PluginConfigPanelNG() {
        super(0);
    }

    @Override
    public void onAccountControllerEvent(final AccountControllerEvent event) {
        if (this.plugin == null || !StringUtils.equals((String)this.plugin.getClass().getSimpleName(), (String)event.getAccount().getPlugin().getClass().getSimpleName())) {
            return;
        }
        switch ((AccountControllerEvent.Types)((Object)event.getType())) {
            case ACCOUNT_CHECKED: 
            case ACCOUNT_PROPERTY_UPDATE: 
            case ACCOUNT_UP_OR_DOWNGRADE: 
            case ADDED: 
            case REMOVED: {
                new EDTRunner(){

                    protected void runInEDT() {
                        PluginConfigPanelNG.this.updateAccountSettings(event.getAccount().getPlugin());
                        Container parent = PluginConfigPanelNG.this.getParent();
                        if (parent != null && parent instanceof JComponent) {
                            ((JComponent)parent).revalidate();
                        }
                    }
                };
                break;
            }
        }
    }

    @Override
    public String getRightGap() {
        return this.gapright;
    }

    @Override
    public String getLeftGap() {
        return this.gapleft;
    }

    @Override
    public Header addHeader(String name, Icon icon) {
        Header header = new Header(name, icon);
        this.add(header, "gapleft " + this.getLeftGap() + ",spanx,newline,growx,pushx" + this.getRightGap());
        header.setLayout((LayoutManager)new MigLayout("ins 0", "[35!,align left]5[]10[grow,fill]"));
        return header;
    }

    public JLabel addStartDescription(String description) {
        if (!description.toLowerCase().startsWith("<html>")) {
            description = "<html>" + description.replace("\r\n", "<br>").replace("\r", "<br>").replace("\n", "<br>") + "</html>";
        }
        JLabel txt = new JLabel();
        SwingUtils.setOpaque((JComponent)txt, (boolean)false);
        txt.setText(description);
        this.add(txt, "gaptop 0,spanx,growx,pushx,gapleft 0,gapbottom 5,wmin 10");
        this.addSeperator();
        return txt;
    }

    public JSeparator addSeperator() {
        if (this.getComponent(this.getComponentCount() - 1) instanceof JSeparator) {
            return null;
        }
        JSeparator sep = new JSeparator();
        this.add(sep, "gapleft " + this.getLeftGap() + ",spanx,growx,pushx,gapbottom 5" + this.getRightGap());
        return sep;
    }

    @Override
    public JLabel addDescription(String description) {
        JLabel txt = this.addDescriptionPlain(description);
        this.addSeperator();
        return txt;
    }

    @Override
    public JLabel addDescriptionPlain(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return null;
        }
        if (!description.toLowerCase().startsWith("<html>")) {
            description = "<html>" + description.replace("\r\n", "<br>").replace("\r", "<br>").replace("\n", "<br>") + "</html>";
        }
        JLabel txt = new JLabel();
        SwingUtils.setOpaque((JComponent)txt, (boolean)false);
        txt.setEnabled(false);
        txt.setText(description);
        this.add(txt, "gaptop 0,spanx,growx,pushx,gapleft " + this.getLeftGap() + ",gapbottom 5,wmin 10" + this.getRightGap());
        return txt;
    }

    public void reset() {
        for (ConfigInterface cfg : this.interfaces) {
            for (KeyHandler m : cfg._getStorageHandler().getKeyHandler()) {
                m.setValue(m.getDefaultValue());
            }
        }
        this.getEventSender().fireEvent((DefaultEvent)new PluginConfigPanelEventSenderEvent(){

            @Override
            public void callListener(PluginConfigPanelEventSenderListener listener) {
                listener.onConfigPanelReset(PluginConfigPanelNG.this.plugin, PluginConfigPanelNG.this, PluginConfigPanelNG.this.interfaces);
            }
        });
        new EDTRunner(){

            protected void runInEDT() {
                PluginConfigPanelNG.this.updateContents();
            }
        };
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return null;
    }

    public void initLayout(Plugin protoType) {
        this.plugin = protoType;
        if (this.accountSettingsComponents != null) {
            this.updateAccountSettings(protoType);
            return;
        }
        this.initPluginSettings(protoType);
        this.updateAccountSettings(protoType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccountSettings(Plugin protoType) {
        if (this.accountSettingsComponents != null) {
            for (Component c : this.accountSettingsComponents) {
                this.remove(c);
            }
        }
        this.accountSettingsComponents = new HashSet();
        this.updateAccounts = true;
        try {
            this.initAccountSettings(protoType, AccountController.getInstance().list(protoType.getHost()));
        }
        finally {
            this.updateAccounts = false;
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.updateAccounts) {
            this.accountSettingsComponents.add(comp);
        }
        super.addImpl(comp, constraints, index);
    }

    public void paint(Graphics g) {
        int start = -1;
        int end = -1;
        Account acc = null;
        for (Component c : this.getComponents()) {
            if (c.getName() == ACCOUNT) {
                acc = this.accountMap.get(c);
                if (start >= 0) {
                    g.fillRect(0, start, this.getWidth(), this.headerHight);
                }
                if (acc != null) {
                    if (!acc.isValid()) {
                        g.setColor(LAFOptions.getInstance().getColorForTableAccountErrorRowBackground());
                    } else if (acc.isTempDisabled()) {
                        g.setColor(LAFOptions.getInstance().getColorForTableAccountTempErrorRowBackground());
                    } else {
                        g.setColor(LAFOptions.getInstance().getColorForPanelHeaderBackground());
                    }
                    if (!acc.isEnabled()) {
                        g.setColor(Color.LIGHT_GRAY);
                    }
                } else {
                    g.setColor(LAFOptions.getInstance().getColorForTableAccountTempErrorRowBackground());
                }
                start = c.getLocation().y - 2;
                end = c.getLocation().y + c.getHeight();
                continue;
            }
            end = c.getLocation().y + c.getHeight();
        }
        if (start >= 0) {
            g.fillRect(0, start, this.getWidth(), this.headerHight);
        }
        super.paint(g);
        g.setColor(LAFOptions.getInstance().getColorForPanelBorders());
        start = -1;
        end = -1;
        for (Component c : this.getComponents()) {
            if (c.getName() == ACCOUNT) {
                if (start >= 0) {
                    if (acc != null && !acc.isEnabled()) {
                        g.setColor(ColorUtils.getAlphaInstance((Color)Color.LIGHT_GRAY, (int)50));
                        g.fillRect(0, start, this.getWidth() - 1, end - start - 1);
                        g.setColor(LAFOptions.getInstance().getColorForPanelBorders());
                    }
                    g.drawLine(0, start + this.headerHight, this.getWidth(), start + this.headerHight);
                    g.drawRect(0, start, this.getWidth() - 1, end - start - 1);
                }
                acc = this.accountMap.get(c);
                start = c.getLocation().y - 2;
                end = c.getLocation().y + c.getHeight();
                continue;
            }
            end = c.getLocation().y + c.getHeight();
        }
        if (start >= 0) {
            if (acc != null && !acc.isEnabled()) {
                g.setColor(ColorUtils.getAlphaInstance((Color)Color.LIGHT_GRAY, (int)50));
                g.fillRect(0, start, this.getWidth() - 1, end - start - 1);
                g.setColor(LAFOptions.getInstance().getColorForPanelBorders());
            }
            g.drawLine(0, start + this.headerHight, this.getWidth(), start + this.headerHight);
            g.drawRect(0, start, this.getWidth() - 1, end - start - 1);
        }
    }

    protected String getTrafficString(Account acc) {
        AccountTrafficView trafficView = acc.getAccountTrafficView();
        if (!acc.isValid()) {
            return null;
        }
        if (acc.isEnabled() && acc.isTempDisabled() && acc.getTmpDisabledTimeout() - System.currentTimeMillis() > 0L) {
            return null;
        }
        if (trafficView == null) {
            return "";
        }
        if (trafficView.isUnlimitedTraffic()) {
            return _GUI.T.premiumaccounttablemodel_column_trafficleft_unlimited();
        }
        return _GUI.T.premiumaccounttablemodel_column_trafficleft_left_(Formatter.formatReadable((long)trafficView.getTrafficLeft()), Formatter.formatReadable((long)trafficView.getTrafficMax()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAccountSettings(Plugin plugin, ArrayList<Account> accounts) {
        String gapbefore = this.gapleft;
        String gaprightBefore = this.getRightGap();
        if (accounts != null) {
            Collections.sort(accounts, new Comparator<Account>(){

                @Override
                public int compare(boolean x, boolean y) {
                    return x == y ? 0 : (x ? 1 : -1);
                }

                @Override
                public int compare(Account o1, Account o2) {
                    boolean e1 = o1.isEnabled();
                    boolean e2 = o2.isEnabled();
                    int ret = this.compare(e2, e1);
                    if (ret == 0) {
                        boolean error1 = o1.getError() == null;
                        boolean error2 = o2.getError() == null;
                        ret = this.compare(error2, error1);
                    }
                    return ret;
                }
            });
        }
        try {
            PluginForHost plgh;
            if (plugin instanceof PluginForHost && (plgh = (PluginForHost)plugin).isPremiumEnabled()) {
                AccountController.getInstance().getEventSender().removeListener((EventListener)this);
                AccountController.getInstance().getEventSender().addListener((EventListener)this, true);
                this.addHeader(_GUI.T.lit_your_accounts(plugin.getHost()), new AbstractIcon("premium", 18));
                this.addDescriptionPlain(_GUI.T.account_settings_description());
                boolean bl = this.added = accounts != null && accounts.size() > 0;
                if (!this.added) {
                    this.addDescriptionPlain(_GUI.T.description_accountmanager_button());
                }
                JButton bt = new JButton(((AccountManagerSettings)ConfigurationView.getInstance().getSubPanel(AccountManagerSettings.class)).getTitle());
                bt.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PluginConfigPanelNG.this.switchToAccountManager(null);
                        if (!PluginConfigPanelNG.this.added) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        BuyAndAddPremiumAccount dia = new BuyAndAddPremiumAccount(DomainInfo.getInstance(plgh.getHost()), "pluginsettings");
                                        UIOManager.I().show(BuyAndAddPremiumDialogInterface.class, (UserIODefinition)dia);
                                        dia.throwCloseExceptions();
                                    }
                                    catch (DialogClosedException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (DialogCanceledException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                });
                this.add(bt, "spanx,pushx,growx");
                this.gapleft = "5";
                this.gapright = ",gapright 5";
                this.headerHight = 0;
                this.accountMap = new HashMap();
                if (accounts != null) {
                    for (final Account acc : accounts) {
                        Class<? extends AccountConfigInterface> accountConfig;
                        AccountInfo ai;
                        JLabel accountHeader = new JLabel(_GUI.T.plugin_account_header(acc.getUser()));
                        SwingUtils.toBold((JLabel)accountHeader);
                        this.add(accountHeader, "gaptop 2,gapbottom 2, gapleft " + this.gapleft + "" + this.getRightGap());
                        this.headerHight = Math.max(this.headerHight, accountHeader.getPreferredSize().height + 4);
                        accountHeader.setName(ACCOUNT);
                        this.accountMap.put(accountHeader, acc);
                        final ExtCheckBox enabledBox = new ExtCheckBox(new JComponent[0]);
                        enabledBox.setSelected(acc.isEnabled());
                        enabledBox.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                acc.setEnabled(enabledBox.isSelected());
                                PluginConfigPanelNG.this.repaint();
                            }
                        });
                        enabledBox.setText(acc.isEnabled() ? _GUI.T.lit_enabled() : _GUI.T.lit_disabled());
                        accountHeader.setEnabled(acc.isEnabled());
                        this.add((Component)enabledBox, "spanx,gapright " + this.gapleft + ", alignx right" + this.getRightGap());
                        this.addPair(_GUI.T.lit_status(), null, new Label(PremiumAccountTableModel.accountToStatusString((Account)acc), PremiumAccountTableModel.accountToStatusIcon((Account)acc)));
                        String traffic = this.getTrafficString(acc);
                        if (StringUtils.isNotEmpty((String)traffic)) {
                            this.addPair(_GUI.T.lit_download_traffic(), null, new Label(traffic));
                        }
                        if ((ai = acc.getAccountInfo()) != null) {
                            long addedTs;
                            String expire = this.getExpireDateString(acc, ai);
                            if (StringUtils.isNotEmpty((String)expire)) {
                                this.addPair(_GUI.T.premiumaccounttablemodel_column_expiredate(), null, new Label(expire));
                            }
                            if ((addedTs = acc.getLongProperty("added", -1L)) > 0L) {
                                this.addPair(_GUI.T.lit_added(), null, new Label(this.formatDate(new Date(addedTs))));
                            }
                            if (ai.getUsedSpace() != -1L) {
                                this.addPair(_GUI.T.lit_used_space(), null, new Label(Formatter.formatReadable((long)ai.getUsedSpace())));
                            }
                            if (ai.getPremiumPoints() != -1L) {
                                this.addPair(_GUI.T.lit_premium_points(), null, new Label(ai.getPremiumPoints() + ""));
                            }
                        }
                        if ((accountConfig = plgh.getAccountConfigInterface(acc)) != null) {
                            this.initAccountConfig(plgh, acc, accountConfig);
                        }
                        plgh.extendAccountSettingsPanel(acc, this);
                        if (acc.isMultiHost() && acc.getPlugin().getLazyP().hasFeature(LazyPlugin.FEATURE.MULTIHOST)) {
                            this.initMultiHosterInfo(plgh, acc);
                        }
                        if (!acc.getPlugin().getLazyP().hasFeature(LazyPlugin.FEATURE.CAPTCHA_SOLVER)) continue;
                        this.initCaptchaSolverPluginInfo(plgh, acc);
                    }
                }
            }
        }
        finally {
            this.gapleft = gapbefore;
            this.gapright = gaprightBefore;
        }
    }

    private String getExpireDateString(Account acc, AccountInfo ai) {
        long validUntil = ai.getValidUntil();
        if (validUntil <= 0L) {
            return null;
        }
        Date date = new Date(validUntil);
        long left = validUntil - System.currentTimeMillis();
        if (left <= 0L) {
            return this.formatDate(date) + " (" + _GUI.T.PremiumAccountTableModel_getStringValue_status_expired() + ")";
        }
        return this.formatDate(date) + " (" + TimeFormatter.formatMilliSeconds((long)left, (int)2) + ")";
    }

    protected String formatDate(Date date) {
        String dateformat = Account.getExpireDateFormatString(this);
        return new SimpleDateFormat(dateformat).format(date);
    }

    protected void initAccountConfig(PluginForHost plugin, Account acc, Class<? extends AccountConfigInterface> accountConfig) {
        Header header = this.addHeader(_GUI.T.account_settings_header(), new AbstractIcon("settings", 16));
        this.build((ConfigInterface)AccountJsonConfig.get(plugin, acc));
        if (this.getComponents()[this.getComponentCount() - 1] == header) {
            this.remove(header);
        } else {
            this.add(Box.createGlue(), "gapbottom 5,pushx,growx,spanx" + this.getRightGap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMultiHosterInfo(PluginForHost plugin, Account acc) {
        String gapbefore = this.getLeftGap();
        String gapbeforeright = this.getRightGap();
        try {
            this.gapleft = "5";
            this.gapright = ",gapright 5";
            this.addHeader(_GUI.T.multihoster_account_settings_header(), new AbstractIcon("list", 18));
            this.addDescriptionPlain(_GUI.T.multihoster_account_settings_description());
            plugin.extendMultiHostAccountSettingsPanel(acc, this);
        }
        finally {
            this.gapleft = gapbefore;
            this.gapright = gapbeforeright;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCaptchaSolverPluginInfo(PluginForHost plugin, Account acc) {
        String gapbefore = this.getLeftGap();
        String gapbeforeright = this.getRightGap();
        try {
            this.gapleft = "5";
            this.gapright = ",gapright 5";
            this.addHeader("Supported captcha types", new AbstractIcon("list", 18));
            this.addDescriptionPlain("This is a captcha solver account. You can use it to solve captchas.");
            plugin.extendCaptchaSolverAccountSettingsPanel(acc, this);
        }
        finally {
            this.gapleft = gapbefore;
            this.gapright = gapbeforeright;
        }
    }

    protected void initPluginSettings(Plugin plugin) {
        Class<? extends PluginConfigInterface> inf = plugin.getConfigInterface();
        if (inf == null) {
            return;
        }
        PluginConfigInterface config = plugin instanceof PluginForHost ? PluginJsonConfig.get(((PluginForHost)plugin).getLazyP(), inf) : (plugin instanceof PluginForDecrypt ? PluginJsonConfig.get(((PluginForDecrypt)plugin).getLazyC(), inf) : null);
        if (config != null) {
            this.build(config);
        }
    }

    public Rectangle getAccountRectangle(Account account) {
        return null;
    }

    protected void switchToAccountManager(AccountEntry obj) {
        ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setConfigViewVisible(true);
        JDGui.getInstance().setContent((View)ConfigurationView.getInstance(), true);
        ConfigurationView.getInstance().setSelectedSubPanel(AccountManagerSettings.class);
        ((AccountManagerSettings)ConfigurationView.getInstance().getSubPanel(AccountManagerSettings.class)).getAccountManager().setTab(0);
        if (obj != null) {
            ((AccountManagerSettings)ConfigurationView.getInstance().getSubPanel(AccountManagerSettings.class)).getAccountManager().selectAccount(obj.getAccount());
        }
    }

    protected Map<String, Boolean> newMapInstance(KeyHandler m) throws InstantiationException, IllegalAccessException {
        Class<HashMap> raw = ReflectionUtils.getRaw((Type)m.getTypeRef().getType());
        if (raw.isInterface()) {
            raw = HashMap.class;
        }
        Map value = (Map)raw.newInstance();
        value.clear();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(ConfigInterface cfg, final KeyHandler m) {
        block35: {
            String description;
            DescriptionForConfigEntry anno = (DescriptionForConfigEntry)m.getAnnotation(DescriptionForConfigEntry.class);
            String label = this.getTranslation(m, "_label");
            if (label == null) {
                label = m.getReadableName();
            }
            if ((description = this.getTranslation(m, "_description")) == null && anno != null) {
                description = anno.value();
            }
            Pair<Object> pair = null;
            try {
                Type[] types;
                if (m instanceof BooleanKeyHandler) {
                    pair = this.addPair(label, null, new Checkbox((BooleanKeyHandler)m, new JComponent[0]));
                    return;
                }
                if (m instanceof StringKeyHandler) {
                    pair = this.addPair(label, null, new TextInput((StringKeyHandler)m));
                    return;
                }
                if (m instanceof ByteKeyHandler) {
                    pair = this.addPair(label, null, new Spinner((SpinnerNumberModel)new ConfigByteSpinnerModel((ByteKeyHandler)m)));
                    return;
                }
                if (m instanceof ShortKeyHandler) {
                    pair = this.addPair(label, null, new Spinner((SpinnerNumberModel)new ConfigShortSpinnerModel((ShortKeyHandler)m)));
                    return;
                }
                if (m instanceof IntegerKeyHandler) {
                    pair = this.addPair(label, null, new Spinner((SpinnerNumberModel)new ConfigIntSpinnerModel((IntegerKeyHandler)m)));
                    return;
                }
                if (m instanceof LongKeyHandler) {
                    pair = this.addPair(label, null, new Spinner((SpinnerNumberModel)new ConfigLongSpinnerModel((LongKeyHandler)m)));
                    return;
                }
                if (m instanceof DoubleKeyHandler) {
                    pair = this.addPair(label, null, new Spinner((SpinnerNumberModel)new ConfigDoubleSpinnerModel((DoubleKeyHandler)m)));
                    return;
                }
                if (m instanceof FloatKeyHandler) {
                    pair = this.addPair(label, null, new Spinner((SpinnerNumberModel)new ConfigFloatSpinnerModel((FloatKeyHandler)m)));
                    return;
                }
                if (m instanceof EnumKeyHandler) {
                    pair = this.addPair(label, null, null, new ComboBox(m, (Object[])((EnumKeyHandler)m).values(), null));
                    return;
                }
                if (!(m instanceof ObjectKeyHandler)) break block35;
                Class raw = ReflectionUtils.getRaw((Type)m.getTypeRef().getType());
                if (Map.class.isAssignableFrom(raw)) {
                    Type[] types2 = ((ParameterizedType)m.getTypeRef().getType()).getActualTypeArguments();
                    if (types2[0] != String.class || types2[1] != Boolean.class) break block35;
                    try {
                        Map<String, Boolean> value = (Map<String, Boolean>)m.getValue();
                        if (value == null) {
                            value = this.newMapInstance(m);
                        }
                        final Map<String, Boolean> finalValue = value;
                        MultiComboBox<String> comp = new MultiComboBox<String>(new ArrayList<String>(value.keySet())){
                            private final GenericConfigEventListener<Map<String, Boolean>> listener;
                            {
                                super(options);
                                this.listener = new GenericConfigEventListener<Map<String, Boolean>>(){

                                    public void onConfigValidatorError(KeyHandler<Map<String, Boolean>> keyHandler, Map<String, Boolean> invalidValue, ValidationException validateException) {
                                    }

                                    public void onConfigValueModified(KeyHandler<Map<String, Boolean>> keyHandler, Map<String, Boolean> newValue) {
                                        this.updateModel(newValue);
                                    }
                                };
                                m.getEventSender().addListener(this.listener, true);
                                this.updateModel(finalValue);
                            }

                            protected String getLabel(String sc) {
                                return super.getLabel((Object)sc);
                            }

                            protected String getLabel(List<String> list) {
                                return "[" + list.size() + "/" + this.getValues().size() + "] " + super.getLabel(list);
                            }

                            protected void updateModel(Map<String, Boolean> value) {
                                ArrayList<String> selected = new ArrayList<String>();
                                for (Map.Entry<String, Boolean> es : value.entrySet()) {
                                    if (es.getValue() != Boolean.TRUE) continue;
                                    selected.add(es.getKey());
                                }
                                this.setSelectedItems(selected);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onChanged() {
                                super.onChanged();
                                Map value = (Map)m.getValue();
                                DontThrowFromCurrentThreadEventSuppressor added = new DontThrowFromCurrentThreadEventSuppressor();
                                m.getEventSender().addEventSuppressor((EventSuppressor)added);
                                try {
                                    Map<String, Boolean> ret = PluginConfigPanelNG.this.newMapInstance(m);
                                    ret.putAll(value);
                                    for (String key : ret.keySet()) {
                                        ret.put(key, this.isItemSelected(key));
                                    }
                                    m.setValue(ret);
                                }
                                catch (InstantiationException e) {
                                    LogController.CL().log((Throwable)e);
                                }
                                catch (IllegalAccessException e) {
                                    LogController.CL().log((Throwable)e);
                                }
                                finally {
                                    m.getEventSender().removeEventSuppressor((EventSuppressor)added);
                                }
                            }
                        };
                        pair = this.addPair(label, (String)null, (BooleanKeyHandler)null, comp);
                    }
                    catch (InstantiationException e) {
                        LogController.CL().log((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        LogController.CL().log((Throwable)e);
                    }
                    return;
                }
                if (!Set.class.isAssignableFrom(raw) || !((types = ((ParameterizedType)m.getTypeRef().getType()).getActualTypeArguments())[0] instanceof Class) || !((Class)types[0]).isEnum()) break block35;
                try {
                    MultiComboBox<Object> comp = new MultiComboBox<Object>((Object[])((Class)types[0]).getEnumConstants()){
                        private final GenericConfigEventListener<Set<Enum>> listener;
                        {
                            super(options);
                            this.listener = new GenericConfigEventListener<Set<Enum>>(){

                                public void onConfigValidatorError(KeyHandler<Set<Enum>> keyHandler, Set<Enum> invalidValue, ValidationException validateException) {
                                }

                                public void onConfigValueModified(KeyHandler<Set<Enum>> keyHandler, Set<Enum> newValue) {
                                    this.updateModel(newValue);
                                }
                            };
                            Set<Enum> value = (Set<Enum>)m.getValue();
                            if (value == null) {
                                value = this.newSetInstance(m);
                                for (Object e : ((Class)types[0]).getEnumConstants()) {
                                    value.add((Enum)e);
                                }
                            }
                            m.getEventSender().addListener(this.listener, true);
                            this.updateModel(value);
                        }

                        protected String getLabel(List<Object> list) {
                            return "[" + list.size() + "/" + this.getValues().size() + "] " + super.getLabel(list);
                        }

                        protected Set<Enum> newSetInstance(KeyHandler m2) throws InstantiationException, IllegalAccessException {
                            Class<HashSet> raw = ReflectionUtils.getRaw((Type)m2.getTypeRef().getType());
                            if (raw.isInterface()) {
                                raw = HashSet.class;
                            }
                            Set value = (Set)raw.newInstance();
                            return value;
                        }

                        protected void updateModel(Set<Enum> newValue) {
                            if (newValue == null) {
                                this.setSelectedItems(((Class)types[0]).getEnumConstants());
                            } else {
                                this.setSelectedItems(newValue.toArray(new Enum[0]));
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onChanged() {
                            super.onChanged();
                            DontThrowFromCurrentThreadEventSuppressor added = new DontThrowFromCurrentThreadEventSuppressor();
                            m.getEventSender().addEventSuppressor((EventSuppressor)added);
                            try {
                                Set<Enum> set = this.newSetInstance(m);
                                for (Object e : this.getSelectedItems()) {
                                    set.add((Enum)e);
                                }
                                m.setValue(set);
                            }
                            catch (InstantiationException e1) {
                                LogController.CL().log((Throwable)e1);
                            }
                            catch (IllegalAccessException e1) {
                                LogController.CL().log((Throwable)e1);
                            }
                            finally {
                                m.getEventSender().removeEventSuppressor((EventSuppressor)added);
                            }
                        }
                    };
                    pair = this.addPair(label, (String)null, (BooleanKeyHandler)null, comp);
                }
                catch (InstantiationException e) {
                    LogController.CL().log((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LogController.CL().log((Throwable)e);
                }
                return;
            }
            finally {
                Checkbox comp;
                if (description != null && !StringUtils.equalsIgnoreCase((String)description, (String)label)) {
                    this.addDescriptionPlain(description);
                }
                if (pair != null && (comp = pair.getComponent()) != null) {
                    comp.setToolTipText(description);
                }
            }
        }
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            UIOManager.I().showException("Unsupported Type: " + m, (Throwable)new Exception());
        }
    }

    private String getTranslation(KeyHandler m, String ext) {
        if (this.translation == null) {
            return null;
        }
        String caseSensitiveGetter = m.getGetMethod().getName();
        if (caseSensitiveGetter.startsWith("is")) {
            caseSensitiveGetter = "get" + caseSensitiveGetter.substring(2);
        }
        try {
            Method method = this.translation.getClass().getMethod(caseSensitiveGetter + ext, new Class[0]);
            method.setAccessible(true);
            return (String)method.invoke(this.translation, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if ("_label".equals(ext)) {
                System.out.println("Missing Translation: " + this.translation.getClass().getName() + "." + caseSensitiveGetter + ext + "(){return ....}");
            }
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        return null;
    }

    protected boolean showKeyHandler(KeyHandler<?> keyHandler) {
        return keyHandler != null;
    }

    public void build(ConfigInterface cfg) {
        this.interfaces.add(cfg);
        ArrayList<Group> interfaceGroups = new ArrayList<Group>();
        interfaceGroups.addAll(this.groups);
        try {
            Field groupField = cfg._getStorageHandler().getConfigInterface().getField("GROUPS");
            groupField.setAccessible(true);
            for (Group p : (Group[])groupField.get(null)) {
                interfaceGroups.add(p.createClone());
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
            UIOManager.I().showException("Bad Plugin Config Interface. Contact Support.", e);
        }
        try {
            Field field = cfg._getStorageHandler().getConfigInterface().getField("TRANSLATION");
            field.setAccessible(true);
            this.translation = field.get(null);
        }
        catch (NoSuchFieldException field) {
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
            UIOManager.I().showException("Bad Plugin Config Interface. Contact Support.", e);
        }
        Group defGroup = null;
        ArrayList<Group> finalGroups = new ArrayList<Group>();
        HashSet<Group> groupsAdded = new HashSet<Group>();
        List list = cfg._getStorageHandler().getKeyHandler();
        Collections.sort(list, new Comparator<KeyHandler<?>>(){

            @Override
            public int compare(KeyHandler<?> o1, KeyHandler<?> o2) {
                Order orderAn2;
                int order2;
                Order orderAn1 = (Order)o1.getAnnotation(Order.class);
                int order1 = orderAn1 == null ? Integer.MAX_VALUE : orderAn1.value();
                int ret = CompareUtils.compareInt((int)order1, (int)(order2 = (orderAn2 = (Order)o2.getAnnotation(Order.class)) == null ? Integer.MAX_VALUE : orderAn2.value()));
                if (ret == 0) {
                    return o1.getKey().compareToIgnoreCase(o2.getKey());
                }
                return ret;
            }
        });
        block7: for (KeyHandler m : list) {
            if (!this.showKeyHandler(m)) continue;
            for (Group g : interfaceGroups) {
                if (!g.matches(m)) continue;
                g.add(m);
                if (groupsAdded.add(g)) {
                    finalGroups.add(g);
                }
                defGroup = null;
                continue block7;
            }
            if (defGroup == null) {
                defGroup = new Group();
                finalGroups.add(defGroup);
            }
            defGroup.add(m);
        }
        this.seperatorRequired = false;
        for (Group p : finalGroups) {
            if (StringUtils.isNotEmpty((String)p.getTitle())) {
                this.addHeader(p.getTitle(), new AbstractIcon(p.getIconKey(), 20));
                this.seperatorRequired = false;
            } else if (this.seperatorRequired) {
                this.addSeperator();
                this.seperatorRequired = false;
            }
            for (KeyHandler h : p.handler) {
                if (this.useCustomUI(h)) continue;
                this.addHandler(cfg, h);
                if (p.getTitle() == null) continue;
                this.seperatorRequired = true;
            }
        }
    }

    protected boolean useCustomUI(KeyHandler<?> h) {
        return h.getAnnotation(CustomUI.class) != null;
    }

    public void addStringPair(String key, Object value) {
        if (value == null) {
            return;
        }
        this.addPair(key, null, new Label(String.valueOf(value)));
    }
}

