/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.JTableHeader;
import jd.PluginWrapper;
import jd.captcha.JACMethod;
import jd.config.SubConfiguration;
import jd.controlling.AccountController;
import jd.controlling.captcha.CaptchaSettings;
import jd.controlling.captcha.SkipException;
import jd.controlling.captcha.SkipRequest;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.DiskSpaceManager;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogJob;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.reconnect.ipcheck.BalancedWebIPCheck;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.OfflineException;
import jd.gui.swing.jdgui.BasicJDTable;
import jd.gui.swing.jdgui.views.settings.panels.pluginsettings.PluginConfigPanel;
import jd.http.Browser;
import jd.http.NoGateWayException;
import jd.http.ProxySelectorInterface;
import jd.http.Request;
import jd.http.StaticProxySelector;
import jd.http.URLConnectionAdapter;
import jd.nutils.Formatter;
import jd.nutils.JDHash;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountInvalidException;
import jd.plugins.AccountTrafficView;
import jd.plugins.AccountUnavailableException;
import jd.plugins.CaptchaException;
import jd.plugins.CaptchaType;
import jd.plugins.CouldNotRenameException;
import jd.plugins.DefaultEditAccountPanel;
import jd.plugins.DefaultEditAccountPanelAPIKeyLogin;
import jd.plugins.DefaultEditAccountPanelCookieLogin;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkCaptchaTracker;
import jd.plugins.FileExistsException;
import jd.plugins.FilePackage;
import jd.plugins.MovePluginProgress;
import jd.plugins.MultiHostHost;
import jd.plugins.Plugin;
import jd.plugins.PluginBrowser;
import jd.plugins.PluginConfigPanelNG;
import jd.plugins.PluginException;
import jd.plugins.PluginProgress;
import jd.plugins.SingleDownloadControllerCaptchaTrackerJob;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadInterfaceFactory;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import net.miginfocom.swing.MigLayout;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.MigPanel;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtFileSizeColumn;
import org.appwork.swing.exttable.columns.ExtLongColumn;
import org.appwork.swing.exttable.columns.ExtProgressColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.timetracker.TimeTracker;
import org.appwork.timetracker.TrackerJob;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.InputDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.ProgressFeedback;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.InputDialog;
import org.appwork.utils.swing.dialog.ProgressDialog;
import org.jdownloader.DomainInfo;
import org.jdownloader.captcha.blacklist.BlockAllDownloadCaptchasEntry;
import org.jdownloader.captcha.blacklist.BlockDownloadCaptchasByHost;
import org.jdownloader.captcha.blacklist.BlockDownloadCaptchasByLink;
import org.jdownloader.captcha.blacklist.BlockDownloadCaptchasByPackage;
import org.jdownloader.captcha.blacklist.CaptchaBlackList;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickedPoint;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.controlling.DefaultDownloadLinkViewImpl;
import org.jdownloader.controlling.DownloadLinkView;
import org.jdownloader.controlling.UrlProtection;
import org.jdownloader.controlling.ffmpeg.FFMpegInstallProgress;
import org.jdownloader.controlling.ffmpeg.FFMpegInstallThread;
import org.jdownloader.controlling.ffmpeg.FFmpeg;
import org.jdownloader.controlling.ffmpeg.FFmpegProvider;
import org.jdownloader.controlling.ffmpeg.FFmpegSetup;
import org.jdownloader.controlling.ffmpeg.FFprobe;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.controlling.linkcrawler.GenericVariants;
import org.jdownloader.controlling.linkcrawler.LinkVariant;
import org.jdownloader.gui.InputChangedCallbackInterface;
import org.jdownloader.gui.dialog.AskDownloadPasswordDialogInterface;
import org.jdownloader.gui.dialog.AskForDownloadLinkDialog;
import org.jdownloader.gui.dialog.AskToUsePremiumDialog;
import org.jdownloader.gui.dialog.AskToUsePremiumDialogInterface;
import org.jdownloader.gui.helpdialogs.HelpDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.linkgrabber.columns.VariantColumn;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.BadgeIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.ConditionalSkipReasonException;
import org.jdownloader.plugins.PluginTaskID;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.plugins.SleepPluginProgress;
import org.jdownloader.plugins.UserIOProgress;
import org.jdownloader.plugins.WaitForAccountTrafficSkipReason;
import org.jdownloader.plugins.WaitForAccountTrafficSkipReasonMultihostLinksRequired;
import org.jdownloader.plugins.WaitForAccountTrafficSkipReasonMultihostTrafficRequired;
import org.jdownloader.plugins.WaitingSkipReasonMultihostHostUnavailable;
import org.jdownloader.plugins.accounts.AccountBuilderInterface;
import org.jdownloader.plugins.components.captchasolver.abstractPluginForCaptchaSolver;
import org.jdownloader.plugins.config.AccountConfigInterface;
import org.jdownloader.plugins.config.AccountJsonConfig;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.UpdateController;
import org.jdownloader.updatev2.UpdateHandler;

public abstract class PluginForHost
extends Plugin {
    private static final String COPY_MOVE_FILE = "CopyMoveFile";
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("(.*)(\\.pa?r?t?\\.?[0-9]+.*?\\.rar$)", 2), Pattern.compile("(.*)(\\..*?$)", 2)};
    private LazyHostPlugin lazyP = null;
    private boolean dlSet = false;
    protected volatile DownloadInterface dl = null;
    private static final String AUTO_FILE_NAME_CORRECTION_NAME_SPLIT = "AUTO_FILE_NAME_CORRECTION_NAME_SPLIT";
    private static final String AUTO_FILE_NAME_CORRECTION_NAME_SPLIT_PATTERN = "AUTO_FILE_NAME_CORRECTION_NAME_SPLIT_PATTERN";
    private long WAIT_BETWEEN_STARTS = 0L;
    private boolean enablePremium = false;
    private String premiumurl = null;
    private DownloadLink link = null;
    protected DownloadInterfaceFactory customizedDownloadFactory = null;
    private static WeakHashMap<Account, HashMap<String, Boolean>> AUTOCAPTCHAMAP = new WeakHashMap();
    private static Object CHECKSHOWFREEDIALOGLOCK = new Object();

    public LazyHostPlugin getLazyP() {
        return this.lazyP;
    }

    @Override
    public void runCaptchaDDosProtection(String id) throws InterruptedException {
        SingleDownloadController controller;
        DownloadLink downloadLink;
        TimeTracker tracker = ChallengeResponseController.getInstance().getTracker(id);
        Thread thread = Thread.currentThread();
        TrackerJob trackerJob = thread instanceof SingleDownloadController ? new SingleDownloadControllerCaptchaTrackerJob(id, (SingleDownloadController)((Object)thread)) : ((downloadLink = this.getDownloadLink()) != null ? ((controller = downloadLink.getDownloadLinkController()) != null ? new SingleDownloadControllerCaptchaTrackerJob(id, controller) : new DownloadLinkCaptchaTracker(id, downloadLink)) : new TrackerJob(1));
        tracker.wait(trackerJob);
    }

    protected List<LazyCrawlerPlugin> findNextLazyCrawlerPlugins(String url, LazyPlugin.FEATURE ... features) {
        ArrayList<LazyCrawlerPlugin> ret = new ArrayList<LazyCrawlerPlugin>();
        for (LazyCrawlerPlugin lazyCrawlerPlugin : CrawlerPluginController.list(true)) {
            if (features != null && features.length != 0 && !lazyCrawlerPlugin.hasFeature(features) || !lazyCrawlerPlugin.canHandle(url)) continue;
            ret.add(lazyCrawlerPlugin);
        }
        return ret;
    }

    public String getPluginContentURL(DownloadLink link) {
        String ret = link.getStringProperty("URL_CONTENT");
        return ret;
    }

    public boolean setPluginContentURL(String url, DownloadLink link) {
        if (!StringUtils.equals((String)url, (String)this.getPluginContentURL(link))) {
            if (StringUtils.isEmpty((String)url)) {
                return link.removeProperty("URL_CONTENT");
            }
            return link.setProperty("URL_CONTENT", url);
        }
        return false;
    }

    public String getPluginCustomURL(DownloadLink link) {
        String ret = link.getStringProperty("URL_CUSTOM");
        return ret;
    }

    public boolean setPluginCustomURL(String url, DownloadLink link) {
        if (!StringUtils.equals((String)url, (String)this.getPluginCustomURL(link))) {
            if (StringUtils.isEmpty((String)url)) {
                return link.removeProperty("URL_CUSTOM");
            }
            return link.setProperty("URL_CUSTOM", url);
        }
        return false;
    }

    public String getPluginContainerURL(DownloadLink link) {
        String ret = link.getStringProperty("URL_CONTAINER");
        return ret;
    }

    public boolean setPluginContainerURL(String url, DownloadLink link) {
        if (!StringUtils.equals((String)url, (String)this.getPluginContainerURL(link))) {
            if (StringUtils.isEmpty((String)url)) {
                return link.removeProperty("URL_CONTAINER");
            }
            return link.setProperty("URL_CONTAINER", url);
        }
        return false;
    }

    public String getLinkID(DownloadLink link) {
        String linkID = link.getSetLinkID();
        if (StringUtils.isEmpty((String)linkID)) {
            return link.getPluginPatternMatcher();
        }
        String orgLinkID = link.getStringProperty("ORG_LINKID");
        if (orgLinkID != null) {
            return linkID.replaceFirst("_ORIGINAL$", "");
        }
        return linkID;
    }

    public void setLinkID(DownloadLink link, String linkID) {
        if (StringUtils.isEmpty((String)linkID)) {
            link.removeProperty("LINKDUPEID");
        } else {
            link.setProperty("LINKDUPEID", linkID);
        }
    }

    public AccountInfo handleAccountException(Account account, LogInterface logger, Throwable throwable) {
        HTTPProxy proxy;
        AccountInfo ai;
        if (account.getAccountInfo() != null) {
            ai = account.getAccountInfo();
        } else {
            ai = new AccountInfo();
            account.setAccountInfo(ai);
        }
        if (logger != null) {
            if (logger instanceof LogSource) {
                ((LogSource)logger).clear();
            }
            logger.info("PluginDetails(" + this.getLazyP().getClassName() + "|" + this.getVersion() + ")");
            logger.log(throwable);
        }
        if (throwable instanceof NoGateWayException) {
            account.setError(Account.AccountError.TEMP_DISABLED, 300000L, _JDT.T.AccountController_updateAccountInfo_no_gateway());
            return ai;
        }
        if (throwable instanceof NullPointerException) {
            throwable = new PluginException(0x400000, null, throwable);
        }
        if (throwable instanceof PluginException) {
            PluginException pluginException = (PluginException)throwable;
            switch (pluginException.getLinkStatus()) {
                case 8: {
                    this.invalidateLastChallengeResponse();
                    String errorMsg = StringUtils.isEmpty((String)pluginException.getLocalizedMessage()) ? _JDT.T.DownloadLink_setSkipped_statusmessage_captcha() : pluginException.getLocalizedMessage();
                    account.setError(Account.AccountError.TEMP_DISABLED, 3600000L, errorMsg);
                    return ai;
                }
                case 256: {
                    this.validateLastChallengeResponse();
                    if ((long)PluginException.VALUE_ID_PREMIUM_TEMP_DISABLE == pluginException.getValue()) {
                        String errorMsg = StringUtils.isEmpty((String)pluginException.getLocalizedMessage()) ? (!ai.isUnlimitedTraffic() && ai.getTrafficLeft() <= 0L ? _JDT.T.AccountController_updateAccountInfo_status_traffic_reached() : _JDT.T.AccountController_updateAccountInfo_status_uncheckable()) : pluginException.getLocalizedMessage();
                        if (pluginException instanceof AccountUnavailableException) {
                            AccountUnavailableException timeout = (AccountUnavailableException)pluginException;
                            account.setError(Account.AccountError.TEMP_DISABLED, timeout.getTimeout(), errorMsg);
                        } else {
                            account.setError(Account.AccountError.TEMP_DISABLED, 3600000L, errorMsg);
                        }
                    } else {
                        String errorMsg = StringUtils.isEmpty((String)pluginException.getLocalizedMessage()) ? _JDT.T.AccountController_updateAccountInfo_status_logins_wrong() : pluginException.getLocalizedMessage();
                        account.setError(Account.AccountError.INVALID, -1L, errorMsg);
                    }
                    return ai;
                }
                case 0x400000: {
                    String errorMsg = StringUtils.isEmpty((String)pluginException.getLocalizedMessage()) ? _JDT.T.AccountController_updateAccountInfo_status_plugin_defect() : pluginException.getLocalizedMessage();
                    account.setError(Account.AccountError.TEMP_DISABLED, 3600000L, errorMsg);
                    return ai;
                }
            }
            String errorMsg = StringUtils.isEmpty((String)pluginException.getLocalizedMessage()) ? _JDT.T.AccountController_updateAccountInfo_status_uncheckable() : pluginException.getLocalizedMessage();
            account.setError(Account.AccountError.TEMP_DISABLED, 3600000L, errorMsg);
            return ai;
        }
        StaticProxySelector proxySelector = null;
        Browser.BrowserException browserException = (Browser.BrowserException)Exceptions.getInstanceof((Throwable)throwable, Browser.BrowserException.class);
        if (browserException != null && browserException.getRequest() != null && (proxy = browserException.getRequest().getProxy()) != null) {
            proxySelector = new StaticProxySelector(proxy);
        }
        if (proxySelector == null && this.getBrowser() != null && this.getBrowser().getRequest() != null && (proxy = this.getBrowser().getRequest().getProxy()) != null) {
            proxySelector = new StaticProxySelector(proxy);
        }
        BalancedWebIPCheck onlineCheck = new BalancedWebIPCheck((ProxySelectorInterface)proxySelector);
        try {
            onlineCheck.getExternalIP();
        }
        catch (OfflineException e2) {
            account.setError(Account.AccountError.TEMP_DISABLED, 300000L, "No Internet Connection");
            return ai;
        }
        catch (IPCheckException e2) {
            // empty catch block
        }
        if (browserException != null && Exceptions.getInstanceof((Throwable)browserException, UnknownHostException.class) != null) {
            account.setError(Account.AccountError.TEMP_DISABLED, 300000L, "DNS issues");
            return ai;
        }
        String errorMsg = StringUtils.isEmpty((String)throwable.getMessage()) ? _JDT.T.AccountController_updateAccountInfo_status_uncheckable() : (browserException != null && browserException.getRequest() != null ? browserException.getSuperMessage() : throwable.getMessage());
        account.setError(Account.AccountError.TEMP_DISABLED, 3600000L, errorMsg);
        return ai;
    }

    public void setLazyP(LazyHostPlugin lazyP) {
        this.lazyP = lazyP;
    }

    @Deprecated
    public void errLog(Throwable e, Browser br, DownloadLink link) {
        this.errLog(e, br, null, link, null);
    }

    public long calculateAdditionalRequiredDiskSpace(DownloadLink link) {
        return 0L;
    }

    protected void checkAndReserve(DownloadLink downloadLink, DiskSpaceReservation reservation) throws Exception {
        DiskSpaceManager.DISKSPACERESERVATIONRESULT result = DownloadWatchDog.getInstance().getSession().getDiskSpaceManager().checkAndReserve(reservation, downloadLink != null ? downloadLink.getDownloadLinkController() : null);
        switch (result) {
            case FAILED: {
                throw new SkipReasonException(SkipReason.DISK_FULL);
            }
            case INVALIDDESTINATION: {
                throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
            }
        }
    }

    protected void free(DownloadLink downloadLink, DiskSpaceReservation reservation) {
        DownloadWatchDog.getInstance().getSession().getDiskSpaceManager().free(reservation, downloadLink != null ? downloadLink.getDownloadLinkController() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errLog(Throwable e, Browser br, LogSource log, DownloadLink link, Account account) {
        if (e != null && e instanceof PluginException && ((PluginException)e).getLinkStatus() == 0x400000) {
            LogSource errlogger = LogController.getInstance().getLogger("PluginErrors");
            try {
                errlogger.severe("HosterPlugin out of date: " + this + " :" + this.getVersion());
                errlogger.severe("URL: " + link.getPluginPatternMatcher() + " | ContentUrl: " + link.getContentUrl() + " | ContainerUrl: " + link.getContainerUrl() + " | OriginUrl: " + link.getOriginUrl() + " | ReferrerUrl: " + link.getReferrerUrl());
                if (e != null) {
                    errlogger.log(e);
                }
            }
            finally {
                errlogger.close();
            }
        }
    }

    @Deprecated
    public PluginForHost(PluginWrapper wrapper) {
        super(wrapper);
        ClassLoader cl = this.getClass().getClassLoader();
        if (!(cl instanceof PluginClassLoader.PluginClassLoaderChild)) {
            throw new WTFException(this + " got loaded by non PluginClassLoaderChild!");
        }
        this.br = null;
        this.dl = null;
        this.lazyP = (LazyHostPlugin)wrapper.getLazy();
    }

    public DownloadInterface getDownloadInterface() {
        return this.dl;
    }

    public String getCaptchaCode(String captchaAddress, DownloadLink downloadLink) throws Exception {
        return this.getCaptchaCode(this.getHost(), captchaAddress, downloadLink);
    }

    @Override
    public long getVersion() {
        return this.lazyP.getVersion();
    }

    @Override
    public Pattern getSupportedLinks() {
        return this.lazyP.getPattern();
    }

    protected String getCaptchaCode(String method, String captchaAddress, DownloadLink downloadLink) throws Exception {
        if (StringUtils.isEmpty((String)captchaAddress)) {
            throw new PluginException(0x400000, "No captcha url given");
        }
        return this.getCaptchaCode(method, this.getCaptchaImage(captchaAddress), downloadLink);
    }

    protected MultiClickedPoint getMultiCaptchaClickedPoint(File file, DownloadLink link, String explain) throws Exception {
        File copy = this.copyCaptcha(this.getHost(), file);
        MultiClickCaptchaChallenge c = new MultiClickCaptchaChallenge(copy, explain, this);
        return this.handleCaptchaChallenge(link, c);
    }

    protected String getCaptchaCode(File captchaFile, DownloadLink downloadLink) throws Exception {
        return this.getCaptchaCode(this.getHost(), captchaFile, downloadLink);
    }

    public String getCaptchaCode(String methodname, File captchaFile, DownloadLink downloadLink) throws Exception {
        return this.getCaptchaCode(methodname, captchaFile, 0, downloadLink, null, null);
    }

    protected String getCaptchaCode(String method, File file, int flag, DownloadLink link, String defaultValue, String explain) throws Exception {
        String orgCaptchaImage = link.getStringProperty("orgCaptchaFile", null);
        if (orgCaptchaImage != null && new File(orgCaptchaImage).exists()) {
            file = new File(orgCaptchaImage);
        }
        File copy = this.copyCaptcha(method, file);
        if (this.getDownloadLink() == null) {
            this.setDownloadLink(link);
        }
        BasicCaptchaChallenge c = this.createChallenge(method, copy, flag, link, defaultValue, explain);
        return this.handleCaptchaChallenge(link, c);
    }

    private File copyCaptcha(String method, File file) throws Exception {
        if (file == null) {
            return null;
        }
        File copy = Application.getResource((String)("captchas/" + method + "/" + Hash.getMD5((File)file) + "." + Files.getExtension((String)file.getName())));
        copy.delete();
        copy.getParentFile().mkdirs();
        IO.copyFile((File)file, (File)copy);
        return copy;
    }

    @Deprecated
    protected boolean isAccountLoginCaptchaChallenge(DownloadLink link, Challenge<?> c) {
        return this.isAccountLoginCaptchaChallenge(c) || link == null || FilePackage.isDefaultFilePackage(link.getFilePackage());
    }

    protected <ReturnType> ReturnType handleSkipException(DownloadLink link, Challenge<ReturnType> c, SkipException e) throws PluginException, CaptchaException, InterruptedException {
        LogSource.exception((LogInterface)this.logger, (Throwable)e);
        if (link != null && !c.isAccountLogin()) {
            switch (e.getSkipRequest()) {
                case BLOCK_ALL_CAPTCHAS: {
                    CaptchaBlackList.getInstance().add(new BlockAllDownloadCaptchasEntry());
                    HelpDialog.showCaptchaSkippedDialog();
                    break;
                }
                case BLOCK_HOSTER: {
                    CaptchaBlackList.getInstance().add(new BlockDownloadCaptchasByHost(link.getHost()));
                    HelpDialog.showCaptchaSkippedDialog();
                    break;
                }
                case BLOCK_PACKAGE: {
                    CaptchaBlackList.getInstance().add(new BlockDownloadCaptchasByPackage(link.getParentNode()));
                    HelpDialog.showCaptchaSkippedDialog();
                    break;
                }
                case TIMEOUT: {
                    this.onCaptchaTimeout(link, c);
                }
                case SINGLE: {
                    CaptchaBlackList.getInstance().add(new BlockDownloadCaptchasByLink(e.getSkipRequest(), link));
                    HelpDialog.showCaptchaSkippedDialog();
                    break;
                }
            }
        }
        switch (e.getSkipRequest()) {
            case STOP_CURRENT_ACTION: {
                if (!(Thread.currentThread() instanceof SingleDownloadController)) break;
                DownloadWatchDog.getInstance().stopDownloads();
                break;
            }
            case REFRESH: {
                return c.getRefreshTrigger();
            }
        }
        throw new CaptchaException(e.getSkipRequest());
    }

    /*
     * Exception decompiling
     */
    public <T> T handleCaptchaChallenge(DownloadLink link, Challenge<T> c) throws CaptchaException, PluginException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onCaptchaTimeout(DownloadLink link, Challenge<?> challenge) throws CaptchaException, PluginException, InterruptedException {
        switch (((CaptchaSettings)JsonConfig.create(CaptchaSettings.class)).getOnHosterCaptchaTimeoutAction()) {
            case RETRY: {
                throw new PluginException(4);
            }
            case ASK: {
                if (!UIOManager.I().showConfirmDialog(0, _GUI.T.gui_captchaWindow_askForInput(link.getDomainInfo().getTld()), _GUI.T.StatusBarImpl_skippedLinksMarker_desc(1), (Icon)new AbstractIcon("question", 32), _GUI.T.CaptchaDialog_layoutDialogContent_refresh(), _GUI.T.AbstractCaptchaDialog_AbstractCaptchaDialog_cancel())) break;
                throw new PluginException(4);
            }
            case SKIP_HOSTER: {
                throw new CaptchaException(SkipRequest.BLOCK_HOSTER);
            }
            default: {
                HelpDialog.showCaptchaSkippedDialog();
            }
        }
    }

    protected String getDefaultFileName(DownloadLink link) {
        return null;
    }

    protected DownloadLinkView getDownloadLinkView(DownloadLink link) {
        return new DefaultDownloadLinkViewImpl();
    }

    protected DomainInfo getDomainInfo(DownloadLink link) {
        if (this instanceof DomainInfo.DomainInfoFactory) {
            return DomainInfo.getInstance(this.getHost(link, null, true), (DomainInfo.DomainInfoFactory)((Object)this));
        }
        return DomainInfo.getInstance(this.getHost(link, null, true));
    }

    protected BasicCaptchaChallenge createChallenge(String method, File file, int flag, DownloadLink link, String defaultValue, String explain) {
        return new BasicCaptchaChallenge(method, file, defaultValue, explain, this, flag);
    }

    public DownloadInterfaceFactory getCustomizedDownloadFactory() {
        return this.customizedDownloadFactory;
    }

    public void setCustomizedDownloadFactory(DownloadInterfaceFactory customizedDownloadFactory) {
        this.customizedDownloadFactory = customizedDownloadFactory;
    }

    @Override
    public String getHost() {
        return this.lazyP.getDisplayName();
    }

    @Override
    public LogInterface getLogger() {
        return super.getLogger();
    }

    @Override
    @Deprecated
    public SubConfiguration getPluginConfig() {
        return SubConfiguration.getConfig(this.lazyP.getHost());
    }

    @Override
    protected PluginConfigPanelNG createConfigPanel() {
        boolean hasConfigPanel = this.getConfigInterface() != null;
        hasConfigPanel |= this.isPremiumEnabled() && this.getAccountConfigInterface(null) != null;
        if (!(hasConfigPanel |= this.hasFeature(LazyPlugin.FEATURE.MULTIHOST))) {
            return null;
        }
        PluginConfigPanelNG ret = new PluginConfigPanelNG(){
            private PluginConfigPanel oldStyle;

            @Override
            public void updateContents() {
            }

            @Override
            protected void initPluginSettings(Plugin plugin) {
                super.initPluginSettings(plugin);
                if (PluginForHost.this.hasOldConfigContainer()) {
                    PluginConfigPanel oldStyle = PluginConfigPanel.create((LazyPlugin)PluginForHost.this.getLazyP());
                    if (oldStyle != null) {
                        this.add((Component)oldStyle, "pushx,growx,spanx");
                    }
                    this.oldStyle = oldStyle;
                }
            }

            @Override
            protected void onHide() {
                super.onHide();
                PluginConfigPanel oldStyle = this.oldStyle;
                if (oldStyle != null) {
                    oldStyle.setHidden();
                }
            }

            @Override
            protected void onShow() {
                super.onShow();
                PluginConfigPanel oldStyle = this.oldStyle;
                if (oldStyle != null) {
                    oldStyle.setShown();
                }
            }

            @Override
            public void save() {
            }
        };
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() {
        try {
            block15: {
                try {
                    DownloadInterface dl = this.getDownloadInterface();
                    if (dl == null) break block15;
                    try {
                        URLConnectionAdapter con = dl.getConnection();
                        if (con != null) {
                            con.disconnect();
                        }
                    }
                    finally {
                        dl.close();
                    }
                }
                catch (Throwable dl) {
                }
                finally {
                    this.setDownloadInterface(null);
                }
            }
            try {
                Browser br = this.getBrowser();
                if (br != null) {
                    br.disconnect();
                }
                this.br = null;
            }
            catch (Throwable throwable) {
                this.br = null;
            }
            catch (Throwable throwable) {
                this.br = null;
                throw throwable;
            }
        }
        finally {
            super.clean();
        }
    }

    public boolean gotDownloadInterface() {
        return this.dlSet;
    }

    public synchronized void setDownloadInterface(DownloadInterface dl) {
        DownloadInterface oldDl = this.dl;
        this.dl = dl;
        if (!this.dlSet && dl != null) {
            this.dlSet = true;
        }
        if (oldDl != null && oldDl != dl) {
            try {
                oldDl.close();
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    protected void setBrowserExclusive() {
        if (this.br != null && this.br.setCookiesExclusive(true)) {
            this.br.clearCookies(this.getHost());
        }
    }

    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        AccountInfo ai = new AccountInfo();
        account.setValid(true);
        return ai;
    }

    public abstract String getAGBLink();

    protected void enablePremium() {
        this.enablePremium(null);
    }

    protected void enablePremium(String url) {
        this.premiumurl = url;
        this.enablePremium = true;
    }

    public ArrayList<DownloadLink> getDownloadLinks(CrawledLink source, String data, FilePackage fp) {
        String[] hits = new Regex(data, this.getSupportedLinks()).getColumn(-1);
        if (hits == null || hits.length == 0) {
            return null;
        }
        ArrayList<DownloadLink> links = new ArrayList<DownloadLink>(hits.length);
        try {
            PluginForHost plugin = null;
            for (String url : hits) {
                url = url.trim();
                while (url.charAt(0) == '\"') {
                    url = url.substring(1);
                }
                while (url.charAt(url.length() - 1) == '\"') {
                    url = url.substring(0, url.length() - 1);
                }
                if (!this.isValidURL(url)) continue;
                if (plugin == null) {
                    plugin = this.getLazyP().getPrototype(null);
                }
                DownloadLink link = new DownloadLink(plugin, null, this.getHost(), url, true);
                links.add(link);
            }
        }
        catch (Throwable e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
        }
        if (fp != null && fp != FilePackage.getDefaultFilePackage()) {
            fp.addLinks(links);
        }
        return links;
    }

    public boolean isValidURL(String URL2) {
        return true;
    }

    @Override
    public Matcher getMatcher() {
        return this.lazyP.getMatcher();
    }

    public void correctDownloadLink(DownloadLink link) throws Exception {
    }

    public void onPluginAssigned(DownloadLink link) throws Exception {
    }

    public abstract DownloadLink.AvailableStatus requestFileInformation(DownloadLink var1) throws Exception;

    public int getMaxSimultanFreeDownloadNum() {
        return 1;
    }

    public int getMaxSimultanPremiumDownloadNum() {
        return -1;
    }

    public boolean isResumeable(DownloadLink link, Account account) {
        if (link != null) {
            return link.getBooleanProperty("PROPERTY_RESUMEABLE", false);
        }
        return false;
    }

    public int getMaxSimultanDownload(DownloadLink link, Account account, AbstractProxySelectorImpl proxy) {
        return this.getMaxSimultanDownload(link, account);
    }

    protected int getMaxSimultanDownload(DownloadLink link, Account account) {
        if (account == null) {
            int max = this.getMaxSimultanFreeDownloadNum();
            if (max >= 0) {
                return max;
            }
            if (max == -1) {
                return Integer.MAX_VALUE;
            }
            return 0;
        }
        int max = account.getMaxSimultanDownloads();
        if (max >= 1) {
            return max;
        }
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        if (max == 0) {
            max = this.getMaxSimultanPremiumDownloadNum();
            if (max >= 0) {
                return max;
            }
            if (max == -1) {
                return Integer.MAX_VALUE;
            }
            return 0;
        }
        return 0;
    }

    public String getHost(DownloadLink link, Account account, boolean includeSubdomain) {
        return this.getHost();
    }

    public void handlePremium(DownloadLink link, Account account) throws Exception {
        throw new PluginException(0x400000);
    }

    public abstract void handleFree(DownloadLink var1) throws Exception;

    public boolean canHandle(DownloadLink downloadLink, Account account) throws Exception {
        if (account != null && account.isMultiHost() && !account.getHoster().equals(downloadLink.getHost())) {
            AccountInfo ai = account.getAccountInfo();
            if (ai == null) {
                return false;
            }
            MultiHostHost mhost = ai.getMultihostSupportedHost(downloadLink.getHost());
            if (mhost == null) {
                return false;
            }
            if (!mhost.isEnabled()) {
                return false;
            }
            MultiHostHost.MultihosterHostStatus status = mhost.getStatus();
            if (status != MultiHostHost.MultihosterHostStatus.WORKING && status != MultiHostHost.MultihosterHostStatus.WORKING_UNSTABLE) {
                return false;
            }
            if (mhost.getUnavailableTimeMillis() > 0L) {
                throw new ConditionalSkipReasonException(new WaitingSkipReasonMultihostHostUnavailable(account, downloadLink.getHost(), mhost.getUnavailableStatusText(), mhost.getUnavailableUntilTimestamp()));
            }
        }
        return true;
    }

    public boolean allowHandle(DownloadLink downloadLink, PluginForHost plugin) {
        return true;
    }

    public AccountTrafficView getAccountTrafficView(Account account) {
        if (account == null) {
            return null;
        }
        return account.getAccountInfo();
    }

    public boolean enoughTrafficFor(DownloadLink link, Account account) throws Exception {
        if (account == null) {
            return true;
        }
        AccountInfo ai = account.getAccountInfo();
        if (ai == null) {
            return true;
        }
        long trafficLeft = ai.getTrafficLeft();
        long minimum = 1024L;
        long downloadSize = link.getView().getBytesTotalEstimated();
        long trafficNeeded = downloadSize > 0L ? Math.max(1024L, downloadSize - link.getView().getBytesLoaded()) : 1024L;
        if (account.isMultiHost() && !account.getHoster().equals(link.getHost())) {
            long host_TrafficLeft;
            MultiHostHost mhost = ai.getMultihostSupportedHost(link.getHost());
            if (mhost == null) {
                return false;
            }
            if (!mhost.isUnlimitedLinks() && mhost.getLinksLeft() <= 0L) {
                if (ai.isTrafficRefill()) {
                    throw new ConditionalSkipReasonException(new WaitForAccountTrafficSkipReasonMultihostLinksRequired(account, link.getHost(), mhost.getLinksMax()));
                }
                return false;
            }
            if (!mhost.isUnlimitedTraffic() && trafficNeeded > (host_TrafficLeft = Math.max(0L, mhost.getTrafficLeft()))) {
                if (ai.isTrafficRefill()) {
                    long howMuchTrafficIsMissing = trafficNeeded - host_TrafficLeft;
                    throw new ConditionalSkipReasonException(new WaitForAccountTrafficSkipReasonMultihostTrafficRequired(account, link.getHost(), howMuchTrafficIsMissing));
                }
                return false;
            }
            trafficNeeded = trafficNeeded * (long)mhost.getTrafficCalculationFactorPercent() / 100L;
        }
        if (!ai.isUnlimitedTraffic() && !ai.isSpecialTraffic() && trafficNeeded > trafficLeft) {
            if (ai.isTrafficRefill()) {
                long howMuchTrafficIsMissing = trafficNeeded - trafficLeft;
                throw new ConditionalSkipReasonException(new WaitForAccountTrafficSkipReason(account, howMuchTrafficIsMissing));
            }
            return false;
        }
        return true;
    }

    public FFmpeg getFFmpeg(Browser br, DownloadLink downloadLink) {
        return new FFmpeg(br){

            @Override
            public LogInterface getLogger() {
                return PluginForHost.this.getLogger();
            }
        };
    }

    public FFprobe getFFProbe(Browser br, DownloadLink downloadLink) {
        return new FFprobe(br){

            @Override
            public LogInterface getLogger() {
                return PluginForHost.this.getLogger();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFFmpeg(DownloadLink downloadLink, String reason) throws SkipReasonException, InterruptedException {
        FFmpeg ffmpeg = this.getFFmpeg(null, downloadLink);
        if (!ffmpeg.isAvailable()) {
            UpdateHandler handler = UpdateController.getInstance().getHandler();
            if (handler == null) {
                this.getLogger().warning("Please set FFmpeg: BinaryPath in advanced options");
                throw new SkipReasonException(SkipReason.FFMPEG_MISSING);
            }
            FFMpegInstallProgress progress = new FFMpegInstallProgress();
            progress.setProgressSource(this);
            try {
                downloadLink.addPluginProgress(progress);
                FFmpegProvider.getInstance().install(progress, reason);
            }
            finally {
                downloadLink.removePluginProgress(progress);
            }
            ffmpeg.setPath(((FFmpegSetup)JsonConfig.create(FFmpegSetup.class)).getBinaryPath());
            if (!ffmpeg.isAvailable()) {
                List requestedInstalls = handler.getRequestedInstalls();
                String extensionID = FFMpegInstallThread.getFFmpegExtensionName();
                if (requestedInstalls != null && extensionID != null && requestedInstalls.contains(extensionID)) {
                    throw new SkipReasonException(SkipReason.UPDATE_RESTART_REQUIRED);
                }
                throw new SkipReasonException(SkipReason.FFMPEG_MISSING);
            }
        } else if (!ffmpeg.isCompatible()) {
            this.getLogger().warning("Incompatible/non functional FFMPEG found!");
            throw new SkipReasonException(SkipReason.FFMPEG_MISSING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFFProbe(DownloadLink downloadLink, String reason) throws SkipReasonException, InterruptedException {
        FFprobe ffprobe = this.getFFProbe(null, downloadLink);
        if (!ffprobe.isAvailable()) {
            UpdateHandler handler = UpdateController.getInstance().getHandler();
            if (handler == null) {
                this.getLogger().warning("Please set FFProbe: BinaryPath in advanced options");
                throw new SkipReasonException(SkipReason.FFPROBE_MISSING);
            }
            FFMpegInstallProgress progress = new FFMpegInstallProgress();
            progress.setProgressSource(this);
            try {
                downloadLink.addPluginProgress(progress);
                FFmpegProvider.getInstance().install(progress, reason);
            }
            finally {
                downloadLink.removePluginProgress(progress);
            }
            ffprobe.setPath(((FFmpegSetup)JsonConfig.create(FFmpegSetup.class)).getBinaryPathProbe());
            if (!ffprobe.isAvailable()) {
                List requestedInstalls = handler.getRequestedInstalls();
                String extensionID = FFMpegInstallThread.getFFmpegExtensionName();
                if (requestedInstalls != null && extensionID != null && requestedInstalls.contains(extensionID)) {
                    throw new SkipReasonException(SkipReason.UPDATE_RESTART_REQUIRED);
                }
                throw new SkipReasonException(SkipReason.FFPROBE_MISSING);
            }
        } else if (!ffprobe.isCompatible()) {
            this.getLogger().warning("Incompatible/non functional FFProbe found!");
            throw new SkipReasonException(SkipReason.FFPROBE_MISSING);
        }
    }

    public void handle(DownloadLink downloadLink, Account account) throws Exception {
        Account previousAccount = this.setCurrentAccount(account);
        AccountCache.ACCOUNTTYPE accountType = null;
        try {
            this.waitForNextStartAllowed(downloadLink, account);
            if (account != null) {
                if (StringUtils.equalsIgnoreCase((String)account.getHoster(), (String)downloadLink.getHost())) {
                    accountType = AccountCache.ACCOUNTTYPE.ORIGINAL;
                    this.handlePremium(downloadLink, account);
                } else {
                    accountType = AccountCache.ACCOUNTTYPE.MULTI;
                    this.handleMultiHost(downloadLink, account);
                }
            } else {
                accountType = AccountCache.ACCOUNTTYPE.NONE;
                this.handleFree(downloadLink);
            }
            this.postHandle(downloadLink, account, this);
        }
        catch (Exception e) {
            this.handleException(downloadLink, accountType, account, e);
            throw e;
        }
        finally {
            try {
                if (this.dl != null) {
                    downloadLink.getDownloadLinkController().getConnectionHandler().removeConnectionHandler(this.dl.getManagedConnetionHandler());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.finalHandle(downloadLink, account, this);
            this.setCurrentAccount(previousAccount);
        }
    }

    protected void handleException(DownloadLink downloadLink, AccountCache.ACCOUNTTYPE accountType, Account account, Exception e) throws Exception {
        if (AccountCache.ACCOUNTTYPE.MULTI.equals((Object)accountType) && e instanceof PluginException && ((PluginException)e).getLinkStatus() == 32 && DownloadLink.AvailableStatus.TRUE.equals((Object)downloadLink.getAvailableStatus())) {
            throw new PluginException(2048, "Multihoster " + this.getHost() + " claims that this file is offline", e);
        }
    }

    @Override
    public Browser createNewBrowserInstance() {
        return new PluginBrowser<PluginForHost>(this);
    }

    protected void finalHandle(DownloadLink downloadLink, Account account, PluginForHost pluginForHost) {
    }

    public long getTrafficRequired(DownloadLink downloadLink, Account account, long bytes) {
        if (account == null) {
            return bytes;
        }
        AccountInfo ai = account.getAccountInfo();
        if (ai == null) {
            return bytes;
        }
        MultiHostHost mhost = ai.getMultihostSupportedHost(downloadLink.getHost());
        if (mhost == null) {
            return bytes;
        }
        return bytes * (long)mhost.getTrafficCalculationFactorPercent() / 100L;
    }

    public void update(DownloadLink downloadLink, Account account, long bytesTransfered) {
        if (account == null) {
            return;
        }
        if (bytesTransfered == 0L) {
            return;
        }
        AccountInfo ai = account.getAccountInfo();
        if (ai == null) {
            return;
        }
        if (ai.isUnlimitedTraffic()) {
            return;
        }
        long trafficToDeduct = this.getTrafficRequired(downloadLink, account, bytesTransfered);
        if (trafficToDeduct == 0L) {
            return;
        }
        long trafficLeft = Math.max(0L, ai.getTrafficLeft() - trafficToDeduct);
        ai.setTrafficLeft(trafficLeft);
    }

    public void postHandle(DownloadLink downloadLink, Account account, PluginForHost pluginForHost) throws Exception {
        GenericVariants var;
        if (pluginForHost == null) {
            return;
        }
        if (downloadLink == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((String)downloadLink.getHost(), (String)pluginForHost.getHost()) && downloadLink.hasGenericVariantSupport() && downloadLink.hasVariantSupport() && (var = downloadLink.getVariant(GenericVariants.class)) != null) {
            var.runPostDownload(this, downloadLink, account);
        }
    }

    public void preHandle(DownloadLink downloadLink, Account account, PluginForHost pluginForHost) throws Exception {
        GenericVariants var;
        if (pluginForHost == null) {
            return;
        }
        if (downloadLink == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((String)downloadLink.getHost(), (String)pluginForHost.getHost()) && downloadLink.hasGenericVariantSupport() && downloadLink.hasVariantSupport() && (var = downloadLink.getVariant(GenericVariants.class)) != null) {
            var.runPreDownload(this, downloadLink, account);
        }
    }

    public void handleMultiHost(DownloadLink downloadLink, Account account) throws Exception {
        this.logger.severe("invalid call to handleMultiHost: " + downloadLink.getName() + ":" + downloadLink.getHost() + " to " + this.getHost() + ":" + this.getVersion() + " with " + account);
        throw new PluginException(0x400000);
    }

    public void reset() {
    }

    public final void resetLink(DownloadLink downloadLink) {
        this.resetDownloadlink(downloadLink);
    }

    public void resetDownloadlink(DownloadLink link) {
    }

    public List<File> listProcessFiles(DownloadLink link) {
        HashSet<File> ret = new HashSet<File>();
        ret.add(new File(link.getFileOutputForPlugin(false, false) + ".part"));
        ret.add(new File(link.getFileOutputForPlugin(false, false)));
        ret.add(new File(link.getFileOutputForPlugin(false, true)));
        return new ArrayList<File>(ret);
    }

    public int getTimegapBetweenConnections() {
        return 50;
    }

    public String updateAccountPassword(Account account, String password) {
        if (password == null) {
            return null;
        }
        String ret = password.replaceAll("(?i)<" + Pattern.quote(this.getHost()) + ":EMPTY>", "");
        if (this.hasFeature(LazyPlugin.FEATURE.API_KEY_LOGIN)) {
            ret = ret.trim();
        }
        return ret;
    }

    public void setStartIntervall(long interval) {
        this.WAIT_BETWEEN_STARTS = Math.max(0L, interval);
    }

    protected long getStartInterval(DownloadLink downloadLink, Account account) {
        return this.WAIT_BETWEEN_STARTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForNextStartAllowed(DownloadLink downloadLink, Account account) throws PluginException, InterruptedException {
        SingleDownloadController.WaitingQueueItem queueItem = downloadLink.getDownloadLinkController().getQueueItem();
        long wait = Math.max(0L, this.getStartInterval(downloadLink, account));
        if (wait == 0L) {
            queueItem.lastStartTimestamp.set(System.currentTimeMillis());
            return;
        }
        PluginProgress progress = new PluginProgress(0L, 0L, null){
            private String pluginMessage;
            {
                this.pluginMessage = null;
            }

            @Override
            public String getMessage(Object requestor) {
                return this.pluginMessage;
            }

            @Override
            public PluginTaskID getID() {
                return PluginTaskID.WAIT;
            }

            @Override
            public void updateValues(long current, long total) {
                this.pluginMessage = current > 0L ? _JDT.T.gui_download_waittime_status2(Formatter.formatSeconds((long)(current / 1000L))) : null;
                super.updateValues(current, total);
            }
        };
        progress.setIcon(new AbstractIcon("wait", 16));
        progress.setProgressSource(this);
        progress.setDisplayInProgressColumnEnabled(false);
        try {
            long lastQueuePosition = -1L;
            long waitQueuePosition = -1L;
            long waitMax = 0L;
            long waitCur = 0L;
            SingleDownloadController.WaitingQueueItem waitingQueueItem = queueItem;
            synchronized (waitingQueueItem) {
                if (!queueItem.lastStartTimestamp.compareAndSet(0L, System.currentTimeMillis())) {
                    downloadLink.addPluginProgress(progress);
                    while ((waitQueuePosition = (long)queueItem.indexOf(downloadLink)) >= 0L && !downloadLink.getDownloadLinkController().isAborting()) {
                        if (waitQueuePosition != lastQueuePosition) {
                            waitCur = waitMax = queueItem.lastStartTimestamp.get() - System.currentTimeMillis() + (waitQueuePosition + 1L) * wait;
                            lastQueuePosition = waitQueuePosition;
                        }
                        if (waitCur <= 0L) break;
                        progress.updateValues(waitCur, waitMax);
                        long wTimeout = Math.min(1000L, Math.max(0L, waitCur));
                        queueItem.wait(wTimeout);
                        waitCur -= wTimeout;
                    }
                    if (downloadLink.getDownloadLinkController().isAborting()) {
                        throw new PluginException(4);
                    }
                }
                queueItem.lastStartTimestamp.set(System.currentTimeMillis());
            }
        }
        catch (InterruptedException e) {
            if (downloadLink.getDownloadLinkController().isAborting()) {
                throw new PluginException(4, null, -1L, e);
            }
            throw e;
        }
        finally {
            downloadLink.removePluginProgress(progress);
        }
    }

    public void waitForNextConnectionAllowed(DownloadLink downloadLink) throws InterruptedException {
        long lastConnectionTimestamp;
        SingleDownloadController.WaitingQueueItem queueItem = downloadLink.getDownloadLinkController().getQueueItem();
        long wait = this.getTimegapBetweenConnections();
        if (wait <= 0L) {
            queueItem.lastConnectionTimestamp.set(System.currentTimeMillis());
            return;
        }
        do {
            long waitCur;
            if ((waitCur = Math.max(0L, (lastConnectionTimestamp = queueItem.lastConnectionTimestamp.get()) - System.currentTimeMillis() + wait)) <= 0L) {
                queueItem.lastConnectionTimestamp.set(System.currentTimeMillis());
                break;
            }
            if (downloadLink.getDownloadLinkController().isAborting()) {
                throw new InterruptedException("Controller aborted");
            }
            Thread.sleep(waitCur);
        } while (!queueItem.lastConnectionTimestamp.compareAndSet(lastConnectionTimestamp, System.currentTimeMillis()));
        if (downloadLink.getDownloadLinkController().isAborting()) {
            throw new InterruptedException("Controller aborted");
        }
    }

    protected void sleep(long i, DownloadLink downloadLink) throws PluginException {
        this.sleep(i, downloadLink, "");
    }

    @Deprecated
    public void resetPluginGlobals() {
    }

    @Override
    protected boolean isAbort() {
        DownloadLink link = this.getDownloadLink();
        if (link != null) {
            SingleDownloadController con = link.getDownloadLinkController();
            return con != null && con.isAborting() || Thread.currentThread().isInterrupted();
        }
        return super.isAbort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep(long i, DownloadLink downloadLink, String message) throws PluginException {
        if (this.isAbort()) {
            throw new PluginException(4);
        }
        SleepPluginProgress progress = new SleepPluginProgress(i, message);
        progress.setProgressSource(this);
        progress.setDisplayInProgressColumnEnabled(false);
        try {
            downloadLink.addPluginProgress(progress);
            while (i > 0L && !this.isAbort()) {
                ((PluginProgress)progress).setCurrent(i);
                PluginForHost pluginForHost = this;
                synchronized (pluginForHost) {
                    this.wait(Math.min(1000L, Math.max(0L, i)));
                }
                i -= 1000L;
            }
        }
        catch (InterruptedException e) {
            throw new PluginException(4, null, -1L, e);
        }
        finally {
            downloadLink.removePluginProgress(progress);
        }
        if (this.isAbort()) {
            throw new PluginException(4);
        }
    }

    public String getBuyPremiumUrl() {
        return this.premiumurl;
    }

    public boolean isPremiumEnabled() {
        return this.enablePremium;
    }

    public DownloadLink setDownloadLink(DownloadLink link) {
        DownloadLink ret = this.getDownloadLink();
        this.link = link;
        return ret;
    }

    public DownloadLink buildAccountCheckDownloadLink(Account account) {
        String user = account.getUser();
        if (StringUtils.isEmpty((String)user)) {
            user = "";
        }
        return new DownloadLink(this, "Account (" + user + ")@" + account.getHoster(), this.getHost(), "https://" + account.getHoster(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserInput(String title, String message, DownloadLink link) throws PluginException {
        if (message == null) {
            message = _GUI.T.AskForPasswordDialog_AskForPasswordDialog_title_();
        }
        if (link == null) {
            link = this.getDownloadLink();
        }
        UserIOProgress prg = new UserIOProgress(message);
        prg.setProgressSource(PluginForHost.getCurrentActivePlugin());
        prg.setDisplayInProgressColumnEnabled(false);
        try {
            link.addPluginProgress(prg);
            AskDownloadPasswordDialogInterface handle = (AskDownloadPasswordDialogInterface)UIOManager.I().show(AskDownloadPasswordDialogInterface.class, (UserIODefinition)new AskForDownloadLinkDialog(title, message, link));
            if (handle.getCloseReason() != CloseReason.OK) {
                throw new PluginException(131072, _JDT.T.plugins_errors_wrongpassword());
            }
            String password = handle.getText();
            if (StringUtils.isEmpty((String)password)) {
                throw new PluginException(131072, _JDT.T.plugins_errors_wrongpassword());
            }
            String string = password;
            return string;
        }
        finally {
            link.removePluginProgress(prg);
        }
    }

    public String getUserInput(String message, DownloadLink link) throws PluginException {
        return this.getUserInput(_GUI.T.AskForPasswordDialog_AskForPasswordDialog_title_(), message, link);
    }

    protected String getTwoFACode(Account account, Object patternO) throws PluginException {
        if (account == null) {
            throw new IllegalArgumentException();
        }
        Pattern pattern = null;
        if (patternO != null) {
            if (patternO instanceof Pattern) {
                pattern = (Pattern)patternO;
            } else if (patternO instanceof String) {
                pattern = Pattern.compile(patternO.toString());
            } else {
                throw new IllegalArgumentException();
            }
        }
        DownloadLink dl_dummy = new DownloadLink(this, "Account 2FA login", this.getHost(), "https://" + account.getHoster(), true);
        String twoFACode = this.getUserInput(_GUI.T.jd_gui_swing_components_AccountDialog_2FA_login(), dl_dummy);
        if (twoFACode != null) {
            twoFACode = twoFACode.trim();
        }
        if (StringUtils.isEmpty((String)twoFACode)) {
            throw new AccountInvalidException("Invalid/empty 2FA result.");
        }
        if (pattern != null && !new Regex(twoFACode, pattern).patternMatches()) {
            throw new AccountInvalidException(_GUI.T.jd_gui_swing_components_AccountDialog_2FA_login_invalid_format(pattern.pattern()));
        }
        return twoFACode;
    }

    public long getAvailableStatusTimeout(DownloadLink link, DownloadLink.AvailableStatus availableStatus) {
        if (availableStatus != null) {
            switch (availableStatus) {
                case TRUE: 
                case FALSE: {
                    return 300000L;
                }
            }
            return 120000L;
        }
        return 60000L;
    }

    public DownloadLink getDownloadLink() {
        return this.link;
    }

    public String rewriteHost(String host) {
        if (host != null && host.equals(this.getHost())) {
            return this.getHost();
        }
        return null;
    }

    protected String rewriteHost(List<String[]> pluginDomains, String host, String ... rewriteEnabledHosts) {
        if (rewriteEnabledHosts == null || rewriteEnabledHosts.length == 0 || Arrays.asList(rewriteEnabledHosts).contains(this.getHost())) {
            if (host == null) {
                return this.getHost();
            }
            String mapping = this.getMappedHost(pluginDomains, host);
            return mapping;
        }
        return null;
    }

    public PluginForHost assignPlugin(PluginFinder pluginFinder, DownloadLink link) {
        if (link == null) {
            return null;
        }
        link.setHost(this.getHost());
        link.setDefaultPlugin(this);
        return this;
    }

    public boolean assignPlugin(Account account) {
        if (account == null) {
            return false;
        }
        String oldHost = account.getHoster();
        List<String> hosterHistory = account.getHosterHistory();
        if (hosterHistory == null) {
            hosterHistory = new ArrayList<String>();
            account.setHosterHistory(hosterHistory);
        }
        if (!hosterHistory.contains(oldHost)) {
            hosterHistory.add(oldHost);
        }
        account.setHoster(this.getHost());
        account.setPlugin(this);
        return true;
    }

    public static boolean implementsRewriteHost(PluginForHost plugin) {
        if (plugin == null) {
            return false;
        }
        try {
            Method method = plugin.getClass().getMethod("rewriteHost", String.class);
            boolean implementsHandlePremium = method.getDeclaringClass() != PluginForHost.class;
            return implementsHandlePremium && plugin.rewriteHost(null) != null;
        }
        catch (NoSuchMethodException e) {
            LogController.CL().log((Throwable)e);
            return false;
        }
        catch (Throwable e) {
            LogController.CL().log(e);
            return false;
        }
    }

    public static boolean implementsAllowHandle(PluginForHost plugin) {
        if (plugin == null) {
            return false;
        }
        try {
            Method method = plugin.getClass().getMethod("allowHandle", DownloadLink.class, PluginForHost.class);
            boolean implementsHandlePremium = method.getDeclaringClass() != PluginForHost.class;
            return implementsHandlePremium;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Throwable e) {
            LogController.CL().log(e);
            return false;
        }
    }

    public boolean internal_supportsMassLinkcheck() {
        return PluginForHost.implementsCheckLinks(this);
    }

    public static boolean implementsCheckLinks(PluginForHost plugin) {
        if (plugin == null) {
            return false;
        }
        try {
            Method method = plugin.getClass().getMethod("checkLinks", new DownloadLink[0].getClass());
            boolean hasMassCheck = method.getDeclaringClass() != PluginForHost.class;
            return hasMassCheck;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Throwable e) {
            LogController.CL().log(e);
            return false;
        }
    }

    public static boolean implementsHandlePremium(PluginForHost plugin) {
        if (plugin == null) {
            return false;
        }
        if (!plugin.isPremiumEnabled()) {
            return false;
        }
        try {
            Method method = plugin.getClass().getMethod("handlePremium", DownloadLink.class, Account.class);
            boolean implementsHandlePremium = method.getDeclaringClass() != PluginForHost.class;
            return implementsHandlePremium;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Throwable e) {
            LogController.CL().log(e);
            return false;
        }
    }

    public static boolean implementsSortDownloadLink(PluginForHost plugin) {
        if (plugin == null) {
            return false;
        }
        try {
            Method method = plugin.getClass().getMethod("sortDownloadLinks", Account.class, List.class);
            boolean implementsSortDownloadLink = method.getDeclaringClass() != PluginForHost.class;
            return implementsSortDownloadLink;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Throwable e) {
            LogController.CL().log(e);
            return false;
        }
    }

    public boolean hasCaptcha(DownloadLink link, Account acc) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean expectCaptcha(DownloadLink link, Account acc) {
        WeakHashMap<Account, HashMap<String, Boolean>> weakHashMap = AUTOCAPTCHAMAP;
        synchronized (weakHashMap) {
            String ID2;
            Boolean captcha;
            HashMap<String, Boolean> map = AUTOCAPTCHAMAP.get(acc);
            if (map != null && (captcha = map.get(ID2 = this.getHost() + "_" + (acc != null ? acc.getType() : "") + "_" + link.getHost())) != null) {
                return captcha;
            }
            return this.hasCaptcha(link, acc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasCaptcha(DownloadLink link, Account acc, Boolean hasCaptcha) {
        WeakHashMap<Account, HashMap<String, Boolean>> weakHashMap = AUTOCAPTCHAMAP;
        synchronized (weakHashMap) {
            HashMap<String, Boolean> map;
            if (hasCaptcha != null && hasCaptcha.booleanValue() != this.hasCaptcha(link, acc)) {
                SingleDownloadController controller = link.getDownloadLinkController();
                LogInterface logger = controller != null ? controller.getLogger() : this.getLogger();
                logger.info("Outdated hasCaptcha detected:" + this.getHost());
            }
            if ((map = AUTOCAPTCHAMAP.get(acc)) == null && Boolean.TRUE.equals(hasCaptcha)) {
                map = new HashMap();
                AUTOCAPTCHAMAP.put(acc, map);
            }
            if (map != null) {
                String ID2 = this.getHost() + "_" + (acc != null ? acc.getType() : "") + "_" + link.getHost();
                if (hasCaptcha == null) {
                    if (map.remove(ID2).booleanValue() && map.size() == 0) {
                        AUTOCAPTCHAMAP.remove(acc);
                    }
                } else {
                    map.put(ID2, hasCaptcha);
                }
            }
        }
    }

    public boolean hasAutoCaptcha() {
        return JACMethod.hasMethod((String)this.getHost());
    }

    public String filterPackageID(String packageIdentifier) {
        return packageIdentifier;
    }

    public char[] getFilenameReplaceMap() {
        return new char[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URLConnectionAdapter checkDownloadableRequest(DownloadLink link, Browser br, Request request, long setSizeLargerThan, boolean closeConnection) throws IOException, PluginException {
        if (request == null) {
            return null;
        }
        URLConnectionAdapter con = null;
        boolean closeFlag = true;
        request.getHeaders().put("Accept-Encoding", "identity");
        con = br.openRequestConnection(request);
        if (this.looksLikeDownloadableContent(con)) {
            long completeContentLength = con.getCompleteContentLength();
            if (completeContentLength > setSizeLargerThan) {
                if (con.isContentDecoded()) {
                    link.setDownloadSize(completeContentLength);
                } else {
                    link.setVerifiedFileSize(completeContentLength);
                }
            }
            closeFlag = closeConnection;
            URLConnectionAdapter uRLConnectionAdapter = con;
            return uRLConnectionAdapter;
        }
        try {
            br.followConnection(true);
        }
        catch (IOException ignore) {
            this.logger.log((Throwable)ignore);
        }
        URLConnectionAdapter uRLConnectionAdapter = null;
        return uRLConnectionAdapter;
        finally {
            if (con != null && closeFlag) {
                try {
                    con.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public String autoFilenameCorrection(HashMap<Object, Object> cache, String originalFilename, DownloadLink downloadLink, ArrayList<DownloadLink> dlinks) {
        try {
            String MD5 = downloadLink.getMD5Hash();
            String SHA1 = downloadLink.getSha1Hash();
            String SHA256 = downloadLink.getSha256Hash();
            String[] fileNameSplit = null;
            Pattern pattern = null;
            if (cache != null) {
                fileNameSplit = (String[])cache.get(AUTO_FILE_NAME_CORRECTION_NAME_SPLIT + originalFilename);
                pattern = (Pattern)cache.get(AUTO_FILE_NAME_CORRECTION_NAME_SPLIT_PATTERN + originalFilename);
            }
            char[] originalReplaces = this.getFilenameReplaceMap();
            if (pattern == null) {
                for (Pattern p : PATTERNS) {
                    fileNameSplit = new Regex(originalFilename, p).getRow(0);
                    if (fileNameSplit == null) continue;
                    pattern = p;
                    if (cache == null) break;
                    cache.put(AUTO_FILE_NAME_CORRECTION_NAME_SPLIT + originalFilename, fileNameSplit);
                    cache.put(AUTO_FILE_NAME_CORRECTION_NAME_SPLIT_PATTERN + originalFilename, pattern);
                    break;
                }
            }
            if (fileNameSplit == null) {
                fileNameSplit = CrossSystem.splitFileName((String)originalFilename);
                pattern = null;
            }
            String filteredName = this.filterPackageID(fileNameSplit[0]);
            for (DownloadLink next : dlinks) {
                String newName;
                String prototypeName;
                if (downloadLink == next || next.getHost().equals(this.getHost()) || (prototypeName = next.getNameSetbyPlugin()).equals(originalFilename)) continue;
                if (prototypeName.equalsIgnoreCase(originalFilename) && (newName = this.fixCase(cache, originalFilename, prototypeName)) != null) {
                    return newName;
                }
                String prototypesplit = null;
                if (cache != null && pattern != null) {
                    prototypesplit = (String)cache.get(prototypeName + pattern.toString());
                }
                if (prototypesplit == null) {
                    prototypesplit = pattern != null ? new Regex(prototypeName, pattern).getMatch(0) : CrossSystem.splitFileName((String)prototypeName)[0];
                    if (prototypesplit == null) continue;
                    if (cache != null && pattern != null) {
                        cache.put(prototypeName + pattern.toString(), prototypesplit);
                    }
                }
                if (fileNameSplit[0].equals(prototypesplit)) continue;
                if (this.isHosterManipulatesFilenames() && fileNameSplit[0].length() == prototypesplit.length() && filteredName.equalsIgnoreCase(this.filterPackageID(prototypesplit)) && (newName = this.getFixedFileName(cache, originalFilename, originalReplaces, prototypesplit, next.getDefaultPlugin().getFilenameReplaceMap())) != null) {
                    String caseFix = this.fixCase(cache, newName + fileNameSplit[1], prototypeName);
                    if (caseFix != null) {
                        return caseFix;
                    }
                    return newName + fileNameSplit[1];
                }
                if (!(!StringUtils.isEmpty((String)MD5) && MD5.equalsIgnoreCase(next.getMD5Hash()) || !StringUtils.isEmpty((String)SHA1) && SHA1.equalsIgnoreCase(next.getSha1Hash())) && (StringUtils.isEmpty((String)SHA256) || !SHA256.equalsIgnoreCase(next.getSha256Hash()))) continue;
                return next.getView().getDisplayName();
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        return null;
    }

    protected String getFixedFileName(HashMap<Object, Object> cache, String originalFilename, char[] originalReplaces, String prototypeName, char[] prototypeReplaces) {
        int index;
        if (originalReplaces.length == 0 && prototypeReplaces.length == 0) {
            return null;
        }
        Boolean original = (Boolean)cache.get(originalFilename + new String(originalReplaces));
        Boolean prototype = (Boolean)cache.get(prototypeName + new String(prototypeReplaces));
        if (Boolean.FALSE.equals(original) && Boolean.FALSE.equals(prototype)) {
            return null;
        }
        ArrayList<Character> foundOriginalReplaces = new ArrayList<Character>(originalReplaces.length);
        ArrayList<Character> foundPrototypeReplaces = new ArrayList<Character>(prototypeReplaces.length);
        if (original == null) {
            for (index = 0; index < originalReplaces.length; ++index) {
                if (originalFilename.indexOf(originalReplaces[index]) < 0) continue;
                foundOriginalReplaces.add(Character.valueOf(originalReplaces[index]));
            }
        }
        if (prototype == null) {
            for (index = 0; index < prototypeReplaces.length; ++index) {
                if (prototypeName.indexOf(prototypeReplaces[index]) < 0) continue;
                foundPrototypeReplaces.add(Character.valueOf(prototypeReplaces[index]));
            }
        }
        if (original == null && foundOriginalReplaces.size() == 0) {
            cache.put(originalFilename + new String(originalReplaces), Boolean.FALSE);
        }
        if (prototype == null && foundPrototypeReplaces.size() == 0) {
            cache.put(prototypeName + new String(prototypeReplaces), Boolean.FALSE);
        }
        if (foundOriginalReplaces.size() == 0 && foundOriginalReplaces.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block2: for (int i = 0; i < prototypeName.length(); ++i) {
            char oC = originalFilename.charAt(i);
            char pC = prototypeName.charAt(i);
            if (Character.toLowerCase(oC) != Character.toLowerCase(pC)) {
                for (Character oCC : foundOriginalReplaces) {
                    if (oC != oCC.charValue()) continue;
                    sb.append(pC);
                    continue block2;
                }
                for (Character pCC : foundPrototypeReplaces) {
                    if (pC != pCC.charValue()) continue;
                    sb.append(oC);
                    continue block2;
                }
                return null;
            }
            sb.append(oC);
        }
        return sb.toString();
    }

    protected String fixCase(HashMap<Object, Object> cache, String originalFilename, String prototypeName) {
        Object ret;
        if (cache != null && (ret = cache.get(originalFilename + "_" + prototypeName)) != null) {
            return (String)ret;
        }
        boolean eic = originalFilename.equals(prototypeName);
        StringBuilder sb = new StringBuilder(prototypeName.length());
        for (int i = 0; i < prototypeName.length(); ++i) {
            char c = originalFilename.charAt(i);
            char correctc = prototypeName.charAt(i);
            if (Character.toLowerCase(c) == Character.toLowerCase(correctc)) {
                if (eic) {
                    sb.append(Character.isUpperCase(c) ? c : correctc);
                    continue;
                }
                sb.append(correctc);
                continue;
            }
            if (Character.isDigit(c) && Character.isDefined(correctc)) {
                sb.append(c);
                continue;
            }
            return null;
        }
        if (cache != null) {
            cache.put(originalFilename + "_" + prototypeName, sb.toString());
        }
        return sb.toString();
    }

    public boolean isHosterManipulatesFilenames() {
        return false;
    }

    public JComponent layoutPremiumInfoPanel(AbstractDialog dialog) {
        return null;
    }

    public AccountBuilderInterface getAccountFactory(InputChangedCallbackInterface callback) {
        if (this.hasFeature(LazyPlugin.FEATURE.COOKIE_LOGIN_ONLY) || this.hasFeature(LazyPlugin.FEATURE.COOKIE_LOGIN_OPTIONAL)) {
            return new DefaultEditAccountPanelCookieLogin(callback, this);
        }
        if (this.hasFeature(LazyPlugin.FEATURE.USERNAME_IS_EMAIL)) {
            return new DefaultEditAccountPanelCookieLogin(callback, this);
        }
        if (this.hasFeature(LazyPlugin.FEATURE.API_KEY_LOGIN)) {
            return new DefaultEditAccountPanelAPIKeyLogin(callback, this);
        }
        return new DefaultEditAccountPanel(callback, this, false);
    }

    public void resumeDownloadlink(DownloadLink downloadLink) {
    }

    public boolean checkLinks(DownloadLink[] urls) {
        return false;
    }

    public DownloadLink.AvailableStatus checkLink(DownloadLink downloadLink) throws Exception {
        return this.requestFileInformation(downloadLink);
    }

    public AccountConfigInterface getAccountJsonConfig(Account acc) {
        return AccountJsonConfig.get(this, acc);
    }

    @Override
    public boolean isHandlingMultipleHosts() {
        try {
            if (this.hasFeature(LazyPlugin.FEATURE.GENERIC)) {
                return true;
            }
            Method method = this.getClass().getMethod("getHost", DownloadLink.class, Account.class, Boolean.TYPE);
            boolean ret = method.getDeclaringClass() != PluginForHost.class;
            return ret;
        }
        catch (Throwable throwable) {
            return super.isHandlingMultipleHosts();
        }
    }

    @Override
    protected void displayBubbleNotification(String title, String text) {
        DownloadLink link = this.getDownloadLink();
        this.displayBubbleNotification(title, text, link != null ? link.getDomainInfo().getIcon(32) : null);
    }

    @Override
    public String getCrawlerLoggerID(CrawledLink link) {
        return this.getHost() + "_" + this.getLazyP().getClassName();
    }

    public void setActiveVariantByLink(DownloadLink downloadLink, LinkVariant variant) {
        downloadLink.setVariant(variant);
        if (variant instanceof GenericVariants) {
            GenericVariants v = (GenericVariants)variant;
            switch (v) {
                case ORIGINAL: {
                    downloadLink.setCustomExtension(null);
                    break;
                }
                default: {
                    downloadLink.setCustomExtension(v.getExtension());
                }
            }
        }
    }

    public LinkVariant getActiveVariantByLink(DownloadLink downloadLink) {
        return downloadLink.getVariant(GenericVariants.class);
    }

    public List<? extends LinkVariant> getVariantsByLink(DownloadLink downloadLink) {
        return downloadLink.getVariants(GenericVariants.class);
    }

    public JComponent getVariantPopupComponent(DownloadLink downloadLink) {
        return null;
    }

    public boolean hasVariantToChooseFrom(DownloadLink downloadLink) {
        List<? extends LinkVariant> variants = this.getVariantsByLink(downloadLink);
        return variants != null && variants.size() > 0;
    }

    protected void updateDownloadLink(CheckableLink checkableLink, String url) {
        DownloadLink downloadLink;
        DownloadLink downloadLink2 = downloadLink = checkableLink != null ? checkableLink.getDownloadLink() : null;
        if (downloadLink == null || url == null) {
            return;
        }
        downloadLink.setPluginPatternMatcher(url);
        downloadLink.setDomainInfo(null);
        downloadLink.resume(Arrays.asList(this));
        LinkChecker<CheckableLink> linkChecker = new LinkChecker<CheckableLink>(true);
        linkChecker.check(checkableLink);
    }

    protected boolean supportsUpdateDownloadLink(CheckableLink downloadLink) {
        return false;
    }

    public Object getFavIcon(String host) throws IOException {
        return null;
    }

    protected JMenuItem createChangeURLMenuItem(final CheckableLink checkableLink) {
        DownloadLink downloadLink;
        DownloadLink downloadLink2 = downloadLink = checkableLink != null ? checkableLink.getDownloadLink() : null;
        if (downloadLink == null || UrlProtection.PROTECTED_CONTAINER.equals((Object)downloadLink.getUrlProtection())) {
            return null;
        }
        return new JMenuItem((Action)new BasicAction(){
            private static final long serialVersionUID = 5968961149921441923L;
            private final BadgeIcon icon;
            {
                this.icon = new BadgeIcon(downloadLink.getDomainInfo(), new AbstractIcon("url", 16), 4, 4);
                this.setName(_GUI.T.lit_change_url());
                this.setSmallIcon((Icon)((Object)this.icon));
            }

            public void actionPerformed(ActionEvent e) {
                InputDialogInterface ret = (InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)new InputDialog(0, " " + downloadLink.getName(), _GUI.T.lit_change_url(), downloadLink.getPluginPatternMatcher(), (Icon)((Object)this.icon), null, null));
                try {
                    ret.throwCloseExceptions();
                    final String url = ret.getText();
                    if (!StringUtils.equals((String)downloadLink.getPluginPatternMatcher(), (String)url)) {
                        if (checkableLink instanceof CrawledLink) {
                            LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                                protected Void run() throws RuntimeException {
                                    PluginForHost.this.updateDownloadLink(checkableLink, url);
                                    return null;
                                }
                            });
                        } else {
                            DownloadWatchDog.getInstance().enqueueJob(new DownloadWatchDogJob(){

                                @Override
                                public boolean isHighPriority() {
                                    return false;
                                }

                                @Override
                                public void interrupt() {
                                }

                                @Override
                                public void execute(DownloadSession currentSession) {
                                    SingleDownloadController con = downloadLink.getDownloadLinkController();
                                    if (con == null) {
                                        PluginForHost.this.updateDownloadLink(checkableLink, url);
                                    } else {
                                        con.getJobsAfterDetach().add(new DownloadWatchDogJob(){

                                            @Override
                                            public void execute(DownloadSession currentSession) {
                                                PluginForHost.this.updateDownloadLink(checkableLink, url);
                                            }

                                            @Override
                                            public void interrupt() {
                                            }

                                            @Override
                                            public boolean isHighPriority() {
                                                return false;
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                }
                catch (DialogNoAnswerException dialogNoAnswerException) {
                    // empty catch block
                }
            }
        });
    }

    public List<JComponent> extendLinkgrabberContextMenu(final AtomicBoolean isCancelled, JComponent parent, final SelectionInfo.PluginView<CrawledLink> pv, Collection<SelectionInfo.PluginView<CrawledLink>> allPvs) {
        JMenuItem changeURLMenuItem;
        ArrayList<JComponent> ret = new ArrayList<JComponent>();
        if (pv.size() == 1 && this.supportsUpdateDownloadLink((CheckableLink)pv.get(0)) && (changeURLMenuItem = this.createChangeURLMenuItem((CheckableLink)pv.get(0))) != null) {
            ret.add(changeURLMenuItem);
        }
        if (allPvs.size() != 1) {
            return ret;
        }
        final JMenu setVariants = new JMenu(_GUI.T.PluginForHost_extendLinkgrabberContextMenu_generic_convert());
        DomainInfo domainInfo = DomainInfo.getInstance(this.getHost());
        setVariants.setIcon(domainInfo.getFavIcon());
        setVariants.setEnabled(false);
        final JMenu addVariants = new JMenu("Add converted variant...");
        addVariants.setIcon((Icon)((Object)new BadgeIcon(domainInfo, new AbstractIcon("add", 16), 4, 4)));
        addVariants.setEnabled(false);
        new Thread("Collect Variants"){
            {
                super(x0);
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                HashSet<GenericVariants> map = new HashSet<GenericVariants>();
                final ArrayList<GenericVariants> list = new ArrayList<GenericVariants>();
                for (CrawledLink cl : pv.getChildren()) {
                    List<GenericVariants> v;
                    if (isCancelled.get()) break;
                    if (cl.getDownloadLink() == null || !cl.getDownloadLink().getBooleanProperty("GENERIC_VARIANTS", false).booleanValue() || !cl.getDownloadLink().hasVariantSupport() || (v = cl.getDownloadLink().getVariants(GenericVariants.class)) == null) continue;
                    for (LinkVariant linkVariant : v) {
                        if (!(linkVariant instanceof GenericVariants) || !map.add((GenericVariants)linkVariant)) continue;
                        list.add((GenericVariants)linkVariant);
                    }
                }
                if (list.size() == 0) {
                    return;
                }
                Collections.sort(list, new Comparator<GenericVariants>(){

                    @Override
                    public int compare(GenericVariants o1, GenericVariants o2) {
                        return o1.name().compareTo(o2.name());
                    }
                });
                if (isCancelled.get()) {
                    return;
                }
                new EDTRunner(){

                    protected void runInEDT() {
                        setVariants.setEnabled(true);
                        addVariants.setEnabled(true);
                        setVariants.setVisible(true);
                        addVariants.setVisible(true);
                        for (final GenericVariants gv : list) {
                            setVariants.add(new JMenuItem((Action)new BasicAction(){
                                {
                                    this.setName(gv._getName(PluginForHost.this.link));
                                }

                                public void actionPerformed(ActionEvent e) {
                                    ArrayList<CrawledLink> checkableLinks = new ArrayList<CrawledLink>(1);
                                    block0: for (CrawledLink cl : pv.getChildren()) {
                                        for (LinkVariant linkVariant : PluginForHost.this.getVariantsByLink(cl.getDownloadLink())) {
                                            if (!linkVariant.equals(gv)) continue;
                                            LinkCollector.getInstance().setActiveVariantForLink(cl, (LinkVariant)gv);
                                            checkableLinks.add(cl);
                                            continue block0;
                                        }
                                    }
                                    LinkChecker<ArrayList<CrawledLink>> linkChecker = new LinkChecker<ArrayList<CrawledLink>>(true);
                                    linkChecker.check(checkableLinks);
                                }
                            }));
                            addVariants.add(new JMenuItem((Action)new BasicAction(){
                                {
                                    this.setName(gv._getName(PluginForHost.this.link));
                                }

                                public void actionPerformed(ActionEvent e) {
                                    ArrayList<CrawledLink> checkableLinks = new ArrayList<CrawledLink>(1);
                                    block0: for (CrawledLink cl : pv.getChildren()) {
                                        ArrayList variants = new ArrayList();
                                        for (LinkVariant linkVariant : PluginForHost.this.getVariantsByLink(cl.getDownloadLink())) {
                                            if (!linkVariant.equals(gv)) continue;
                                            CrawledLink newLink = LinkCollector.getInstance().addAdditional(cl, gv);
                                            if (newLink != null) {
                                                checkableLinks.add(newLink);
                                                continue block0;
                                            }
                                            Toolkit.getDefaultToolkit().beep();
                                            continue block0;
                                        }
                                    }
                                    LinkChecker<ArrayList<CrawledLink>> linkChecker = new LinkChecker<ArrayList<CrawledLink>>(true);
                                    linkChecker.check(checkableLinks);
                                }
                            }));
                        }
                    }
                };
            }
        }.start();
        ret.add(setVariants);
        ret.add(addVariants);
        return ret;
    }

    public List<JComponent> extendDownloadsTableContextMenu(AtomicBoolean isCancelled, JComponent parent, SelectionInfo.PluginView<DownloadLink> pv, Collection<SelectionInfo.PluginView<DownloadLink>> views) {
        JMenuItem changeURLMenuItem;
        if (pv.size() == 1 && this.supportsUpdateDownloadLink((CheckableLink)pv.get(0)) && (changeURLMenuItem = this.createChangeURLMenuItem((CheckableLink)pv.get(0))) != null) {
            ArrayList<JComponent> ret = new ArrayList<JComponent>();
            ret.add(changeURLMenuItem);
            return ret;
        }
        return null;
    }

    public Downloadable newDownloadable(DownloadLink downloadLink, Browser br) {
        return new DownloadLinkDownloadable(downloadLink, br);
    }

    public List<Account> sortAccounts(DownloadLink downloadLink, List<Account> accounts) {
        return accounts;
    }

    public List<DownloadLink> sortDownloadLinks(Account account, List<DownloadLink> downloadLinks) {
        return downloadLinks;
    }

    protected AskToUsePremiumDialog createAskToUsePremiumDialog() {
        AskToUsePremiumDialog dialog = new AskToUsePremiumDialog(this){

            public String getDontShowAgainKey() {
                return "adsPremium_" + this.getDomain();
            }
        };
        dialog.setTimeout(60000);
        return dialog;
    }

    @Deprecated
    protected void showFreeDialog(String domain) throws PluginException {
        this.showFreeDialog();
    }

    protected void showFreeDialog() throws PluginException {
        AskToUsePremiumDialog dialog = this.createAskToUsePremiumDialog();
        try {
            ((AskToUsePremiumDialogInterface)UIOManager.I().show(AskToUsePremiumDialogInterface.class, (UserIODefinition)dialog)).throwCloseExceptions();
            CrossSystem.openURL((URL)new URL(dialog.getPremiumUrl()));
        }
        catch (DialogNoAnswerException e) {
            this.logger.log((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new PluginException(0x400000, null, -1L, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkShowFreeDialog(String domain) {
        if (domain == null) {
            return false;
        }
        if (Application.isHeadless()) {
            return false;
        }
        try {
            Object object = CHECKSHOWFREEDIALOGLOCK;
            synchronized (object) {
                String key = JDHash.getMD5((String)domain) + "_05032020";
                long TIMEOUT = 5356800000L;
                long lastTimestamp = -1L;
                SubConfiguration config = null;
                try {
                    config = this.getPluginConfig();
                    Object value = config.getProperty(key, null);
                    if (value != null) {
                        try {
                            lastTimestamp = Long.parseLong(value.toString());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (lastTimestamp < 0L || System.currentTimeMillis() - lastTimestamp > 5356800000L) {
                        lastTimestamp = System.currentTimeMillis();
                        boolean bl = true;
                        return bl;
                    }
                    config = null;
                    lastTimestamp = -1L;
                }
                finally {
                    if (config != null && lastTimestamp > 0L) {
                        config.setProperty(key, Long.toString(lastTimestamp));
                        config.save();
                    }
                }
                return false;
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(DownloadLink link, String currentDirectory, String currentName, String newDirectory, String newName) throws Exception {
        if (link.getView().getBytesLoaded() <= 0L) {
            return;
        }
        if (StringUtils.isEmpty((String)newName)) {
            newName = currentName;
        }
        if (StringUtils.isEmpty((String)newDirectory)) {
            newDirectory = currentDirectory;
        }
        if (CrossSystem.isWindows() ? StringUtils.equalsIgnoreCase((String)currentDirectory, (String)newDirectory) && StringUtils.equalsIgnoreCase((String)currentName, (String)newName) : StringUtils.equals((String)currentDirectory, (String)newDirectory) && StringUtils.equals((String)currentName, (String)newName)) {
            return;
        }
        ArrayList<ExceptionRunnable> revertList = new ArrayList<ExceptionRunnable>();
        MovePluginProgress progress = new MovePluginProgress();
        try {
            link.addPluginProgress(progress);
            progress.setProgressSource(this);
            for (FilePair filesToHandle : this.listFilePairsToMove(link, currentDirectory, currentName, newDirectory, newName)) {
                this.handle(revertList, link, progress, filesToHandle.getOldFile(), filesToHandle.getNewFile());
            }
            revertList.clear();
        }
        catch (Exception e) {
            this.getLogger().log((Throwable)e);
            throw e;
        }
        finally {
            try {
                for (ExceptionRunnable r : revertList) {
                    try {
                        if (r == null) continue;
                        r.run();
                    }
                    catch (Throwable e1) {
                        this.getLogger().log(e1);
                    }
                }
            }
            finally {
                link.removePluginProgress(progress);
            }
        }
    }

    protected FilePair[] listFilePairsToMove(DownloadLink link, String currentDirectory, String currentName, String newDirectory, String newName) {
        FilePair[] ret = new FilePair[]{new FilePair(new File(new File(currentDirectory), currentName + ".part"), new File(new File(newDirectory), newName + ".part")), new FilePair(new File(new File(currentDirectory), currentName), new File(new File(newDirectory), newName))};
        return ret;
    }

    private void handle(ArrayList<ExceptionRunnable> revertList, final DownloadLink downloadLink, final MovePluginProgress progress, final File currentFile, final File newFile) throws FileExistsException, CouldNotRenameException, IOException {
        if (!currentFile.exists()) {
            return;
        }
        if (currentFile.equals(newFile)) {
            return;
        }
        progress.setFile(newFile);
        revertList.add(new ExceptionRunnable(){

            @Override
            public void run() throws Exception {
                PluginForHost.this.renameOrMove(progress, downloadLink, newFile, currentFile);
            }
        });
        this.renameOrMove(progress, downloadLink, currentFile, newFile);
    }

    private void renameOrMove(MovePluginProgress progress, DownloadLink downloadLink, File old, File newFile) throws FileExistsException, CouldNotRenameException, IOException {
        if (newFile.exists()) {
            throw new FileExistsException(old, newFile);
        }
        if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
            throw new IOException("Could not create " + newFile.getParent());
        }
        try {
            this.getLogger().info("Move " + old + " to " + newFile);
            if (CrossSystem.isWindows() && Application.getJavaVersion() >= Application.JAVA17) {
                java.nio.file.Files.move(Paths.get(old.toURI()), Paths.get(newFile.toURI()), StandardCopyOption.ATOMIC_MOVE);
            } else if (!old.renameTo(newFile)) {
                throw new CouldNotRenameException(old, newFile);
            }
        }
        catch (CouldNotRenameException e) {
            this.getLogger().log((Throwable)e);
            this.copyMove(progress, downloadLink, old, newFile);
        }
        catch (IOException e) {
            this.getLogger().log((Throwable)e);
            this.copyMove(progress, downloadLink, old, newFile);
        }
        if (!newFile.getParentFile().equals(old.getParentFile()) && !old.getParentFile().equals(new File(CFG_GENERAL.DEFAULT_DOWNLOAD_FOLDER.getValue()))) {
            old.getParentFile().delete();
        }
    }

    private void copyMove(final MovePluginProgress progress, final DownloadLink downloadLink, final File old, final File newFile) throws IOException {
        if (!old.exists() && newFile.exists()) {
            return;
        }
        if (!old.exists()) {
            throw new IOException("Cannot move " + old + " to " + newFile + ". The File does not exist!");
        }
        newFile.delete();
        Thread thread = null;
        if ((Integer)JSonStorage.getPlainStorage((String)"Dialogs").get(COPY_MOVE_FILE, (Object)-1) < 0) {
            thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                        ProgressDialog dialog = new ProgressDialog(new ProgressDialog.ProgressGetter(){

                            public void run() throws Exception {
                                while (true) {
                                    Thread.sleep(1000L);
                                }
                            }

                            public String getString() {
                                return _JDT.T.lit_please_wait();
                            }

                            public int getProgress() {
                                double perc = progress.getPercent();
                                return Math.min(99, (int)perc);
                            }

                            public String getLabelString() {
                                return null;
                            }
                        }, 32, _GUI.T.PluginForHost_copyMove_progressdialog_title(), null, new AbstractIcon("saveto", 32), null, _JDT.T.lit_hide()){

                            public String getDontShowAgainKey() {
                                return PluginForHost.COPY_MOVE_FILE;
                            }

                            private Component leftLabel(String name) {
                                JLabel ret = new JLabel(name);
                                ret.setHorizontalAlignment(2);
                                return ret;
                            }

                            protected void extendLayout(JPanel p) {
                                if (p.getComponentCount() == 0) {
                                    MigPanel subp = new MigPanel("ins 0,wrap 1", "[]", "[][]");
                                    p.add((Component)subp, "wrap");
                                    p = subp;
                                    String packagename = downloadLink.getParentNode().getName();
                                    p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.lit_hoster())), "split 2,sizegroup left,alignx left");
                                    DomainInfo di = downloadLink.getDomainInfo();
                                    JLabel ret = new JLabel(di.getTld());
                                    ret.setHorizontalAlignment(2);
                                    ret.setIcon(di.getFavIcon());
                                    p.add(ret);
                                    if (downloadLink.getParentNode() != FilePackage.getDefaultFilePackage()) {
                                        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_package())), "split 2,sizegroup left,alignx left");
                                        p.add(this.leftLabel(packagename));
                                    }
                                    p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.lit_filesize())), "split 2,sizegroup left,alignx left");
                                    p.add(this.leftLabel(SizeFormatter.formatBytes((long)old.length())));
                                    if (newFile.getName().equals(old.getName())) {
                                        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.lit_filename())), "split 2,sizegroup left,alignx left");
                                        p.add(this.leftLabel(newFile.getName()));
                                    } else {
                                        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.PLUGINFORHOST_MOVECOPY_DIALOG_OLDFILENAME())), "split 2,sizegroup left,alignx left");
                                        p.add(this.leftLabel(old.getName()));
                                        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.PLUGINFORHOST_MOVECOPY_DIALOG_NEWFILENAME())), "split 2,sizegroup left,alignx left");
                                        p.add(this.leftLabel(newFile.getName()));
                                    }
                                    p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.PLUGINFORHOST_MOVECOPY_DIALOG_OLD())), "split 2,sizegroup left,alignx left");
                                    p.add(this.leftLabel(old.getParent()));
                                    p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.PLUGINFORHOST_MOVECOPY_DIALOG_NEW())), "split 2,sizegroup left,alignx left");
                                    p.add(this.leftLabel(newFile.getParent()));
                                }
                            }
                        };
                        UIOManager.I().show(null, (UserIODefinition)dialog);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        }
        try {
            IO.copyFile((ProgressFeedback)new ProgressFeedback(){

                public void setBytesTotal(long length) {
                    progress.setTotal(length);
                }

                public void setBytesProcessed(long position) {
                    progress.setCurrent(position);
                }
            }, (File)old, (File)newFile, (IO.SYNC)IO.SYNC.META_AND_DATA);
            old.delete();
        }
        catch (IOException io) {
            newFile.delete();
            throw io;
        }
        finally {
            if (thread != null) {
                thread.interrupt();
            }
        }
    }

    public boolean isProxyRotationEnabledForLinkChecker() {
        return true;
    }

    public Object getPluginProperty(DownloadLink link, String returnFormat, String key, Object def) {
        return link.getProperty(key, def);
    }

    public boolean isSpeedLimited(DownloadLink link, Account account) {
        if (link == null) {
            return false;
        }
        if (StringUtils.equals((String)link.getHost(), (String)this.getHost())) {
            if (this.hasFeature(LazyPlugin.FEATURE.MULTIHOST)) {
                return false;
            }
            return this.isPremiumEnabled() && account == null;
        }
        return false;
    }

    public String getMirrorID(DownloadLink link) {
        return null;
    }

    public String buildExternalDownloadURL(DownloadLink downloadLink, PluginForHost buildForThisPlugin) {
        return downloadLink.getPluginPatternMatcher();
    }

    public String buildContainerDownloadURL(DownloadLink downloadLink, PluginForHost buildForThisPlugin) {
        String ret = downloadLink.getContentUrl();
        if (ret != null) {
            return ret;
        }
        return downloadLink.getPluginPatternMatcher();
    }

    public void setLinkID(DownloadLink downloadLink, LinkVariant variant) {
        boolean isOriginal = variant == null || GenericVariants.ORIGINAL.equals(variant);
        String orgLinkID = downloadLink.getStringProperty("ORG_LINKID");
        if (isOriginal) {
            if (orgLinkID != null) {
                downloadLink.setLinkID(orgLinkID);
            }
        } else if (orgLinkID == null) {
            String linkID = downloadLink.getLinkID();
            downloadLink.setProperty("ORG_LINKID", linkID);
            downloadLink.setLinkID(linkID + "_" + variant._getUniqueId());
        } else {
            downloadLink.setLinkID(orgLinkID + "_" + variant._getUniqueId());
        }
    }

    public List<GenericVariants> getGenericVariants(DownloadLink downloadLink) {
        List<String> converts = this.getConvertToList(downloadLink);
        if (converts != null && converts.size() > 0) {
            ArrayList<GenericVariants> variants = new ArrayList<GenericVariants>();
            variants.add(GenericVariants.ORIGINAL);
            for (String v : converts) {
                try {
                    variants.add(GenericVariants.valueOf(v));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (variants.size() > 1) {
                return variants;
            }
        } else {
            String name = downloadLink.getName();
            String exten = Files.getExtension((String)name);
            if (exten != null) {
                boolean isVideo = false;
                for (CompiledFiletypeFilter.VideoExtensions extension : CompiledFiletypeFilter.VideoExtensions.values()) {
                    Pattern pattern = extension.getPattern();
                    if (pattern == null || !pattern.matcher(exten).matches()) continue;
                    isVideo = true;
                    break;
                }
                if (isVideo) {
                    ArrayList<GenericVariants> variants = new ArrayList<GenericVariants>();
                    variants.add(GenericVariants.DEMUX_GENERIC_AUDIO);
                    return variants;
                }
            }
        }
        return null;
    }

    public boolean hasFeature(LazyPlugin.FEATURE feature) {
        if (feature == null) {
            return false;
        }
        LazyPlugin.FEATURE[] features = this.getFeatures();
        if (features == null) {
            return false;
        }
        for (int i = 0; i < features.length; ++i) {
            if (features[i] != feature) continue;
            return true;
        }
        return false;
    }

    public LazyPlugin.FEATURE[] getFeatures() {
        return new LazyPlugin.FEATURE[0];
    }

    public List<String> getConvertToList(DownloadLink downloadLink) {
        return null;
    }

    public UrlProtection getUrlProtection(List<DownloadLink> hosterLinks) {
        return null;
    }

    public String returnDecrypterTaskResult(String url) {
        LinkCrawler lc = LinkCrawler.newInstance();
        lc.crawl(url);
        lc.waitForCrawling();
        return lc.getCrawledLinks().size() >= 1 ? lc.getCrawledLinks().get(0).getURL() : null;
    }

    public boolean fillVariantsPopup(VariantColumn variantColumn, JPopupMenu popup, AbstractNode value, LinkVariant selected, ComboBoxModel<LinkVariant> dm) {
        return false;
    }

    public boolean onLinkCollectorDupe(CrawledLink existingLink, CrawledLink newLink) {
        return false;
    }

    public boolean onLinkCrawlerDupeFilterEnabled(CrawledLink existingLink, CrawledLink newLink) {
        return true;
    }

    public Class<? extends AccountConfigInterface> getAccountConfigInterface(Account account) {
        for (Class<?> currentClass = this.getClass(); currentClass != null && PluginForHost.class.isAssignableFrom(currentClass); currentClass = currentClass.getSuperclass()) {
            for (Class<?> cls : currentClass.getDeclaredClasses()) {
                if (!AccountConfigInterface.class.isAssignableFrom(cls)) continue;
                return cls;
            }
        }
        return null;
    }

    public void extendMultiHostAccountSettingsPanel(Account acc, final PluginConfigPanelNG panel) {
        if (!acc.isEnabled()) {
            return;
        }
        AccountInfo ai = acc.getAccountInfo();
        if (ai == null) {
            return;
        }
        List<MultiHostHost> hosts = ai.getMultiHostSupportV2();
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        boolean shouldShowLinkLimitColumns = false;
        boolean shouldShowTrafficLimitColumns = false;
        boolean shouldShowTrafficCaculationColumn = false;
        boolean shouldShowUnavailableForColumn = false;
        boolean containsItemsWithCustomStatusText = false;
        for (MultiHostHost mhost : hosts) {
            if (!shouldShowLinkLimitColumns && !mhost.isUnlimitedLinks()) {
                shouldShowLinkLimitColumns = true;
            }
            if (!shouldShowTrafficLimitColumns && !mhost.isUnlimitedTraffic()) {
                shouldShowTrafficLimitColumns = true;
            }
            if (!shouldShowTrafficCaculationColumn && mhost.getTrafficCalculationFactorPercent() != 100) {
                shouldShowTrafficCaculationColumn = true;
            }
            if (!shouldShowUnavailableForColumn && mhost.getUnavailableTimeMillis() > 0L) {
                shouldShowUnavailableForColumn = true;
            }
            if (!containsItemsWithCustomStatusText && mhost.getStatusText() != null) {
                containsItemsWithCustomStatusText = true;
            }
            if (!shouldShowTrafficLimitColumns || !shouldShowLinkLimitColumns || !shouldShowTrafficCaculationColumn || !shouldShowUnavailableForColumn) continue;
            break;
        }
        final boolean shouldShowLinkLimitColumns_final = shouldShowLinkLimitColumns;
        final boolean shouldShowTrafficLimitColumns_final = shouldShowTrafficLimitColumns;
        final boolean shouldShowTrafficCaculationColumn_final = shouldShowTrafficCaculationColumn;
        final boolean shouldShowUnavailableForColumn_final = shouldShowUnavailableForColumn;
        final boolean shouldShowUInternalStatusColumn_final = containsItemsWithCustomStatusText;
        final Icon icon_error = NewTheme.I().getIcon("error", 16);
        final Icon icon_okay = NewTheme.I().getIcon("ok", 16);
        final Icon icon_warning = NewTheme.I().getIcon("warning", 16);
        final Icon icon_wait = NewTheme.I().getIcon("wait", 16);
        final Icon icon_filler = NewTheme.I().getIcon("beer", 16);
        ExtTableModel<MultiHostHost> tableModel = new ExtTableModel<MultiHostHost>("MultiHostHostTable_" + acc.getHoster()){

            protected void initColumns() {
                this.addColumn((ExtColumn)new ExtCheckColumn<MultiHostHost>(_GUI.T.premiumaccounttablemodel_column_enabled()){

                    public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                        ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                            private final Icon ok;
                            {
                                this.ok = NewTheme.I().getIcon("ok", 14);
                            }

                            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                this.setIcon(this.ok);
                                this.setHorizontalAlignment(0);
                                this.setText(null);
                                return this;
                            }
                        };
                        return ret;
                    }

                    public int getMaxWidth() {
                        return 30;
                    }

                    protected boolean getBooleanValue(MultiHostHost mhost) {
                        return mhost.isEnabled();
                    }

                    public boolean isEditable(MultiHostHost mhost) {
                        return true;
                    }

                    protected void setBooleanValue(boolean enabled, MultiHostHost mhost) {
                        mhost.setEnabled(enabled);
                        this.fireTableStructureChanged();
                    }
                });
                this.addColumn((ExtColumn)new ExtTextColumn<MultiHostHost>(_GUI.T.multihost_detailed_host_info_table_column_domain()){

                    public String getStringValue(MultiHostHost mhost) {
                        return mhost.getDomain();
                    }

                    public Icon getIcon(MultiHostHost mhost) {
                        DomainInfo di = mhost.getDomainInfo();
                        if (di != null) {
                            return di.getFavIcon(false);
                        }
                        return icon_filler;
                    }

                    public boolean onDoubleClick(MouseEvent e, MultiHostHost mhost) {
                        if (mhost.getStatus() == MultiHostHost.MultihosterHostStatus.DEACTIVATED_JDOWNLOADER_UNSUPPORTED) {
                            return false;
                        }
                        LazyHostPlugin lazyHostPlugin = HostPluginController.getInstance().get(mhost.getDomain());
                        if (lazyHostPlugin != null && lazyHostPlugin.isPremium()) {
                            AccountController.openAfflink(lazyHostPlugin, null, "MultiHostSupportedHostsDetailTable");
                        }
                        return false;
                    }

                    protected String getTooltipText(MultiHostHost mhost) {
                        StringBuilder sb = new StringBuilder();
                        for (String domain : mhost.getDomains()) {
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(domain);
                        }
                        return sb.toString();
                    }

                    public boolean isEnabled(MultiHostHost mhost) {
                        return mhost.isEnabled();
                    }
                });
                this.addColumn((ExtColumn)new ExtTextColumn<MultiHostHost>("Status"){
                    private final Color defaultColor;
                    {
                        this.renderer.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill][]", "[grow,fill]"));
                        this.defaultColor = this.rendererField.getForeground();
                    }

                    public String getStringValue(MultiHostHost mhost) {
                        String text = mhost.getStatusText();
                        if (mhost.getUnavailableTimeMillis() > 0L) {
                            return mhost.getUnavailableStatusText();
                        }
                        if (!mhost.isUnlimitedLinks() && mhost.getLinksLeft() <= 0L) {
                            return _GUI.T.account_error_no_links_left();
                        }
                        if (!mhost.isUnlimitedTraffic() && mhost.getTrafficLeft() <= 0L) {
                            return _GUI.T.account_error_no_traffic_left();
                        }
                        if (text != null) {
                            return text;
                        }
                        return mhost.getStatus().getLabel();
                    }

                    protected String getTooltipText(MultiHostHost mhost) {
                        if (mhost.getUnavailableTimeMillis() > 0L) {
                            return "Host temporarily unavailable because of too many wrong download attempts";
                        }
                        return mhost.getStatus().getLabel();
                    }

                    public void configureRendererComponent(MultiHostHost value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.configureRendererComponent((Object)value, isSelected, hasFocus, row, column);
                        MultiHostHost.MultihosterHostStatus status = value.getStatus();
                        if (status != MultiHostHost.MultihosterHostStatus.WORKING && status != MultiHostHost.MultihosterHostStatus.WORKING_UNSTABLE) {
                            this.rendererField.setForeground(Color.RED);
                        } else {
                            this.rendererField.setForeground(this.defaultColor);
                        }
                    }

                    public Icon getIcon(MultiHostHost mhost) {
                        MultiHostHost.MultihosterHostStatus status = mhost.getStatus();
                        if (mhost.getUnavailableTimeMillis() > 0L) {
                            return icon_wait;
                        }
                        if (!mhost.isUnlimitedLinks() && mhost.getLinksLeft() <= 0L) {
                            return icon_wait;
                        }
                        if (!mhost.isUnlimitedTraffic() && mhost.getTrafficLeft() <= 0L) {
                            return icon_wait;
                        }
                        if (status == MultiHostHost.MultihosterHostStatus.WORKING) {
                            return icon_okay;
                        }
                        if (status == MultiHostHost.MultihosterHostStatus.WORKING_UNSTABLE) {
                            return icon_warning;
                        }
                        return icon_error;
                    }

                    public boolean isEnabled(MultiHostHost mhost) {
                        return mhost.isEnabled();
                    }
                });
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && shouldShowUInternalStatusColumn_final) {
                    this.addColumn((ExtColumn)new ExtTextColumn<MultiHostHost>("Internal status"){
                        private final Color defaultColor;
                        {
                            this.renderer.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill][]", "[grow,fill]"));
                            this.defaultColor = this.rendererField.getForeground();
                        }

                        public String getStringValue(MultiHostHost mhost) {
                            return mhost.getStatus().getLabel();
                        }

                        public void configureRendererComponent(MultiHostHost value, boolean isSelected, boolean hasFocus, int row, int column) {
                            super.configureRendererComponent((Object)value, isSelected, hasFocus, row, column);
                            MultiHostHost.MultihosterHostStatus status = value.getStatus();
                            if (status != MultiHostHost.MultihosterHostStatus.WORKING && status != MultiHostHost.MultihosterHostStatus.WORKING_UNSTABLE) {
                                this.rendererField.setForeground(Color.RED);
                            } else {
                                this.rendererField.setForeground(this.defaultColor);
                            }
                        }

                        public boolean isEnabled(MultiHostHost mhost) {
                            return mhost.isEnabled();
                        }
                    });
                }
                if (shouldShowUnavailableForColumn_final) {
                    this.addColumn((ExtColumn)new ExtLongColumn<MultiHostHost>(_GUI.T.multihost_detailed_host_info_table_column_unavailable_for()){
                        private final AtomicReference<Timer> timerReference;
                        {
                            this.timerReference = new AtomicReference();
                        }

                        protected long getLong(MultiHostHost mhost) {
                            return mhost.getUnavailableTimeMillis();
                        }

                        public boolean isVisible(boolean savedValue) {
                            boolean ret = super.isVisible(savedValue);
                            final 5 thisColumn = this;
                            if (ret && this.timerReference.get() == null) {
                                Timer countdownTimer = new Timer(1000, new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        ExtTable table = this.getTable();
                                        if (table == null) {
                                            return;
                                        }
                                        if (!table.isShowing() || !this.getModel().isColumnVisible((ExtColumn)thisColumn) || timerReference.get() != e.getSource()) {
                                            ((Timer)e.getSource()).stop();
                                            return;
                                        }
                                        table.getModel().fireTableDataChanged();
                                    }
                                }){
                                    private static final long serialVersionUID = -8818019184160268747L;

                                    @Override
                                    public void stop() {
                                        super.stop();
                                        timerReference.compareAndSet(this, null);
                                    }
                                };
                                countdownTimer.start();
                                this.timerReference.set(countdownTimer);
                            }
                            return ret;
                        }

                        protected String getLongFormatted(MultiHostHost mhost) {
                            long unavailableFor = this.getLong(mhost);
                            if (unavailableFor > 0L) {
                                return TimeFormatter.formatMilliSeconds((long)unavailableFor, (int)0);
                            }
                            return "---";
                        }

                        public boolean isEnabled(MultiHostHost mhost) {
                            return mhost.isEnabled();
                        }
                    });
                }
                if (shouldShowLinkLimitColumns_final) {
                    this.addColumn((ExtColumn)new ExtProgressColumn<MultiHostHost>(_GUI.T.multihost_detailed_host_info_table_column_links_left_max()){

                        public int getMinWidth() {
                            return 50;
                        }

                        protected boolean isIndeterminated(MultiHostHost value, boolean isSelected, boolean hasFocus, int row, int column) {
                            return false;
                        }

                        protected String getString(MultiHostHost mhost, long current, long total) {
                            if (mhost.isUnlimitedLinks()) {
                                return _GUI.T.lit_unlimited();
                            }
                            return mhost.getLinksLeft() + "/" + mhost.getLinksMax();
                        }

                        protected long getMax(MultiHostHost mhost) {
                            if (mhost.isUnlimitedLinks()) {
                                return Long.MAX_VALUE;
                            }
                            return mhost.getLinksMax();
                        }

                        protected long getValue(MultiHostHost mhost) {
                            if (mhost.isUnlimitedLinks()) {
                                return Long.MAX_VALUE;
                            }
                            return mhost.getLinksLeft();
                        }

                        public boolean isEnabled(MultiHostHost mhost) {
                            return mhost.isEnabled();
                        }
                    });
                    this.addColumn((ExtColumn)new ExtLongColumn<MultiHostHost>(_GUI.T.multihost_detailed_host_info_table_column_links_left()){

                        protected long getLong(MultiHostHost mhost) {
                            return mhost.getLinksLeft();
                        }

                        protected String getLongFormatted(MultiHostHost mhost) {
                            if (mhost.isUnlimitedLinks()) {
                                return _GUI.T.lit_unlimited();
                            }
                            return StringUtils.toString((NumberFormat)this.formatter, (long)this.getLong(mhost));
                        }

                        public boolean isDefaultVisible() {
                            return false;
                        }

                        public boolean isEnabled(MultiHostHost mhost) {
                            return mhost.isEnabled();
                        }
                    });
                    this.addColumn((ExtColumn)new ExtLongColumn<MultiHostHost>(_GUI.T.multihost_detailed_host_info_table_column_links_max()){

                        protected long getLong(MultiHostHost mhost) {
                            return mhost.getLinksMax();
                        }

                        protected String getLongFormatted(MultiHostHost mhost) {
                            if (mhost.isUnlimitedLinks()) {
                                return _GUI.T.lit_unlimited();
                            }
                            return StringUtils.toString((NumberFormat)this.formatter, (long)this.getLong(mhost));
                        }

                        public boolean isDefaultVisible() {
                            return false;
                        }

                        public boolean isEnabled(MultiHostHost mhost) {
                            return mhost.isEnabled();
                        }
                    });
                }
                if (shouldShowTrafficLimitColumns_final) {
                    this.addColumn((ExtColumn)new ExtProgressColumn<MultiHostHost>(_GUI.T.multihost_detailed_host_info_table_column_traffic_left_max()){
                        private final GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit;
                        private final DecimalFormat formatter;
                        {
                            this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<MultiHostHost>(){

                                public int compare(MultiHostHost o1, MultiHostHost o2) {
                                    long v2;
                                    long v1 = this.getValue(o1);
                                    if (v1 == (v2 = this.getValue(o2))) {
                                        return 0;
                                    }
                                    if (this.getSortOrderIdentifier() != "ASC") {
                                        return v1 > v2 ? -1 : 1;
                                    }
                                    return v2 > v1 ? -1 : 1;
                                }
                            });
                            this.maxSizeUnit = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();
                            this.formatter = new DecimalFormat();
                        }

                        public int getMinWidth() {
                            return 140;
                        }

                        protected boolean isIndeterminated(MultiHostHost value, boolean isSelected, boolean hasFocus, int row, int column) {
                            return false;
                        }

                        protected String getString(MultiHostHost mhost, long current, long total) {
                            if (mhost.isUnlimitedTraffic()) {
                                return _GUI.T.premiumaccounttablemodel_column_trafficleft_unlimited();
                            }
                            return this.getSizeString(mhost.getTrafficLeft()) + "/" + this.getSizeString(mhost.getTrafficMax());
                        }

                        private final String getSizeString(long fileSize) {
                            return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(this.maxSizeUnit, this.formatter, fileSize);
                        }

                        protected long getMax(MultiHostHost mhost) {
                            if (mhost.isUnlimitedTraffic()) {
                                return Long.MAX_VALUE;
                            }
                            return mhost.getTrafficMax();
                        }

                        protected long getValue(MultiHostHost mhost) {
                            if (mhost.isUnlimitedTraffic()) {
                                return Long.MAX_VALUE;
                            }
                            return mhost.getTrafficLeft();
                        }

                        public boolean isEnabled(MultiHostHost mhost) {
                            return mhost.isEnabled();
                        }
                    });
                    this.addColumn((ExtColumn)new ExtFileSizeColumn<MultiHostHost>(_GUI.T.multihost_detailed_host_info_table_column_traffic_left()){

                        public String getStringValue(MultiHostHost mhost) {
                            if (mhost.isUnlimitedTraffic()) {
                                return _GUI.T.lit_unlimited();
                            }
                            return this.getSizeString(mhost.getTrafficLeft());
                        }

                        protected long getBytes(MultiHostHost val) {
                            return val.getTrafficLeft();
                        }

                        public boolean isDefaultVisible() {
                            return false;
                        }

                        public boolean isEnabled(MultiHostHost mhost) {
                            return mhost.isEnabled();
                        }
                    });
                    this.addColumn((ExtColumn)new ExtFileSizeColumn<MultiHostHost>(_GUI.T.multihost_detailed_host_info_table_column_traffic_max()){

                        public String getStringValue(MultiHostHost mhost) {
                            if (mhost.isUnlimitedTraffic()) {
                                return _GUI.T.lit_unlimited();
                            }
                            return this.getSizeString(mhost.getTrafficMax());
                        }

                        protected long getBytes(MultiHostHost val) {
                            return val.getTrafficMax();
                        }

                        public boolean isDefaultVisible() {
                            return false;
                        }

                        public boolean isEnabled(MultiHostHost mhost) {
                            return mhost.isEnabled();
                        }
                    });
                }
                if (shouldShowTrafficCaculationColumn_final) {
                    this.addColumn((ExtColumn)new ExtLongColumn<MultiHostHost>(_GUI.T.multihost_detailed_host_info_table_column_traffic_calculation_factor_percent()){

                        protected long getLong(MultiHostHost mhost) {
                            return mhost.getTrafficCalculationFactorPercent();
                        }

                        protected String getLongFormatted(MultiHostHost mhost) {
                            return this.getLong(mhost) + "%";
                        }

                        public boolean isEnabled(MultiHostHost mhost) {
                            return mhost.isEnabled();
                        }
                    });
                }
            }
        };
        if (shouldShowLinkLimitColumns_final || shouldShowTrafficLimitColumns_final || shouldShowUnavailableForColumn_final) {
            tableModel.addExtComponentRowHighlighter((ExtComponentRowHighlighter)new ExtComponentRowHighlighter<MultiHostHost>(null, Color.YELLOW, null){

                public boolean accept(ExtColumn<MultiHostHost> column, MultiHostHost mhost, boolean selected, boolean focus, int row) {
                    if (!mhost.isUnlimitedLinks() && mhost.getLinksLeft() <= 0L) {
                        return true;
                    }
                    if (!mhost.isUnlimitedTraffic() && mhost.getTrafficLeft() <= 0L) {
                        return true;
                    }
                    return mhost.getUnavailableTimeMillis() > 0L;
                }
            });
        }
        tableModel._fireTableStructureChanged(hosts, false);
        BasicJDTable table = new BasicJDTable((ExtTableModel)tableModel);
        table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredSize().width, table.getRowHeight() * table.getRowCount()));
        table.setSearchEnabled(true);
        table.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                panel.dispatchEvent(e);
            }
        });
        JScrollPane scrollPane = new JScrollPane((Component)table);
        panel.add(scrollPane);
    }

    public void extendCaptchaSolverAccountSettingsPanel(Account acc, PluginConfigPanelNG panel) {
        if (!acc.isEnabled()) {
            return;
        }
        PluginForHost plg = acc.getPlugin();
        if (!(plg instanceof abstractPluginForCaptchaSolver)) {
            return;
        }
        AccountInfo ai = acc.getAccountInfo();
        if (ai == null) {
            return;
        }
        abstractPluginForCaptchaSolver captchaSolverPlugin = (abstractPluginForCaptchaSolver)plg;
        ArrayList<CaptchaType> ctypes = new ArrayList<CaptchaType>();
        for (CaptchaType.CAPTCHA_TYPE ctype_static : captchaSolverPlugin.getSupportedCaptchaTypes()) {
            CaptchaType ctype = new CaptchaType(ctype_static);
            ctype.setAccountInfo(ai);
            ctypes.add(ctype);
        }
        boolean shouldShowDomainColumn = false;
        boolean shouldShowDemoUrlColumn = false;
        boolean shouldShowJDownloaderSupportedColumn = false;
        for (CaptchaType ctype : ctypes) {
            CaptchaType.CAPTCHA_TYPE stype_static = ctype.getCAPTCHA_TYPE_STATIC();
            if (stype_static.getDomain() != null) {
                shouldShowDomainColumn = true;
            }
            if (stype_static.getDemoUrl() != null) {
                shouldShowDemoUrlColumn = true;
            }
            if (!stype_static.isJDownloaderSupported()) {
                shouldShowJDownloaderSupportedColumn = true;
            }
            if (!shouldShowDomainColumn || !shouldShowDemoUrlColumn || !shouldShowJDownloaderSupportedColumn) continue;
            break;
        }
        final boolean final_shouldShowDomainColumn = shouldShowDomainColumn;
        final boolean final_shouldShowDemoUrlColumn = shouldShowDemoUrlColumn;
        final boolean final_shouldShowJDownloaderSupportedColumn = shouldShowJDownloaderSupportedColumn;
        ExtTableModel<CaptchaType> tableModel = new ExtTableModel<CaptchaType>("CaptchaTypeTable"){

            protected void initColumns() {
                this.addColumn((ExtColumn)new ExtCheckColumn<CaptchaType>(_GUI.T.premiumaccounttablemodel_column_enabled()){

                    public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                        ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                            private final Icon ok;
                            {
                                this.ok = NewTheme.I().getIcon("ok", 14);
                            }

                            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                this.setIcon(this.ok);
                                this.setHorizontalAlignment(0);
                                this.setText(null);
                                return this;
                            }
                        };
                        return ret;
                    }

                    public int getMaxWidth() {
                        return 30;
                    }

                    protected boolean getBooleanValue(CaptchaType captchaType) {
                        return captchaType.isEnabled();
                    }

                    public boolean isEditable(CaptchaType captchaType) {
                        return true;
                    }

                    protected void setBooleanValue(boolean enabled, CaptchaType captchaType) {
                        captchaType.setEnabled(enabled);
                        this.fireTableDataChanged();
                    }
                });
                this.addColumn((ExtColumn)new ExtTextColumn<CaptchaType>("Name"){

                    public String getStringValue(CaptchaType captchaType) {
                        return captchaType.getCAPTCHA_TYPE_STATIC().getDisplayName();
                    }

                    public Icon getIcon(CaptchaType captchaType) {
                        String domain = captchaType.getCAPTCHA_TYPE_STATIC().getDomain();
                        if (domain != null) {
                            return DomainInfo.getInstance(domain).getFavIcon();
                        }
                        Icon dummyIcon = NewTheme.I().getIcon("beer", 16);
                        return dummyIcon;
                    }
                });
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && final_shouldShowDomainColumn) {
                    this.addColumn((ExtColumn)new ExtTextColumn<CaptchaType>(_GUI.T.multihost_detailed_host_info_table_column_domain()){

                        public String getStringValue(CaptchaType captchaType) {
                            String domain = captchaType.getCAPTCHA_TYPE_STATIC().getDomain();
                            return domain != null ? domain : "";
                        }

                        protected String getTooltipText(CaptchaType captchaType) {
                            String domain = captchaType.getCAPTCHA_TYPE_STATIC().getDomain();
                            return domain != null ? domain : null;
                        }
                    });
                }
                this.addColumn((ExtColumn)new ExtTextColumn<CaptchaType>("Description"){

                    public String getStringValue(CaptchaType captchaType) {
                        String description = captchaType.getCAPTCHA_TYPE_STATIC().getDescription();
                        return description != null ? description : "";
                    }

                    protected String getTooltipText(CaptchaType captchaType) {
                        String description = captchaType.getCAPTCHA_TYPE_STATIC().getDescription();
                        return description != null ? description : null;
                    }
                });
                if (final_shouldShowDemoUrlColumn) {
                    this.addColumn((ExtColumn)new ExtTextColumn<CaptchaType>("Demo URL"){

                        public String getStringValue(CaptchaType captchaType) {
                            String demoUrl = captchaType.getCAPTCHA_TYPE_STATIC().getDemoUrl();
                            return demoUrl != null ? demoUrl : "";
                        }

                        protected String getTooltipText(CaptchaType captchaType) {
                            String demoUrl = captchaType.getCAPTCHA_TYPE_STATIC().getDemoUrl();
                            return demoUrl != null ? demoUrl : null;
                        }

                        public boolean onDoubleClick(MouseEvent e, CaptchaType captchaType) {
                            String demoUrl = captchaType.getCAPTCHA_TYPE_STATIC().getDemoUrl();
                            if (demoUrl == null || !demoUrl.isEmpty()) {
                                // empty if block
                            }
                            return false;
                        }
                    });
                }
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && final_shouldShowJDownloaderSupportedColumn) {
                    this.addColumn((ExtColumn)new ExtCheckColumn<CaptchaType>("JDownloader Support"){

                        public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                            ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                                private final Icon ok;
                                {
                                    this.ok = NewTheme.I().getIcon("ok", 14);
                                }

                                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                    this.setIcon(this.ok);
                                    this.setHorizontalAlignment(0);
                                    this.setText(null);
                                    return this;
                                }
                            };
                            return ret;
                        }

                        public int getMaxWidth() {
                            return 30;
                        }

                        protected boolean getBooleanValue(CaptchaType captchaType) {
                            return captchaType.getCAPTCHA_TYPE_STATIC().isJDownloaderSupported();
                        }

                        public boolean isEditable(CaptchaType captchaType) {
                            return false;
                        }

                        protected void setBooleanValue(boolean value, CaptchaType captchaType) {
                        }
                    });
                }
            }
        };
        tableModel._fireTableStructureChanged(ctypes, false);
        BasicJDTable table = new BasicJDTable((ExtTableModel)tableModel);
        table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredSize().width, table.getRowHeight() * table.getRowCount()));
        table.setSearchEnabled(true);
        JScrollPane scrollPane = new JScrollPane((Component)table);
        panel.add(scrollPane);
    }

    public void extendAccountSettingsPanel(Account acc, PluginConfigPanelNG panel) {
    }

    protected String getAPILoginHelpURL() {
        return null;
    }

    protected boolean looksLikeValidAPIKey(String str) {
        return false;
    }

    public void validateLogins(Account account) throws AccountInvalidException {
        if (this.hasFeature(LazyPlugin.FEATURE.USERNAME_IS_EMAIL) && !this.looksLikeValidEmailAddress(account, account.getUser())) {
            throw new AccountInvalidException(_GUI.T.accountdialog_LoginValidationErrorInputIsNotEmailAddress());
        }
        if (this.hasFeature(LazyPlugin.FEATURE.COOKIE_LOGIN_ONLY)) {
            if (account.loadUserCookies() == null) {
                throw new AccountInvalidException(_GUI.T.accountdialog_LoginValidationErrorCookieLoginMandatoryButNoCookiesGiven());
            }
        } else if (!this.hasFeature(LazyPlugin.FEATURE.COOKIE_LOGIN_OPTIONAL)) {
            if (account.loadUserCookies() != null) {
                throw new AccountInvalidException(_GUI.T.accountdialog_LoginValidationErrorCookieLoginUnsupportedButGiven());
            }
        } else if (this.hasFeature(LazyPlugin.FEATURE.API_KEY_LOGIN) && !this.looksLikeValidAPIKey(account.getPass())) {
            throw new AccountInvalidException(_GUI.T.accountdialog_LoginValidationErrorInvalidAPIKey());
        }
    }

    public boolean looksLikeValidEmailAddress(Account account, String email) {
        if (email == null) {
            return false;
        }
        return email.matches("^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}$");
    }

    public boolean isSameAccount(Account downloadAccount, AbstractProxySelectorImpl downloadProxySelector, Account candidateAccount, AbstractProxySelectorImpl candidateProxySelector) {
        return downloadProxySelector == candidateProxySelector && downloadAccount == candidateAccount;
    }

    protected URLConnectionAdapter basicLinkCheck(Browser br, Request request, DownloadLink link, String customFileName, String defaultExtension) throws IOException, PluginException {
        return this.basicLinkCheck(br, request, link, customFileName, defaultExtension, FILENAME_SOURCE.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URLConnectionAdapter basicLinkCheck(Browser br, Request request, DownloadLink link, String customFileName, String defaultExtension, FILENAME_SOURCE ... fileNameSource) throws IOException, PluginException {
        URLConnectionAdapter con = null;
        try {
            br.setFollowRedirects(true);
            request.getHeaders().put("Accept-Encoding", "identity");
            con = br.openRequestConnection(request);
            this.handleConnectionErrors(br, con);
            if (con.getCompleteContentLength() > 0L) {
                if (con.isContentDecoded()) {
                    link.setVerifiedFileSize(-1L);
                    link.setDownloadSize(con.getCompleteContentLength());
                } else {
                    link.setVerifiedFileSize(con.getCompleteContentLength());
                }
            }
            if (fileNameSource != null && ((FILENAME_SOURCE[])fileNameSource).length > 0) {
                for (URLConnectionAdapter source : fileNameSource) {
                    String filename;
                    if (source.setFilename(this, link, filename = this.getFileNameFromSource((FILENAME_SOURCE)source, link, con, customFileName, defaultExtension))) break;
                }
            }
            if (HTTPConnection.RequestMethod.HEAD.equals((Object)request.getRequestMethod())) {
                br.followConnection();
            }
            URLConnectionAdapter uRLConnectionAdapter = con;
            return uRLConnectionAdapter;
        }
        finally {
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected void handleConnectionErrors(Browser br, URLConnectionAdapter con) throws PluginException, IOException {
        if (!this.looksLikeDownloadableContent(con)) {
            br.followConnection(true);
            this.throwConnectionExceptions(br, con);
            this.throwFinalConnectionException(br, con);
        }
    }

    protected void throwConnectionExceptions(Browser br, URLConnectionAdapter con) throws PluginException, IOException {
        switch (con.getResponseCode()) {
            case 403: {
                throw new PluginException(2048, "Server error 403", 3600000L);
            }
            case 404: {
                throw new PluginException(2048, "Server error 404", 3600000L);
            }
            case 416: {
                throw new PluginException(2048, "Server error 416", 3600000L);
            }
            case 429: {
                throw new PluginException(16, "429 Too Many Requests", 60000L);
            }
            case 503: {
                throw new PluginException(4096, "Server error 503 connection limit reached", 300000L);
            }
        }
    }

    protected void throwFinalConnectionException(Browser br, URLConnectionAdapter con) throws PluginException, IOException {
        if (br.getRequest().getHtmlCode().length() == 0) {
            String errormessage = "Got blank page";
            throw new PluginException(131072, "Got blank page");
        }
        if (br.getRequest().getHtmlCode().length() <= 100 && !br.isHtml()) {
            String plaintextError = br.getRequest().getHtmlCode().trim();
            throw new PluginException(131072, plaintextError);
        }
        throw new PluginException(2048, "Content broken?");
    }

    protected Thread showCookieLoginInfo() {
        final String host = this.getHost();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String title;
                    String help_article_url = "https://support.jdownloader.org/knowledgebase/article/account-cookie-login-instructions";
                    String message = "";
                    if ("de".equalsIgnoreCase(System.getProperty("user.language"))) {
                        title = host + " - Login";
                        message = message + "Hallo liebe(r) " + host + " NutzerIn\r\n";
                        message = message + "Um deinen " + host + " Account in JDownloader verwenden zu k\u00f6nnen, musst du folgende Schritte beachten:\r\n";
                        message = message + "Folge der Anleitung im Hilfe-Artikel:\r\n";
                        message = message + "https://support.jdownloader.org/knowledgebase/article/account-cookie-login-instructions";
                    } else {
                        title = host + " - Login";
                        message = message + "Hello dear " + host + " user\r\n";
                        message = message + "In order to use an account of this service in JDownloader, please follow these instructions:\r\n";
                        message = message + "https://support.jdownloader.org/knowledgebase/article/account-cookie-login-instructions";
                    }
                    ConfirmDialog dialog = new ConfirmDialog(4, title, message);
                    dialog.setTimeout(180000);
                    if (CrossSystem.isOpenBrowserSupported() && !Application.isHeadless()) {
                        CrossSystem.openURL((String)"https://support.jdownloader.org/knowledgebase/article/account-cookie-login-instructions");
                    }
                    ConfirmDialogInterface ret = (ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)dialog);
                    ret.throwCloseExceptions();
                }
                catch (Throwable e) {
                    PluginForHost.this.getLogger().log(e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static enum FILENAME_SOURCE implements FilenameSourceInterface
    {
        FORCED{

            @Override
            public String getFilename(Plugin plugin, DownloadLink link, URLConnectionAdapter con, String ... customValues) {
                if (link == null) {
                    return null;
                }
                String ret = CrawledLink.getForcedName(link);
                if (ret != null && plugin != null) {
                    ret = plugin.correctOrApplyFileNameExtension(this, link, ret, con, customValues);
                }
                return ret;
            }

            @Override
            public boolean setFilename(DownloadLinkDownloadable downloadable, String filename) {
                if (filename == null) {
                    return false;
                }
                downloadable.setForcedFileName(filename);
                downloadable.setFinalFileName(filename);
                return true;
            }

            @Override
            public boolean setFilename(Plugin plugin, DownloadLink link, String fileName) {
                if (fileName == null) {
                    return false;
                }
                if (plugin != null) {
                    return plugin.setFilename(this, link, fileName);
                }
                CrawledLink.setForcedName(link, fileName);
                link.setFinalFileName(fileName);
                return true;
            }
        }
        ,
        CUSTOM{

            @Override
            public String getFilename(Plugin plugin, DownloadLink link, URLConnectionAdapter con, String ... customValues) {
                String ret = 2.getCustomFilename(customValues);
                if (ret != null && plugin != null) {
                    ret = plugin.correctOrApplyFileNameExtension(this, link, ret, con, customValues);
                }
                return ret;
            }
        }
        ,
        CONNECTION{

            @Override
            public String getFilename(Plugin plugin, DownloadLink link, URLConnectionAdapter con, String ... customValues) {
                if (con == null) {
                    return null;
                }
                String ret = HEADER.getFilename(plugin, link, con, customValues);
                if (ret == null) {
                    ret = URL.getFilename(plugin, link, con, customValues);
                }
                if (ret != null && plugin != null) {
                    ret = plugin.correctOrApplyFileNameExtension(this, link, ret, con, customValues);
                }
                return ret;
            }
        }
        ,
        FINAL{

            @Override
            public String getFilename(Plugin plugin, DownloadLink link, URLConnectionAdapter con, String ... customValues) {
                if (link == null) {
                    return null;
                }
                String ret = link.getFinalFileName();
                if (ret != null && plugin != null) {
                    ret = plugin.correctOrApplyFileNameExtension(this, link, ret, con, customValues);
                }
                return ret;
            }
        }
        ,
        HEADER{

            @Override
            public String getFilename(Plugin plugin, DownloadLink link, URLConnectionAdapter con, String ... customValues) {
                if (con == null) {
                    return null;
                }
                HTTPConnectionUtils.DispositionHeader header = plugin != null ? plugin.getDispositionHeader(con) : Plugin.parseDispositionHeader(con);
                if (header == null) {
                    return null;
                }
                String ret = header.getFilename();
                if (ret != null && plugin != null) {
                    ret = plugin.correctOrApplyFileNameExtension(this, link, ret, con, customValues);
                }
                return ret;
            }
        }
        ,
        URL{

            @Override
            public String getFilename(Plugin plugin, DownloadLink link, URLConnectionAdapter con, String ... customValues) {
                if (con == null) {
                    return null;
                }
                String ret = Plugin.getFileNameFromURL(con.getURL());
                if (ret != null && plugin != null) {
                    ret = plugin.correctOrApplyFileNameExtension(this, link, ret, con, customValues);
                }
                return ret;
            }
        }
        ,
        PLUGIN{

            @Override
            public String getFilename(Plugin plugin, DownloadLink link, URLConnectionAdapter con, String ... customValues) {
                if (link == null) {
                    return null;
                }
                String ret = link.getNameSetbyPlugin();
                if (ret != null && plugin != null) {
                    ret = plugin.correctOrApplyFileNameExtension(this, link, ret, con, customValues);
                }
                return ret;
            }
        };


        public static String getCustomFilename(String ... customValues) {
            if (customValues != null && customValues.length > 0) {
                return customValues[0];
            }
            return null;
        }

        public static String getCustomExtension(String ... customValues) {
            if (customValues != null && customValues.length > 1) {
                return customValues[1];
            }
            return null;
        }

        public static FILENAME_SOURCE[] prefer(FILENAME_SOURCE[] list, FILENAME_SOURCE ... preferSource) {
            LinkedHashSet<FILENAME_SOURCE> ret = new LinkedHashSet<FILENAME_SOURCE>();
            if (preferSource != null) {
                ret.addAll(Arrays.asList(preferSource));
            }
            if (list != null) {
                ret.addAll(Arrays.asList(list));
            }
            return ret.toArray(new FILENAME_SOURCE[0]);
        }

        @Override
        public boolean setFilename(DownloadLinkDownloadable downloadable, String filename) {
            if (filename == null) {
                return false;
            }
            downloadable.setFinalFileName(filename);
            return true;
        }

        @Override
        public boolean setFilename(Plugin plugin, DownloadLink link, String fileName) {
            if (fileName == null) {
                return false;
            }
            if (plugin != null) {
                return plugin.setFilename(this, link, fileName);
            }
            link.setFinalFileName(fileName);
            return true;
        }
    }

    public static interface FilenameSourceInterface {
        public String getFilename(Plugin var1, DownloadLink var2, URLConnectionAdapter var3, String ... var4);

        public boolean setFilename(Plugin var1, DownloadLink var2, String var3);

        public boolean setFilename(DownloadLinkDownloadable var1, String var2);
    }

    public static class FilePair {
        private final File oldFile;
        private final File newFile;

        public FilePair(File oldFile, File newFile) {
            this.oldFile = oldFile;
            this.newFile = newFile;
        }

        public File getOldFile() {
            return this.oldFile;
        }

        public File getNewFile() {
            return this.newFile;
        }
    }
}

