/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.Color;
import javax.swing.Icon;
import org.jdownloader.gui.views.downloads.columns.ETAColumn;
import org.jdownloader.plugins.PluginTaskID;

public abstract class PluginProgress {
    protected volatile long total = 0L;
    protected volatile long current = 0L;
    protected volatile long eta = -1L;
    protected Color color;
    protected Icon icon = null;
    protected Object progressSource = null;
    protected final long startedTimestamp;
    private boolean displayInProgressColumnEnabled = true;

    public void setDisplayInProgressColumnEnabled(boolean displayInProgressColumnEnabled) {
        this.displayInProgressColumnEnabled = displayInProgressColumnEnabled;
    }

    public abstract String getMessage(Object var1);

    public abstract PluginTaskID getID();

    public PluginProgress(long current, long total, Color color) {
        this.total = total;
        this.current = current;
        this.color = color;
        this.startedTimestamp = System.currentTimeMillis();
    }

    public Color getColor() {
        return this.color;
    }

    public long getCurrent() {
        return this.current;
    }

    public double getPercent() {
        return (double)Math.round((double)this.getCurrent() * 10000.0 / (double)this.getTotal()) / 100.0;
    }

    public long getTotal() {
        return this.total;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void updateValues(long current, long total) {
        this.current = current;
        this.total = total;
        long runtime = System.currentTimeMillis() - this.startedTimestamp;
        if (runtime > 0L) {
            double speed = (double)current / (double)runtime;
            if (speed > 0.0) {
                this.setETA((long)((double)(total - current) / speed));
            } else {
                this.setETA(-1L);
            }
        }
    }

    public Icon getIcon(Object requestor) {
        if (requestor instanceof ETAColumn) {
            return null;
        }
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Object getProgressSource() {
        return this.progressSource;
    }

    public void setProgressSource(Object progressSource) {
        this.progressSource = progressSource;
    }

    public long getETA() {
        return this.eta;
    }

    public void setETA(long eTA) {
        this.eta = eTA;
    }

    public long getStarted() {
        return this.startedTimestamp;
    }

    public void abort() {
    }

    public boolean isDisplayInProgressColumnEnabled() {
        return this.displayInProgressColumnEnabled;
    }
}

