/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.components;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import jd.plugins.DownloadLink;
import org.appwork.utils.StringUtils;
import org.jdownloader.plugins.components.config.MediathekProperties;

public class MediathekHelper {
    public static String getMediathekFilename(DownloadLink dl, MediathekProperties data, boolean multipleProtocolsAvailable, boolean sameResolutionWithDifferentBitratePossible) {
        String ext;
        String protocol;
        String title = data.getTitle();
        String show = data.getShow();
        String channel = data.getChannel();
        if (channel == null) {
            channel = dl.getHost().replace(".", "_");
        }
        if ((protocol = data.getProtocol()) != null) {
            protocol = protocol.replace("httpsub", "http");
            protocol = protocol.replace("hlssub", "hls");
        }
        String videoResolution = data.getResolution();
        String date_formatted = MediathekHelper.formatDate(data.getReleaseDate());
        String type = data.getStreamingType();
        long bitrateTotal = data.getBitrateTotal();
        long bandwith = data.getBandwidth();
        int seasonNumber = data.getSeasonNumber();
        int episodeNumber = data.getEpisodeNumber();
        String filename = "";
        filename = date_formatted != null ? date_formatted + "_" + channel : channel;
        if (show != null) {
            filename = filename + "_" + show;
        }
        if (seasonNumber > 0 && episodeNumber > 0) {
            filename = filename + " - " + String.format(Locale.ROOT, "S%0" + StringUtils.getPadLength((int)seasonNumber) + "dE%0" + StringUtils.getPadLength((int)episodeNumber) + "d", seasonNumber, episodeNumber);
        }
        if (title != null) {
            filename = filename + " - " + title;
        }
        if (multipleProtocolsAvailable) {
            filename = filename + "_" + protocol;
        }
        if (sameResolutionWithDifferentBitratePossible && bitrateTotal > 0L) {
            filename = filename + "_" + bitrateTotal;
        } else if (sameResolutionWithDifferentBitratePossible && bandwith > 0L) {
            filename = filename + "_" + bandwith;
        }
        if (videoResolution != null) {
            filename = filename + "_" + videoResolution;
        }
        if (data.getAudioDescription()) {
            filename = filename + "_AD";
        }
        if ((ext = data.getFileExtension()) == null) {
            ext = "subtitle".equalsIgnoreCase(type) ? "srt" : "mp4";
        }
        if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        filename = filename + ext;
        return filename;
    }

    public static String getMediathekFilename(DownloadLink dl) {
        return MediathekHelper.getMediathekFilename(dl, dl.bindData(MediathekProperties.class), false, false);
    }

    public static String formatDate(long date) {
        if (date <= 0L) {
            return null;
        }
        String formattedDate = null;
        String targetFormat = "yyyy-MM-dd";
        Date theDate = new Date(date);
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            formattedDate = formatter.format(theDate);
        }
        catch (Exception e) {
            formattedDate = "date_error";
        }
        return formattedDate;
    }
}

