/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.components;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import org.appwork.utils.Files;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.SizeFormatter;
import org.jdownloader.controlling.UrlProtection;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.usenet.UsenetFile;
import org.jdownloader.plugins.components.usenet.UsenetFileSegment;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NZBSAXHandler
extends DefaultHandler {
    private final CharArrayWriter text = new CharArrayWriter();
    private String path = "";
    private final HashSet<String> passwords = new HashSet();
    private String password = null;
    private UsenetFile currentFile = null;
    private UsenetFileSegment currentSegment = null;
    private final ArrayList<DownloadLink> downloadLinks;
    private String date = null;
    private boolean isyEnc = false;
    private final Comparator<UsenetFileSegment> segmentComparator = new Comparator<UsenetFileSegment>(){

        @Override
        public int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compare(UsenetFileSegment o1, UsenetFileSegment o2) {
            return this.compare(o1.getIndex(), o2.getIndex());
        }
    };

    public static ArrayList<DownloadLink> parseNZB(final String string) throws Exception {
        return NZBSAXHandler.parseNZB(new InputStream(){
            final StringReader stringReader;
            {
                this.stringReader = new StringReader(string);
            }

            @Override
            public int read() throws IOException {
                return this.stringReader.read();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<DownloadLink> parseNZB(InputStream is) throws Exception {
        ArrayList<DownloadLink> downloadLinks = new ArrayList<DownloadLink>();
        NZBSAXHandler handler = new NZBSAXHandler(downloadLinks);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setXIncludeAware(false);
        factory.setValidating(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        SAXParser saxParser = factory.newSAXParser();
        try {
            saxParser.parse(new InputSource(is), (DefaultHandler)handler);
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        finally {
            try {
                handler.finishCurrentFile();
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return downloadLinks;
    }

    public NZBSAXHandler(ArrayList<DownloadLink> downloadLinks) {
        this.downloadLinks = downloadLinks;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return new InputSource(new StringReader(""));
    }

    public void finishCurrentFile() {
        if (this.currentFile != null) {
            ArrayList<UsenetFileSegment> segments = this.currentFile.getSegments();
            Collections.sort(segments, this.segmentComparator);
            BitSet segmentSet = new BitSet();
            long estimatedFileSize = 0L;
            for (UsenetFileSegment segment : segments) {
                int index = segment.getIndex();
                if (segmentSet.get(index)) continue;
                segmentSet.set(index);
                estimatedFileSize += Math.max(0L, segment.getSize());
            }
            if (this.isyEnc) {
                segmentSet.clear();
                int numOfSegments = segmentSet.length();
                long estimatedFileSizeTemp = estimatedFileSize;
                estimatedFileSize = 0L;
                long processedSize = 0L;
                for (UsenetFileSegment segment : segments) {
                    int index = segment.getIndex();
                    if (segmentSet.get(index)) continue;
                    segmentSet.set(index);
                    long estimatedSegmentSize = segment.getSize();
                    estimatedSegmentSize -= (long)("=ybegin part=" + index + " total=" + numOfSegments + " line=... size=" + estimatedFileSizeTemp + " name=" + this.currentFile.getName() + "\r\n").length();
                    estimatedSegmentSize = index == numOfSegments ? (estimatedSegmentSize -= (long)("=yend size=" + estimatedSegmentSize + " part=" + index + " pcrc32=........ crc32=........\r\n").length()) : (estimatedSegmentSize -= (long)("=yend size=" + estimatedSegmentSize + " part=" + index + " pcrc32=........\r\n").length());
                    estimatedSegmentSize -= (long)("=ypart begin=" + processedSize + " end=" + processedSize + estimatedSegmentSize + "\r\n").length();
                    estimatedSegmentSize -= estimatedSegmentSize / 128L * 2L;
                    estimatedSegmentSize = (long)((float)estimatedSegmentSize / 1.015f);
                    processedSize += estimatedSegmentSize;
                }
                estimatedFileSize = processedSize;
            }
            if (this.currentFile.getSize() != -1L && (estimatedFileSize = Math.min(estimatedFileSize, this.currentFile.getSize())) != this.currentFile.getSize()) {
                this.currentFile.setSize(-1L);
            }
            String usenetURL = "usenet://" + this.currentFile.getName() + "|" + this.currentFile.getNumSegments() + "|" + this.date;
            DownloadLink downloadLink = new DownloadLink(null, this.currentFile.getName(), "usenet", usenetURL, true);
            downloadLink.setUrlProtection(UrlProtection.PROTECTED_CONTAINER);
            if (estimatedFileSize > 0L) {
                downloadLink.setDownloadSize(estimatedFileSize);
            }
            int maxSegments = Math.max(this.currentFile.getNumSegments(), segmentSet.length() - 1);
            for (int i = 1; i <= maxSegments; ++i) {
                if (segmentSet.get(i)) continue;
                LogController.CL().info(this.currentFile.getName() + " is missing segment " + i);
                downloadLink.setProperty("incomplete", Boolean.TRUE);
                downloadLink.setAvailableStatus(DownloadLink.AvailableStatus.FALSE);
                break;
            }
            try {
                this.currentFile._write(downloadLink);
            }
            catch (IOException e) {
                LogController.CL().info("Exception for " + this.currentFile.getName());
                LogController.CL().log((Throwable)e);
                downloadLink.setProperty("incomplete", Boolean.TRUE);
                downloadLink.setAvailableStatus(DownloadLink.AvailableStatus.FALSE);
            }
            this.downloadLinks.add(downloadLink);
            this.currentFile = null;
        }
        if (this.passwords.size() > 0) {
            ArrayList<String> sourcePluginPasswords = new ArrayList<String>(this.passwords);
            for (DownloadLink downloadLink : this.downloadLinks) {
                downloadLink.setSourcePluginPasswordList(sourcePluginPasswords);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (StringUtils.equalsIgnoreCase((String)"meta", (String)qName)) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (!StringUtils.equalsIgnoreCase((String)"password", (String)attributes.getValue(index))) continue;
                this.password = "";
                break;
            }
        } else if (StringUtils.equalsIgnoreCase((String)"file", (String)qName)) {
            this.finishCurrentFile();
            this.currentFile = new UsenetFile();
            this.date = attributes.getValue("date");
            String subject = attributes.getValue("subject");
            String nameBySubject = new Regex(subject, "( |^)\"([^\"]*?\\.[a-z0-9]{2,4})\"").getMatch(1);
            if (nameBySubject == null && (nameBySubject = new Regex(subject, "( \"|^\"?)([^\"]*?\\.[a-z0-9]{2,4})\"").getMatch(1)) == null) {
                nameBySubject = new Regex(subject, "(.+ |^)(.*?)\\s*\\(\\s*[0]*1\\s*/\\s*\\d+").getMatch(1);
            }
            if (nameBySubject == null) {
                String fileNameExtension = Files.getExtension((String)subject);
                CompiledFiletypeFilter.CompiledFiletypeExtension compiled = CompiledFiletypeFilter.getExtensionsFilterInterface(fileNameExtension);
                nameBySubject = compiled != null ? subject : "Unsupported Subject:" + subject;
            }
            this.currentFile.setName(nameBySubject);
            if (subject.contains(" yEnc ")) {
                String fileSize;
                this.isyEnc = true;
                String parts = new Regex(subject, "\\s*yEnc\\s*\\(\\s*[0]*1\\s*/\\s*(\\d+)\\s*\\)$").getMatch(0);
                if (parts != null) {
                    this.currentFile.setNumSegments(Integer.parseInt(parts));
                }
                if ((fileSize = new Regex(subject, "\\s*yEnc\\s*\\(\\s*[0]*1\\s*/\\s*(\\d+)\\s*\\)\\s*\\[([0-9\\.,]+\\s*(kb|mb|gb|b))").getMatch(0)) != null) {
                    this.currentFile.setSize(SizeFormatter.getSize((String)fileSize));
                } else {
                    fileSize = new Regex(subject, "\\s*([0-9\\.,]+\\s*?(kb|mb|gb|b))\\s*yEnc").getMatch(0);
                    if (fileSize != null) {
                        this.currentFile.setSize(SizeFormatter.getSize((String)fileSize));
                    }
                }
            } else {
                this.isyEnc = false;
                String fileSize = new Regex(subject, "([0-9\\.,]+\\s*?(kb|mb|gb))").getMatch(0);
                if (fileSize != null) {
                    this.currentFile.setSize(SizeFormatter.getSize((String)fileSize));
                }
            }
        } else if (StringUtils.equalsIgnoreCase((String)"segment", (String)qName)) {
            String bytes;
            this.currentSegment = new UsenetFileSegment();
            String number = attributes.getValue("number");
            if (number != null) {
                this.currentSegment.setIndex(Integer.parseInt(number));
            }
            if ((bytes = attributes.getValue("bytes")) != null) {
                this.currentSegment.setSize(Long.parseLong(bytes));
            }
        }
        this.path = this.path + "." + qName;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (StringUtils.equalsIgnoreCase((String)"meta", (String)qName) && "".equals(this.password)) {
            this.password = this.text.toString().trim();
            if (StringUtils.isNotEmpty((String)this.password)) {
                this.passwords.add(this.password);
            }
            this.password = null;
        } else if ("segment".equalsIgnoreCase(qName)) {
            String messageID = this.text.toString().trim();
            this.currentSegment.setMessageID(messageID);
            this.currentFile.getSegments().add(this.currentSegment);
            this.currentSegment = null;
        }
        this.path = this.path.substring(0, this.path.length() - qName.length() - 1);
        this.text.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

