/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.appwork.utils.net.HTTPHeader;

public class UserAgents {
    private static final Random RANDOM = new Random();
    public static final String DEVICE_DESKTOP = "desktop";
    public static final String DEVICE_MOBILE = "mobile";
    public static final String[] DEVICES = new String[]{"desktop", "mobile"};
    public static final String PLATFORM_WINDOWS = "windows";
    public static final String PLATFORM_MACOS = "macos";
    public static final String PLATFORM_LINUX = "linux";
    public static final String PLATFORM_ANDROID = "android";
    public static final String PLATFORM_IOS = "ios";
    public static final String[] PLATFORMS = new String[]{"windows", "macos", "linux", "android", "ios"};
    public static final String[] PLATFORMS_DESKTOP = new String[]{"windows", "macos", "linux"};
    public static final String[] PLATFORMS_MOBILE = new String[]{"android", "ios"};
    public static final String BROWSER_CHROME = "chrome";
    public static final String BROWSER_FIREFOX = "firefox";
    public static final String BROWSER_SAFARI = "safari";
    public static final String BROWSER_EDGE = "edge";
    public static final String[] BROWSERS = new String[]{"chrome", "firefox", "safari", "edge"};
    public static final String[] BROWSERS_SUPPORT_CH = new String[]{"chrome", "edge"};
    private static final int[] CHROME_VERSION_RANGE = new int[]{96, 115};
    private static final int[] FIREFOX_VERSION_RANGE = new int[]{95, 115};
    private static final int[] SAFARI_VERSION_RANGE = new int[]{14, 17};
    private static final int[] EDGE_VERSION_RANGE = new int[]{96, 115};
    private static final String[] WINDOWS_VERSIONS = new String[]{"Windows NT 10.0; Win64; x64", "Windows NT 10.0; WOW64", "Windows NT 10.0"};
    private static final String[] MACOS_VERSIONS = new String[]{"Macintosh; Intel Mac OS X 10_15_7", "Macintosh; Intel Mac OS X 10_15_6", "Macintosh; Intel Mac OS X 10_15", "Macintosh; Intel Mac OS X 10_14_6"};
    private static final String[] LINUX_VERSIONS = new String[]{"X11; Linux x86_64", "X11; Ubuntu; Linux x86_64"};
    private static final String[] ANDROID_VERSIONS = new String[]{"Linux; Android 13", "Linux; Android 12", "Linux; Android 11", "Linux; Android 10"};
    private static final String[] IOS_VERSIONS = new String[]{"iPhone; CPU iPhone OS 16_5_1 like Mac OS X", "iPhone; CPU iPhone OS 16_4 like Mac OS X", "iPhone; CPU iPhone OS 15_7_1 like Mac OS X", "iPad; CPU OS 16_5_1 like Mac OS X", "iPad; CPU OS 16_4 like Mac OS X", "iPad; CPU OS 15_7_1 like Mac OS X"};
    private static final String[] ANDROID_MOBILE_MODELS = new String[]{"SM-S918B", "SM-G991B", "Pixel 7 Pro", "Pixel 7", "OnePlus 11", "OnePlus 10 Pro", "Redmi Note 12 Pro", "Mi 13 Pro"};
    private static final String[] ANDROID_TABLET_MODELS = new String[]{"SM-X910", "SM-X810", "SM-T870", "SM-T970", "Lenovo TB-X606F", "HUAWEI MatePad"};

    public static UserAgent generate() {
        return UserAgents.generate(new Options());
    }

    public static UserAgent generate(Options options) {
        String device = UserAgents.selectDevice(options);
        String platform = UserAgents.selectPlatform(device, options);
        String browser = UserAgents.selectBrowser(platform, options);
        Generator generator = new Generator(device, platform, browser, options);
        return new UserAgent(device, platform, browser, generator.getUserAgent(), generator.getHeaders(), generator.getClientHints());
    }

    public static List<HTTPHeader> generateHTTPHeaders() {
        return UserAgents.generateHTTPHeaders(new Options());
    }

    public static List<HTTPHeader> generateHTTPHeaders(Options options) {
        String device = UserAgents.selectDevice(options);
        String platform = UserAgents.selectPlatform(device, options);
        String browser = UserAgents.selectBrowser(platform, options);
        Generator generator = new Generator(device, platform, browser, options);
        return generator.getHTTPHeaders();
    }

    public static String randomUserAgent() {
        return UserAgents.generate().getUserAgentString();
    }

    public static String randomUserAgent(String browser) {
        Options options = new Options();
        options.setBrowserTypes(browser);
        return UserAgents.generate(options).getUserAgentString();
    }

    public static String randomUserAgent(String device, String browser) {
        Options options = new Options();
        options.setDeviceTypes(device);
        options.setBrowserTypes(browser);
        return UserAgents.generate(options).getUserAgentString();
    }

    public static String stringUserAgent() {
        return UserAgents.stringUserAgent(null);
    }

    public static String stringUserAgent(BrowserName browser) {
        Options options = new Options();
        options.setPlatformTypes(PLATFORMS_DESKTOP);
        if (browser != null) {
            if (BrowserName.Chrome.equals((Object)browser)) {
                options.setBrowserTypes(BROWSER_CHROME);
            } else if (BrowserName.Firefox.equals((Object)browser)) {
                options.setBrowserTypes(BROWSER_FIREFOX);
            } else if (BrowserName.Safari.equals((Object)browser)) {
                options.setBrowserTypes(BROWSER_SAFARI);
            }
        }
        return UserAgents.generate(options).getUserAgentString();
    }

    public static String portableUserAgent() {
        Options options = new Options();
        options.setDeviceTypes(DEVICE_MOBILE);
        return UserAgents.generate(options).getUserAgentString();
    }

    private static String selectDevice(Options options) {
        if (options.getDeviceTypes() != null && options.getDeviceTypes().length > 0) {
            return UserAgents.getRandomItem(options.getDeviceTypes());
        }
        return UserAgents.getRandomItem(DEVICES);
    }

    private static String selectPlatform(String device, Options options) {
        String[] platformPool = options.getPlatformTypes() != null && options.getPlatformTypes().length > 0 ? options.getPlatformTypes() : (DEVICE_DESKTOP.equals(device) ? PLATFORMS_DESKTOP : (DEVICE_MOBILE.equals(device) ? PLATFORMS_MOBILE : PLATFORMS));
        return UserAgents.getRandomItem(platformPool);
    }

    private static String selectBrowser(String platform, Options options) {
        if (options.getBrowserTypes() != null && options.getBrowserTypes().length > 0) {
            String browser = UserAgents.getRandomItem(options.getBrowserTypes());
            if (BROWSER_SAFARI.equals(browser) && !PLATFORM_MACOS.equals(platform) && !PLATFORM_IOS.equals(platform)) {
                return BROWSER_CHROME;
            }
            return browser;
        }
        if (PLATFORM_MACOS.equals(platform) || PLATFORM_IOS.equals(platform)) {
            return UserAgents.getRandomItem(BROWSERS);
        }
        ArrayList<String> compatibleBrowsers = new ArrayList<String>();
        for (String browser : BROWSERS) {
            if (BROWSER_SAFARI.equals(browser)) continue;
            compatibleBrowsers.add(browser);
        }
        return UserAgents.getRandomItem(compatibleBrowsers.toArray(new String[0]));
    }

    private static <T> T getRandomItem(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[RANDOM.nextInt(array.length)];
    }

    private static int getRandomInt(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    private static String capitalizeFirstLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static void main(String[] args) {
        String backwardCompatString = UserAgents.stringUserAgent();
        System.out.println("Backward compatibility - stringUserAgent(): " + backwardCompatString);
        String mobileString = UserAgents.portableUserAgent();
        System.out.println("Mobile user agent: " + mobileString);
        String chromeAgent = UserAgents.randomUserAgent(BROWSER_CHROME);
        System.out.println("\nChrome agent: " + chromeAgent);
        String firefoxAgent = UserAgents.randomUserAgent(BROWSER_FIREFOX);
        System.out.println("\nFirefox agent: " + firefoxAgent);
        String safariAgent = UserAgents.randomUserAgent(BROWSER_SAFARI);
        System.out.println("\nSafari agent: " + safariAgent);
        UserAgent fullAgent = UserAgents.generate();
        System.out.println("\n=== Full User Agent ===");
        System.out.println("Device: " + fullAgent.getDevice());
        System.out.println("Platform: " + fullAgent.getPlatform());
        System.out.println("Browser: " + fullAgent.getBrowser());
        System.out.println("User-Agent: " + fullAgent.getUserAgentString());
        System.out.println("\n=== Headers ===");
        Map<String, String> headers = fullAgent.getHeaders();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            System.out.println(header.getKey() + ": " + header.getValue());
        }
        Options options = new Options().setDeviceTypes(DEVICE_DESKTOP).setPlatformTypes(PLATFORM_WINDOWS).setBrowserTypes(BROWSER_EDGE);
        UserAgent specificAgent = UserAgents.generate(options);
        System.out.println("\n=== Windows Edge Browser ===");
        System.out.println(specificAgent.getUserAgentString());
    }

    public static class Generator {
        private final String device;
        private final String platform;
        private final String browser;
        private final Options options;
        private final String userAgent;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> clientHints = new HashMap<String, String>();
        private final List<HTTPHeader> httpHeaders = new ArrayList<HTTPHeader>();

        public Generator(String device, String platform, String browser, Options options) {
            this.device = device;
            this.platform = platform;
            this.browser = browser;
            this.options = options;
            this.userAgent = this.buildUserAgentString();
            this.buildHeaders();
            if (this.supportsClientHints()) {
                this.buildClientHints();
            }
            this.buildHTTPHeaders();
        }

        private String buildUserAgentString() {
            StringBuilder ua = new StringBuilder("Mozilla/5.0 (");
            if (UserAgents.PLATFORM_WINDOWS.equals(this.platform)) {
                ua.append((String)UserAgents.getRandomItem(WINDOWS_VERSIONS));
            } else if (UserAgents.PLATFORM_MACOS.equals(this.platform)) {
                ua.append((String)UserAgents.getRandomItem(MACOS_VERSIONS));
            } else if (UserAgents.PLATFORM_LINUX.equals(this.platform)) {
                ua.append((String)UserAgents.getRandomItem(LINUX_VERSIONS));
            } else if (UserAgents.PLATFORM_ANDROID.equals(this.platform)) {
                ua.append((String)UserAgents.getRandomItem(ANDROID_VERSIONS));
                if (UserAgents.DEVICE_MOBILE.equals(this.device)) {
                    ua.append("; ").append((String)UserAgents.getRandomItem(ANDROID_MOBILE_MODELS));
                } else {
                    ua.append("; ").append((String)UserAgents.getRandomItem(ANDROID_TABLET_MODELS));
                }
            } else if (UserAgents.PLATFORM_IOS.equals(this.platform)) {
                ua.append((String)UserAgents.getRandomItem(IOS_VERSIONS));
            }
            ua.append(") AppleWebKit/537.36 (KHTML, like Gecko) ");
            if (UserAgents.BROWSER_CHROME.equals(this.browser)) {
                int chromeVersion = UserAgents.getRandomInt(CHROME_VERSION_RANGE[0], CHROME_VERSION_RANGE[1]);
                int chromeBuild = UserAgents.getRandomInt(4500, 5999);
                ua.append("Chrome/").append(chromeVersion).append(".0.").append(chromeBuild).append(".").append(UserAgents.getRandomInt(10, 99));
                ua.append(" Safari/537.36");
            } else if (UserAgents.BROWSER_FIREFOX.equals(this.browser)) {
                int firefoxVersion = UserAgents.getRandomInt(FIREFOX_VERSION_RANGE[0], FIREFOX_VERSION_RANGE[1]);
                ua.append("Firefox/").append(firefoxVersion).append(".0");
            } else if (UserAgents.BROWSER_EDGE.equals(this.browser)) {
                int edgeVersion = UserAgents.getRandomInt(EDGE_VERSION_RANGE[0], EDGE_VERSION_RANGE[1]);
                int edgeBuild = UserAgents.getRandomInt(1000, 1500);
                ua.append("Chrome/").append(edgeVersion).append(".0.").append(UserAgents.getRandomInt(4500, 5999)).append(".").append(UserAgents.getRandomInt(10, 99));
                ua.append(" Safari/537.36 Edg/").append(edgeVersion).append(".0.").append(edgeBuild).append(".").append(UserAgents.getRandomInt(10, 99));
            } else if (UserAgents.BROWSER_SAFARI.equals(this.browser)) {
                if (UserAgents.PLATFORM_IOS.equals(this.platform)) {
                    ua.append("Version/").append(UserAgents.getRandomInt(15, 17)).append(".").append(UserAgents.getRandomInt(0, 6)).append(" Mobile/15E148 Safari/604.1");
                } else {
                    int safariVersion = UserAgents.getRandomInt(SAFARI_VERSION_RANGE[0], SAFARI_VERSION_RANGE[1]);
                    ua.append("Version/").append(safariVersion).append(".").append(UserAgents.getRandomInt(0, 6)).append(".").append(UserAgents.getRandomInt(1, 15));
                    ua.append(" Safari/605.1.15");
                }
            }
            return ua.toString();
        }

        private void buildHeaders() {
            this.headers.put("User-Agent", this.userAgent);
            this.headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            this.headers.put("Accept-Language", "en-US,en;q=0.9");
            this.headers.put("Accept-Encoding", "gzip, deflate, br");
            this.headers.put("Connection", "keep-alive");
            if (UserAgents.BROWSER_FIREFOX.equals(this.browser)) {
                this.headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8");
                this.headers.put("Upgrade-Insecure-Requests", "1");
                this.headers.put("TE", "trailers");
            }
        }

        private boolean supportsClientHints() {
            for (String supportedBrowser : BROWSERS_SUPPORT_CH) {
                if (!this.browser.equals(supportedBrowser)) continue;
                return true;
            }
            return false;
        }

        private void buildClientHints() {
            this.clientHints.put("Sec-CH-UA-Mobile", this.device.equals(UserAgents.DEVICE_MOBILE) ? "?1" : "?0");
            this.clientHints.put("Sec-CH-UA-Platform", "\"" + UserAgents.capitalizeFirstLetter(this.platform) + "\"");
            if (UserAgents.BROWSER_CHROME.equals(this.browser) || UserAgents.BROWSER_EDGE.equals(this.browser)) {
                int majorVersion = UserAgents.BROWSER_CHROME.equals(this.browser) ? UserAgents.getRandomInt(CHROME_VERSION_RANGE[0], CHROME_VERSION_RANGE[1]) : UserAgents.getRandomInt(EDGE_VERSION_RANGE[0], EDGE_VERSION_RANGE[1]);
                String browserBrand = UserAgents.BROWSER_CHROME.equals(this.browser) ? "Google Chrome" : "Microsoft Edge";
                String uaList = "\"" + browserBrand + "\";v=\"" + majorVersion + "\", ";
                uaList = majorVersion >= 100 ? uaList + "\"Not=A?Brand\";v=\"99\", \"Chromium\";v=\"" + majorVersion + "\"" : uaList + "\" Not A;Brand\";v=\"99\", \"Chromium\";v=\"" + majorVersion + "\"";
                this.clientHints.put("Sec-CH-UA", uaList);
                this.headers.put("Sec-CH-UA", this.clientHints.get("Sec-CH-UA"));
                this.headers.put("Sec-CH-UA-Mobile", this.clientHints.get("Sec-CH-UA-Mobile"));
                this.headers.put("Sec-CH-UA-Platform", this.clientHints.get("Sec-CH-UA-Platform"));
                this.headers.put("sec-ch-ua-full-version-list", uaList);
                if (UserAgents.BROWSER_CHROME.equals(this.browser)) {
                    this.headers.put("sec-ch-ua-arch", "\"x86\"");
                    this.headers.put("sec-ch-ua-bitness", "\"64\"");
                    this.headers.put("sec-ch-ua-full-version", "\"" + majorVersion + ".0.0.0\"");
                    this.headers.put("sec-ch-ua-model", "\"\"");
                    this.headers.put("sec-ch-ua-wow64", "?0");
                    this.headers.put("sec-fetch-dest", "document");
                    this.headers.put("sec-fetch-mode", "navigate");
                    this.headers.put("sec-fetch-site", "none");
                    this.headers.put("sec-fetch-user", "?1");
                    this.headers.put("upgrade-insecure-requests", "1");
                }
            }
        }

        private void buildHTTPHeaders() {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                this.httpHeaders.add(new HTTPHeader(entry.getKey(), entry.getValue(), true));
            }
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Map<String, String> getClientHints() {
            return this.clientHints;
        }

        public List<HTTPHeader> getHTTPHeaders() {
            return this.httpHeaders;
        }
    }

    public static class UserAgent {
        private final String device;
        private final String platform;
        private final String browser;
        private final String userAgentString;
        private final Map<String, String> headers;
        private final Map<String, String> clientHints;
        private final List<HTTPHeader> httpHeaders;

        public UserAgent(String device, String platform, String browser, String userAgentString, Map<String, String> headers, Map<String, String> clientHints) {
            this.device = device;
            this.platform = platform;
            this.browser = browser;
            this.userAgentString = userAgentString;
            this.headers = headers;
            this.clientHints = clientHints;
            this.httpHeaders = new ArrayList<HTTPHeader>();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.httpHeaders.add(new HTTPHeader(entry.getKey(), entry.getValue(), true));
            }
        }

        public String getDevice() {
            return this.device;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getBrowser() {
            return this.browser;
        }

        public String getUserAgentString() {
            return this.userAgentString;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Map<String, String> getClientHints() {
            return this.clientHints;
        }

        public List<HTTPHeader> getHTTPHeaders() {
            return this.httpHeaders;
        }

        public String toString() {
            return this.userAgentString;
        }
    }

    public static class Options {
        private boolean randomizeUserAgent = true;
        private String[] deviceTypes = null;
        private String[] platformTypes = null;
        private String[] browserTypes = null;

        public Options setDeviceTypes(String ... deviceTypes) {
            this.deviceTypes = deviceTypes;
            return this;
        }

        public Options setPlatformTypes(String ... platformTypes) {
            this.platformTypes = platformTypes;
            return this;
        }

        public Options setBrowserTypes(String ... browserTypes) {
            this.browserTypes = browserTypes;
            return this;
        }

        public Options setRandomizeUserAgent(boolean randomize) {
            this.randomizeUserAgent = randomize;
            return this;
        }

        public String[] getDeviceTypes() {
            return this.deviceTypes;
        }

        public String[] getPlatformTypes() {
            return this.platformTypes;
        }

        public String[] getBrowserTypes() {
            return this.browserTypes;
        }

        public boolean isRandomizeUserAgent() {
            return this.randomizeUserAgent;
        }
    }

    public static enum BrowserName {
        Chrome(" Chrome/"),
        Firefox(" Firefox/"),
        Safari(" Version/[0-9]\\.[0-9]\\.[0-9] Safari/[0-9]{3}\\.[0-9]\\.[0-9]");

        private final Pattern pattern;

        public Pattern getPattern() {
            return this.pattern;
        }

        private BrowserName(String s) {
            this.pattern = Pattern.compile(s);
        }
    }
}

