/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.components.gopro;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.AccountFilter;
import jd.controlling.TaskQueue;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.plugins.Account;
import org.appwork.swing.components.ExtButton;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuExtenderHandler;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.gui.mainmenu.MenuManagerMainmenu;
import org.jdownloader.gui.toolbar.MenuManagerMainToolbar;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;

public class SyncGoProLibraryToolbarAction
extends AbstractToolBarAction {
    private static final AtomicBoolean EXTENDER_REGISTERED = new AtomicBoolean(false);
    private static final AtomicBoolean ENABLED = new AtomicBoolean(false);
    private static final WeakHashMap<SyncGoProLibraryToolbarAction, Object> ACTION_REFERENCES = new WeakHashMap();

    public SyncGoProLibraryToolbarAction() {
        this.setTooltipText("Sync GoPro Plus Library");
        this.setIconKey("fav/gopro.com");
        new EDTRunner(){

            protected void runInEDT() {
                ACTION_REFERENCES.put(SyncGoProLibraryToolbarAction.this, new Object());
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        SyncGoProLibraryToolbarAction.updateEnabled();
                        return null;
                    }
                });
            }
        };
    }

    @Override
    public AbstractButton createButton() {
        ExtButton ret = new ExtButton((AbstractAction)((Object)this));
        ret.setHideActionText(true);
        ret.setIcon(DomainInfo.getInstance("gopro.com").getFavIcon(true));
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled() && UIOManager.I().showConfirmDialog(32, "GoPro Plus Media Library Sync", "JDownloader will now search all available media files in your GoPro media library and add them to the Linkgrabber tab.\r\nPlease be patient - this will take a while. If you keep all links in the linkgrabber or downlist, the next sync process will be much faster.")) {
            LinkCollector.getInstance().addCrawlerJob(new LinkCollectingJob(LinkOrigin.TOOLBAR.getLinkOriginDetails(), "https://plus.gopro.com/media-library/"));
        }
    }

    @Override
    protected String createTooltip() {
        return "Sync GoPro Plus Library";
    }

    public boolean isEnabled() {
        return ENABLED.get();
    }

    private static void updateEnabled() {
        final boolean enabled = AccountController.getInstance().listAccounts(new AccountFilter("gopro.com").setEnabled(true).setValid(true).setAccountTypes(Account.AccountType.PREMIUM, Account.AccountType.LIFETIME).setMaxResultsNum(1)).size() > 0;
        ENABLED.set(enabled);
        new EDTRunner(){

            protected void runInEDT() {
                for (SyncGoProLibraryToolbarAction action : ACTION_REFERENCES.keySet()) {
                    action.setEnabled(enabled);
                }
            }
        };
    }

    public static void registerExtender() {
        if (!Application.isHeadless() && EXTENDER_REGISTERED.compareAndSet(false, true)) {
            new Thread("SyncGoProLibraryToolbarAction.registerExtender"){

                @Override
                public void run() {
                    AccountController.getInstance().getEventSender().addListener((EventListener)new AccountControllerListener(){

                        @Override
                        public void onAccountControllerEvent(AccountControllerEvent event) {
                            SyncGoProLibraryToolbarAction.updateEnabled();
                        }
                    });
                    MenuExtenderHandler extenderHandler = new MenuExtenderHandler(){

                        @Override
                        public MenuItemData updateMenuModel(ContextMenuManager manager, MenuContainerRoot mr) {
                            if (manager instanceof MenuManagerMainmenu) {
                                return null;
                            }
                            if (manager instanceof MenuManagerMainToolbar) {
                                for (MenuItemData m : mr.getItems()) {
                                    String cl;
                                    ActionData ad = m.getActionData();
                                    if (ad == null || !StringUtils.equals((String)(cl = ad.getClazzName()), (String)SyncGoProLibraryToolbarAction.class.getName())) continue;
                                    return null;
                                }
                                mr.add(SyncGoProLibraryToolbarAction.class);
                            }
                            return null;
                        }
                    };
                    MenuManagerMainmenu.getInstance().registerExtender(extenderHandler);
                    MenuManagerMainToolbar.getInstance().registerExtender(extenderHandler);
                }
            }.start();
        }
    }
}

