/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import jd.plugins.download.raf.FileBytesCacheFlusher;
import org.jdownloader.logging.LogController;

public class FileBytesCache {
    protected final byte[] writeCache;
    protected volatile int writeCachePosition = 0;
    protected volatile long lastWriteCacheFlush = -1L;
    protected final ArrayList<WriteCacheEntry> writeCacheEntries = new ArrayList();
    protected final int flushTimeout;
    private static final Comparator<WriteCacheEntry> sorter = new Comparator<WriteCacheEntry>(){

        @Override
        private int compare(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compare(WriteCacheEntry o1, WriteCacheEntry o2) {
            return this.compare(o1.getFileWritePosition(), o2.getFileWritePosition());
        }
    };

    public FileBytesCache(int writeCacheSize, int flushTimeout) {
        this.writeCache = new byte[writeCacheSize];
        this.flushTimeout = flushTimeout;
    }

    public synchronized void write(FileBytesCacheFlusher flusher, long fileWritePosition, byte[] readBuffer, int length) {
        int writeCacheRemaining = this.writeCache.length - this.writeCachePosition;
        if (length > writeCacheRemaining || this.lastWriteCacheFlush > 0L && System.currentTimeMillis() > this.lastWriteCacheFlush) {
            if (this.contains(flusher) || this.lastWriteCacheFlush > 0L && System.currentTimeMillis() > this.lastWriteCacheFlush) {
                WriteThroughEntry writeThrough = new WriteThroughEntry(flusher, readBuffer, fileWritePosition);
                writeThrough.increaseSize(length);
                this.writeCacheEntries.add(writeThrough);
                this.flush();
            } else {
                try {
                    flusher.flush(readBuffer, 0, length, fileWritePosition);
                    flusher.flushed();
                }
                catch (Throwable e) {
                    LogController.CL().log(e);
                }
            }
            return;
        }
        WriteCacheEntry entry = null;
        boolean add = false;
        if (this.writeCacheEntries.size() <= 0 || (entry = this.writeCacheEntries.get(this.writeCacheEntries.size() - 1)) == null || entry.getFlusher() != flusher || entry.getFileWritePosition() + (long)entry.getSize() != fileWritePosition) {
            entry = new WriteCacheEntry(flusher, this.writeCachePosition, fileWritePosition);
            add = true;
        }
        System.arraycopy(readBuffer, 0, this.writeCache, this.writeCachePosition, length);
        this.writeCachePosition += length;
        entry.increaseSize(length);
        if (add) {
            this.writeCacheEntries.add(entry);
        }
        if (this.lastWriteCacheFlush < 0L) {
            this.lastWriteCacheFlush = System.currentTimeMillis() + (long)this.flushTimeout;
        }
    }

    private synchronized boolean contains(FileBytesCacheFlusher flusher) {
        for (WriteCacheEntry writeCacheEntry : this.writeCacheEntries) {
            if (writeCacheEntry.getFlusher() != flusher) continue;
            return true;
        }
        return false;
    }

    public synchronized void flushIfContains(FileBytesCacheFlusher flusher) {
        if (this.contains(flusher)) {
            this.flush();
        }
    }

    public synchronized void execute(Runnable task) {
        if (task != null) {
            task.run();
        }
    }

    public synchronized void flush() {
        FileBytesCacheFlusher flusher;
        this.lastWriteCacheFlush = -1L;
        this.writeCachePosition = 0;
        HashMap<FileBytesCacheFlusher, ArrayList<WriteCacheEntry>> writeEntries = new HashMap<FileBytesCacheFlusher, ArrayList<WriteCacheEntry>>();
        for (WriteCacheEntry writeCacheEntry : this.writeCacheEntries) {
            flusher = writeCacheEntry.getFlusher();
            ArrayList<WriteCacheEntry> cacheList = (ArrayList<WriteCacheEntry>)writeEntries.get(flusher);
            if (cacheList == null) {
                cacheList = new ArrayList<WriteCacheEntry>();
                writeEntries.put(flusher, cacheList);
            }
            cacheList.add(writeCacheEntry);
        }
        this.writeCacheEntries.clear();
        for (Map.Entry entry : writeEntries.entrySet()) {
            flusher = (FileBytesCacheFlusher)entry.getKey();
            try {
                ArrayList cacheEntries = (ArrayList)entry.getValue();
                Collections.sort(cacheEntries, sorter);
                for (WriteCacheEntry writeCacheEntry : cacheEntries) {
                    if (writeCacheEntry instanceof WriteThroughEntry) {
                        WriteThroughEntry writeThrough = (WriteThroughEntry)writeCacheEntry;
                        flusher.flush(writeThrough.getBuffer(), writeCacheEntry.getWriteCachePosition(), writeCacheEntry.getSize(), writeCacheEntry.getFileWritePosition());
                        continue;
                    }
                    flusher.flush(this.writeCache, writeCacheEntry.getWriteCachePosition(), writeCacheEntry.getSize(), writeCacheEntry.getFileWritePosition());
                }
                flusher.flushed();
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
    }

    private class WriteCacheEntry {
        private volatile int size;
        private final FileBytesCacheFlusher flusher;
        private final int writeCachePosition;
        private final long fileWritePosition;

        protected final int getSize() {
            return this.size;
        }

        protected final void increaseSize(int size) {
            this.size += size;
        }

        protected final FileBytesCacheFlusher getFlusher() {
            return this.flusher;
        }

        protected long getFileWritePosition() {
            return this.fileWritePosition;
        }

        protected final int getWriteCachePosition() {
            return this.writeCachePosition;
        }

        private WriteCacheEntry(FileBytesCacheFlusher flusher, int writeCachePosition, long fileWritePosition) {
            this.writeCachePosition = writeCachePosition;
            this.fileWritePosition = fileWritePosition;
            this.size = 0;
            this.flusher = flusher;
        }

        public String toString() {
            return this.flusher + ":" + this.writeCachePosition + "=" + this.size + "->" + this.fileWritePosition;
        }
    }

    private class WriteThroughEntry
    extends WriteCacheEntry {
        private final byte[] buffer;

        protected final byte[] getBuffer() {
            return this.buffer;
        }

        private WriteThroughEntry(FileBytesCacheFlusher flusher, byte[] buffer, long fileWritePosition) {
            super(flusher, 0, fileWritePosition);
            this.buffer = buffer;
        }
    }
}

