/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.plugins.download.Downloadable;
import jd.plugins.download.raf.ChunkRange;
import jd.plugins.download.raf.HTTPDownloader;
import org.appwork.utils.Exceptions;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.LimitedInputStream;
import org.appwork.utils.net.throttledconnection.MeteredThrottledInputStream;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class HTTPChunk
extends Thread {
    private final AtomicBoolean connectionClosedFlag = new AtomicBoolean(false);
    private final HTTPDownloader dl;
    private final Downloadable downloadable;
    private final LogInterface logger;
    private final AtomicBoolean runningFlag = new AtomicBoolean(true);
    private final URLConnectionAdapter reuseConnection;
    private volatile URLConnectionAdapter currentConnection = null;
    private final NullsafeAtomicReference<ERROR> error = new NullsafeAtomicReference((Object)ERROR.NONE);
    private volatile Throwable errorThrowable = null;
    private final ChunkRange chunkRange;

    protected ERROR getError() {
        return (ERROR)((Object)this.error.get());
    }

    protected Throwable getErrorThrowable() {
        return this.errorThrowable;
    }

    protected ChunkRange getChunkRange() {
        return this.chunkRange;
    }

    protected boolean isRunning() {
        return this.runningFlag.get();
    }

    private void setError(ERROR error, Throwable errorThrowable) {
        if (!this.isExternalyAborted() && this.error.compareAndSet((Object)ERROR.NONE, (Object)error)) {
            switch (error) {
                case CONNECTING: {
                    this.logger.severe("Connecting failed! " + Exceptions.getStackTrace((Throwable)errorThrowable));
                    break;
                }
                case DOWNLOADING: {
                    this.logger.severe("Downloading failed! " + Exceptions.getStackTrace((Throwable)errorThrowable));
                    break;
                }
                case RANGE: {
                    this.logger.severe("Range error!");
                    break;
                }
                case ABORT: {
                    this.logger.severe("Aborted!");
                    break;
                }
                case REDIRECT: {
                    this.logger.severe("Redirect error!");
                    break;
                }
                case INVALID_CONTENT: {
                    this.logger.severe("Invalid_Content error!");
                    break;
                }
            }
            this.errorThrowable = errorThrowable;
        }
    }

    public HTTPChunk(ChunkRange chunkRange, URLConnectionAdapter reuseConnection, HTTPDownloader dl, Downloadable link) {
        super("DownloadChunkRAF:" + link.getName() + "|" + chunkRange);
        this.chunkRange = chunkRange;
        this.reuseConnection = reuseConnection;
        this.dl = dl;
        this.downloadable = link;
        this.logger = dl.getLogger();
        if (CrossSystem.isWindows()) {
            try {
                this.setPriority(7);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URLConnectionAdapter openConnection() {
        URLConnectionAdapter con = this.reuseConnection;
        if (con != null) {
            long[] responseRange = con.getRange();
            if (responseRange == null) {
                if (this.chunkRange.getFrom() <= 0L) return con;
                this.setError(ERROR.RANGE, new IOException("RangeError(Missing):" + Arrays.toString(responseRange) + "|" + this.chunkRange + "|" + this.dl.getVerifiedFileSize()));
                return null;
            }
            if (responseRange[0] != this.chunkRange.getFrom()) {
                this.setError(ERROR.RANGE, new IOException("RangeError(From):" + Arrays.toString(responseRange) + "|" + this.chunkRange + "|" + this.dl.getVerifiedFileSize()));
                return null;
            }
            if (this.chunkRange.getTo() != null && this.chunkRange.getTo() >= 0L && responseRange[1] < this.chunkRange.getTo()) {
                this.logger.info("RangeWarning(To):" + Arrays.toString(responseRange) + "|" + this.chunkRange + "|" + this.dl.getVerifiedFileSize());
            }
            if (this.dl.getVerifiedFileSize() < 0L) return con;
            if (responseRange[2] == this.dl.getVerifiedFileSize()) return con;
            if (responseRange[2] == -1L) {
                this.logger.info("RangeWarning(size):" + Arrays.toString(responseRange) + "|" + this.chunkRange + "|" + this.dl.getVerifiedFileSize());
                return con;
            }
            this.setError(ERROR.RANGE, new IOException("RangeError(size):" + Arrays.toString(responseRange) + "|" + this.chunkRange + "|" + this.dl.getVerifiedFileSize()));
            return null;
        }
        try {
            Browser br = this.downloadable.getContextBrowser();
            br.setLogger(this.logger);
            Request request = this.dl.getRequest().cloneRequest();
            request.getHeaders().put(new HTTPHeader("Accept-Encoding", "identity", false));
            request.setConnectTimeout(this.dl.getRequestTimeout());
            request.setReadTimeout(this.dl.getReadTimeout());
            if (!br.getHeaders().contains("Referer")) {
                br.setCurrentURL(null);
            }
            boolean returnConnection = false;
            try {
                block71: {
                    block70: {
                        block72: {
                            String requestedRange = this.chunkRange.isRangeRequested() ? this.chunkRange.getRangeHeaderContent(false) : null;
                            request.getHeaders().remove("Range");
                            request.getHeaders().put(new HTTPHeader("Range", requestedRange, false));
                            try {
                                this.downloadable.waitForNextConnectionAllowed();
                            }
                            catch (InterruptedException e1) {
                                if (this.downloadable.isInterrupted()) {
                                    this.setError(ERROR.ABORT, e1);
                                }
                                URLConnectionAdapter uRLConnectionAdapter = null;
                                if (returnConnection) return uRLConnectionAdapter;
                                try {
                                    con.disconnect();
                                    return uRLConnectionAdapter;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                return uRLConnectionAdapter;
                            }
                            if (this.isExternalyAborted()) {
                                this.setError(ERROR.ABORT, null);
                                URLConnectionAdapter e1 = null;
                                return e1;
                            }
                            con = br.openRequestConnection(request, false);
                            int maxRedirects = 10;
                            while (con.getRequest().getLocation() != null && maxRedirects-- > 0) {
                                con.disconnect();
                                request = br.createRedirectFollowingRequest(request);
                                try {
                                    this.downloadable.waitForNextConnectionAllowed();
                                }
                                catch (InterruptedException e1) {
                                    if (this.downloadable.isInterrupted()) {
                                        this.setError(ERROR.ABORT, e1);
                                    }
                                    URLConnectionAdapter uRLConnectionAdapter = null;
                                    if (returnConnection) return uRLConnectionAdapter;
                                    try {
                                        con.disconnect();
                                        return uRLConnectionAdapter;
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    return uRLConnectionAdapter;
                                }
                                if (this.isExternalyAborted()) {
                                    this.setError(ERROR.ABORT, null);
                                    URLConnectionAdapter e1 = null;
                                    return e1;
                                }
                                con = br.openRequestConnection(request, false);
                            }
                            if (con.getRequest().getLocation() != null) {
                                this.setError(ERROR.REDIRECT, null);
                                URLConnectionAdapter e1 = null;
                                return e1;
                            }
                            HTTPDownloader.VALIDATION_RESULT validation_result = this.dl.validateConnection(con);
                            long[] contentRange = con.getRange();
                            if (!validation_result.isOk() && (validation_result.countOk() <= 0 || validation_result.countFailed() != 1 || !validation_result.hasFailed(HTTPDownloader.VALIDATION.CONTENT_LENGTH))) break block71;
                            if (con.getResponseCode() != 200) {
                                if (con.getResponseCode() != 206) return null;
                            }
                            if (requestedRange == null) break block72;
                            if (contentRange != null) {
                                if (contentRange[0] != this.chunkRange.getFrom()) {
                                    this.setError(ERROR.RANGE, new IOException("RangeError(From):" + Arrays.toString(contentRange) + "|" + this.chunkRange + "|VerifiedFileSize:" + this.dl.getVerifiedFileSize()));
                                    URLConnectionAdapter uRLConnectionAdapter = null;
                                    return uRLConnectionAdapter;
                                }
                                if (this.chunkRange.getTo() != null && this.chunkRange.getTo() >= 0L && contentRange[1] < this.chunkRange.getTo()) {
                                    this.logger.info("Allow smaller response range:" + Arrays.toString(contentRange) + "|" + this.chunkRange + "|VerifiedFileSize:" + this.dl.getVerifiedFileSize());
                                }
                                if (this.dl.getVerifiedFileSize() >= 0L && contentRange[2] != this.dl.getVerifiedFileSize()) {
                                    if (contentRange[2] == -1L) {
                                        this.logger.info("RangeWarning(Size):" + Arrays.toString(contentRange) + "|" + this.chunkRange + "|VerifiedFileSize:" + this.dl.getVerifiedFileSize());
                                        break block70;
                                    } else {
                                        if (!con.isContentDecoded()) {
                                            this.setError(ERROR.RANGE, new IOException("RangeError(Size):" + Arrays.toString(contentRange) + "|" + this.chunkRange + "|VerifiedFileSize:" + this.dl.getVerifiedFileSize()));
                                            URLConnectionAdapter uRLConnectionAdapter = null;
                                            return uRLConnectionAdapter;
                                        }
                                        this.logger.info("RangeWarning(Size):" + Arrays.toString(contentRange) + "|" + this.chunkRange + "|VerifiedFileSize:" + this.dl.getVerifiedFileSize() + "|Content-Encoding" + con.getHeaderField("Content-Encoding"));
                                    }
                                }
                                break block70;
                            } else if (this.chunkRange.getFrom() > 0L) {
                                if (con.getResponseCode() == 200 && validation_result.hasFailed(HTTPDownloader.VALIDATION.CONTENT_LENGTH) && this.chunkRange.getLength() == con.getCompleteContentLength()) {
                                    this.logger.info("ResponseWarning(invalid content-range?!)");
                                    break block70;
                                } else {
                                    this.setError(ERROR.RANGE, new IOException("RangeError(Missing):" + Arrays.toString(contentRange) + "|" + this.chunkRange + "|VerifiedFileSize:" + this.dl.getVerifiedFileSize()));
                                    URLConnectionAdapter uRLConnectionAdapter = null;
                                    return uRLConnectionAdapter;
                                }
                            }
                            break block70;
                        }
                        new IOException("FIXME");
                    }
                    returnConnection = true;
                    URLConnectionAdapter uRLConnectionAdapter = con;
                    return uRLConnectionAdapter;
                }
                if (con.getResponseCode() == 200 || con.getResponseCode() == 206) {
                    this.setError(ERROR.INVALID_CONTENT, null);
                } else {
                    this.setError(ERROR.INVALID_RESPONSE, null);
                }
                String contentType = con.getContentType();
                if (contentType != null && (contentType.contains("text") || contentType.contains("html"))) {
                    br.followConnection();
                }
                URLConnectionAdapter uRLConnectionAdapter = null;
                return uRLConnectionAdapter;
            }
            finally {
                if (!returnConnection) {
                    try {
                        con.disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable e) {
            this.setError(ERROR.CONNECTING, e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadConnection(URLConnectionAdapter connection) {
        MeteredThrottledInputStream inputStream = null;
        try {
            connection.setReadTimeout(this.dl.getReadTimeout());
            connection.setConnectTimeout(this.dl.getRequestTimeout());
            InputStream is2332 = connection.getInputStream();
            if (this.chunkRange.getLength() >= 0L) {
                is2332 = new LimitedInputStream(is2332, this.chunkRange.getLength());
            }
            inputStream = new MeteredThrottledInputStream(is2332, (SpeedMeterInterface)new AverageSpeedMeter(10)){

                public void close() throws IOException {
                }
            };
            this.dl.getManagedConnetionHandler().addThrottledConnection((ThrottledConnection)inputStream);
            byte[] readBuffer = this.dl.getChunkBuffer(this);
            while (!this.isExternalyAborted()) {
                int bytesRead = inputStream.read(readBuffer);
                if (bytesRead > 0) {
                    long overlap = this.dl.write(this, readBuffer, bytesRead, this.chunkRange.getPosition());
                    this.chunkRange.incLoaded(bytesRead);
                    if (overlap == (long)bytesRead) continue;
                    this.logger.finer("Overlap Chunk: " + this.chunkRange + " (" + overlap + ")");
                } else {
                    if (bytesRead != -1) continue;
                    if (this.chunkRange.getLoaded() == 0L) {
                        throw new IOException("No bytes read!");
                    }
                    this.chunkRange.setValidLoaded(true);
                }
                break;
            }
        }
        catch (Throwable e) {
            try {
                this.setError(ERROR.DOWNLOADING, e);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                block25: {
                    try {
                        if (inputStream == null) break block25;
                        try {
                            inputStream.setHandler(null);
                        }
                        finally {
                            this.dl.getManagedConnetionHandler().removeThrottledConnection((ThrottledConnection)inputStream);
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            if (inputStream == null) return;
            try {
                inputStream.setHandler(null);
                return;
            }
            finally {
                this.dl.getManagedConnetionHandler().removeThrottledConnection((ThrottledConnection)inputStream);
            }
        }
        catch (Throwable is2332) {
            return;
        }
    }

    private boolean isExternalyAborted() {
        return this.dl.externalDownloadStop() || this.connectionClosedFlag.get();
    }

    @Override
    public void run() {
        try {
            if (this.runningFlag.get()) {
                this.run0();
            }
        }
        finally {
            this.runningFlag.set(false);
            this.dl.onChunkFinished(this);
        }
    }

    public void run0() {
        URLConnectionAdapter connection = null;
        try {
            this.logger.finer("Start Chunk: " + this.chunkRange);
            this.currentConnection = connection = this.openConnection();
            if (connection != null && !this.isExternalyAborted()) {
                this.dl.updateCacheMapSize(connection);
                this.downloadConnection(connection);
            }
        }
        finally {
            this.currentConnection = null;
            this.logger.finer("Stop Chunk: " + this.chunkRange + " (ExternalAbort: " + this.isExternalyAborted() + "|ERROR:" + (Object)((Object)this.getError()) + ")");
            try {
                if (connection != null && connection != this.reuseConnection) {
                    connection.disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public String toString() {
        return this.chunkRange.toString();
    }

    public void closeConnections() {
        if (this.runningFlag.get() && this.connectionClosedFlag.compareAndSet(false, true)) {
            if (!this.isAlive()) {
                this.runningFlag.set(false);
            } else {
                this.setError(ERROR.ABORT, null);
            }
            try {
                URLConnectionAdapter lCurrentConnection = this.currentConnection;
                if (lCurrentConnection != null) {
                    lCurrentConnection.disconnect();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static enum ERROR {
        NONE,
        ABORT,
        REDIRECT,
        INVALID_CONTENT,
        INVALID_RESPONSE,
        RANGE,
        CONNECTING,
        DOWNLOADING,
        FLUSHING,
        NOT_ENOUGH_SPACE_ON_DISK;

    }
}

