/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jd.http.URLConnectionAdapter;
import jd.plugins.download.raf.ChunkRange;
import jd.plugins.download.raf.ChunkStrategy;
import jd.plugins.download.raf.HTTPChunk;
import jd.plugins.download.raf.HTTPDownloader;
import org.appwork.exceptions.WTFException;

public class MaxJumpStrategy
implements ChunkStrategy {
    private final HTTPDownloader downloadInterface;
    private final long maxJumpLength;
    private final long minChunkSplitSize;
    private final ArrayList<HTTPChunk> chunkHistory = new ArrayList();
    private boolean initialConnectionUsed = false;
    protected final Comparator<ChunkRange> unMarkedAreaOrderSorter = new Comparator<ChunkRange>(){

        @Override
        private int compare(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compare(ChunkRange o1, ChunkRange o2) {
            return this.compare(o1.getFrom(), o2.getFrom());
        }
    };
    protected final Comparator<ChunkRange> unMarkedAreaSizeSorter = new Comparator<ChunkRange>(){

        @Override
        private int compare(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compare(ChunkRange o1, ChunkRange o2) {
            return -this.compare(o1.getLength(), o2.getLength());
        }
    };

    public MaxJumpStrategy(HTTPDownloader downloadInterface, long maxJumpLength, long minChunkSplitSize) {
        this.downloadInterface = downloadInterface;
        this.maxJumpLength = maxJumpLength;
        this.minChunkSplitSize = minChunkSplitSize;
    }

    protected URLConnectionAdapter getInitialConnection(ChunkRange chunkRange) {
        if (this.initialConnectionUsed) {
            return null;
        }
        URLConnectionAdapter initialConnection = this.downloadInterface.getRequest().getHttpConnection();
        long[] initialRange = initialConnection.getRange();
        if (initialRange != null) {
            if (chunkRange.getFrom() == initialRange[0] && (chunkRange.getLength() >= 0L && chunkRange.getTo() == initialRange[1] || initialRange[2] == this.downloadInterface.getVerifiedFileSize())) {
                this.initialConnectionUsed = true;
                return initialConnection;
            }
        } else if (chunkRange.getFrom() == 0L && chunkRange.getLength() < 0L || chunkRange.getLength() >= 0L && chunkRange.getLength() == this.downloadInterface.getVerifiedFileSize()) {
            this.downloadInterface.getLogger().info("Reuse initialConnection for Chunk: " + chunkRange);
            this.initialConnectionUsed = true;
            return initialConnection;
        }
        return null;
    }

    protected int processFinishedChunks(List<HTTPChunk> finishedChunks) {
        int maxChunks = -1;
        for (HTTPChunk chunk : finishedChunks) {
            HTTPChunk.ERROR error = chunk.getError();
            switch (error) {
                case RANGE: 
                case INVALID_CONTENT: 
                case INVALID_RESPONSE: 
                case REDIRECT: {
                    this.downloadInterface.addError(error);
                    maxChunks = this.downloadInterface.setMaxChunksNum(this.downloadInterface.getActiveChunks());
                    break;
                }
                case CONNECTING: 
                case DOWNLOADING: {
                    this.downloadInterface.addError(error);
                    maxChunks = this.downloadInterface.setMaxChunksNum(this.downloadInterface.getActiveChunks());
                    break;
                }
                case ABORT: 
                case FLUSHING: 
                case NOT_ENOUGH_SPACE_ON_DISK: {
                    this.downloadInterface.addError(error);
                    break;
                }
            }
        }
        return maxChunks;
    }

    @Override
    public List<HTTPChunk> getNextChunks(List<HTTPChunk> finishedChunks) {
        int maxChunks = this.processFinishedChunks(finishedChunks);
        this.chunkHistory.addAll(finishedChunks);
        block3: for (HTTPChunk finishedChunk : finishedChunks) {
            switch (finishedChunk.getError()) {
                case NONE: {
                    ChunkRange chunkRange = finishedChunk.getChunkRange();
                    if (!chunkRange.isValidLoaded() || chunkRange.getTo() != null || chunkRange.getFrom() != 0L || chunkRange.getLoaded() < 0L || this.downloadInterface.getCacheMap().getFinalSize() >= 0L) continue block3;
                    this.downloadInterface.getLogger().info("Use contentLength from Chunk as finalFileSize: " + chunkRange);
                    this.downloadInterface.getCacheMap().setFinalSize(chunkRange.getLoaded());
                    continue block3;
                }
            }
            System.out.println(finishedChunk);
        }
        if (this.downloadInterface.getStateFlag().get() != HTTPDownloader.STATEFLAG.RUN) {
            return null;
        }
        if (this.downloadInterface.getActiveChunks() >= this.downloadInterface.getChunkNum()) {
            return null;
        }
        if (maxChunks == 0 && this.downloadInterface.getActiveChunks() == 0) {
            return null;
        }
        ArrayList<HTTPChunk> ret = new ArrayList<HTTPChunk>();
        List<ChunkRange> unMarkedAreas = this.getUnMarkedAreas();
        if (unMarkedAreas.size() > 0) {
            ChunkRange nextChunk;
            if (this.downloadInterface.tryRangeRequest()) {
                if (this.downloadInterface.getCacheMap().getFinalSize() >= 0L) {
                    long minChunkSize = 0xA00000L;
                    long chunkJumpPosition = 0L;
                    Collections.sort(unMarkedAreas, this.unMarkedAreaSizeSorter);
                    while (ret.size() == 0) {
                        boolean skipChunk = false;
                        for (ChunkRange unMarkedArea : unMarkedAreas) {
                            if (unMarkedArea.getFrom() > chunkJumpPosition) continue;
                            if (unMarkedArea.getLength() < 0L) {
                                throw new WTFException("FIXME: unknown length");
                            }
                            long chunkSize = Math.min(chunkJumpPosition + this.maxJumpLength, unMarkedArea.getLength());
                            ChunkRange nextChunk2 = null;
                            if (this.downloadInterface.getChunksInArea(unMarkedArea) > 0) {
                                long newChunkSize = chunkSize / 2L;
                                if (newChunkSize <= minChunkSize) {
                                    skipChunk = true;
                                    continue;
                                }
                                nextChunk2 = new ChunkRange(unMarkedArea.getFrom() + Math.min(this.maxJumpLength, newChunkSize), unMarkedArea.getTo());
                            } else {
                                nextChunk2 = unMarkedArea;
                            }
                            if (nextChunk2 == null) continue;
                            HTTPChunk chunk = new HTTPChunk(nextChunk2, this.getInitialConnection(nextChunk2), this.downloadInterface, this.downloadInterface.getDownloadable());
                            ret.add(chunk);
                            break;
                        }
                        if (!skipChunk || (chunkJumpPosition += this.maxJumpLength) < this.downloadInterface.getVerifiedFileSize()) continue;
                        minChunkSize = Math.max(this.minChunkSplitSize, minChunkSize / 2L);
                        chunkJumpPosition = 0L;
                        if (minChunkSize != this.minChunkSplitSize) continue;
                        break;
                    }
                } else if (this.downloadInterface.getActiveChunks() == 0) {
                    nextChunk = new ChunkRange(unMarkedAreas.get(0).getFrom(), null);
                    HTTPChunk chunk = new HTTPChunk(nextChunk, this.getInitialConnection(nextChunk), this.downloadInterface, this.downloadInterface.getDownloadable());
                    ret.add(chunk);
                }
            } else if (this.downloadInterface.getActiveChunks() == 0) {
                nextChunk = new ChunkRange(0L, null);
                HTTPChunk chunk = new HTTPChunk(nextChunk, this.getInitialConnection(nextChunk), this.downloadInterface, this.downloadInterface.getDownloadable());
                ret.add(chunk);
            }
        }
        return ret;
    }

    @Override
    public List<ChunkRange> getUnMarkedAreas() {
        ArrayList<ChunkRange> ret = new ArrayList<ChunkRange>();
        for (Long[] unMarkedArea : this.downloadInterface.getCacheMap().getUnMarkedAreas()) {
            ret.add(new ChunkRange(unMarkedArea[0], unMarkedArea[1]));
        }
        return ret;
    }
}

