/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.plugins.PluginException;
import jd.plugins.download.Downloadable;
import jd.plugins.download.raf.OldRAFDownload;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ReusableByteArrayOutputStream;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.throttledconnection.MeteredThrottledInputStream;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.translate._JDT;

public class RAFChunk
extends Thread {
    private static final String UNEXPECTED_RANGE_HEADER_FORMAT = "Unexpected Range Header Format";
    private static final String CHUNKLOAD_NOT_SUPPORTED = "Chunkload not supported";
    private static final String COULD_NOT_CLONE_CONNECTION = "Could Not Clone Connection";
    private static final String NETWORK_PROBLEMS = "Network Problems: ";
    private static final String NO_IO_PREMISSION_TO_WRITE_ON_HARDDRIVE = "No IOPremission to write on harddrive";
    private static final String TEMP_NOT_AVAILABLE = "Temp. not available";
    public static final long MIN_CHUNKSIZE = 102400L;
    private volatile long chunkBytesLoaded = 0L;
    private URLConnectionAdapter connection;
    private long endByte;
    private final int id;
    private MeteredThrottledInputStream inputStream;
    private volatile long startByte;
    private long bytes2Do = -1L;
    private AtomicBoolean connectionclosed = new AtomicBoolean(false);
    private long requestedEndByte;
    private OldRAFDownload dl;
    private Downloadable downloadable;
    private LogInterface logger;
    protected ReusableByteArrayOutputStream buffer = null;
    private AtomicBoolean running = new AtomicBoolean(false);
    private URLConnectionAdapter originalConnection;
    private boolean writeCompleteFlag = false;
    private boolean writeFlushFlag = false;

    public URLConnectionAdapter getOriginalConnection() {
        return this.originalConnection;
    }

    public URLConnectionAdapter getCurrentConnection() {
        return this.connection;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public RAFChunk(long startByte, long endByte, URLConnectionAdapter connection, OldRAFDownload dl, Downloadable link, int id) {
        super("DownloadChunkRAF:" + link.getName());
        this.running.set(true);
        this.startByte = startByte;
        this.id = id;
        this.endByte = endByte;
        this.requestedEndByte = endByte;
        this.originalConnection = connection;
        this.dl = dl;
        this.downloadable = link;
        this.logger = dl.getLogger();
        if (CrossSystem.isWindows()) {
            try {
                this.setPriority(7);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public int getMaximalSpeed() {
        return 0;
    }

    @Deprecated
    public void setMaximalSpeed(int i) {
    }

    public int getPercent() {
        return (int)(10000L * this.chunkBytesLoaded / Math.max(1L, Math.max(this.chunkBytesLoaded, this.endByte - this.startByte)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URLConnectionAdapter copyConnection(URLConnectionAdapter connection) {
        long start = this.startByte;
        String end = (this.endByte > 0L ? Long.valueOf(this.endByte + 1L) : "") + "";
        long[] connectionRange = connection.getRange();
        if (connectionRange == null && start == 0L) {
            this.logger.finer("Takeover connection(no range) for Start:" + this.startByte + "|End:" + this.endByte);
            return connection;
        }
        if (connectionRange != null && connectionRange[0] == start) {
            this.logger.finer("Takeover connection(" + Arrays.toString(connectionRange) + ") for Start:" + this.startByte + "|End:" + this.endByte);
            return connection;
        }
        try {
            this.downloadable.waitForNextConnectionAllowed();
        }
        catch (InterruptedException e1) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e1);
            return null;
        }
        try {
            Browser br = this.downloadable.getContextBrowser();
            boolean forwardReferer = br.getHeaders().contains("Referer");
            br.setReadTimeout(this.dl.getReadTimeout());
            br.setConnectTimeout(this.dl.getRequestTimeout());
            Map request = connection.getRequestProperties();
            if (request != null) {
                for (Map.Entry next : request.entrySet()) {
                    if (next.getValue() == null) continue;
                    String value = ((String)next.getValue()).toString();
                    br.getHeaders().put((String)next.getKey(), value);
                }
            }
            if (!forwardReferer) {
                br.setCurrentURL(null);
            }
            URLConnectionAdapter con = null;
            boolean returnConnection = false;
            try {
                URLConnectionAdapter uRLConnectionAdapter;
                if (connection.getRequestMethod() == HTTPConnection.RequestMethod.POST) {
                    if (StringUtils.isEmpty((String)end)) {
                        connection.getRequest().getHeaders().put("Range", "bytes=" + start + "-");
                    } else {
                        connection.getRequest().getHeaders().put("Range", "bytes=" + start + "-" + end);
                    }
                    con = br.openRequestConnection(connection.getRequest());
                } else {
                    if (StringUtils.isEmpty((String)end)) {
                        br.getHeaders().put("Range", "bytes=" + start + "-");
                    } else {
                        br.getHeaders().put("Range", "bytes=" + start + "-" + end);
                    }
                    con = br.openGetConnection(connection.getURL() + "");
                }
                if (!con.isOK()) {
                    if (con.getResponseCode() != 416) {
                        this.dl.error(new PluginException(512, "Server: " + con.getResponseMessage()));
                    } else {
                        this.logger.warning("HTTP 416, maybe finished last chunk?");
                    }
                    uRLConnectionAdapter = null;
                    return uRLConnectionAdapter;
                }
                if (con.getRequest().getLocation() != null) {
                    this.dl.error(new PluginException(512, "Server: Redirect"));
                    uRLConnectionAdapter = null;
                    return uRLConnectionAdapter;
                }
                returnConnection = true;
                uRLConnectionAdapter = con;
                return uRLConnectionAdapter;
            }
            finally {
                if (!returnConnection) {
                    try {
                        if (con != null) {
                            con.disconnect();
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Exception e) {
            this.dl.error(new PluginException(4, Exceptions.getStackTrace((Throwable)e)));
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download() {
        int flushLevel = 0;
        int flushTimeout = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getFlushBufferTimeout();
        try {
            int maxbuffersize = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getMaxBufferSize() * 1024;
            this.buffer = new ReusableByteArrayOutputStream(Math.max(maxbuffersize, 10240));
            flushLevel = Math.max(maxbuffersize / 100 * ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getFlushBufferLevel(), 1);
        }
        catch (Throwable e) {
            this.dl.error(new PluginException(131072, "OOM", e).localizedMessage(_JDT.T.download_error_message_outofmemory()));
            return;
        }
        if (this.endByte > 0L) {
            this.bytes2Do = this.endByte - this.startByte + 1L;
        }
        boolean remoteIO = false;
        try {
            if (this.connection == null) {
                throw new WTFException("connection null");
            }
            if (this.dl == null) {
                throw new WTFException("connection null");
            }
            this.connection.setReadTimeout(this.dl.getReadTimeout());
            this.connection.setConnectTimeout(this.dl.getRequestTimeout());
            this.inputStream = new MeteredThrottledInputStream(this.connection.getInputStream(), (SpeedMeterInterface)new AverageSpeedMeter(10)){

                public void close() throws IOException {
                }
            };
            this.dl.getManagedConnetionHandler().addThrottledConnection((ThrottledConnection)this.inputStream);
            int read = 0;
            boolean reachedEOF = false;
            long lastFlush = 0L;
            long bytesRead = 0L;
            long bytesWritten = 0L;
            while (!this.isExternalyAborted() && !this.connectionclosed.get()) {
                try {
                    lastFlush = Time.systemIndependentCurrentJVMTimeMillis();
                    while (!(reachedEOF || this.isExternalyAborted() || this.connectionclosed.get())) {
                        int bufLeft = this.buffer.free();
                        if (bufLeft == 0 || this.buffer.size() >= flushLevel) {
                            this.writeFlushFlag = true;
                            break;
                        }
                        if (this.endByte > 0L) {
                            remoteIO = true;
                            int readMaxNext = (int)Math.min(this.bytes2Do, (long)bufLeft);
                            long bytes2DoBf = this.bytes2Do;
                            if (this.bytes2Do > 0L && this.bytes2Do < 524288L) {
                                readMaxNext = this.bytes2Do < 32767L ? (int)Math.min(this.bytes2Do, 32L) : 512;
                                readMaxNext = Math.min(readMaxNext, bufLeft);
                            }
                            try {
                                read = this.inputStream.read(this.buffer.getInternalBuffer(), this.buffer.size(), readMaxNext);
                            }
                            catch (IOException e) {
                                this.logger.warning("Chunk(" + this.getID() + "):" + e.getMessage() + "|todo:" + this.bytes2Do + "|readMax" + readMaxNext);
                                throw e;
                            }
                            if (read > 0) {
                                this.bytes2Do -= (long)read;
                                if (this.bytes2Do == 0L) {
                                    this.logger.warning("reached artificial EOF");
                                    reachedEOF = true;
                                } else if (this.bytes2Do < 0L) {
                                    this.logger.warning("Chunk(" + this.getID() + "):WTF, where is EOF?!|todo:" + this.bytes2Do + "|todoBf:" + bytes2DoBf + "|readMax:" + readMaxNext);
                                    reachedEOF = true;
                                }
                            }
                        } else {
                            remoteIO = true;
                            read = this.inputStream.read(this.buffer.getInternalBuffer(), this.buffer.size(), bufLeft);
                        }
                        if (read > 0) {
                            bytesRead += (long)read;
                            this.dl.totalLinkBytesLoadedLive.getAndAdd(read);
                            this.buffer.increaseUsed(read);
                        } else if (read == -1) {
                            this.logger.warning("reached EOF");
                            reachedEOF = true;
                        } else {
                            RAFChunk readMaxNext = this;
                            synchronized (readMaxNext) {
                                this.wait(500L);
                            }
                        }
                        if (Time.systemIndependentCurrentJVMTimeMillis() - lastFlush <= (long)flushTimeout) continue;
                        this.writeFlushFlag = true;
                        break;
                    }
                }
                catch (NullPointerException e) {
                    LogSource.exception((LogInterface)this.logger, (Throwable)e);
                    throw e;
                }
                catch (IOException e4) {
                    LogSource.exception((LogInterface)this.logger, (Throwable)e4);
                    if (this.buffer.size() > 0) {
                        this.logger.warning("flush(exception):eof:" + reachedEOF + "|exClosed:" + this.isExternalyAborted() + "|conClosed:" + this.connectionclosed + "|read:" + bytesRead + "|toWrite:" + this.buffer.size() + "|written:" + bytesWritten);
                        try {
                            this.writeCompleteFlag = true;
                            long flush = this.dl.write(this);
                            if (flush > 0L) {
                                this.dl.addToTotalLinkBytesLoaded(flush, false);
                                bytesWritten += flush;
                            }
                            this.logger.warning("flushed(exception):eof:" + reachedEOF + "|exClosed:" + this.isExternalyAborted() + "|conClosed:" + this.connectionclosed + "|read:" + bytesRead + "|toWrite:" + this.buffer.size() + "|written:" + bytesWritten);
                        }
                        catch (Throwable throwable) {
                            LogSource.exception((LogInterface)this.logger, (Throwable)throwable);
                        }
                    }
                    if (this.isExternalyAborted() || this.connectionclosed.get()) break;
                    throw e4;
                }
                if (reachedEOF || this.isExternalyAborted() || this.connectionclosed.get()) {
                    if (this.buffer.size() > 0) {
                        this.logger.warning("flush(loop):eof:" + reachedEOF + "|exClosed:" + this.isExternalyAborted() + "|conClosed:" + this.connectionclosed + "|read:" + bytesRead + "|toWrite:" + this.buffer.size() + "|written:" + bytesWritten);
                        try {
                            this.writeCompleteFlag = true;
                            long flush = this.dl.write(this);
                            if (flush > 0L) {
                                this.dl.addToTotalLinkBytesLoaded(flush, false);
                                bytesWritten += flush;
                            }
                            this.logger.warning("flushed(loop):eof:" + reachedEOF + "|exClosed:" + this.isExternalyAborted() + "|conClosed:" + this.connectionclosed + "|read:" + bytesRead + "|toWrite:" + this.buffer.size() + "|written:" + bytesWritten);
                        }
                        catch (Throwable throwable) {
                            LogSource.exception((LogInterface)this.logger, (Throwable)throwable);
                        }
                    }
                    this.logger.warning("break(loop):eof:" + reachedEOF + "|exClosed:" + this.isExternalyAborted() + "|conClosed:" + this.connectionclosed + "|read:" + bytesRead + "|toWrite:" + this.buffer.size() + "|written:" + bytesWritten);
                    break;
                }
                if (this.buffer.size() > 0) {
                    remoteIO = false;
                    long flush = this.dl.write(this);
                    if (flush > 0L) {
                        this.dl.addToTotalLinkBytesLoaded(flush, false);
                        bytesWritten += flush;
                    }
                }
                if ((this.bytes2Do != 0L || this.endByte <= 0L) && (this.getCurrentBytesPosition() <= this.endByte || this.endByte <= 0L)) continue;
            }
            if (this.buffer.size() > 0) {
                this.logger.warning("flush(final):eof:" + reachedEOF + "|exClosed:" + this.isExternalyAborted() + "|conClosed:" + this.connectionclosed + "|read:" + bytesRead + "|toWrite:" + this.buffer.size() + "|written:" + bytesWritten);
                this.writeCompleteFlag = true;
                remoteIO = false;
                long flush = this.dl.write(this);
                if (flush > 0L) {
                    this.dl.addToTotalLinkBytesLoaded(flush, false);
                    bytesWritten += flush;
                }
                this.logger.warning("flushed(final):eof:" + reachedEOF + "|exClosed:" + this.isExternalyAborted() + "|conClosed:" + this.connectionclosed + "|read:" + bytesRead + "|toWrite:" + this.buffer.size() + "|written:" + bytesWritten);
            }
            this.logger.info("ExternalAbort: " + this.isExternalyAborted());
            long endPosition = this.endByte;
            if (endPosition < 0L) {
                endPosition = this.downloadable.getVerifiedFileSize();
            }
            if (endPosition >= 0L && this.getCurrentBytesPosition() < endPosition) {
                this.logger.warning("Download not finished. Loaded until now: " + this.getCurrentBytesPosition() + "/" + endPosition + " read:" + bytesRead + " written:" + bytesWritten + "|buffer:" + this.buffer.size());
                this.dl.error(new PluginException(512, "Download Incomplete").localizedMessage(_JDT.T.download_error_message_incomplete()));
            }
        }
        catch (FileNotFoundException e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            if (remoteIO) {
                this.dl.error(new PluginException(32, null));
            } else {
                this.dl.error(new PluginException(16384, NO_IO_PREMISSION_TO_WRITE_ON_HARDDRIVE, 2L).localizedMessage(_JDT.T.download_error_message_iopermissions()));
            }
        }
        catch (SecurityException e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            this.logger.severe("not enough rights to write the file. " + e.getLocalizedMessage());
            this.dl.error(new PluginException(16384, NO_IO_PREMISSION_TO_WRITE_ON_HARDDRIVE, 2L).localizedMessage(_JDT.T.download_error_message_iopermissions()));
        }
        catch (UnknownHostException e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            this.dl.error(new PluginException(2048, TEMP_NOT_AVAILABLE, 600000L).localizedMessage(_JDT.T.download_error_message_unavailable()));
        }
        catch (IOException e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            if (e.getMessage() != null && e.getMessage().contains("reset")) {
                this.logger.info("Connection reset: network problems!");
                this.dl.error(new PluginException(2048, NETWORK_PROBLEMS + e.getMessage(), 300000L).localizedMessage(_JDT.T.download_error_message_networkreset()));
            } else if (e.getMessage() != null && e.getMessage().indexOf("timed out") >= 0) {
                LogSource.exception((LogInterface)this.logger, (Throwable)e);
                this.logger.severe("Read timeout: network problems! (too many connections?, firewall/antivirus?)");
                this.dl.error(new PluginException(512, NETWORK_PROBLEMS + e.getMessage(), 1L).localizedMessage(_JDT.T.download_error_message_networkreset()));
            } else if (e instanceof SocketException) {
                this.logger.info("Socket Exception: network problems!");
                this.dl.error(new PluginException(2048, NETWORK_PROBLEMS + e.getMessage(), 300000L).localizedMessage(_JDT.T.download_error_message_networkreset()));
            } else {
                LogSource.exception((LogInterface)this.logger, (Throwable)e);
                if (e.getMessage() != null && e.getMessage().contains("503")) {
                    this.dl.error(new PluginException(2048, TEMP_NOT_AVAILABLE, 600000L).localizedMessage(_JDT.T.download_error_message_unavailable()));
                } else if (remoteIO) {
                    this.dl.error(new PluginException(512, NETWORK_PROBLEMS + e.getMessage(), 1L).localizedMessage(_JDT.T.download_error_message_networkreset()));
                } else {
                    this.logger.severe("error occurred while writing to file. " + e.getMessage());
                    this.dl.error(new PluginException(16384, NO_IO_PREMISSION_TO_WRITE_ON_HARDDRIVE, 2L).localizedMessage(_JDT.T.download_error_message_iopermissions()));
                }
            }
        }
        catch (Throwable e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            this.dl.error(new PluginException(4, Exceptions.getStackTrace((Throwable)e)));
        }
        finally {
            try {
                this.inputStream.setHandler(null);
                this.dl.getManagedConnetionHandler().removeThrottledConnection((ThrottledConnection)this.inputStream);
            }
            catch (Throwable e) {
            }
            finally {
                this.inputStream = null;
            }
            try {
                if (this.getOriginalConnection() != this.getCurrentConnection()) {
                    this.getCurrentConnection().disconnect();
                }
            }
            catch (Throwable e) {}
        }
    }

    public long getBytesLoaded() {
        return this.getCurrentBytesPosition() - this.startByte;
    }

    protected int write(DataOutput raf) throws IOException {
        int toWrite;
        int bufSize = this.buffer.size();
        if (bufSize == 0) {
            toWrite = 0;
        } else if (this.writeCompleteFlag || this.buffer.free() == 0) {
            toWrite = bufSize;
        } else {
            int allocationUnitSize = this.dl.getAllocationUnitSize();
            toWrite = bufSize - bufSize % allocationUnitSize;
            if (toWrite == 0 && this.writeFlushFlag) {
                while (allocationUnitSize > bufSize) {
                    allocationUnitSize /= 2;
                }
                if (allocationUnitSize > 0) {
                    toWrite = bufSize - bufSize % allocationUnitSize;
                }
                if (toWrite == 0) {
                    toWrite = bufSize;
                }
            }
        }
        this.writeFlushFlag = false;
        if (toWrite == 0) {
            return 0;
        }
        raf.write(this.buffer.getInternalBuffer(), 0, toWrite);
        if (toWrite == bufSize) {
            this.buffer.reset();
        } else {
            int remaining = bufSize - toWrite;
            byte[] buf = this.buffer.getInternalBuffer();
            System.arraycopy(buf, toWrite, buf, 0, remaining);
            this.buffer.setUsed(remaining);
        }
        this.chunkBytesLoaded += (long)toWrite;
        int chunkID = this.getID();
        if (chunkID >= 0) {
            long[] chunkProgress = this.downloadable.getChunksProgress();
            chunkProgress[chunkID] = this.getCurrentBytesPosition() - 1L;
            this.downloadable.setChunksProgress(chunkProgress);
        }
        return toWrite;
    }

    public long getChunkSize() {
        return this.endByte - this.startByte + 1L;
    }

    public long getCurrentBytesPosition() {
        return this.startByte + this.chunkBytesLoaded;
    }

    public long getEndByte() {
        return this.endByte;
    }

    public int getID() {
        return this.id;
    }

    public long getStartByte() {
        return this.startByte;
    }

    private boolean isExternalyAborted() {
        return this.dl != null && this.dl.externalDownloadStop() || this.downloadable.isInterrupted();
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        finally {
            this.running.set(false);
            this.dl.onChunkFinished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run0() {
        try {
            long end;
            long contentLength;
            block74: {
                long[] ContentRange;
                block75: {
                    block76: {
                        this.logger.finer("Start Chunk " + this.getID() + " : " + this.startByte + " - " + this.endByte);
                        long endCheck = this.endByte;
                        if (endCheck < 0L) {
                            endCheck = this.downloadable.getVerifiedFileSize();
                        }
                        if (this.startByte >= endCheck && endCheck >= 0L) {
                            return;
                        }
                        if (this.dl.getChunkNum() > 1) {
                            this.connection = this.copyConnection(this.getOriginalConnection());
                            if (this.connection == null) {
                                if (this.isExternalyAborted()) {
                                    this.logger.severe("ExternalyAborted: no copyConnection for " + this.getID());
                                    return;
                                }
                                if (this.startByte >= endCheck && endCheck >= 0L) {
                                    this.logger.finer("Is no error. Last chunk is just already finished");
                                    return;
                                }
                                this.dl.error(new PluginException(512, COULD_NOT_CLONE_CONNECTION).localizedMessage(_JDT.T.download_error_message_connectioncopyerror()));
                                this.logger.severe("ERROR Chunk (connection copy failed) " + this.getID());
                                return;
                            }
                        } else if (this.startByte > 0L) {
                            this.connection = this.copyConnection(this.getOriginalConnection());
                            if (this.connection == null && this.isExternalyAborted()) {
                                this.logger.severe("ExternalyAborted: no copyConnection for " + this.getID());
                                return;
                            }
                            if (this.startByte >= endCheck && endCheck >= 0L) {
                                this.logger.finer("Is no error. Last chunk is just already finished");
                                return;
                            }
                            if (this.connection == null) {
                                this.dl.error(new PluginException(512, COULD_NOT_CLONE_CONNECTION).localizedMessage(_JDT.T.download_error_message_connectioncopyerror()));
                                this.logger.severe("ERROR Chunk (connection copy failed) " + this.getID());
                                return;
                            }
                            if (this.startByte > 0L && (this.connection.getHeaderField("Content-Range") == null || this.connection.getHeaderField("Content-Range").length() == 0)) {
                                this.dl.error(new PluginException(512, CHUNKLOAD_NOT_SUPPORTED).localizedMessage(_JDT.T.download_error_message_rangeheaders()));
                                this.logger.severe("ERROR Chunk (no range header response)" + this.getID() + "\r\n" + this.connection.toString());
                                return;
                            }
                        } else {
                            this.connection = this.copyConnection(this.originalConnection);
                        }
                        ContentRange = this.connection.getRange();
                        contentLength = this.connection.getLongContentLength();
                        if (this.startByte < 0L) break block75;
                        if (ContentRange == null || ContentRange.length != 3) break block76;
                        if (this.endByte >= 0L && this.endByte != ContentRange[1]) {
                            this.logger.info("EndByte missmatch(1)! " + this.endByte + "!=" + ContentRange[1]);
                        }
                        this.endByte = ContentRange[1];
                        break block74;
                    }
                    if (this.dl.getChunkNum() > 1) {
                        if (contentLength == this.startByte) {
                            return;
                        }
                        if (!(ContentRange == null && this.startByte == 0L && contentLength == -1L || ContentRange == null && this.startByte == 0L && contentLength >= this.endByte)) {
                            this.logger.severe("ERROR Chunk (range header parse error)" + this.getID() + "\r\n" + this.connection.toString());
                            this.dl.error(new PluginException(512, UNEXPECTED_RANGE_HEADER_FORMAT).localizedMessage(_JDT.T.download_error_message_rangeheaderparseerror() + this.connection.getHeaderField("Content-Range")));
                            return;
                        }
                        break block74;
                    } else if (contentLength > 0L) {
                        end = contentLength - 1L;
                        if (this.endByte >= 0L && this.endByte != end) {
                            this.logger.info("EndByte missmatch(2)! " + this.endByte + "!=" + end);
                        }
                        this.endByte = end;
                        break block74;
                    } else {
                        this.logger.severe("no contentLength available, endByte remains " + this.endByte);
                    }
                    break block74;
                }
                if (ContentRange != null) {
                    this.logger.severe("No Range Request -> Content-Range Response?!");
                    if (this.endByte > 0L && this.endByte != ContentRange[1]) {
                        this.logger.info("EndByte missmatch! " + this.endByte + "!=" + ContentRange[1]);
                    }
                    this.endByte = ContentRange[1];
                }
            }
            if (this.connection.isContentDecoded()) {
                String encoding = this.connection.getHeaderField("Content-Encoding");
                if (this.startByte != 0L) {
                    this.dl.error(new PluginException(0x400000, "unsupported resume with content-encoding:" + encoding));
                    return;
                }
                this.logger.severe("reset endByte(-1) because connection is content decoded:" + encoding);
                this.endByte = -1L;
            } else if (this.endByte <= 0L) {
                if (contentLength > 0L) {
                    end = contentLength - 1L;
                    if (this.endByte >= 0L && this.endByte != end) {
                        this.logger.info("EndByte missmatch(3)! " + this.endByte + "!=" + end);
                    }
                    this.endByte = end;
                } else {
                    this.logger.severe("no contentLength available, endByte remains " + this.endByte);
                }
            }
            long cRequestedEndByte = this.requestedEndByte + 1L;
            if (cRequestedEndByte > 0L && this.endByte > cRequestedEndByte) {
                if (this.getID() == 0) {
                    this.logger.info("First Connection -> Content-Range(" + this.endByte + ") is larger than requested (" + cRequestedEndByte + ")! Truncate it");
                } else {
                    this.logger.info(this.getID() + ". Connection -> Content-Range(" + this.endByte + ") is larger than requested (" + cRequestedEndByte + ")! Truncate it");
                }
                this.endByte = cRequestedEndByte;
            }
            this.download();
            this.logger.finer("Chunk finished " + this.getID() + " " + this.getBytesLoaded() + " bytes");
            return;
        }
        finally {
            try {
                if (this.getOriginalConnection() != this.getCurrentConnection()) {
                    this.getCurrentConnection().disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void setLoaded(long loaded) {
        loaded = Math.max(0L, loaded);
        this.dl.addToTotalLinkBytesLoaded(loaded, true);
    }

    public void startChunk() {
        this.start();
    }

    public void closeConnections() {
        this.connectionclosed.set(true);
        if (!Thread.currentThread().isAlive()) {
            this.running.set(false);
        }
        super.interrupt();
        try {
            this.inputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.getCurrentConnection().disconnect();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.originalConnection = null;
        }
        try {
            this.getOriginalConnection().disconnect();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.connection = null;
        }
    }

    public MeteredThrottledInputStream getInputStream() {
        return this.inputStream;
    }
}

