/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jd.SecondLevelLaunch;
import jd.nutils.Executer;
import jd.nutils.Formatter;
import jd.nutils.io.JDIO;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.utils.Application;
import org.appwork.utils.XML;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.translate._JDT;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JDUtilities {
    private static File JD_HOME = null;
    private static String REVISION;
    private static long REVISIONINT;
    private static Boolean oldDBExists;

    public static String getJACMethodsDirectory() {
        return "jd/captcha/methods/";
    }

    public static File getJDHomeDirectoryFromEnvironment() {
        if (JD_HOME != null) {
            return JD_HOME;
        }
        URL ressource = JDUtilities.class.getClassLoader().getResource(SecondLevelLaunch.class.getName().replace(".", "/") + ".class");
        if (ressource != null) {
            File root = new File(Application.getRoot(SecondLevelLaunch.class));
            if (!root.isDirectory()) {
                FileCreationManager.getInstance().mkdir(root);
            }
            JD_HOME = root;
            return JD_HOME;
        }
        throw new NullPointerException(SecondLevelLaunch.class.getName() + "not found");
    }

    public static String getJDTitle(int waitingupdates) {
        StringBuilder ret = new StringBuilder("JDownloader");
        if (waitingupdates > 0) {
            ret.append(new char[]{' ', '('});
            ret.append(_JDT.T.gui_mainframe_title_updatemessage2(waitingupdates));
            ret.append(')');
        }
        return ret.toString();
    }

    @Deprecated
    public static PluginForDecrypt getPluginForDecrypt(String host) {
        LazyCrawlerPlugin l = CrawlerPluginController.getInstance().get(host);
        if (l != null) {
            try {
                return l.getPrototype(PluginClassLoader.getThreadPluginClassLoaderChild());
            }
            catch (UpdateRequiredClassNotFoundException e) {
                LogController.CL().log((Throwable)e);
            }
        }
        return null;
    }

    @Deprecated
    public static PluginForHost getPluginForHost(String host) {
        LazyHostPlugin lplugin = HostPluginController.getInstance().get(host);
        if (lplugin != null) {
            try {
                return lplugin.getPrototype(PluginClassLoader.getThreadPluginClassLoaderChild());
            }
            catch (UpdateRequiredClassNotFoundException e) {
                LogController.CL().log((Throwable)e);
            }
        }
        return null;
    }

    @Deprecated
    public static PluginForHost getNewPluginForHostInstance(String host) {
        LazyHostPlugin lplugin = HostPluginController.getInstance().get(host);
        if (lplugin != null) {
            try {
                return lplugin.newInstance(PluginClassLoader.getThreadPluginClassLoaderChild());
            }
            catch (UpdateRequiredClassNotFoundException e) {
                LogController.CL().log((Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public static String getRevision() {
        return REVISION != null ? REVISION : (REVISION = JDUtilities.getRevisionNumber() + "");
    }

    @Deprecated
    public static long getRevisionNumber() {
        if (REVISIONINT != -1L) {
            return REVISIONINT;
        }
        int rev = -1;
        try {
            rev = Formatter.filterInt((String)JDIO.readFileToString((File)JDUtilities.getResourceFile("config/version.cfg")));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        long rev2 = Formatter.getRevision((String)"$Revision: 48637 $");
        REVISIONINT = Math.max(rev2, (long)rev);
        return REVISIONINT;
    }

    @Deprecated
    public static File getResourceFile(String resource) {
        if (resource.startsWith("tmp/")) {
            return Application.getTempResource((String)resource.substring(4));
        }
        return Application.getResource((String)resource);
    }

    public static File getResourceFile(String resource, boolean mkdirs) {
        File f = JDUtilities.getResourceFile(resource);
        if (f != null) {
            File f2;
            if (mkdirs && (f2 = f.getParentFile()) != null && !f2.exists()) {
                FileCreationManager.getInstance().mkdir(f2);
            }
            return f;
        }
        return null;
    }

    public static String runCommand(String command, String[] parameter, String runIn, int waitForReturn) {
        Executer exec = new Executer(command);
        exec.addParameters(parameter);
        exec.setRunin(runIn);
        exec.setWaitTimeout(waitForReturn);
        exec.start();
        exec.waitTimeout();
        return exec.getOutputStream() + " \r\n " + exec.getErrorStream();
    }

    public static Document parseXmlString(String xmlString) {
        if (xmlString == null) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = XML.newSecureFactory();
            InputSource inSource = new InputSource(new StringReader(xmlString));
            Document doc = factory.newDocumentBuilder().parse(inSource);
            return doc;
        }
        catch (Exception e) {
            LogController.CL().severe(xmlString);
            LogController.CL().log((Throwable)e);
            return null;
        }
    }

    public static String createXmlString(Document doc) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Throwable e) {
            LogController.CL().log(e);
            return null;
        }
    }

    public static String getAttribute(Node childNode, String key) {
        NamedNodeMap att = childNode.getAttributes();
        if (att == null || att.getNamedItem(key) == null) {
            return null;
        }
        return att.getNamedItem(key).getNodeValue();
    }

    static {
        REVISIONINT = -1L;
        oldDBExists = null;
    }
}

