/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader;

import java.awt.Component;
import java.awt.Graphics;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.Icon;
import jd.config.Property;
import jd.controlling.faviconcontroller.FavIconRequestor;
import jd.controlling.faviconcontroller.FavIcons;
import jd.http.Browser;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import org.appwork.swing.components.IDIcon;
import org.appwork.swing.components.IconIdentifier;
import org.appwork.utils.DebugMode;
import org.appwork.utils.images.IconIO;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;

public class DomainInfo
implements FavIconRequestor,
Comparable<DomainInfo>,
Icon,
IDIcon {
    private static final HashMap<String, String> HARDCODEDFAVICONS = new HashMap();
    private static final HashMap<String, WeakReference<DomainInfo>> CACHE = new HashMap();
    private static final int HEIGHT = 16;
    private static final int WIDTH = 16;
    private final String domain;
    private final IconIdentifier iconIdentifier;
    private final String tld;
    private String name = null;
    protected Icon hosterIcon = null;
    protected boolean hosterIconUpdatePermission = false;

    public DomainInfo(String tld, String domain) {
        this.tld = Property.dedupeString(tld);
        this.domain = domain == null || domain.equals(tld) ? tld : Property.dedupeString(domain);
        this.iconIdentifier = new IconIdentifier("DomainInfo", domain);
    }

    private static String getCacheID(String domain) {
        String ret = domain.toLowerCase(Locale.ENGLISH);
        int index = ret.indexOf(" ");
        if (index > 0) {
            ret = ret.substring(0, index);
        }
        if ((index = ret.indexOf("/")) > 0) {
            ret = ret.substring(0, index);
        }
        return ret;
    }

    public static DomainInfo getInstance(String domain) {
        return DomainInfo.getInstance(domain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DomainInfo getInstance(String domain, DomainInfoFactory builder) {
        if (domain == null) {
            return null;
        }
        String lcaseTld = DomainInfo.getCacheID(domain);
        HashMap<String, WeakReference<DomainInfo>> hashMap = CACHE;
        synchronized (hashMap) {
            DomainInfo ret = null;
            WeakReference<DomainInfo> domainInfo = CACHE.get(lcaseTld);
            if (domainInfo == null || (ret = (DomainInfo)domainInfo.get()) == null) {
                String host = Browser.getHost((String)lcaseTld, (boolean)true);
                if (builder != null) {
                    ret = builder.createDomainInfo(host, lcaseTld);
                }
                if (ret == null) {
                    ret = new DomainInfo(host, lcaseTld);
                }
                CACHE.put(lcaseTld, new WeakReference<DomainInfo>(ret));
            }
            return ret;
        }
    }

    @Override
    public int compareTo(DomainInfo o) {
        return this.getTld().compareTo(o.getTld());
    }

    @Deprecated
    public PluginForHost findPlugin() {
        return JDUtilities.getPluginForHost(this.getTld());
    }

    public String getDomain() {
        return this.domain;
    }

    public Icon getFavIcon() {
        return this.getFavIcon(true);
    }

    public Icon getFavIcon(boolean updatePermission) {
        return this.getFavIcon(this, 16, 16, updatePermission);
    }

    public Icon getIcon(int size) {
        return this.getIcon(size, true);
    }

    public Icon getIcon(int size, boolean updatePermission) {
        return this.getIcon(null, size, size, updatePermission);
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    public IconIdentifier getIdentifier() {
        return this.iconIdentifier;
    }

    public String getTld() {
        return this.tld;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getFavIcon().paintIcon(c, g, x, y);
    }

    @Override
    public Icon setFavIcon(Icon icon) {
        if (icon == null) {
            icon = this.getFavIcon(true);
        }
        this.setHosterIcon(icon, true);
        return icon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name != null ? this.name : this.domain;
    }

    public String toString() {
        return this.tld;
    }

    protected Icon getFavIcon(FavIconRequestor requestor, int width, int height, boolean updatePermission) {
        boolean hasHosterIcon;
        if (!updatePermission && "linkcrawlerretry".equals(this.getDomain())) {
            updatePermission = true;
        }
        updatePermission = updatePermission || DebugMode.TRUE_IN_IDE_ELSE_FALSE;
        Icon ret = this.getHosterIcon();
        boolean bl = hasHosterIcon = ret != null;
        if (ret == null || !this.hosterIconUpdatePermission && updatePermission) {
            String hardcodedFavIcon = HARDCODEDFAVICONS.get(this.domain);
            if (hardcodedFavIcon != null) {
                ret = NewTheme.I().getIcon(hardcodedFavIcon, -1);
            } else {
                ret = FavIcons.getFavIcon(this.domain, requestor, updatePermission);
                if (ret == null && !updatePermission) {
                    ret = FavIcons.getDefaultIcon(this.domain, false);
                }
            }
        }
        if (ret != null) {
            ret = IconIO.getScaledInstance((Icon)ret, (int)width, (int)height);
        }
        if (updatePermission || !hasHosterIcon) {
            this.setHosterIcon(ret, updatePermission);
        }
        return ret;
    }

    protected Icon getHosterIcon() {
        return this.hosterIcon;
    }

    protected Icon getIcon(FavIconRequestor requestor, int width, int height, boolean updatePermission) {
        Icon ret = null;
        NewTheme theme = NewTheme.I();
        if (theme.hasIcon("fav/big." + this.domain)) {
            ret = new AbstractIcon("fav/big." + this.domain, -1);
        }
        if (ret == null && theme.hasIcon("fav/" + this.domain)) {
            ret = new AbstractIcon("fav/" + this.domain, -1);
        }
        if (ret != null && ret.getIconHeight() >= height && ret.getIconWidth() >= width) {
            return IconIO.getScaledInstance((Icon)ret, (int)width, (int)height);
        }
        return this.getFavIcon(requestor, width, height, updatePermission);
    }

    protected void setHosterIcon(Icon icon, boolean updatePermission) {
        if (icon != null && icon != this.hosterIcon) {
            int height;
            int width;
            Icon hosterIcon = this.hosterIcon;
            if (hosterIcon != null) {
                width = hosterIcon.getIconWidth();
                height = hosterIcon.getIconHeight();
            } else {
                width = 16;
                height = 16;
            }
            icon = IconIO.getScaledInstance((Icon)icon, (int)width, (int)height);
        }
        this.hosterIcon = icon;
        this.hosterIconUpdatePermission = icon != null && (this.hosterIconUpdatePermission || updatePermission);
    }

    static {
        HARDCODEDFAVICONS.put("http", "url");
        HARDCODEDFAVICONS.put("ftp", "url");
        HARDCODEDFAVICONS.put("filesystem", "harddisk");
        HARDCODEDFAVICONS.put("directhttp", "url");
        HARDCODEDFAVICONS.put("f4m", "url");
        HARDCODEDFAVICONS.put("m3u8", "url");
        HARDCODEDFAVICONS.put("updaterequired", "url");
        HARDCODEDFAVICONS.put("cloudcache", "url");
        HARDCODEDFAVICONS.put("usenet", "logo/nzb");
        HARDCODEDFAVICONS.put("genericusenet", "logo/nzb");
        HARDCODEDFAVICONS.put("captcha_type_image", "image");
    }

    public static interface DomainInfoFactory {
        public DomainInfo createDomainInfo(String var1, String var2);
    }
}

