/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jd.nutils.DiffMatchPatch;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.DefaultDocsPageFactory;
import org.appwork.remoteapi.InterfaceHandler;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.RemoteAPIInterface;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.SessionRemoteAPI;
import org.appwork.remoteapi.SessionRemoteAPIRequest;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.remoteapi.annotations.ApiNamespace;
import org.appwork.remoteapi.events.EventObject;
import org.appwork.remoteapi.events.EventPublisher;
import org.appwork.remoteapi.events.EventsAPI;
import org.appwork.remoteapi.events.EventsAPIInterface;
import org.appwork.remoteapi.events.Subscriber;
import org.appwork.remoteapi.events.json.EventObjectStorable;
import org.appwork.remoteapi.exceptions.APIFileNotFoundException;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIOHandlerInterface;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.handler.HttpSessionRequestHandler;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.net.websocket.ReadWebSocketFrame;
import org.appwork.utils.net.websocket.WebSocketEndPoint;
import org.appwork.utils.net.websocket.WebSocketFrame;
import org.appwork.utils.net.websocket.WebSocketFrameHeader;
import org.appwork.utils.net.websocket.WriteWebSocketFrame;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.api.DeprecatedAPIHttpServerController;
import org.jdownloader.api.DeprecatedAPIRequestInterface;
import org.jdownloader.api.DeprecatedRemoteAPIRequest;
import org.jdownloader.api.DocsPageFactoryImpl;
import org.jdownloader.api.MyJDRemoteAPIRequest;
import org.jdownloader.api.MyJDRmoteAPIResponse;
import org.jdownloader.api.RemoteAPIConfig;
import org.jdownloader.api.RemoteAPISession;
import org.jdownloader.api.RemoteAPISessionControllerImp;
import org.jdownloader.api.UpdateAPIImpl;
import org.jdownloader.api.accounts.AccountAPIImpl;
import org.jdownloader.api.accounts.v2.AccountAPIImplV2;
import org.jdownloader.api.captcha.CaptchaAPISolver;
import org.jdownloader.api.cnl2.ExternInterfaceImpl;
import org.jdownloader.api.config.AdvancedConfigManagerAPIImpl;
import org.jdownloader.api.content.ContentAPIImpl;
import org.jdownloader.api.content.v2.ContentAPIImplV2;
import org.jdownloader.api.device.DeviceAPIImpl;
import org.jdownloader.api.dialog.RemoteAPIIOHandlerWrapper;
import org.jdownloader.api.downloads.DownloadControllerEventPublisher;
import org.jdownloader.api.downloads.DownloadWatchDogEventPublisher;
import org.jdownloader.api.downloads.DownloadsAPIImpl;
import org.jdownloader.api.downloads.v2.DownloadWatchdogAPIImpl;
import org.jdownloader.api.downloads.v2.DownloadsAPIV2Impl;
import org.jdownloader.api.extensions.ExtensionsAPIImpl;
import org.jdownloader.api.extraction.ExtractionAPIImpl;
import org.jdownloader.api.jd.JDAPIImpl;
import org.jdownloader.api.jdanywhere.JDAnywhereAPI;
import org.jdownloader.api.linkcollector.LinkCollectorAPIImpl;
import org.jdownloader.api.linkcollector.LinkCollectorEventPublisher;
import org.jdownloader.api.linkcollector.v2.LinkCollectorAPIImplV2;
import org.jdownloader.api.linkcrawler.LinkCrawlerAPIImpl;
import org.jdownloader.api.linkcrawler.LinkCrawlerEventPublisher;
import org.jdownloader.api.logs.LogAPIImpl;
import org.jdownloader.api.myjdownloader.MyJDownloaderHttpConnection;
import org.jdownloader.api.myjdownloader.MyJDownloaderPostRequest;
import org.jdownloader.api.myjdownloader.MyJDownloaderRequestInterface;
import org.jdownloader.api.plugins.PluginsAPIImpl;
import org.jdownloader.api.polling.PollingAPIImpl;
import org.jdownloader.api.reconnect.ReconnectAPIImpl;
import org.jdownloader.api.system.SystemAPIImpl;
import org.jdownloader.api.toolbar.JDownloaderToolBarAPIImpl;
import org.jdownloader.api.ui.UIAPIImpl;
import org.jdownloader.api.useragent.UserAgentController;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.AbstractMyJDClient;
import org.jdownloader.myjdownloader.client.bindings.ClientApiNameSpace;
import org.jdownloader.myjdownloader.client.bindings.events.json.MyJDEvent;
import org.jdownloader.myjdownloader.client.bindings.interfaces.EventsInterface;
import org.jdownloader.myjdownloader.client.bindings.interfaces.Linkable;
import org.jdownloader.myjdownloader.client.json.AbstractJsonData;
import org.jdownloader.myjdownloader.client.json.JSonRequest;
import org.jdownloader.myjdownloader.client.json.ObjectData;

public class RemoteAPIController {
    private static RemoteAPIController INSTANCE = new RemoteAPIController();
    private final boolean isJared = Application.isJared(RemoteAPIController.class);
    private final SessionRemoteAPI<RemoteAPISession> rapi;
    private RemoteAPISessionControllerImp sessionc = null;
    private EventsAPI eventsapi;
    private final LogSource logger;
    private AdvancedConfigManagerAPIImpl advancedConfigAPI;
    private ContentAPIImplV2 contentAPI;
    private DownloadsAPIV2Impl downloadsAPIV2;
    private LinkCollectorAPIImplV2 linkcollector;
    private final UserAgentController uaController;
    private final Map<String, RidHistory> ridHistory = new HashMap<String, RidHistory>();

    public static RemoteAPIController getInstance() {
        return INSTANCE;
    }

    private RemoteAPIController() {
        this.uaController = new UserAgentController();
        this.logger = LogController.getInstance().getLogger(RemoteAPIController.class.getName());
        this.rapi = new SessionRemoteAPI<RemoteAPISession>(){

            protected void _handleRemoteAPICall(RemoteAPIRequest request, RemoteAPIResponse response) throws BasicRemoteAPIException {
                RemoteAPIController.this.uaController.handle(request);
                super._handleRemoteAPICall(request, response);
            }

            protected DefaultDocsPageFactory createHelpBuilder() throws NoSuchMethodException {
                return new DocsPageFactoryImpl(this);
            }

            public String toString(RemoteAPIRequest request, RemoteAPIResponse response, Object responseData) {
                if (((SessionRemoteAPIRequest)request).getApiRequest() instanceof DeprecatedRemoteAPIRequest) {
                    return JSonStorage.serializeToJson((Object)responseData);
                }
                MyJDownloaderRequestInterface ri = ((MyJDRemoteAPIRequest)((SessionRemoteAPIRequest)request).getApiRequest()).getRequest();
                if (responseData instanceof List && ((List)responseData).size() > 0 && ((List)responseData).get(0) instanceof EventObjectStorable) {
                    if (ri.getApiVersion() <= 0) {
                        return JSonStorage.serializeToJson((Object)responseData);
                    }
                    ArrayList<MyJDownloaderEvent> newResponse = new ArrayList<MyJDownloaderEvent>();
                    for (Object o : (List)responseData) {
                        MyJDownloaderEvent ret = new MyJDownloaderEvent();
                        ret.setEventData(((EventObjectStorable)o).getEventdata());
                        ret.setEventid(((EventObjectStorable)o).getEventid());
                        ret.setPublisher(((EventObjectStorable)o).getPublisher());
                        newResponse.add(ret);
                    }
                    responseData = newResponse;
                }
                if (ri.getApiVersion() > 0) {
                    return JSonStorage.serializeToJson((Object)responseData);
                }
                return super.toString(request, response, (Object)responseData);
            }

            public void sendText(RemoteAPIRequest request, RemoteAPIResponse response, String text) throws UnsupportedEncodingException, IOException {
                block19: {
                    try {
                        LogSource logger;
                        if (request.getHttpRequest() instanceof MyJDownloaderRequestInterface) {
                            MyJDownloaderHttpConnection myJDownloaderConnection = ((MyJDownloaderRequestInterface)request.getHttpRequest()).getConnection();
                            logger = myJDownloaderConnection.getLogger();
                        } else {
                            logger = RemoteAPIController.this.logger;
                        }
                        if (!RemoteAPIController.this.isJared) {
                            logger.info("\r\n===========API Call Result:==============\r\n" + request.toString() + "\r\nResponse:\r\n" + text + "\r\n=========================================");
                        }
                        if (request instanceof SessionRemoteAPIRequest) {
                            if (((SessionRemoteAPIRequest)request).getApiRequest() instanceof DeprecatedRemoteAPIRequest) {
                                super.sendText(request, response, JSonStorage.serializeToJson((Object)new ObjectData(JSonStorage.restoreFromString((String)text, (TypeRef)new TypeRef<Object>(){}, null), -1L)));
                                return;
                            }
                            MyJDownloaderRequestInterface ri = ((MyJDRemoteAPIRequest)((SessionRemoteAPIRequest)request).getApiRequest()).getRequest();
                            if (ri.getApiVersion() > 0) {
                                long dka = ri.getDiffKeepAlive();
                                String type = ri.getDiffType();
                                if (dka > 0L && type != null) {
                                    File tmp;
                                    String diffID = ri.getDiffID();
                                    String old = null;
                                    if (StringUtils.isNotEmpty((String)diffID) && (tmp = Application.getTempResource((String)("apidiffs/" + ri.getDiffID() + ".dat"))).exists()) {
                                        old = IO.readFileToString((File)tmp);
                                    }
                                    tmp = Application.getTempResource((String)("apidiffs/" + Hash.getMD5((String)text) + ".dat"));
                                    IO.secureWrite((File)tmp, (byte[])text.getBytes("UTF-8"));
                                    if (old == null) {
                                        ObjectData od = new ObjectData(text, ri.getRid());
                                        od.setDiffID(Hash.getMD5((String)text));
                                        super.sendText(request, response, JSonStorage.serializeToJson((Object)od));
                                    } else if ("patch".equalsIgnoreCase(type)) {
                                        DiffMatchPatch differ = new DiffMatchPatch();
                                        LinkedList diff = differ.diffMain(old, text);
                                        differ.diffEditCost = (short)10;
                                        differ.diffCleanupEfficiency(diff);
                                        LinkedList patches = differ.patchMake(diff);
                                        String md5 = Hash.getMD5((String)text);
                                        String difftext = differ.patchToText((List)patches);
                                        if (difftext.length() >= text.length()) {
                                            ObjectData od = new ObjectData(text, ri.getRid());
                                            od.setDiffID(Hash.getMD5((String)text));
                                            super.sendText(request, response, JSonStorage.serializeToJson((Object)od));
                                        } else {
                                            ObjectData od = new ObjectData(difftext, ri.getRid());
                                            od.setDiffID(md5);
                                            od.setDiffType("patch");
                                            super.sendText(request, response, JSonStorage.serializeToJson((Object)od));
                                        }
                                    } else {
                                        ObjectData od = new ObjectData(text, ri.getRid());
                                        od.setDiffID(Hash.getMD5((String)text));
                                        super.sendText(request, response, JSonStorage.serializeToJson((Object)od));
                                    }
                                } else {
                                    Object object = JSonStorage.restoreFromString((String)text, (TypeRef)new TypeRef<Object>(){});
                                    ObjectData od = new ObjectData(object, ri.getRid());
                                    String json = JSonStorage.serializeToJson((Object)od);
                                    json = json.replaceFirst("\"data\":", "\"data\" :");
                                    if (!RemoteAPIController.this.isJared) {
                                        logger.info("\r\n===========API Call Result:==============\r\n" + request.toString() + "\r\nObjectData:\r\n" + json + "\r\n=========================================");
                                    }
                                    super.sendText(request, response, json);
                                }
                            } else {
                                super.sendText(request, response, text);
                            }
                            break block19;
                        }
                        throw new WTFException();
                    }
                    catch (Throwable e) {
                        throw new WTFException(e);
                    }
                }
            }

            protected RemoteAPIResponse createRemoteAPIResponseObject(RemoteAPIRequest request, HttpResponse response) {
                MyJDRmoteAPIResponse ret = new MyJDRmoteAPIResponse(response, (RemoteAPI)this);
                return ret;
            }

            public RemoteAPIRequest createRemoteAPIRequestObject(HttpRequest request, Object extractedData, String methodName, InterfaceHandler<?> interfaceHandler, RemoteAPI.ParsedParameters parsedParameters) throws IOException, BasicRemoteAPIException {
                if (request instanceof DeprecatedAPIRequestInterface) {
                    return new DeprecatedRemoteAPIRequest(interfaceHandler, methodName, parsedParameters.parameters.toArray(new String[0]), (DeprecatedAPIRequestInterface)request, parsedParameters.jqueryCallback);
                }
                return new MyJDRemoteAPIRequest(interfaceHandler, methodName, parsedParameters.parameters.toArray(new String[0]), (MyJDownloaderRequestInterface)request);
            }

            protected void validateRequest(HttpRequest request) throws BasicRemoteAPIException {
                super.validateRequest(request);
                if (request instanceof DeprecatedAPIRequestInterface) {
                    return;
                }
                if (request instanceof MyJDownloaderPostRequest) {
                    try {
                        JSonRequest jsonRequest = ((MyJDownloaderPostRequest)request).getJsonRequest();
                        if (jsonRequest == null) {
                            throw new BasicRemoteAPIException("no JSONRequest", HTTPConstants.ResponseCode.ERROR_BAD_REQUEST);
                        }
                        if (!RemoteAPIController.this.isJared) {
                            // empty if block
                        }
                        if (StringUtils.isEmpty((String)jsonRequest.getUrl())) {
                            throw new BasicRemoteAPIException("JSonRequest URL is empty", HTTPConstants.ResponseCode.ERROR_BAD_REQUEST);
                        }
                        if (!StringUtils.equals((String)request.getRequestedURL(), (String)jsonRequest.getUrl())) {
                            throw new BasicRemoteAPIException("JSonRequest URL=" + jsonRequest.getUrl() + " does not match " + request.getRequestedURL(), HTTPConstants.ResponseCode.ERROR_BAD_REQUEST);
                        }
                        if (!RemoteAPIController.this.validateRID(jsonRequest.getRid(), ((MyJDownloaderPostRequest)request).getRequestConnectToken())) {
                            throw new BasicRemoteAPIException("JSonRequest URL=" + jsonRequest.getUrl() + " has duplicated RID=" + jsonRequest.getRid(), HTTPConstants.ResponseCode.ERROR_BAD_REQUEST);
                        }
                    }
                    catch (IOException e) {
                        throw new BasicRemoteAPIException(e);
                    }
                }
                MyJDownloaderRequestInterface ri = (MyJDownloaderRequestInterface)request;
                try {
                    if (!RemoteAPIController.this.validateRID(ri.getRid(), ri.getRequestConnectToken())) {
                        throw new BasicRemoteAPIException("JSonRequest URL=" + request.getRequestedURL() + " has duplicated RID=" + ri.getRid(), HTTPConstants.ResponseCode.ERROR_BAD_REQUEST);
                    }
                }
                catch (IOException e) {
                    throw new BasicRemoteAPIException((Throwable)e, e.getMessage(), HTTPConstants.ResponseCode.SERVERERROR_INTERNAL, null);
                }
            }

            protected void validateRequest(RemoteAPIRequest ret) throws BasicRemoteAPIException {
                super.validateRequest(ret);
            }
        };
        this.sessionc = new RemoteAPISessionControllerImp();
        try {
            this.sessionc.registerSessionRequestHandler((HttpSessionRequestHandler)this.rapi);
            this.rapi.register((RemoteAPIInterface)this.sessionc);
            RemoteAPIConfig remoteAPIConfig = (RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class);
            if (remoteAPIConfig.isDeprecatedApiEnabled()) {
                DeprecatedAPIHttpServerController.getInstance().registerRequestHandler(remoteAPIConfig.getDeprecatedApiPort(), remoteAPIConfig.isDeprecatedApiLocalhostOnly(), (HttpRequestHandler)this.sessionc);
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        this.eventsapi = new EventsAPI(){

            public void listen(RemoteAPIRequest request, RemoteAPIResponse response, long subscriptionid) throws APIFileNotFoundException, InternalApiException {
                Subscriber subscriber = this.getSubscriber(subscriptionid);
                if (subscriber == null) {
                    throw new APIFileNotFoundException();
                }
                if (!this.wrapWebSocket(request, response, subscriber)) {
                    super.listen(request, response, subscriptionid);
                }
            }

            private boolean wrapWebSocket(RemoteAPIRequest request, RemoteAPIResponse response, Subscriber subscriber) throws InternalApiException {
                String upgradeHeader = request.getRequestHeaders().getValue("Upgrade");
                String connectionHeader = request.getRequestHeaders().getValue("Connection");
                String secWebSocketKey = request.getRequestHeaders().getValue("Sec-WebSocket-Key");
                if (StringUtils.isNotEmpty((String)secWebSocketKey) && StringUtils.equalsIgnoreCase((String)upgradeHeader, (String)"websocket") && StringUtils.containsIgnoreCase((String)connectionHeader, (String)"upgrade")) {
                    block16: {
                        response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SWITCHING_PROTOCOLS);
                        response.getResponseHeaders().add(new HTTPHeader("Connection", "Upgrade"));
                        response.getResponseHeaders().add(new HTTPHeader("Upgrade", "websocket"));
                        try {
                            MessageDigest md = MessageDigest.getInstance("SHA1");
                            byte[] digest = md.digest((secWebSocketKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes("UTF-8"));
                            response.getResponseHeaders().add(new HTTPHeader("Sec-WebSocket-Accept", Base64.encodeToString((byte[])digest, (boolean)false)));
                            final OutputStream outputStream = response.getOutputStream(true);
                            final InputStream is = request.getHttpRequest().getConnection().getInputStream();
                            WebSocketEndPoint wsc = new WebSocketEndPoint(){

                                public ReadWebSocketFrame readWebSocketFrame(InputStream is2) throws IOException {
                                    if (is2.available() > 0) {
                                        return super.readWebSocketFrame(is2);
                                    }
                                    return null;
                                }

                                protected void log(WebSocketFrame webSocketFrame) {
                                }

                                protected OutputStream getOutputStream() throws IOException {
                                    return outputStream;
                                }

                                protected InputStream getInputStream() throws IOException {
                                    return is;
                                }
                            };
                            long lastActivity = System.currentTimeMillis();
                            boolean waitForPong = false;
                            while (true) {
                                ReadWebSocketFrame frame;
                                EventObject event;
                                if (!subscriber.isAlive()) {
                                    wsc.writeFrame(wsc.buildCloseFrame());
                                    break;
                                }
                                if (!waitForPong) {
                                    event = this.pollEvent(subscriber, 0L);
                                    if (event != null) {
                                        byte[] jsonBytes = JSonStorage.getMapper().objectToByteArray((Object)new EventObjectStorable(event));
                                        try {
                                            wsc.writeFrame(new WriteWebSocketFrame(new WebSocketFrameHeader(true, WebSocketFrameHeader.OP_CODE.UTF8_TEXT, (long)jsonBytes.length, null), jsonBytes));
                                        }
                                        catch (IOException e) {
                                            this.pushBackEvent(subscriber, Arrays.asList(event));
                                            throw e;
                                        }
                                    }
                                } else {
                                    event = null;
                                }
                                if ((frame = wsc.readNextFrame()) != null) {
                                    waitForPong = false;
                                    lastActivity = System.currentTimeMillis();
                                    System.out.println(frame);
                                    switch (frame.getFrameHeader().getOpcode()) {
                                        case PING: {
                                            wsc.writeFrame(wsc.buildPongFrame(frame));
                                            break;
                                        }
                                        case CLOSE: {
                                            break block16;
                                        }
                                    }
                                    continue;
                                }
                                if (event != null) continue;
                                if (System.currentTimeMillis() - lastActivity > 15000L) {
                                    waitForPong = true;
                                    wsc.writeFrame(wsc.buildPingFrame());
                                }
                                Thread.sleep(50L);
                            }
                        }
                        catch (Exception e) {
                            throw new InternalApiException((Throwable)e);
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        this.register(this.eventsapi);
        RemoteAPIController.validateInterfaces(EventsAPIInterface.class, EventsInterface.class);
        this.register(CaptchaAPISolver.getInstance());
        this.register(CaptchaAPISolver.getInstance().getEventPublisher());
        this.register(new JDAPIImpl());
        DownloadWatchDogEventPublisher downloadWatchDogEventPublisher = new DownloadWatchDogEventPublisher();
        DownloadsAPIImpl downloadsAPI = new DownloadsAPIImpl();
        this.register(downloadsAPI);
        this.downloadsAPIV2 = new DownloadsAPIV2Impl();
        this.register(this.downloadsAPIV2);
        this.register(new DownloadWatchdogAPIImpl());
        this.register(downloadWatchDogEventPublisher);
        this.advancedConfigAPI = new AdvancedConfigManagerAPIImpl();
        this.register(this.advancedConfigAPI);
        this.register(new JDownloaderToolBarAPIImpl());
        this.register(new AccountAPIImpl());
        this.register(new AccountAPIImplV2());
        this.register(new SystemAPIImpl());
        this.register(new LinkCollectorAPIImpl());
        this.linkcollector = new LinkCollectorAPIImplV2();
        this.register(this.linkcollector);
        this.register(new ContentAPIImpl());
        this.contentAPI = new ContentAPIImplV2();
        this.register(this.contentAPI);
        this.register(new UIAPIImpl());
        this.register(new PollingAPIImpl());
        this.register(new ExtractionAPIImpl());
        this.register(new LinkCrawlerAPIImpl());
        this.register(new PluginsAPIImpl());
        this.register(new ExternInterfaceImpl());
        this.register(new DownloadControllerEventPublisher(this.eventsapi));
        this.register(new LinkCollectorEventPublisher());
        this.register(new ExtensionsAPIImpl());
        this.register(new UpdateAPIImpl());
        this.register(new LinkCrawlerEventPublisher());
        this.register(new DeviceAPIImpl());
        this.register(new ReconnectAPIImpl());
        this.register(new LogAPIImpl());
        RemoteAPIIOHandlerWrapper wrapper = new RemoteAPIIOHandlerWrapper(UIOManager.I());
        UIOManager.setUserIO((UserIOHandlerInterface)wrapper);
        this.register(wrapper.getRemoteHandler());
        JDAnywhereAPI.getInstance().init(this, downloadsAPI);
    }

    public UserAgentController getUaController() {
        return this.uaController;
    }

    public LinkCollectorAPIImplV2 getLinkcollector() {
        return this.linkcollector;
    }

    public DownloadsAPIV2Impl getDownloadsAPIV2() {
        return this.downloadsAPIV2;
    }

    public ContentAPIImplV2 getContentAPI() {
        return this.contentAPI;
    }

    public AdvancedConfigManagerAPIImpl getAdvancedConfigAPI() {
        return this.advancedConfigAPI;
    }

    public synchronized boolean validateRID(long rid, String sessionToken) {
        return true;
    }

    public HttpRequestHandler getRequestHandler() {
        return this.sessionc;
    }

    public boolean register(Object x) {
        if (x == null) {
            return false;
        }
        boolean ret = false;
        if (x instanceof EventPublisher) {
            boolean bl = ret = ret || this.eventsapi.register((EventPublisher)x);
        }
        if (x instanceof RemoteAPIInterface) {
            try {
                this.rapi.register((RemoteAPIInterface)x);
                ret = true;
            }
            catch (Throwable e) {
                this.logger.log(e);
                Dialog.getInstance().showExceptionDialog("Bad API Interface", e.getMessage(), e);
                return false;
            }
        }
        return ret;
    }

    public EventsAPI getEventsapi() {
        return this.eventsapi;
    }

    public boolean unregister(RemoteAPIInterface x) {
        if (x == null) {
            return false;
        }
        try {
            this.rapi.unregister(x);
            return true;
        }
        catch (Throwable e) {
            this.logger.log(e);
            return false;
        }
    }

    public boolean unregister(EventPublisher publisher) {
        if (publisher == null) {
            return false;
        }
        return this.eventsapi.unregister(publisher);
    }

    public static void validateInterfaces(Class<? extends RemoteAPIInterface> deviceInterface, Class<? extends Linkable> clientInterface) {
        if (Application.isJared(RemoteAPIController.class)) {
            return;
        }
        try {
            String deviceNameSpace = deviceInterface.getSimpleName();
            String clientNameSpace = clientInterface.getSimpleName();
            ApiNamespace deviceNameSpaceAnnotation = deviceInterface.getAnnotation(ApiNamespace.class);
            ClientApiNameSpace clientNameSpaceAnnotation = clientInterface.getAnnotation(ClientApiNameSpace.class);
            if (deviceNameSpaceAnnotation != null) {
                deviceNameSpace = deviceNameSpaceAnnotation.value();
            }
            if (clientNameSpaceAnnotation != null) {
                clientNameSpace = clientNameSpaceAnnotation.value();
            }
            if (!StringUtils.equals((String)deviceNameSpace, (String)clientNameSpace)) {
                throw new Exception("DeviceNameSpace: " + deviceNameSpace + " != Clientnamespace " + clientNameSpace);
            }
            HashMap<String, Method> deviceMap = RemoteAPIController.createMethodMap(deviceInterface.getDeclaredMethods());
            HashMap<String, Method> clientMap = RemoteAPIController.createMethodMap(clientInterface.getDeclaredMethods());
            for (Map.Entry<String, Method> e : deviceMap.entrySet()) {
                Method device = e.getValue();
                Method client = clientMap.get(e.getKey());
                if (client != null) continue;
                throw new Exception(e.getKey() + " Missing in " + clientInterface);
            }
            for (Map.Entry<String, Method> e : clientMap.entrySet()) {
                Method client = e.getValue();
                Method device = clientMap.get(e.getKey());
                if (device != null) continue;
                throw new Exception(e.getKey() + " Missing in " + clientInterface);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Dialog.getInstance().showExceptionDialog("Error In API Interface Declaration ", e.getMessage(), (Throwable)e);
        }
    }

    public static HashMap<String, Method> createMethodMap(Method[] deviceMethods) throws Exception {
        HashMap<String, Method> deviceMap = new HashMap<String, Method>();
        for (Method m : deviceMethods) {
            String name = m.getName();
            Class<?>[] actualTypes = m.getParameterTypes();
            ArrayList params = new ArrayList();
            for (Class<?> c : actualTypes) {
                if (Clazz.isInstanceof(c, RemoteAPIRequest.class) || Clazz.isInstanceof(c, RemoteAPIResponse.class)) continue;
                Class<?> sc = c.getSuperclass();
                Package pkg = AbstractMyJDClient.class.getPackage();
                if (sc != null && sc != AbstractJsonData.class && sc.getName().startsWith(pkg.getName()) && !c.getName().startsWith(pkg.getName())) {
                    c = sc;
                }
                params.add(c);
            }
            String id = name + "(" + params + ")";
            Method oldMethod = deviceMap.put(id, m);
            if (oldMethod == null) continue;
            throw new Exception("Dupe Method definition: " + m + " - " + oldMethod);
        }
        return deviceMap;
    }

    public Object call(final String namespace, final String methodName, Object ... params) throws BasicRemoteAPIException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RemoteAPI.RemoteAPIMethod dummyMethod = this.rapi.getRemoteAPIMethod(new HttpRequest(null){

            public String getRequestedPath() {
                return "/" + namespace + "/" + methodName;
            }

            public HttpConnection.HttpConnectionType getHttpConnectionType() {
                return HttpConnection.HttpConnectionType.GET;
            }

            public String getParameterbyKey(String key) throws IOException {
                return null;
            }

            public String[] getParametersbyKey(String key) throws IOException {
                return null;
            }
        });
        InterfaceHandler iface = dummyMethod.getInterfaceHandler();
        Method method = iface.getMethod(methodName, params.length);
        ArrayList<String> stringParams = new ArrayList<String>();
        for (Object o : params) {
            stringParams.add(JSonStorage.serializeToJson((Object)o));
        }
        Object[] parameters = new Object[method.getParameterTypes().length];
        int count = 0;
        for (int i = 0; i < parameters.length; ++i) {
            if (RemoteAPIRequest.class.isAssignableFrom(method.getParameterTypes()[i])) {
                RemoteAPIRequest dummyRequest = new RemoteAPIRequest(iface, methodName, stringParams.toArray(new String[0]), null, null);
                parameters[i] = dummyRequest;
                continue;
            }
            if (RemoteAPIResponse.class.isAssignableFrom(method.getParameterTypes()[i])) {
                throw new BasicRemoteAPIException("Not Found", HTTPConstants.ResponseCode.ERROR_NOT_FOUND);
            }
            try {
                parameters[i] = RemoteAPI.convert((String)((String)stringParams.get(count)), (Type)method.getGenericParameterTypes()[i]);
            }
            catch (Throwable e) {
                try {
                    if (parameters.length != 1 || !(method.getGenericParameterTypes()[i] instanceof Class) || !((Class)method.getGenericParameterTypes()[i]).isArray()) {
                        throw new BadParameterException(e, (String)stringParams.get(count));
                    }
                    parameters[i] = RemoteAPI.convert((String)JSonStorage.serializeToJson((Object)params), (Type)method.getGenericParameterTypes()[i]);
                }
                catch (Throwable e1) {
                    throw new BadParameterException(e, (String)stringParams.get(count));
                }
            }
            ++count;
        }
        return iface.invoke(method, parameters);
    }

    private class RidHistory {
        private long[] oldest = null;
        private final List<long[]> history = new ArrayList<long[]>();

        private RidHistory() {
        }
    }

    public static class MyJDownloaderEvent
    extends MyJDEvent
    implements Storable {
        @Override
        @AllowNonStorableObjects
        public Object getEventData() {
            return super.getEventData();
        }
    }
}

