/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api;

import java.util.HashMap;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.exceptions.AuthException;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.handler.ExtendedHttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HTTPBridge;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.OptionsRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.net.httpserver.session.HttpSessionController;
import org.jdownloader.api.RemoteAPIConfig;
import org.jdownloader.api.RemoteAPISession;
import org.jdownloader.api.myjdownloader.MyJDownloaderAPISession;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectThread;
import org.jdownloader.api.myjdownloader.MyJDownloaderController;
import org.jdownloader.api.myjdownloader.MyJDownloaderDirectHttpConnection;
import org.jdownloader.api.myjdownloader.MyJDownloaderHttpConnection;
import org.jdownloader.myjdownloader.client.json.ServerErrorType;

public class RemoteAPISessionControllerImp
extends HttpSessionController<RemoteAPISession>
implements ExtendedHttpRequestHandler,
HttpConnection.ConnectionHook {
    private final HashMap<String, RemoteAPISession> sessions = new HashMap();

    public void onBeforeRequest(HttpRequest request, HttpResponse response) throws BasicRemoteAPIException {
        response.setHook((HttpConnection.ConnectionHook)this);
        HTTPBridge bridge = request.getBridge();
        this.checkDirectConnectionToken(request);
        if (bridge != null && bridge instanceof MyJDownloaderConnectThread) {
            return;
        }
        HTTPHeader originHeader = request.getRequestHeaders().get("Origin");
        if (originHeader != null) {
            String origin = originHeader.getValue().replaceAll("^https?://", "");
            String value = ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).getLocalAPIServerHeaderAccessControllAllowOrigin();
            if (StringUtils.isNotEmpty((String)origin) && !"*".equals(value)) {
                throw new AuthException("Bad Origin");
            }
        }
    }

    protected void checkDirectConnectionToken(HttpRequest request) throws BasicRemoteAPIException {
        RawHttpConnectionInterface connection = request.getConnection();
        if (connection instanceof MyJDownloaderDirectHttpConnection && request.getHttpConnectionType() != HttpConnection.HttpConnectionType.OPTIONS) {
            MyJDownloaderDirectHttpConnection myConnection = (MyJDownloaderDirectHttpConnection)connection;
            String sessionToken = myConnection.getRequestConnectToken();
            if (!MyJDownloaderController.getInstance().isSessionValid(sessionToken)) {
                ServerErrorType type = ServerErrorType.TOKEN_INVALID;
                HTTPConstants.ResponseCode code = HTTPConstants.ResponseCode.get((int)type.getCode());
                throw new BasicRemoteAPIException(null, type.name(), code, null);
            }
        }
    }

    public void onAfterRequest(HttpRequest request, HttpResponse response, boolean handled) {
    }

    public boolean onGetRequest(GetRequest request, HttpResponse response) throws BasicRemoteAPIException {
        if (request instanceof OptionsRequest) {
            response.getResponseHeaders().add(new HTTPHeader("Content-Length", "0"));
            response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
            return true;
        }
        return super.onGetRequest(request, response);
    }

    public void onBeforeSendHeaders(HttpResponse response) {
        String pna;
        HttpRequest request = response.getConnection().getRequest();
        HTTPBridge bridge = request.getBridge();
        response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Max-Age", "1800"));
        response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST"));
        String allowHeaders = request.getRequestHeaders().getValue("Access-Control-Request-Headers");
        if (allowHeaders != null) {
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Headers", allowHeaders));
        }
        if ((pna = request.getRequestHeaders().getValue("Access-Control-Request-Private-Network")) != null) {
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Private-Network", pna));
        }
        if (bridge != null && bridge instanceof MyJDownloaderConnectThread) {
            String allowOrigin = request.getRequestHeaders().getValue("Origin");
            if (allowOrigin != null) {
                response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Origin", allowOrigin));
            } else if (StringUtils.containsIgnoreCase((String)request.getRequestHeaders().getValue("Host"), (String)"my.jdownloader.org")) {
                response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Origin", "https://my.jdownloader.org"));
            } else {
                response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Origin", "*"));
            }
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Credentials", "true"));
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("X-Frame-Options", "DENY"));
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("X-Xss-Protection", "1; mode=block"));
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("Referrer-Policy", ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).getLocalAPIServerHeaderReferrerPolicy()));
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("X-Content-Type-Options", "nosniff"));
        } else {
            String allowOrigin = ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).getLocalAPIServerHeaderAccessControllAllowOrigin();
            if (StringUtils.isNotEmpty((String)allowOrigin)) {
                response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Origin", allowOrigin));
            }
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("Content-Security-Policy", ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).getLocalAPIServerHeaderContentSecurityPolicy()));
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("X-Frame-Options", ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).getLocalAPIServerHeaderXFrameOptions()));
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("X-Xss-Protection", ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).getLocalAPIServerHeaderXXssProtection()));
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("Referrer-Policy", ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).getLocalAPIServerHeaderReferrerPolicy()));
            response.getResponseHeaders().addIfAbsent(new HTTPHeader("X-Content-Type-Options", ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).getLocalAPIServerHeaderXContentTypeOptions()));
        }
    }

    public void onAfterRequestException(HttpRequest request, HttpResponse response, Throwable e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteAPISession getSession(HttpRequest request, String id) {
        if (request.getConnection() instanceof MyJDownloaderHttpConnection) {
            return new MyJDownloaderAPISession(this, (MyJDownloaderHttpConnection)request.getConnection());
        }
        HashMap<String, RemoteAPISession> hashMap = this.sessions;
        synchronized (hashMap) {
            return this.sessions.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteAPISession newSession(RemoteAPIRequest request, String username, String password) {
        if (!"wron".equals(password)) {
            RemoteAPISession session = new RemoteAPISession(this);
            HashMap<String, RemoteAPISession> hashMap = this.sessions;
            synchronized (hashMap) {
                this.sessions.put(session.getSessionID(), session);
            }
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSession(RemoteAPISession session) {
        if (session == null) {
            return false;
        }
        HashMap<String, RemoteAPISession> hashMap = this.sessions;
        synchronized (hashMap) {
            RemoteAPISession ret = this.sessions.remove(session.getSessionID());
            if (ret == null) {
                return false;
            }
            ret.setAlive(false);
            return true;
        }
    }
}

