/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.accounts.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import jd.controlling.AccountController;
import jd.controlling.accountchecker.AccountChecker;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountTrafficView;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.utils.StringUtils;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.accounts.v2.AccountAPIStorableV2;
import org.jdownloader.api.accounts.v2.AccountAPIV2;
import org.jdownloader.api.accounts.v2.BasicAuthenticationAPIStorable;
import org.jdownloader.auth.AuthenticationController;
import org.jdownloader.auth.AuthenticationInfo;
import org.jdownloader.myjdownloader.client.bindings.AccountQuery;
import org.jdownloader.myjdownloader.client.bindings.BasicAuthenticationStorable;
import org.jdownloader.myjdownloader.client.bindings.interfaces.AccountInterface;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;

public class AccountAPIImplV2
implements AccountAPIV2 {
    public AccountAPIImplV2() {
        RemoteAPIController.validateInterfaces(AccountAPIV2.class, AccountInterface.class);
    }

    @Override
    public List<AccountAPIStorableV2> listAccounts(AccountQuery queryParams) {
        List<Account> accs = AccountController.getInstance().list();
        ArrayList<AccountAPIStorableV2> ret = new ArrayList<AccountAPIStorableV2>();
        int startWith = queryParams.getStartAt();
        int maxResults = queryParams.getMaxResults();
        if (startWith > accs.size() - 1) {
            return ret;
        }
        if (startWith < 0) {
            startWith = 0;
        }
        if (maxResults < 0) {
            maxResults = accs.size();
        }
        for (int i = startWith; i < Math.min(startWith + maxResults, accs.size()); ++i) {
            AccountInfo ai;
            Account acc = accs.get(i);
            if (queryParams.getUUIDList() != null && !queryParams.getUUIDList().contains(acc.getId().getID())) continue;
            AccountAPIStorableV2 accas = new AccountAPIStorableV2(acc);
            accas.setErrorType(this.enumToString(acc.getError()));
            if (queryParams.isError()) {
                accas.setErrorString(acc.getErrorString());
            }
            if (queryParams.isUserName()) {
                accas.setUsername(acc.getUser());
            }
            if (queryParams.isValidUntil() && (ai = acc.getAccountInfo()) != null) {
                accas.setValidUntil(ai.getValidUntil());
            }
            AccountTrafficView accountTrafficView = null;
            if (queryParams.isTrafficLeft() && (accountTrafficView = acc.getAccountTrafficView()) != null) {
                if (accountTrafficView.isUnlimitedTraffic()) {
                    accas.setTrafficLeft(-1L);
                } else {
                    accas.setTrafficLeft(accountTrafficView.getTrafficLeft());
                }
            }
            if (queryParams.isTrafficMax()) {
                if (accountTrafficView == null) {
                    accountTrafficView = acc.getAccountTrafficView();
                }
                if (accountTrafficView != null) {
                    if (accountTrafficView.isUnlimitedTraffic()) {
                        accas.setTrafficMax(-1L);
                    } else {
                        accas.setTrafficMax(accountTrafficView.getTrafficMax());
                    }
                }
            }
            if (queryParams.isEnabled()) {
                accas.setEnabled(acc.isEnabled());
            }
            if (queryParams.isValid()) {
                accas.setValid(acc.isValid());
            }
            ret.add(accas);
        }
        return ret;
    }

    private String enumToString(Account.AccountError error) {
        if (error == null) {
            return null;
        }
        return error.name();
    }

    @Override
    public List<String> listPremiumHoster() {
        Collection<LazyHostPlugin> allPLugins = HostPluginController.getInstance().list();
        ArrayList<String> ret = new ArrayList<String>();
        for (LazyHostPlugin lhp : allPLugins) {
            if (!lhp.isPremium()) continue;
            ret.add(lhp.getDisplayName());
        }
        return ret;
    }

    @Override
    public HashMap<String, String> listPremiumHosterUrls() {
        Collection<LazyHostPlugin> allPLugins = HostPluginController.getInstance().list();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (LazyHostPlugin lazyHostPlugin : allPLugins) {
            if (!lazyHostPlugin.isPremium()) continue;
            ret.put(lazyHostPlugin.getHost(), AccountController.buildAfflink(lazyHostPlugin, null, "accountmanager/webinterface"));
        }
        return ret;
    }

    @Override
    public String getPremiumHosterUrl(String hoster) {
        if (hoster == null) {
            return null;
        }
        LazyHostPlugin lazyHostPlugin = HostPluginController.getInstance().get(hoster);
        return AccountController.buildAfflink(lazyHostPlugin, null, "captcha/webinterface");
    }

    @Override
    public void removeAccounts(long[] ids) {
        List<Account> removeACCs = this.getAccountbyIDs(ids);
        for (Account acc : removeACCs) {
            AccountController.getInstance().removeAccount(acc);
        }
    }

    private List<Account> getAccountbyIDs(long[] ids) {
        HashSet<Long> todoIDs = new HashSet<Long>();
        for (long l : ids) {
            todoIDs.add(l);
        }
        ArrayList<Account> accs = new ArrayList<Account>();
        for (Account lacc : AccountController.getInstance().list()) {
            if (lacc != null && todoIDs.size() > 0) {
                if (!todoIDs.remove(lacc.getId().getID())) continue;
                accs.add(lacc);
                continue;
            }
            if (todoIDs.size() != 0) continue;
            break;
        }
        return accs;
    }

    @Override
    public void enableAccounts(long[] linkIds) {
        this.setEnabledState(true, linkIds);
    }

    @Override
    public void disableAccounts(long[] linkIds) {
        this.setEnabledState(false, linkIds);
    }

    @Override
    public void refreshAccounts(long[] ids) {
        this.refreshAccounts(ids, false);
    }

    @Override
    public void refreshAccounts(long[] ids, boolean force) {
        List<Account> accs = this.getAccountbyIDs(ids);
        for (Account acc : accs) {
            AccountChecker.getInstance().check(acc, force);
        }
    }

    public void setEnabledState(boolean enabled, long[] ids) {
        List<Account> accs = this.getAccountbyIDs(ids);
        for (Account acc : accs) {
            acc.setEnabled(enabled);
        }
    }

    @Override
    public void addAccount(String host, String username, String password) {
        PluginFinder pluginFinder = new PluginFinder();
        String pluginHost = new PluginFinder().assignHost(host);
        if (pluginHost != null) {
            Account acc = new Account(username, password);
            acc.setHoster(pluginHost);
            pluginFinder.assignPlugin(acc, true);
            AccountController.getInstance().addAccount(acc);
        }
    }

    @Override
    public boolean setUserNameAndPassword(long accountId, String username, String password) {
        for (Account acc : AccountController.getInstance().list()) {
            if (accountId != acc.getId().getID()) continue;
            if (StringUtils.isNotEmpty((String)username)) {
                acc.setUser(username);
            }
            if (StringUtils.isNotEmpty((String)password)) {
                acc.setPass(password);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<BasicAuthenticationAPIStorable> listBasicAuth() {
        ArrayList<BasicAuthenticationAPIStorable> result = new ArrayList<BasicAuthenticationAPIStorable>();
        List<AuthenticationInfo> auths = AuthenticationController.getInstance().list();
        for (AuthenticationInfo info : auths) {
            result.add(this.createAuthenticationStorable(info));
        }
        return result;
    }

    private BasicAuthenticationAPIStorable createAuthenticationStorable(AuthenticationInfo info) {
        BasicAuthenticationAPIStorable tmp = new BasicAuthenticationAPIStorable();
        tmp.setCreated(info.getCreated());
        tmp.setEnabled(info.isEnabled());
        tmp.setUsername(info.getUsername());
        tmp.setHostmask(info.getHostmask());
        tmp.setId(info.getId());
        tmp.setLastValidated(info.getLastValidated());
        if (info.getType() != null) {
            BasicAuthenticationStorable.Type type = BasicAuthenticationStorable.Type.valueOf(info.getType().name());
            tmp.setType(type);
        }
        tmp.setUsername(info.getUsername());
        return tmp;
    }

    @Override
    public long addBasicAuth(BasicAuthenticationStorable.Type type, String hostmask, String username, String password) throws BadParameterException {
        AuthenticationInfo.Type authType;
        if (type == null) {
            throw new BadParameterException("type == null");
        }
        try {
            authType = AuthenticationInfo.Type.valueOf(type.name());
        }
        catch (IllegalArgumentException e) {
            throw new BadParameterException("invalid type");
        }
        AuthenticationInfo info = new AuthenticationInfo();
        info.setType(authType);
        info.setHostmask(hostmask);
        info.setUsername(username);
        info.setPassword(password);
        AuthenticationController.getInstance().add(info);
        return info.getId();
    }

    @Override
    public boolean removeBasicAuths(long[] ids) throws BadParameterException {
        if (ids == null || ids.length == 0) {
            throw new BadParameterException("ids empty or null");
        }
        List<AuthenticationInfo> auths = this.getBasicAuthsByIds(ids);
        AuthenticationController.getInstance().remove(auths);
        return true;
    }

    private List<AuthenticationInfo> getBasicAuthsByIds(long[] ids) {
        HashSet<Long> todoIDs = new HashSet<Long>();
        for (long l : ids) {
            todoIDs.add(l);
        }
        ArrayList<AuthenticationInfo> accs = new ArrayList<AuthenticationInfo>();
        for (AuthenticationInfo lacc : AuthenticationController.getInstance().list()) {
            if (lacc != null && todoIDs.size() > 0) {
                if (!todoIDs.remove(lacc.getId())) continue;
                accs.add(lacc);
                continue;
            }
            if (todoIDs.size() != 0) continue;
            break;
        }
        return accs;
    }

    @Override
    public boolean updateBasicAuth(BasicAuthenticationAPIStorable updatedEntry) throws BadParameterException {
        if (updatedEntry == null) {
            throw new BadParameterException("updated entry == null");
        }
        if (updatedEntry.getId() == -1L) {
            throw new BadParameterException("id not set");
        }
        List<AuthenticationInfo> infos = this.getBasicAuthsByIds(new long[]{updatedEntry.getId()});
        if (infos.size() == 0) {
            throw new BadParameterException("entry not found");
        }
        AuthenticationInfo existingEntry = infos.get(0);
        boolean updated = false;
        if (updatedEntry.getHostmask() != null) {
            existingEntry.setHostmask(updatedEntry.getHostmask());
            updated = true;
        }
        if (updatedEntry.getUsername() != null) {
            existingEntry.setUsername(updatedEntry.getUsername());
            updated = true;
        }
        if (updatedEntry.getPassword() != null) {
            existingEntry.setPassword(updatedEntry.getPassword());
            updated = true;
        }
        if (updatedEntry.isEnabled() != null) {
            existingEntry.setEnabled(updatedEntry.isEnabled());
            updated = true;
        }
        if (updatedEntry.getType() != null) {
            try {
                existingEntry.setType(AuthenticationInfo.Type.valueOf(updatedEntry.getType().name()));
                updated = true;
            }
            catch (IllegalArgumentException e) {
                throw new BadParameterException("unkown type");
            }
        }
        return updated;
    }
}

