/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.device;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jd.controlling.reconnect.ipcheck.BalancedWebIPCheck;
import jd.controlling.reconnect.ipcheck.IP;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.net.Base64OutputStream;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxyUtils;
import org.jdownloader.api.device.DeviceAPI;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectThread;
import org.jdownloader.api.myjdownloader.MyJDownloaderController;
import org.jdownloader.api.myjdownloader.MyJDownloaderDirectServer;
import org.jdownloader.api.myjdownloader.MyJDownloaderHttpConnection;
import org.jdownloader.api.myjdownloader.MyJDownloaderSettings;
import org.jdownloader.myjdownloader.client.json.DirectConnectionInfo;
import org.jdownloader.myjdownloader.client.json.DirectConnectionInfos;

public class DeviceAPIImpl
implements DeviceAPI {
    private static final InetAddress[] lookup(final String hostName) throws IOException {
        final AtomicReference ret = new AtomicReference();
        Thread lookup = new Thread("Lookup:" + hostName){
            {
                super(x0);
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    ret.set(HTTPConnectionUtils.resolvHostIP((String)hostName));
                }
                catch (IOException e) {
                    ret.set(e);
                }
            }
        };
        lookup.start();
        try {
            lookup.join(2000L);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        Object result = ret.get();
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof InetAddress[]) {
            return (InetAddress[])result;
        }
        return null;
    }

    private DirectConnectionInfo buildDirectConnectionInfo(InetAddress inetAddress, int port) {
        if (inetAddress.isLoopbackAddress() && inetAddress instanceof Inet6Address) {
            return null;
        }
        if (inetAddress.isLinkLocalAddress()) {
            return null;
        }
        DirectConnectionInfo ret = new DirectConnectionInfo();
        ret.setPort(port);
        if (inetAddress instanceof Inet6Address) {
            ret.setIp("[" + inetAddress.getHostAddress().replaceFirst("%.+", "") + "]");
        } else {
            ret.setIp(inetAddress.getHostAddress());
        }
        return ret;
    }

    @Override
    public DirectConnectionInfos getDirectConnectionInfos(RemoteAPIRequest request) {
        String[] customDeviceIPs;
        DirectConnectionInfos ret = new DirectConnectionInfos();
        ret.setMode(MyJDownloaderSettings.DIRECTMODE.NONE.name());
        ret.setInfos(new ArrayList<DirectConnectionInfo>());
        MyJDownloaderConnectThread thread = MyJDownloaderController.getInstance().getConnectThread();
        if (thread == null) {
            return ret;
        }
        MyJDownloaderDirectServer directServer = thread.getDirectServer();
        if (directServer == null || !directServer.isAlive() || directServer.getLocalPort() < 0) {
            return ret;
        }
        int lanPort = directServer.getLocalPort();
        int wanPort = directServer.getRemotePort();
        ret.setMode(directServer.getConnectMode().name());
        ArrayList<DirectConnectionInfo> infos = new ArrayList<DirectConnectionInfo>();
        List localIPs = HTTPProxyUtils.getLocalIPs((boolean)true);
        if (localIPs != null) {
            block17: {
                try {
                    InetAddress[] localhost = DeviceAPIImpl.lookup("127-0-0-1.mydns.jdownloader.org");
                    if (localhost == null || localhost.length != 1 || !"127.0.0.1".equals(localhost[0].getHostAddress())) {
                        ret.setRebindProtectionDetected(true);
                        break block17;
                    }
                    for (InetAddress localIP : localIPs) {
                        InetAddress[] resolv;
                        if (!localIP.isSiteLocalAddress() || (resolv = DeviceAPIImpl.lookup(HexFormatter.byteArrayToHex((byte[])localIP.getAddress()) + ".mydns.jdownloader.org")) != null && resolv.length == 1 && resolv[0].equals(localIP)) continue;
                        ret.setRebindProtectionDetected(true);
                        break;
                    }
                }
                catch (Throwable e) {
                    ret.setRebindProtectionDetected(true);
                }
            }
            for (InetAddress inetAddress : localIPs) {
                DirectConnectionInfo info = this.buildDirectConnectionInfo(inetAddress, lanPort);
                if (info == null) continue;
                infos.add(info);
            }
        }
        if ((customDeviceIPs = ((MyJDownloaderSettings)JsonConfig.create(MyJDownloaderSettings.class)).getCustomDeviceIPs()) != null) {
            for (String customDeviceIP : customDeviceIPs) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(customDeviceIP);
                    DirectConnectionInfo info = this.buildDirectConnectionInfo(inetAddress, lanPort);
                    if (info == null) continue;
                    infos.add(info);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (wanPort > 0) {
            try {
                BalancedWebIPCheck balancedWebIPCheck = new BalancedWebIPCheck(){
                    {
                        this.br.setConnectTimeout(5000);
                        this.br.setReadTimeout(5000);
                    }
                };
                IP externalIP = balancedWebIPCheck.getExternalIP();
                if (externalIP.getIP() != null) {
                    DirectConnectionInfo info = new DirectConnectionInfo();
                    info.setPort(wanPort);
                    info.setIp(externalIP.getIP());
                    infos.add(info);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (infos.size() > 0) {
            ret.setInfos(infos);
        }
        return ret;
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public String getSessionPublicKey(RemoteAPIRequest request) {
        KeyPair keyPair;
        MyJDownloaderHttpConnection connection = MyJDownloaderHttpConnection.getMyJDownloaderHttpConnection(request);
        if (connection != null && (keyPair = connection.getRSAKeyPair()) != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Base64OutputStream b64 = new Base64OutputStream((OutputStream)bos);
                b64.write(keyPair.getPublic().getEncoded());
                b64.close();
                return bos.toString("UTF-8");
            }
            catch (IOException e) {
                connection.getLogger().log((Throwable)e);
            }
        }
        return null;
    }
}

