/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.dialog;

import java.awt.Dialog;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import jd.gui.swing.jdgui.JDGui;
import org.appwork.exceptions.WTFException;
import org.appwork.resources.AWUTheme;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.ExceptionDialogInterface;
import org.appwork.uio.MessageDialogInterface;
import org.appwork.uio.UserIODefinition;
import org.appwork.uio.UserIOHandlerInterface;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExceptionDialog;
import org.appwork.utils.swing.dialog.MessageDialogImpl;
import org.jdownloader.api.dialog.ApiHandle;
import org.jdownloader.api.dialog.DialogApiImpl;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.SilentModeSettings;
import org.jdownloader.settings.staticreferences.CFG_SILENTMODE;

public class RemoteAPIIOHandlerWrapper
implements UserIOHandlerInterface {
    private final DialogApiImpl remoteHandler = new DialogApiImpl(this);
    private final LogSource logger = LogController.getInstance().getLogger(RemoteAPIIOHandlerWrapper.class.getName());

    public RemoteAPIIOHandlerWrapper(UserIOHandlerInterface i) {
    }

    public boolean showConfirmDialog(int flags, String title, String message, Icon icon, String ok, String cancel, final String dontShowAgainKey) {
        ConfirmDialog dialog = StringUtils.isEmpty((String)dontShowAgainKey) ? new ConfirmDialog(flags, title, message, icon, ok, cancel) : new ConfirmDialog(flags, title, message, icon, ok, cancel){

            public String getDontShowAgainKey() {
                return dontShowAgainKey;
            }
        };
        ConfirmDialogInterface io = (ConfirmDialogInterface)this.show(ConfirmDialogInterface.class, dialog);
        return io.getCloseReason() == CloseReason.OK;
    }

    public boolean showConfirmDialog(int flags, String title, String message, Icon icon, String ok, String cancel) {
        return this.showConfirmDialog(flags, title, message, icon, ok, cancel, null);
    }

    public boolean showConfirmDialog(int flags, String title, String message) {
        return this.showConfirmDialog(flags, title, message, null, null, null, null);
    }

    public void showMessageDialog(String message) {
        this.show(MessageDialogInterface.class, new MessageDialogImpl(0, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends UserIODefinition> T showModeless(Class<T> class1, T impl) {
        Object object;
        ApiHandle handle;
        block63: {
            boolean silentModeActive;
            AbstractDialog dialog;
            block62: {
                if (!(impl instanceof AbstractDialog)) throw new WTFException("Dialog Type not supported");
                dialog = (AbstractDialog)impl;
                handle = null;
                try {
                    try {
                        dialog.forceDummyInit();
                        try {
                            if (dialog.evaluateDontShowAgainFlag()) {
                                T t = impl;
                                return t;
                            }
                            break block62;
                        }
                        catch (Exception e) {
                            this.logger.log((Throwable)e);
                        }
                        break block62;
                    }
                    catch (InterruptedException e) {
                        dialog.setInterrupted();
                        break block63;
                    }
                    catch (DialogClosedException e) {
                        dialog.fillReturnMask(e);
                    }
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
                break block63;
            }
            boolean bl = silentModeActive = Application.isHeadless() ? true : JDGui.getInstance().isSilentModeActive();
            if (silentModeActive && !Application.isHeadless() && CFG_SILENTMODE.ON_DIALOG_DURING_SILENT_MODE_ACTION.getValue() == SilentModeSettings.DialogDuringSilentModeAction.CANCEL_DIALOG) {
                throw new DialogClosedException(64);
            }
            handle = this.remoteHandler.enqueue(class1, impl);
            if (silentModeActive && !SwingUtilities.isEventDispatchThread()) {
                long countdown = -1L;
                if (dialog.isCountdownFlagEnabled()) {
                    long countdownDif = dialog.getCountdown();
                    countdown = System.currentTimeMillis() + countdownDif;
                }
                if (countdown < 0L && CFG_SILENTMODE.ON_DIALOG_DURING_SILENT_MODE_ACTION.getValue() == SilentModeSettings.DialogDuringSilentModeAction.WAIT_IN_BACKGROUND_UNTIL_WINDOW_GETS_FOCUS_OR_TIMEOUT) {
                    countdown = System.currentTimeMillis() + (Long)CFG_SILENTMODE.ON_DIALOG_DURING_SILENT_MODE_ACTION_TIMEOUT.getValue();
                }
                if (!Application.isHeadless()) {
                    JDGui.getInstance().flashTaskbar();
                }
                while (!handle.isDisposed() && (Application.isHeadless() || JDGui.getInstance().isSilentModeActive())) {
                    if (countdown > 0L) {
                        Thread.sleep(Math.min(Math.max(1L, countdown - System.currentTimeMillis()), 250L));
                        if (System.currentTimeMillis() <= countdown) continue;
                        dialog.onTimeout();
                        Thread.interrupted();
                        T t = impl;
                        return t;
                    }
                    Thread.sleep(250L);
                }
            }
            if (handle != null && handle.isDisposed()) {
                Object object2 = handle.getAnswer() != null ? handle.getAnswer() : impl;
                return object2;
            }
            dialog.resetDummyInit();
            new EDTRunner(){

                protected void runInEDT() {
                    dialog.displayDialog();
                    dialog.getDialog().addWindowListener(new WindowListener(){

                        @Override
                        public void windowOpened(WindowEvent e) {
                        }

                        @Override
                        public void windowIconified(WindowEvent e) {
                        }

                        @Override
                        public void windowDeiconified(WindowEvent e) {
                        }

                        @Override
                        public void windowDeactivated(WindowEvent e) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void windowClosing(WindowEvent e) {
                            AbstractDialog abstractDialog = dialog;
                            synchronized (abstractDialog) {
                                dialog.notifyAll();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void windowClosed(WindowEvent e) {
                            AbstractDialog abstractDialog = dialog;
                            synchronized (abstractDialog) {
                                dialog.notifyAll();
                            }
                        }

                        @Override
                        public void windowActivated(WindowEvent e) {
                        }
                    });
                }
            }.waitForEDT();
            while (dialog.getDialog().isDisplayable()) {
                AbstractDialog abstractDialog = dialog;
                synchronized (abstractDialog) {
                    dialog.wait(10000L);
                }
            }
            break block63;
            finally {
                try {
                    dialog.dispose();
                }
                catch (Exception e) {}
                try {
                    if (handle != null) {
                        handle.dispose();
                    }
                }
                catch (Exception e) {}
            }
        }
        if (handle == null) {
            return impl;
        }
        if (handle.getAnswer() != null) {
            object = handle.getAnswer();
            return object;
        }
        object = impl;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends UserIODefinition> T show(Class<T> class1, T impl) {
        if (impl instanceof AbstractDialog) {
            AbstractDialog dialog = (AbstractDialog)impl;
            if (dialog.getModalityType() == Dialog.ModalityType.MODELESS) {
                if (SwingUtilities.isEventDispatchThread()) {
                    IllegalStateException e = new IllegalStateException("Cannot call a Modeless Blocking dialog in the EDT. Use a Wrapperthread");
                    LoggerFactory.getDefaultLogger().log((Throwable)e);
                    throw e;
                }
                return this.showModeless(class1, impl);
            }
            try {
                dialog.forceDummyInit();
                if (dialog.evaluateDontShowAgainFlag()) {
                    return impl;
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            dialog.resetDummyInit();
        }
        ApiHandle handle = this.remoteHandler.enqueue(class1, impl);
        try {
            AbstractDialog dialog;
            Object ret;
            block23: {
                try {
                    if (impl instanceof AbstractDialog) {
                        if (Application.isHeadless()) {
                            if (handle != null) {
                                handle.waitFor();
                            }
                        } else {
                            Dialog.getInstance().showDialog((AbstractDialog)impl);
                        }
                        break block23;
                    }
                    throw new WTFException("Not Supported Dialog Type!: " + impl);
                }
                catch (DialogClosedException e) {
                    if (e.isCausedByInterrupt()) {
                        // empty if block
                    }
                }
                catch (DialogCanceledException e) {
                }
                finally {
                    if (handle != null) {
                        handle.dispose();
                    }
                }
            }
            if (handle == null) {
                return impl;
            }
            Object object = ret = handle.getAnswer() != null ? handle.getAnswer() : impl;
            if (impl instanceof AbstractDialog && (dialog = (AbstractDialog)impl).isDontShowAgainFlagEabled()) {
                boolean dontShowAgain = ret.isDontShowAgainSelected();
                boolean clickedOK = ret.getCloseReason() == CloseReason.OK;
                dialog.writeDontShowAgainAnswer(clickedOK, dontShowAgain);
            }
            return ret;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            return impl;
        }
    }

    public void showErrorMessage(String message) {
        this.showConfirmDialog(48, _AWU.T.DIALOG_ERROR_TITLE(), message, AWUTheme.I().getIcon(Dialog.ICON_ERROR, 32), null, null);
    }

    public void onHandlerDone(final ApiHandle ret) {
        if (ret.getImpl() instanceof AbstractDialog && !Application.isHeadless()) {
            new EDTRunner(){

                protected void runInEDT() {
                    try {
                        if (!((AbstractDialog)ret.getImpl()).isDisposed()) {
                            ((AbstractDialog)ret.getImpl()).interrupt();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }
    }

    public DialogApiImpl getRemoteHandler() {
        return this.remoteHandler;
    }

    public void showException(String message, Throwable e) {
        ExceptionDialog dialog = new ExceptionDialog(2064, _AWU.T.DIALOG_ERROR_TITLE(), message, e, null, null);
        this.show(ExceptionDialogInterface.class, dialog);
    }
}

