/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.downloads.v2;

import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.downloads.v2.DownloadWatchdogAPI;
import org.jdownloader.api.utils.PackageControllerUtils;
import org.jdownloader.myjdownloader.client.bindings.interfaces.DownloadControllerInterface;

public class DownloadWatchdogAPIImpl
implements DownloadWatchdogAPI {
    private final PackageControllerUtils<FilePackage, DownloadLink> packageControllerUtils;

    public DownloadWatchdogAPIImpl() {
        RemoteAPIController.validateInterfaces(DownloadWatchdogAPI.class, DownloadControllerInterface.class);
        this.packageControllerUtils = new PackageControllerUtils<FilePackage, DownloadLink>(DownloadController.getInstance());
    }

    @Override
    public boolean start() {
        DownloadWatchDog.getInstance().startDownloads();
        return true;
    }

    @Override
    public boolean stop() {
        DownloadWatchDog.getInstance().stopDownloads();
        return true;
    }

    @Override
    public boolean pause(boolean value) {
        DownloadWatchDog.getInstance().pauseDownloadWatchDog(value);
        return true;
    }

    @Override
    public String getCurrentState() {
        return DownloadWatchDog.getInstance().getStateMachine().getState().getLabel();
    }

    @Override
    public int getSpeedInBps() {
        DownloadWatchDog dwd = DownloadWatchDog.getInstance();
        return dwd.getDownloadSpeedManager().getSpeed();
    }

    @Override
    public void forceDownload(long[] linkIds, long[] packageIds) {
        DownloadWatchDog dwd = DownloadWatchDog.getInstance();
        dwd.forceDownload(this.packageControllerUtils.getSelectionInfo(linkIds, packageIds).getChildren());
    }
}

