/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jd.http.Browser;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.api.jdanywhere.api.CaptchaPushRegistration;
import org.jdownloader.api.jdanywhere.api.JDAnywhereConfig;
import org.jdownloader.api.jdanywhere.api.interfaces.IEventsApi;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.captcha.v2.solverjob.SolverJob;

public class EventsAPI
implements IEventsApi {
    private static final JDAnywhereConfig cfg = (JDAnywhereConfig)JsonConfig.create(JDAnywhereConfig.class);
    private static final Map<String, CaptchaPushRegistration> captchaPushList = EventsAPI.getCaptchaPushList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, CaptchaPushRegistration> getCaptchaPushList() {
        Map<String, CaptchaPushRegistration> captchaPushList = cfg.getList();
        if (captchaPushList == null) {
            captchaPushList = new HashMap<String, CaptchaPushRegistration>();
        }
        Boolean itemRemoved = false;
        Map<String, CaptchaPushRegistration> map = captchaPushList;
        synchronized (map) {
            Iterator<Map.Entry<String, CaptchaPushRegistration>> it = captchaPushList.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, CaptchaPushRegistration> entry = it.next();
                if (!entry.getKey().startsWith("DeviceToken=") || !captchaPushList.containsKey(entry.getKey().substring(12))) continue;
                it.remove();
                itemRemoved = true;
            }
        }
        if (itemRemoved.booleanValue()) {
            cfg.setList(captchaPushList);
        }
        return captchaPushList;
    }

    @Override
    public boolean RegisterCaptchaPush(String host, String path, String query) {
        String deviceID = query.substring(query.indexOf("DeviceToken="), query.indexOf("&Badge=", query.indexOf("DeviceToken=")));
        return this.RegisterCaptchaPush_v2(deviceID, host, path, query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean RegisterCaptchaPush_v2(String deviceID, String host, String path, String query, boolean withSound) {
        URI uri = null;
        try {
            uri = new URI("http", host, path, query, null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (uri == null) {
            return false;
        }
        String request = uri.toASCIIString();
        CaptchaPushRegistration cpr = new CaptchaPushRegistration();
        cpr.setUrl(request);
        cpr.setWithSound(withSound);
        Map<String, CaptchaPushRegistration> map = captchaPushList;
        synchronized (map) {
            captchaPushList.remove(deviceID);
            captchaPushList.remove("DeviceToken=" + deviceID);
            captchaPushList.put(deviceID, cpr);
            cfg.setList(captchaPushList);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IsRegistered(String deviceID) {
        Map<String, CaptchaPushRegistration> map = captchaPushList;
        synchronized (map) {
            return captchaPushList.containsKey(deviceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IsSoundEnabled(String deviceID) {
        Map<String, CaptchaPushRegistration> map = captchaPushList;
        synchronized (map) {
            if (captchaPushList.containsKey(deviceID)) {
                CaptchaPushRegistration cpr = captchaPushList.get(deviceID);
                if (cpr != null) {
                    return cpr.isWithSound();
                }
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean UnRegisterCaptchaPush(String deviceID) {
        Map<String, CaptchaPushRegistration> map = captchaPushList;
        synchronized (map) {
            if (captchaPushList.remove(deviceID) != null) {
                cfg.setList(captchaPushList);
            }
        }
        return true;
    }

    public void sendNewCaptcha(SolverJob<?> job) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long captchCount = 0L;
                for (SolverJob<?> entry : ChallengeResponseController.getInstance().listJobs()) {
                    if (entry.isDone() || !(entry.getChallenge() instanceof ImageCaptchaChallenge)) continue;
                    ++captchCount;
                }
                Map map = captchaPushList;
                synchronized (map) {
                    for (Map.Entry entry : captchaPushList.entrySet()) {
                        try {
                            CaptchaPushRegistration cpr = (CaptchaPushRegistration)entry.getValue();
                            if (cpr == null) continue;
                            String request = cpr.getUrl();
                            request = request.replace("%7BCaptchaCount%7D", Long.toString(captchCount));
                            EventsAPI.this.getHTML(request);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHTML(String urlToRead) {
        Browser br = null;
        try {
            br = new Browser();
            String string = br.getPage(urlToRead);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.getHttpConnection().disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }
}

