/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api.storable;

import jd.controlling.linkcrawler.CrawledLink;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.jdownloader.extensions.ExtensionController;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkFactory;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;

@StorableValidatorIgnoresMissingSetter
public class CrawledLinkStoreable
implements Storable {
    private CrawledLink link;

    public long getId() {
        if (this.link == null) {
            return 0L;
        }
        return this.link.getDownloadLink().getUniqueID().getID();
    }

    public String getName() {
        if (this.link == null) {
            return null;
        }
        return this.link.getName();
    }

    public String getHost() {
        if (this.link == null) {
            return null;
        }
        return this.link.getHost();
    }

    public String getOnlinestatus() {
        if (this.link == null) {
            return null;
        }
        return "";
    }

    public long getSize() {
        if (this.link == null) {
            return -1L;
        }
        return this.link.getDownloadLink().getView().getBytesTotalEstimated();
    }

    public boolean isEnabled() {
        if (this.link == null) {
            return true;
        }
        return this.link.isEnabled();
    }

    public long getAdded() {
        if (this.link == null) {
            return -1L;
        }
        return this.link.getCreated();
    }

    public long getFinished() {
        if (this.link == null) {
            return -1L;
        }
        return this.link.getFinishedDate();
    }

    public int getPriority() {
        if (this.link == null) {
            return 0;
        }
        return this.link.getPriority().getId();
    }

    public int getChunks() {
        if (this.link == null) {
            return 0;
        }
        return this.link.getChunks();
    }

    public String getBrowserurl() {
        if (this.link == null) {
            return null;
        }
        return this.link.getURL();
    }

    public String getPassword() {
        CrawledLinkFactory clf;
        if (this.link == null) {
            return null;
        }
        String returnValue = "";
        ExtractionExtension extractor = (ExtractionExtension)ExtensionController.getInstance().getExtension(ExtractionExtension.class)._getExtension();
        Archive archive = extractor.getArchiveByFactory((ArchiveFactory)(clf = new CrawledLinkFactory(this.link)));
        if (archive != null && archive.getSettings() != null && archive.getSettings().getPasswords() != null) {
            for (String pwd : archive.getSettings().getPasswords()) {
                if (returnValue != "") {
                    returnValue = returnValue + "/";
                }
                returnValue = returnValue + pwd;
            }
        }
        return returnValue;
    }

    public String getDirectory() {
        if (this.link == null) {
            return null;
        }
        return LinkTreeUtils.getDownloadDirectory(this.link).getAbsolutePath();
    }

    public String getComment() {
        if (this.link == null) {
            return null;
        }
        return this.link.getDownloadLink().getComment();
    }

    @StorableAllowPrivateAccessModifier
    private CrawledLinkStoreable() {
        this.link = null;
    }

    public CrawledLinkStoreable(CrawledLink link) {
        this.link = link;
    }
}

