/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api.storable;

import java.util.ArrayList;
import java.util.List;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.jdownloader.api.jdanywhere.api.storable.CrawledLinkStoreable;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;

@StorableValidatorIgnoresMissingSetter
public class CrawledPackageStorable
implements Storable {
    private List<CrawledLinkStoreable> links;
    private CrawledPackage pkg;

    public String getName() {
        return this.pkg.getName();
    }

    public long getId() {
        return this.pkg.getUniqueID().getID();
    }

    public String getDirectory() {
        return LinkTreeUtils.getDownloadDirectory(this.pkg).getAbsolutePath();
    }

    public String getComment() {
        String comment = this.pkg.getComment();
        if (comment == null || comment.length() == 0) {
            return "";
        }
        return comment;
    }

    public long getAdded() {
        return this.pkg.getCreated();
    }

    public List<CrawledLinkStoreable> getLinks() {
        return this.links;
    }

    public long getSize() {
        long size = 0L;
        for (CrawledLink link : this.pkg.getChildren()) {
            size += Math.max(0L, link.getSize());
        }
        return size;
    }

    public List<String> getHoster() {
        ArrayList<String> links = new ArrayList<String>(this.pkg.getChildren().size());
        for (CrawledLink link : this.pkg.getChildren()) {
            if (links.contains(link.getHost())) continue;
            links.add(link.getHost());
        }
        return links;
    }

    public String getPassword() {
        String password = "---";
        for (CrawledLink link : this.pkg.getChildren()) {
            if (password == null || password.length() == 0 || password.equals("---")) {
                password = link.getDownloadLink().getDownloadPassword();
                continue;
            }
            if (link.getDownloadLink().getDownloadPassword().equals(password)) continue;
            password = "";
            break;
        }
        if (password == null || password.length() == 0 || password.equals("---")) {
            password = "";
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEnabled() {
        int enabled = -1;
        CrawledPackage crawledPackage = this.pkg;
        synchronized (crawledPackage) {
            for (CrawledLink link : this.pkg.getChildren()) {
                if (enabled == 2) continue;
                if (link.isEnabled()) {
                    if (enabled == -1) {
                        enabled = 1;
                        continue;
                    }
                    if (enabled != 0) continue;
                    enabled = 2;
                    break;
                }
                if (enabled == -1) {
                    enabled = 0;
                    continue;
                }
                if (enabled != 1) continue;
                enabled = 2;
                break;
            }
        }
        return enabled;
    }

    public void _setLinks(List<CrawledLinkStoreable> links) {
        this.links = links;
    }

    @StorableAllowPrivateAccessModifier
    private CrawledPackageStorable() {
    }

    public CrawledPackageStorable(CrawledPackage pkg) {
        this.pkg = pkg;
    }
}

