/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api.storable;

import java.util.ArrayList;
import java.util.List;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;

@StorableValidatorIgnoresMissingSetter
public class FilePackageStorable
implements Storable {
    private FilePackage pkg;

    public String getName() {
        return this.pkg.getName();
    }

    public long getId() {
        return this.pkg.getUniqueID().getID();
    }

    public long getAdded() {
        return this.pkg.getCreated();
    }

    public long getSpeed() {
        long speed = DownloadWatchDog.getInstance().getDownloadSpeedbyFilePackage(this.pkg);
        return Math.max(0L, speed);
    }

    public long getDone() {
        return this.pkg.getView().getDone();
    }

    public long getSize() {
        return this.pkg.getView().getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFinished() {
        long finished = 1L;
        FilePackage filePackage = this.pkg;
        synchronized (filePackage) {
            for (DownloadLink link : this.pkg.getChildren()) {
                if (link.getFinishedDate() != -1L) continue;
                finished = -1L;
                break;
            }
        }
        return finished;
    }

    public List<String> getHoster() {
        ArrayList<String> links = new ArrayList<String>(this.pkg.size());
        for (DownloadLink link : this.pkg.getChildren()) {
            if (links.contains(link.getHost())) continue;
            links.add(link.getHost());
        }
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEnabled() {
        int enabled = -1;
        FilePackage filePackage = this.pkg;
        synchronized (filePackage) {
            for (DownloadLink link : this.pkg.getChildren()) {
                if (enabled == 2) continue;
                if (link.isEnabled()) {
                    if (enabled == -1) {
                        enabled = 1;
                        continue;
                    }
                    if (enabled != 0) continue;
                    enabled = 2;
                    break;
                }
                if (enabled == -1) {
                    enabled = 0;
                    continue;
                }
                if (enabled != 1) continue;
                enabled = 2;
                break;
            }
        }
        return enabled;
    }

    @StorableAllowPrivateAccessModifier
    private FilePackageStorable() {
    }

    public FilePackageStorable(FilePackage pkg) {
        this.pkg = pkg;
    }
}

