/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.myjdownloader;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.SessionRemoteAPIRequest;
import org.appwork.remoteapi.exceptions.ApiInterfaceNotAvailable;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.Base64OutputStream;
import org.appwork.utils.net.ChunkedOutputStream;
import org.appwork.utils.net.DeChunkingOutputStream;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.httpserver.EmptyRequestException;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.HttpConnectionExceptionHandler;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HTTPBridge;
import org.appwork.utils.net.httpserver.requests.HeadRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.OptionsRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.net.httpserver.session.HttpSession;
import org.bouncycastle.tls.TlsNoCloseNotifyException;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.myjdownloader.InvalidMyJDownloaderRequest;
import org.jdownloader.api.myjdownloader.MyJDownloaderAPISession;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectThread;
import org.jdownloader.api.myjdownloader.MyJDownloaderController;
import org.jdownloader.api.myjdownloader.MyJDownloaderGetRequest;
import org.jdownloader.api.myjdownloader.MyJDownloaderHeadRequest;
import org.jdownloader.api.myjdownloader.MyJDownloaderOptionsRequest;
import org.jdownloader.api.myjdownloader.MyJDownloaderPostRequest;
import org.jdownloader.api.myjdownloader.api.MyJDownloaderAPI;
import org.jdownloader.myjdownloader.RequestLineParser;
import org.jdownloader.myjdownloader.client.SessionInfo;
import org.jdownloader.myjdownloader.client.exceptions.MyJDownloaderException;
import org.jdownloader.myjdownloader.client.exceptions.TokenException;
import org.jdownloader.myjdownloader.client.json.SessionInfoResponse;

public class MyJDownloaderHttpConnection
extends HttpConnection {
    protected static final ArrayList<HttpRequestHandler> requestHandler = new ArrayList();
    protected final MyJDownloaderAPI api;
    private final LogSource logger;
    private final SocketStreamInterface socketStream;
    private static final HashMap<String, List<MyJDownloaderHttpConnection>> CONNECTIONS;
    private static final HashMap<String, KeyPair> RSAKEYPAIRS;
    public static final Charset UTF8;
    protected static final WeakHashMap<SessionInfoResponse, MinTimeWeakReference<SessionInfoResponse>> sessionInfos;
    private OutputStream os = null;
    private byte[] iv = null;
    private byte[] key = null;
    private String requestConnectToken;
    private HTTPHeader accept_encoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair getRSAKeyPair() {
        String token = this.getRequestConnectToken();
        if (token != null) {
            KeyPair keyPair = null;
            HashMap<String, KeyPair> hashMap = RSAKEYPAIRS;
            synchronized (hashMap) {
                keyPair = RSAKEYPAIRS.get(token);
                if (keyPair == null) {
                    try {
                        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                        keyPairGenerator.initialize(2048);
                        keyPair = keyPairGenerator.genKeyPair();
                        RSAKEYPAIRS.put(token, keyPair);
                    }
                    catch (Throwable e) {
                        this.getLogger().log(e);
                    }
                }
            }
            return keyPair;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MyJDownloaderHttpConnection> getConnectionsByToken(String connectToken) {
        HashMap<String, List<MyJDownloaderHttpConnection>> hashMap = CONNECTIONS;
        synchronized (hashMap) {
            return CONNECTIONS.get(connectToken);
        }
    }

    protected SessionInfoResponse getSessionInfo(String queryToken) {
        if (this.api != null && StringUtils.isNotEmpty((String)queryToken)) {
            MyJDownloaderConnectThread.SessionInfoWrapper session = null;
            try {
                session = (MyJDownloaderConnectThread.SessionInfoWrapper)this.api.getSessionInfo();
                if (MyJDownloaderConnectThread.SessionInfoWrapper.STATE.VALID.equals((Object)session.getState())) {
                    SessionInfoResponse ret = this.api.getSessionInfo(queryToken);
                    return ret;
                }
            }
            catch (TokenException e) {
                this.getLogger().log((Throwable)e);
                if (session != null) {
                    session.compareAndSetState(MyJDownloaderConnectThread.SessionInfoWrapper.STATE.VALID, MyJDownloaderConnectThread.SessionInfoWrapper.STATE.RECONNECT);
                }
            }
            catch (MyJDownloaderException e) {
                this.getLogger().log((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionInfoResponse getSessionInfo() {
        WeakHashMap<SessionInfoResponse, MinTimeWeakReference<SessionInfoResponse>> weakHashMap = sessionInfos;
        synchronized (weakHashMap) {
            for (Map.Entry<SessionInfoResponse, MinTimeWeakReference<SessionInfoResponse>> entry : sessionInfos.entrySet()) {
                SessionInfoResponse session = entry.getKey();
                MinTimeWeakReference<SessionInfoResponse> ref = entry.getValue();
                if (!StringUtils.equals((String)session.getSessionToken(), (String)this.getRequestConnectToken()) || ref.get() != session) continue;
                return (SessionInfoResponse)ref.get();
            }
        }
        SessionInfoResponse sessionInfo = this.getSessionInfo(this.getRequestConnectToken());
        if (sessionInfo != null) {
            WeakHashMap<SessionInfoResponse, MinTimeWeakReference<SessionInfoResponse>> weakHashMap2 = sessionInfos;
            synchronized (weakHashMap2) {
                sessionInfos.put(sessionInfo, (MinTimeWeakReference<SessionInfoResponse>)new MinTimeWeakReference((Object)sessionInfo, 900000L, "SessionInfo:" + this.getRequestConnectToken()));
            }
        }
        return sessionInfo;
    }

    public static MyJDownloaderHttpConnection getMyJDownloaderHttpConnection(RemoteAPIRequest request) {
        HttpSession session;
        if (request instanceof SessionRemoteAPIRequest && (session = ((SessionRemoteAPIRequest)request).getSession()) != null && session instanceof MyJDownloaderAPISession) {
            return ((MyJDownloaderAPISession)session).getConnection();
        }
        return null;
    }

    public LogSource getLogger() {
        return this.logger;
    }

    public MyJDownloaderHttpConnection(Socket clientConnection, MyJDownloaderAPI api) throws IOException {
        super(null, clientConnection);
        this.api = api;
        this.socketStream = null;
        this.logger = api.getLogger();
    }

    public MyJDownloaderHttpConnection(SocketStreamInterface socketStream, MyJDownloaderAPI api) throws IOException {
        super(null, socketStream.getSocket(), socketStream.getInputStream(), socketStream.getOutputStream());
        this.socketStream = socketStream;
        this.api = api;
        this.logger = api.getLogger();
    }

    public MyJDownloaderHttpConnection(Socket clientSocket, InputStream is, OutputStream os, MyJDownloaderAPI api) throws IOException {
        super(null, clientSocket, is, os);
        this.socketStream = null;
        this.api = api;
        this.logger = api.getLogger();
    }

    protected GetRequest buildGetRequest() {
        return new MyJDownloaderGetRequest(this);
    }

    protected HeadRequest buildHeadRequest() {
        return new MyJDownloaderHeadRequest(this);
    }

    protected OptionsRequest buildOptionsRequest() {
        return new MyJDownloaderOptionsRequest(this);
    }

    protected PostRequest buildPostRequest() {
        return new MyJDownloaderPostRequest(this);
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getKey() {
        return this.key;
    }

    protected void setIv(byte[] iv) {
        this.iv = iv;
    }

    protected void setKey(byte[] key) {
        this.key = key;
    }

    public List<HttpRequestHandler> getHandler() {
        return requestHandler;
    }

    protected void onUnhandled(HttpRequest request, HttpResponse response) throws IOException {
        this.onException((Throwable)new ApiInterfaceNotAvailable(), request, response);
    }

    public boolean onException(Throwable e, HttpRequest request, HttpResponse response) throws IOException {
        if (Exceptions.containsInstanceOf((Throwable)e, (Class[])new Class[]{SocketException.class, ClosedChannelException.class})) {
            return true;
        }
        if (Exceptions.containsInstanceOf((Throwable)e, (Class[])new Class[]{TlsNoCloseNotifyException.class})) {
            return true;
        }
        if (e instanceof HttpConnectionExceptionHandler) {
            return ((HttpConnectionExceptionHandler)e).handle(response);
        }
        Object apiException = !(e instanceof BasicRemoteAPIException) ? new InternalApiException(e) : (BasicRemoteAPIException)e;
        this.logger.log((Throwable)apiException);
        this.response = new HttpResponse((RawHttpConnectionInterface)this);
        return apiException.handle(this.response);
    }

    public String getRequestConnectToken() {
        return this.requestConnectToken;
    }

    protected HttpRequest buildRequest() throws IOException {
        HttpRequest ret = super.buildRequest();
        ret.setBridge((HTTPBridge)MyJDownloaderController.getInstance().getConnectThread());
        HTTPHeader xAcceptEncoding = ret.getRequestHeaders().get("X-Accept-Encoding");
        this.accept_encoding = xAcceptEncoding != null && (StringUtils.containsIgnoreCase((String)xAcceptEncoding.getValue(), (String)"gazeisp") || StringUtils.containsIgnoreCase((String)xAcceptEncoding.getValue(), (String)"gzip_aes")) ? xAcceptEncoding : ret.getRequestHeaders().get("Accept-Encoding");
        ret.getRequestHeaders().remove("Accept-Encoding");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        String token = this.getRequestConnectToken();
        if (token != null) {
            HashMap<String, List<MyJDownloaderHttpConnection>> hashMap = CONNECTIONS;
            synchronized (hashMap) {
                List<MyJDownloaderHttpConnection> list = CONNECTIONS.get(token);
                if (list != null && list.remove((Object)this) && list.size() == 0) {
                    CONNECTIONS.remove(token);
                }
            }
        }
        try {
            if (!this.clientSocket.isClosed()) {
                this.getOutputStream(true).close();
            }
        }
        catch (Throwable nothing) {
            nothing.printStackTrace();
        }
        if (this.socketStream != null) {
            try {
                this.socketStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.clientSocket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String preProcessRequestLine(String requestLine) throws IOException {
        if (StringUtils.isEmpty((String)requestLine)) {
            throw new EmptyRequestException();
        }
        RequestLineParser parser = RequestLineParser.parse(requestLine.getBytes(UTF8));
        if (parser == null || parser.getSessionToken() == null) {
            throw new InvalidMyJDownloaderRequest();
        }
        this.requestConnectToken = parser.getSessionToken();
        String token = this.getRequestConnectToken();
        if (token != null) {
            HashMap<String, List<MyJDownloaderHttpConnection>> hashMap = CONNECTIONS;
            synchronized (hashMap) {
                List<MyJDownloaderHttpConnection> list = CONNECTIONS.get(token);
                if (list == null) {
                    list = new CopyOnWriteArrayList<MyJDownloaderHttpConnection>();
                    CONNECTIONS.put(token, list);
                }
                list.add(this);
            }
        }
        try {
            SessionInfo session = this.api.getSessionInfo();
            byte[] payloadEncryptionToken = StringUtils.equals((String)parser.getSessionToken(), (String)session.getSessionToken()) ? session.getServerEncryptionToken() : this.api.getDeviceEncryptionTokenBySession(parser.getSessionToken());
            this.iv = Arrays.copyOfRange(payloadEncryptionToken, 0, 16);
            this.key = Arrays.copyOfRange(payloadEncryptionToken, 16, 32);
        }
        catch (MyJDownloaderException e) {
            throw new IOException(e);
        }
        requestLine = requestLine.replaceFirst(" /t_[a-zA-z0-9]{40}_.+?/", " /");
        return requestLine;
    }

    public synchronized OutputStream getOutputStream(boolean sendHeaders) throws IOException {
        if (this.os != null) {
            return this.os;
        }
        HTTPHeader contentType = this.response.getResponseHeaders().get("Content-Type");
        if (contentType != null && StringUtils.startsWithCaseInsensitive((String)contentType.getValue(), (String)"application/json")) {
            try {
                boolean deChunk = false;
                HTTPHeader transferEncoding = this.response.getResponseHeaders().get("Transfer-Encoding");
                if (transferEncoding != null) {
                    if ("chunked".equalsIgnoreCase(transferEncoding.getValue())) {
                        deChunk = true;
                    } else {
                        throw new IOException("Unsupported TransferEncoding " + transferEncoding);
                    }
                }
                final boolean useDeChunkingOutputStream = deChunk;
                final Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                IvParameterSpec ivSpec = new IvParameterSpec(this.getIv());
                SecretKeySpec skeySpec = new SecretKeySpec(this.getKey(), "AES");
                cipher.init(1, (Key)skeySpec, ivSpec);
                this.response.getResponseHeaders().remove("Content-Length");
                this.response.getResponseHeaders().add(new HTTPHeader("Transfer-Encoding", "chunked"));
                if (this.accept_encoding != null && (StringUtils.containsIgnoreCase((String)this.accept_encoding.getValue(), (String)"gazeisp") || StringUtils.containsIgnoreCase((String)this.accept_encoding.getValue(), (String)"gzip_aes"))) {
                    if (StringUtils.containsIgnoreCase((String)this.accept_encoding.getValue(), (String)"gazeisp")) {
                        this.response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "gazeisp"));
                        this.response.getResponseHeaders().add(new HTTPHeader("X-Content-Encoding", "gazeisp"));
                    } else {
                        this.response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "gzip_aes"));
                        this.response.getResponseHeaders().add(new HTTPHeader("X-Content-Encoding", "gzip_aes"));
                    }
                    this.openOutputStream();
                    if (useDeChunkingOutputStream) {
                        this.os = new DeChunkingOutputStream((OutputStream)new GZIPOutputStream(new CipherOutputStream((OutputStream)new ChunkedOutputStream(this.getRawOutputStream(), 16384), cipher)));
                    }
                    this.os = new GZIPOutputStream(new CipherOutputStream((OutputStream)new ChunkedOutputStream(this.getRawOutputStream(), 16384), cipher));
                }
                this.openOutputStream();
                this.os = new OutputStream(){
                    private ChunkedOutputStream chunkedOS;
                    Base64OutputStream b64os;
                    OutputStream outos;
                    {
                        this.chunkedOS = new ChunkedOutputStream((OutputStream)new BufferedOutputStream(MyJDownloaderHttpConnection.this.getRawOutputStream(), 16384));
                        this.b64os = new Base64OutputStream((OutputStream)this.chunkedOS){};
                        this.outos = new CipherOutputStream((OutputStream)this.b64os, cipher);
                        if (useDeChunkingOutputStream) {
                            this.outos = new DeChunkingOutputStream(this.outos);
                        }
                    }

                    @Override
                    public void close() throws IOException {
                        this.outos.close();
                        this.b64os.flush();
                        this.chunkedOS.close();
                    }

                    @Override
                    public void flush() throws IOException {
                    }

                    @Override
                    public void write(int b) throws IOException {
                        this.outos.write(b);
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        this.outos.write(b, off, len);
                    }
                };
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        } else {
            if (sendHeaders) {
                this.openOutputStream();
            }
            this.os = this.getRawOutputStream();
        }
        return this.os;
    }

    static {
        requestHandler.add(RemoteAPIController.getInstance().getRequestHandler());
        CONNECTIONS = new HashMap();
        RSAKEYPAIRS = new HashMap();
        UTF8 = Charset.forName("UTF-8");
        sessionInfos = new WeakHashMap();
    }
}

