/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.myjdownloader.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import jd.controlling.proxy.ProxyController;
import jd.http.Browser;
import jd.http.ProxySelectorInterface;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.URLConnectionAdapterDirectImpl;
import jd.http.requests.PostRequest;
import jd.nutils.encoding.Encoding;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.Base64InputStream;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.os.ContainerRuntime;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.hardware.HardwareType;
import org.appwork.utils.os.hardware.HardwareTypeInterface;
import org.jdownloader.myjdownloader.client.AbstractMyJDClientForDesktopJVM;
import org.jdownloader.myjdownloader.client.exceptions.ExceptionResponse;
import org.jdownloader.settings.staticreferences.CFG_MYJD;

public class MyJDownloaderAPI
extends AbstractMyJDClientForDesktopJVM {
    private LogSource logger = null;
    protected volatile String connectToken = null;

    @Override
    protected byte[] base64decode(String base64encodedString) {
        return Base64.decode((String)base64encodedString);
    }

    @Override
    protected String base64Encode(byte[] encryptedBytes) {
        return Base64.encodeToString((byte[])encryptedBytes, (boolean)false);
    }

    @Override
    public String urlencode(String text) {
        return Encoding.urlEncode((String)text);
    }

    @Override
    protected String objectToJSon(Object payload) {
        return JSonStorage.serializeToJson((Object)payload);
    }

    @Override
    protected <T> T jsonToObject(String dec, Type clazz) {
        return (T)JSonStorage.restoreFromString((String)dec, (TypeRef)new TypeRef<T>(clazz){});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] post(String query, String object, byte[] keyAndIV) throws ExceptionResponse {
        URLConnectionAdapter con = null;
        byte[] ret = null;
        try {
            Browser br = this.getBrowser();
            byte[] sendBytes = (object == null ? "" : object).getBytes("UTF-8");
            PostRequest request = br.createPostRequest(this.getServerRoot() + query, new ArrayList(), null);
            request.setPostBytes(sendBytes);
            request.setContentType("application/json; charset=utf-8");
            if (keyAndIV != null) {
                request.getHeaders().put("Accept-Encoding", "gazeisp");
                con = this.openRequestConnection(br, (Request)request);
                String contentEncoding = con.getHeaderField("Content-Encoding");
                String xContentEncoding = con.getHeaderField("X-Content-Encoding");
                if (xContentEncoding != null && (StringUtils.containsIgnoreCase((String)xContentEncoding, (String)"gazeisp") || StringUtils.containsIgnoreCase((String)xContentEncoding, (String)"gzip_aes"))) {
                    contentEncoding = xContentEncoding;
                }
                String content_Type = con.getHeaderField("Content-Type");
                if (con.getResponseCode() == 200) {
                    if (StringUtils.contains((String)contentEncoding, (String)"gazeisp") || StringUtils.contains((String)contentEncoding, (String)"gzip_aes")) {
                        byte[] aes = IO.readStream((int)-1, (InputStream)con.getInputStream());
                        byte[] decrypted = this.decrypt(aes, keyAndIV);
                        byte[] byArray = IO.readStream((int)-1, (InputStream)new GZIPInputStream(new ByteArrayInputStream(decrypted)));
                        return byArray;
                    }
                    if (StringUtils.contains((String)content_Type, (String)"aesjson-server")) {
                        byte[] aes = IO.readStream((int)-1, (InputStream)new Base64InputStream(con.getInputStream()));
                        byte[] byArray = this.decrypt(aes, keyAndIV);
                        return byArray;
                    }
                    byte[] byArray = IO.readStream((int)-1, (InputStream)con.getInputStream());
                    return byArray;
                }
                ret = IO.readStream((int)-1, (InputStream)con.getInputStream());
            } else {
                request.getHeaders().put("Accept-Encoding", null);
                con = this.openRequestConnection(br, (Request)request);
                ret = IO.readStream((int)-1, (InputStream)con.getInputStream());
            }
            if (con != null && con.getResponseCode() > 0 && con.getResponseCode() != 200) {
                throw new ExceptionResponse(this.toString(ret), con.getResponseCode(), con.getResponseMessage());
            }
            byte[] byArray = ret;
            return byArray;
        }
        catch (ExceptionResponse e) {
            throw e;
        }
        catch (Exception e) {
            if (con == null) throw new ExceptionResponse(e);
            throw new ExceptionResponse(e, con.getResponseCode(), con.getResponseMessage());
        }
        finally {
            if (con != null) {
                try {
                    con.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected URLConnectionAdapter openRequestConnection(Browser br, Request request) throws IOException {
        int retryDirectSocketTimeoutException = 3;
        while (true) {
            try {
                return br.openRequestConnection(request);
            }
            catch (Browser.BrowserException e) {
                LogSource logger = this.logger;
                if (logger != null) {
                    logger.log((Throwable)e);
                }
                if (Exceptions.containsInstanceOf((Throwable)e, (Class[])new Class[]{SocketTimeoutException.class}) && request.getHttpConnection() instanceof URLConnectionAdapterDirectImpl && retryDirectSocketTimeoutException-- > 0) {
                    request.getHeaders().put("X-RDSTE", Integer.toString(retryDirectSocketTimeoutException));
                    logger.info("retryDirectSocketTimeoutException:" + retryDirectSocketTimeoutException);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        throw e;
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    protected Browser getBrowser() {
        return new MyJDownloaderAPIBrowser();
    }

    private static String getRevision() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("|OS:" + CrossSystem.getOSFamily() + "|" + CrossSystem.getOS() + "|" + CrossSystem.is64BitOperatingSystem());
            sb.append("|CPU:" + CrossSystem.getARCHFamily() + "|" + CrossSystem.is64BitArch());
            sb.append("|JVM:" + JVMVersion.get() + "|" + Application.is64BitJvm());
            try {
                HardwareTypeInterface hardwareType = HardwareType.getHardware();
                if (hardwareType != null) {
                    sb.append("|HW:" + hardwareType.getHardwareType());
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
            try {
                if (ContainerRuntime.isInsideContainer()) {
                    sb.append("|" + ContainerRuntime.getType());
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Map map;
            Object ret;
            File file = Application.getResource((String)"build.json");
            if (file.isFile() && (ret = (map = (Map)JSonStorage.restoreFromString((String)IO.readFileToString((File)file), (TypeRef)TypeRef.HASHMAP)).get("JDownloaderRevision")) != null) {
                return "core_" + ret.toString() + sb.toString();
            }
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        String revision = new Regex("$Revision: 46545 $", "Revision:\\s*?(\\d+)").getMatch(0);
        if (revision == null) {
            return "api_0" + sb.toString();
        }
        return "api_" + revision + sb.toString();
    }

    public MyJDownloaderAPI() {
        super("JD_" + MyJDownloaderAPI.getRevision());
        this.setServerRoot("https://" + CFG_MYJD.SERVER_HOST.getValue());
    }

    public LogSource getLogger() {
        return this.logger;
    }

    public void setLogger(LogSource logger) {
        this.logger = logger;
    }

    private class MyJDownloaderAPIBrowser
    extends Browser {
        private MyJDownloaderAPIBrowser() {
            this.setDebug(true);
            this.setVerbose(true);
            this.setAllowedResponseCodes(new int[]{200, 503, 401, 407, 403, 500, 429});
            this.setProxySelector(new ProxySelectorInterface(){

                public boolean updateProxy(Request request, int retryCounter) {
                    return ProxyController.getInstance().updateProxy(request, retryCounter);
                }

                public boolean reportConnectException(Request request, int retryCounter, IOException e) {
                    return ProxyController.getInstance().reportConnectException(request, retryCounter, e);
                }

                public List<HTTPProxy> getProxiesByURL(URL uri) {
                    return ProxyController.getInstance().getProxiesWithNoneFallBack(uri, Application.isHeadless());
                }
            });
        }

        protected void onBeforeRequestConnect(Request request) throws IOException {
            if (request.getProxy() == null || request.getProxy().isNone() || request.getProxy().isDirect()) {
                request.setConnectTimeout(10000);
            }
        }

        public Browser cloneBrowser() {
            MyJDownloaderAPIBrowser br = new MyJDownloaderAPIBrowser();
            return this.cloneBrowser(br);
        }

        public LogInterface getLogger() {
            return MyJDownloaderAPI.this.getLogger();
        }
    }
}

