/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.polling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.linkcollector.LinkCollector;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.remoteapi.APIQuery;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.jdownloader.api.captcha.CaptchaAPI;
import org.jdownloader.api.captcha.CaptchaAPISolver;
import org.jdownloader.api.jd.AggregatedNumbersAPIStorable;
import org.jdownloader.api.polling.PollingAPI;
import org.jdownloader.api.polling.PollingAPIDownloadLinkStorable;
import org.jdownloader.api.polling.PollingAPIFilePackageStorable;
import org.jdownloader.api.polling.PollingResultAPIStorable;
import org.jdownloader.controlling.AggregatedCrawlerNumbers;
import org.jdownloader.controlling.AggregatedNumbers;
import org.jdownloader.myjdownloader.client.json.JsonMap;

public class PollingAPIImpl
implements PollingAPI {
    private final DownloadWatchDog dwd = DownloadWatchDog.getInstance();
    private final DownloadController dc = DownloadController.getInstance();
    private final LinkCollector lc = LinkCollector.getInstance();
    private CaptchaAPI captchaAPI = CaptchaAPISolver.getInstance();

    @Override
    public List<PollingResultAPIStorable> poll(RemoteAPIRequest request, APIQuery queryParams) {
        ArrayList<PollingResultAPIStorable> result = new ArrayList<PollingResultAPIStorable>();
        if (queryParams.containsKey((Object)"downloadProgress")) {
            result.add(this.getDownloadProgress(queryParams));
        }
        if (queryParams.containsKey((Object)"jdState")) {
            result.add(this.getJDState());
        }
        if (queryParams.containsKey((Object)"linkGrabberState")) {
            result.add(this.getLinkGrabberState());
        }
        if (queryParams.containsKey((Object)"captchasWaiting")) {
            result.add(this.getCaptchasWaiting(request));
        }
        if (queryParams.containsKey((Object)"aggregatedNumbers")) {
            result.add(this.getAggregatedNumbers());
        }
        return result;
    }

    private PollingResultAPIStorable getAggregatedNumbers() {
        PollingResultAPIStorable prs = new PollingResultAPIStorable();
        prs.setEventName("aggregatedNumbers");
        JsonMap eventData = new JsonMap();
        eventData.put("data", new AggregatedNumbersAPIStorable(new AggregatedNumbers(this.dc.getSelectionInfo()), new AggregatedCrawlerNumbers(this.lc.getSelectionInfo())));
        prs.setEventData(eventData);
        return prs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollingResultAPIStorable getDownloadProgress(APIQuery queryParams) {
        ArrayList<Long> expandedPackageUUIDs;
        if (queryParams.get((Object)"downloadProgress") == null) {
            expandedPackageUUIDs = null;
        } else {
            expandedPackageUUIDs = new ArrayList<Long>();
            List uuidsFromQuery = (List)queryParams._getQueryParam("downloadProgress", List.class, new ArrayList());
            for (Iterator<FilePackage> uuidFromQuery : uuidsFromQuery) {
                try {
                    expandedPackageUUIDs.add(((Number)((Object)uuidFromQuery)).longValue());
                }
                catch (ClassCastException e) {}
            }
        }
        PollingResultAPIStorable prs = new PollingResultAPIStorable();
        prs.setEventName("downloadProgress");
        ArrayList<PollingAPIFilePackageStorable> fpas = new ArrayList<PollingAPIFilePackageStorable>();
        for (FilePackage fp : this.dwd.getRunningFilePackages()) {
            PollingAPIFilePackageStorable fps = new PollingAPIFilePackageStorable(fp);
            fps._setSpeed(this.dwd.getDownloadSpeedbyFilePackage(fp));
            if (expandedPackageUUIDs == null || expandedPackageUUIDs.contains(fp.getUniqueID().getID())) {
                boolean readL = fp.getModifyLock().readLock();
                try {
                    for (DownloadLink dl : fp.getChildren()) {
                        if (dl.getDownloadLinkController() == null) continue;
                        PollingAPIDownloadLinkStorable pdls = new PollingAPIDownloadLinkStorable(dl);
                        fps.getLinks().add(pdls);
                    }
                }
                finally {
                    fp.getModifyLock().readUnlock(readL);
                }
            }
            fpas.add(fps);
        }
        JsonMap eventData = new JsonMap();
        eventData.put("data", fpas);
        prs.setEventData(eventData);
        return prs;
    }

    private PollingResultAPIStorable getJDState() {
        PollingResultAPIStorable prs = new PollingResultAPIStorable();
        prs.setEventName("jdState");
        JsonMap eventData = new JsonMap();
        eventData.put("data", this.dwd.getStateMachine().getState().getLabel());
        prs.setEventData(eventData);
        return prs;
    }

    private PollingResultAPIStorable getLinkGrabberState() {
        PollingResultAPIStorable prs = new PollingResultAPIStorable();
        prs.setEventName("linkGrabberState");
        LinkCollector lc = LinkCollector.getInstance();
        String status = "UNKNOWN";
        status = lc.getDefaultLinkChecker().isRunning() ? "RUNNING" : "IDLE";
        JsonMap eventData = new JsonMap();
        eventData.put("data", status);
        prs.setEventData(eventData);
        return prs;
    }

    private PollingResultAPIStorable getCaptchasWaiting(RemoteAPIRequest request) {
        PollingResultAPIStorable prs = new PollingResultAPIStorable();
        prs.setEventName("captchasWaiting");
        JsonMap eventData = new JsonMap();
        eventData.put("data", this.captchaAPI.list(request));
        prs.setEventData(eventData);
        return prs;
    }
}

